/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.graph.model.GraphCell;
import kd.bos.workflow.design.graph.model.GraphModel;
import kd.bos.workflow.design.plugin.ISupportDesignerModelChange;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class BizFlowPluginUtil {
    private static Log log = LogFactory.getLog(BizFlowPluginUtil.class);

    private BizFlowPluginUtil() {
    }

    public static boolean isBizFlow(String modelType) {
        return "BizFlowModel".equals(modelType);
    }

    public static String getProcessEntityNumber(Map<String, Object> processProperties) {
        String entityNumber = (String)processProperties.get("entraBill");
        return entityNumber != null ? entityNumber : "";
    }

    public static boolean isStartItemCorrelationStencil(String stencilType) {
        switch (stencilType) {
            case "BillTask": 
            case "UserTask": 
            case "CallActivity": {
                return true;
            }
        }
        return false;
    }

    public static Map<String, Object> getStartItemByEntityNumber(List<Map<String, Object>> startItems, String entityNumber) {
        if (startItems == null || startItems.isEmpty()) {
            return null;
        }
        for (Map<String, Object> startItem : startItems) {
            if (entityNumber == null || !entityNumber.equals(startItem.get("entitynumber"))) continue;
            return startItem;
        }
        return null;
    }

    public static void addOrUpdateStartItemEntity(String modelType, IFormView ideView, JSONObject properties) {
        if (BizFlowPluginUtil.isBizFlow(modelType)) {
            BizFlowPluginUtil.addOrUpdateStartItemEntity(ideView, properties);
        }
    }

    private static void addOrUpdateStartItemEntity(IFormView ideView, JSONObject properties) {
        String entityName = properties.getString("entityName");
        String entityNumber = properties.getString("entityNumber");
        String nodeId = properties.getString("itemId");
        ISupportDesignerModelChange plugin = DesignerPluginUtil.getSupportModelChangePlugin(ideView);
        if (plugin != null) {
            List<Map<String, Object>> startItems = plugin.getListPropertyValue("node_1", "startItems");
            if (startItems == null) {
                startItems = new ArrayList<Map<String, Object>>();
            }
            Map<String, Object> startItem = BizFlowPluginUtil.getStartItemByEntityNumber(startItems, entityNumber);
            Map<Object, Object> item = new HashMap();
            if (startItem != null) {
                item = startItem;
                String nodeIdValue = (String)item.get("nodeid");
                if (nodeIdValue != null && nodeIdValue.contains(nodeId)) {
                    return;
                }
                String nodeIds = String.format("%s %s", nodeIdValue, nodeId);
                item.put("nodeid", nodeIds);
            } else {
                startItems.add(item);
                String id = BpmnDiffUtil.getListElementId((String)"startItems");
                item.put("id", id);
                item.put("nodeid", nodeId);
            }
            item.put("entityname", entityName);
            item.put("entitynumber", entityNumber);
            item.put("allowstart", Boolean.TRUE);
            Object operations = properties.get((Object)"decisionOptions");
            if (operations != null) {
                item.put("operation", SerializationUtils.toJsonString((Object)operations));
            }
            plugin.setObjectProperty("node_1", "startItems", startItems);
        }
    }

    public static void updateStartItemWhenEntityNumberChanged(IFormView ideView, JSONObject properties, String oriEntityNumber, String procEntityNumber) {
        ISupportDesignerModelChange plugin = DesignerPluginUtil.getSupportModelChangePlugin(ideView);
        if (plugin != null) {
            Map<String, Object> startItem;
            String entityName = properties.getString("entityName");
            String entityNumber = properties.getString("entityNumber");
            String itemId = properties.getString("itemId");
            List<Map<String, Object>> startItems = plugin.getListPropertyValue("node_1", "startItems");
            Map<String, Object> oriStartItem = BizFlowPluginUtil.getStartItemByEntityNumber(startItems, oriEntityNumber);
            if (oriStartItem != null) {
                String nodeIds = (String)oriStartItem.get("nodeid");
                if ("".equals((nodeIds = nodeIds.replaceAll(String.format("\\b%s\\b", itemId), "")).trim())) {
                    BizFlowPluginUtil.deleteListItem(startItems, "entitynumber", oriEntityNumber);
                } else {
                    oriStartItem.put("nodeid", nodeIds);
                }
            }
            if ((startItem = BizFlowPluginUtil.getStartItemByEntityNumber(startItems, entityNumber)) == null) {
                HashMap<String, Object> item = new HashMap<String, Object>();
                startItems.add(item);
                String id = BpmnDiffUtil.getListElementId((String)"startItems");
                item.put("id", id);
                item.put("nodeid", itemId);
                item.put("entityname", entityName);
                item.put("entitynumber", entityNumber);
                item.put("allowstart", procEntityNumber.equals(entityNumber));
                Object operations = properties.get((Object)"decisionOptions");
                if (operations != null) {
                    item.put("operation", SerializationUtils.toJsonString((Object)operations));
                }
            } else {
                String nodeIds = String.format("%s %s", startItem.get("nodeid"), itemId);
                startItem.put("nodeid", nodeIds);
                JSONArray operations = properties.getJSONArray("operation");
                if (operations != null && !operations.isEmpty()) {
                    ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>(operations.size());
                    for (int i = 0; i < operations.size(); ++i) {
                        datas.add((Map<String, Object>)operations.getJSONObject(i));
                    }
                    BizFlowPluginUtil.mergeStartItemOperations(startItem, datas);
                }
            }
            plugin.setObjectProperty("node_1", "startItems", startItems);
        }
    }

    public static void updateStartItemOperation(String modelType, String entityNumber, IFormView ideView, Object returnData) {
        if (!BizFlowPluginUtil.isBizFlow(modelType)) {
            return;
        }
        if (returnData instanceof List) {
            BizFlowPluginUtil.updateStartItemOperation(ideView, entityNumber, (List)returnData);
        } else if (returnData instanceof Map) {
            ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
            data.add((Map)returnData);
            BizFlowPluginUtil.updateStartItemOperation(ideView, entityNumber, data);
        }
    }

    public static void updateStartItemOperation(IFormView ideView, String entityNumber, List<Map<String, Object>> datas) {
        ISupportDesignerModelChange plugin = DesignerPluginUtil.getSupportModelChangePlugin(ideView);
        List<Map<String, Object>> startItems = plugin.getListPropertyValue("node_1", "startItems");
        Map<String, Object> startItem = BizFlowPluginUtil.getStartItemByEntityNumber(startItems, entityNumber);
        if (startItem == null) {
            log.debug("startItem is null! " + entityNumber);
            return;
        }
        BizFlowPluginUtil.mergeStartItemOperations(startItem, datas);
        plugin.setObjectProperty("node_1", "startItems", startItems);
    }

    private static void mergeStartItemOperations(Map<String, Object> startItem, List<Map<String, Object>> decisionOptions) {
        if (decisionOptions == null || decisionOptions.isEmpty()) {
            return;
        }
        String operationStr = (String)startItem.get("operation");
        if (WfUtils.isEmpty((String)operationStr)) {
            ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>(decisionOptions.size());
            for (Map<String, Object> operation : decisionOptions) {
                datas.add(operation);
            }
            String result = SerializationUtils.toJsonString(datas);
            startItem.put("operation", result);
        }
    }

    private static List<Map<String, Object>> getMergedOperations(List<Map<String, Object>> operations, List<Map<String, Object>> datas) {
        String number = "number";
        for (Map<String, Object> operation : operations) {
            Iterator<Map<String, Object>> iterator = datas.iterator();
            while (iterator.hasNext()) {
                Map<String, Object> data = iterator.next();
                if (!operation.get(number).equals(data.get(number))) continue;
                iterator.remove();
            }
        }
        operations.addAll(datas);
        return operations;
    }

    public static void showBatchNumberPage(IFormView view, IFormPlugin plugin, String gridKey, String callBackId, String entityNumberKey, String batchNumberKey) {
        EntryGrid grid = (EntryGrid)view.getControl(gridKey);
        int focusRow = grid.getEntryState().getFocusRow();
        IDataModel model = view.getModel();
        String entityNumber = (String)model.getValue(entityNumberKey, focusRow);
        String batchNumber = (String)model.getValue(batchNumberKey, focusRow);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCloseCallBack(new CloseCallBack(plugin, callBackId));
        parameter.setFormId("wf_valueexpression");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("entityNumber", (Object)entityNumber);
        parameter.setCustomParam("ruleType", (Object)ConditionalRuleType.skip);
        parameter.setCustomParam("expression", (Object)batchNumber);
        view.showForm(parameter);
    }

    public static void setStartItemBatchNumber(IFormView view, Object returnData, String gridKey, String batchNumberKey, String batchNumNameKey) {
        if (returnData instanceof Map) {
            EntryGrid grid = (EntryGrid)view.getControl(gridKey);
            Map data = (Map)returnData;
            String expression = (String)data.get("expression");
            String propStr = (String)data.get("prop");
            String fullName = "";
            if (propStr != null) {
                Map prop = (Map)SerializationUtils.fromJsonString((String)propStr, Map.class);
                fullName = (String)prop.get("fullName");
            }
            int rowIndex = grid.getSelectRows()[0];
            IDataModel model = view.getModel();
            model.setValue(batchNumNameKey, (Object)fullName, rowIndex);
            model.setValue(batchNumberKey, (Object)expression, rowIndex);
        }
    }

    public static void deleteListItem(List<Map<String, Object>> list, String idKey, String idValue) {
        Iterator<Map<String, Object>> iterator = list.iterator();
        while (iterator.hasNext()) {
            Map<String, Object> item = iterator.next();
            if (!idValue.equals(item.get(idKey))) continue;
            iterator.remove();
            break;
        }
    }

    public static void openBizEventListPage(IFormView view, IFormPlugin plugin, String actionId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCloseCallBack(new CloseCallBack(plugin, actionId));
        parameter.setFormId("wf_common_f7list");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("billFormId", (Object)"wf_evt_eventlist");
        parameter.setShowTitle(false);
        view.showForm(parameter);
    }

    public static void setEntryFieldEnable(boolean enable, int index, FieldEdit ... fields) {
        for (FieldEdit field : fields) {
            field.setEnable(field.getFieldKey(), enable, index);
        }
    }

    public static List<Map<String, Object>> getListPropertyValue(GraphModel graphModel, String nodeId, String property) {
        GraphCell cell = graphModel.getGraphCell(nodeId);
        if (cell != null) {
            Map properties = cell.getProperties();
            Object data = DesignerModelUtil.getProperty(properties, property);
            if (data instanceof List) {
                return (List)data;
            }
            log.debug(String.format("%s's %s is not a list!", nodeId, property));
        } else {
            log.debug(String.format("%s not exist!", nodeId));
        }
        return null;
    }

    public static List<Map<String, Object>> getNotOverlengthOperations(List<Map<String, Object>> datas, int maxSize) {
        StringBuilder sb = new StringBuilder();
        ArrayList<Map<String, Object>> operations = new ArrayList<Map<String, Object>>(datas.size());
        for (Map<String, Object> operation : datas) {
            sb.append(operation.get("number"));
            if (sb.length() > maxSize) break;
            sb.append(",");
            operations.add(operation);
        }
        return operations;
    }

    public static String openBillRelationGraph(Long procInstId, IFormView view) {
        if ("false".equals(WfConfigurationUtil.getConfigCenterVal((String)"workflow.relationGraph.recordRelationData"))) {
            RepositoryService service = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getRepositoryService();
            String fields = String.format("%s,%s", "entitynumber", "businessKey");
            HistoricProcessInstanceEntity hiProcInst = (HistoricProcessInstanceEntity)service.findEntityById(procInstId, "wf_hiprocinst", fields);
            return BizFlowUtil.showBillRelation((IFormView)view, (String)hiProcInst.getEntitynumber(), (String)hiProcInst.getBusinessKey());
        }
        return BizFlowUtil.showBillRelation((Long)procInstId, (IFormView)view);
    }
}

