/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.filter.CompareTypeDto;
import kd.bos.lang.Lang;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.Macro;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.Task;
import kd.bos.workflow.bpmn.model.Variable;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.comparetype.CompareTypesUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.bos.workflow.engine.impl.util.condition.ConditionalRuleHelper;
import kd.bos.workflow.taskcenter.plugin.rule.ConditionRegister;

public class ConditionalRuleUtil {
    private static final String NUMBERREGEX = "^(-?([1-9]\\d*)|0)|(-?(0|([1-9]{1,}))\\.\\d*[1-9])$";
    private static final String CONNECTOR_HYPHEN = " - ";
    private static final String CONNECTOR_DOT = ".";
    public static final String NEEDSOURCEELEMENT = "needSourceElement";

    public static boolean isNumber(Object num) {
        return String.valueOf(num).matches(NUMBERREGEX);
    }

    public static String getEntryBillNumber(Process process, String nodeId, Object needSourceElement) {
        return ConditionalRuleHelper.getEntryBillNumber((Process)process, (String)nodeId, (Object)needSourceElement);
    }

    public static boolean isBaseType(String dataType) {
        String baseDataType = "string,number,date,boolean";
        return baseDataType.indexOf(dataType.toLowerCase()) > -1;
    }

    public static boolean isBaseData(String dataType) {
        return dataType.equals("user") || dataType.equals("org") || dataType.equals("basedata");
    }

    private static Map<String, Object> getConditionItemValue(String prefix, String number, String type) {
        HashMap<String, Object> value = new HashMap<String, Object>();
        if ("string".equals(type)) {
            type = "text";
        }
        value.put("number", ConditionalRuleUtil.getDecoratedNumber(prefix, CONNECTOR_DOT, number));
        value.put("type", type);
        return value;
    }

    private static Map<String, Object> getConditionItemValue(String prefix, String number, String type, String entityId) {
        Map<String, Object> value = ConditionalRuleUtil.getConditionItemValue(prefix, number, type);
        if (WfUtils.isNotEmpty((String)entityId)) {
            value.put("entityId", entityId);
        }
        return value;
    }

    private static List<Map<String, Object>> getListWrappedValue(Map<String, Object> value) {
        ArrayList<Map<String, Object>> values = new ArrayList<Map<String, Object>>();
        values.add(value);
        return values;
    }

    private static Map<String, Object> getConditionItemValue(String prefix, String number, String type, List<Object> items) {
        Map<String, Object> value = ConditionalRuleUtil.getConditionItemValue(prefix, number, type);
        value.put("items", items);
        return value;
    }

    private static String getEntityId(String type) {
        if (WfUtils.isEmpty((String)type)) {
            return null;
        }
        switch (type) {
            case "user": {
                return "bos_user";
            }
            case "org": {
                return "bos_org";
            }
        }
        return null;
    }

    public static List<Map<String, Object>> getBillConditions(String entityId) {
        List<Map<String, Object>> conditions = ConditionRegister.getBillConditions(entityId);
        Object groupId = null;
        Object type = null;
        String prefix = ResManager.loadKDString((String)"\u5355\u636e", (String)"ConditionalRuleUtil_1", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        for (Map<String, Object> condition : conditions) {
            ConditionalRuleUtil.setCommonField(condition);
            condition.put("fieldCaption", ConditionalRuleUtil.getDecoratedNumber(prefix, CONNECTOR_HYPHEN, condition.get("fieldCaption").toString()));
            type = ((Map)((List)condition.get("value")).get(0)).get("type");
            condition.put("commVal", ((List)condition.get("value")).get(0));
            condition.put("fieldVal", ConditionalRuleUtil.getFieldVal(condition.get("fieldName").toString(), entityId));
            condition.remove("value");
        }
        return conditions;
    }

    public static List<Map<String, Object>> getProcessInfoConditions(Process process, String entityId, String nodeId, String type) {
        List macros = process.getMacros();
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>(macros.size());
        HashMap<String, Object> item = null;
        Macro macro = null;
        String name = null;
        String caption = null;
        String prefix = "proc";
        Map<String, Object> value = null;
        for (int i = 0; i < macros.size(); ++i) {
            macro = (Macro)macros.get(i);
            item = new HashMap<String, Object>();
            name = macro.getName();
            value = ConditionalRuleUtil.getConditionItemValue(prefix, name, macro.getDataType(), ConditionalRuleUtil.getEntityId(macro.getDataType()));
            if (name.matches(String.format("%s\\w+%s", process.getId(), "AuditNumber"))) {
                String activityId = name.substring(0, name.length() - "AuditNumber".length());
                value.put("items", ConditionalRuleUtil.getAuditNumberItems((AuditTask)process.getFlowElement(activityId)));
            }
            caption = WfUtils.isEmpty((String)macro.getDescription()) ? name : macro.getDescription();
            ConditionalRuleUtil.setConditionItemMapField(item, ConditionalRuleUtil.getDecoratedNumber(prefix, CONNECTOR_DOT, name), ConditionalRuleUtil.getDecoratedNumber(ResManager.loadKDString((String)"\u6d41\u7a0b", (String)"ConditionalRuleUtil_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), CONNECTOR_HYPHEN, caption), macro.getDataType(), value, ConditionalRuleUtil.getFieldVal(ConditionalRuleUtil.getDecoratedNumber(prefix, CONNECTOR_DOT, name), entityId));
            items.add(item);
        }
        return items;
    }

    public static List<Map<String, Object>> getProcessVariableConditions(Process process, String type, String nodeId, String entityId) {
        Task task;
        List<Map<String, Object>> items;
        List<Map<String, Object>> variableItems = ConditionalRuleUtil.getElementVariableConditions((BaseElement)process, entityId);
        if ((ConditionalRuleType.skip.toString().equals(type) || ConditionalRuleType.autoApproval.toString().equals(type)) && !(items = ConditionalRuleUtil.getElementVariableConditions((BaseElement)(task = (Task)process.getFlowElement(nodeId)), entityId)).isEmpty()) {
            for (Map<String, Object> tmp : items) {
                if (!"currentParticipant".equalsIgnoreCase((String)tmp.get("fieldName"))) continue;
                variableItems.add(tmp);
                break;
            }
        }
        return variableItems;
    }

    public static List<Map<String, Object>> getElementVariableConditions(BaseElement element, String entityId) {
        List variables = null;
        String prefix = ResManager.loadKDString((String)"\u6d41\u7a0b", (String)"ConditionalRuleUtil_2", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        if (element instanceof Process) {
            variables = ((Process)element).getVariables();
        } else {
            prefix = element.getName();
            variables = ((Task)element).getVariables();
        }
        AuditTask auditTask = null;
        if (element instanceof AuditTask) {
            auditTask = (AuditTask)element;
        }
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>(variables.size());
        Variable variable = null;
        HashMap<String, Object> item = null;
        Map<String, Object> value = null;
        String number = null;
        String caption = null;
        for (int i = 0; i < variables.size(); ++i) {
            variable = (Variable)variables.get(i);
            item = new HashMap<String, Object>();
            number = variable.getName();
            value = ConditionalRuleUtil.getConditionItemValue("", number, variable.getType(), ConditionalRuleUtil.getEntityId(variable.getType()));
            if ("auditNumber".equals(number)) {
                value.put("items", ConditionalRuleUtil.getAuditNumberItems(auditTask));
            }
            caption = WfUtils.isEmpty((String)variable.getDescription()) ? number : variable.getDescription();
            ConditionalRuleUtil.setConditionItemMapField(item, number, ConditionalRuleUtil.getDecoratedNumber(prefix, CONNECTOR_HYPHEN, caption), variable.getType(), value, ConditionalRuleUtil.getFieldVal(number, entityId));
            items.add(item);
        }
        return items;
    }

    private static List<ValueMapItem> getAuditNumberItems(AuditTask auditTask) {
        ArrayList<ValueMapItem> vmItems = new ArrayList<ValueMapItem>();
        if (auditTask != null) {
            List options = auditTask.getDecisionOptions();
            for (DecisionOption option : options) {
                vmItems.add(new ValueMapItem(null, option.getNumber(), new LocaleString(option.getName())));
            }
        }
        return vmItems;
    }

    public static List<Map<String, Object>> getBracketList(int num, boolean left, boolean nullable) {
        String bkt = left ? "(" : ")";
        ArrayList<Map<String, Object>> brackets = new ArrayList<Map<String, Object>>(num);
        HashMap<String, Object> bracket = null;
        if (nullable) {
            bracket = new HashMap<String, Object>();
            bracket.put("name", new LocaleString(Lang.zh_CN.toString(), " "));
            bracket.put("number", " ");
            brackets.add(bracket);
        }
        for (int i = 1; i <= num; ++i) {
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < i; ++j) {
                sb.append(bkt);
            }
            bracket = new HashMap();
            bracket.put("name", new LocaleString(Lang.zh_CN.toString(), sb.toString()));
            bracket.put("number", sb.toString());
            brackets.add(bracket);
        }
        return brackets;
    }

    public static List<Map<String, Object>> getLogicList() {
        ArrayList<Map<String, Object>> logics = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> logic = new HashMap<String, Object>();
        logic.put("name", new LocaleString(Lang.zh_CN.toString(), ResManager.loadKDString((String)"\u5e76\u4e14", (String)"ConditionalRuleUtil_3", (String)"bos-wf-formplugin", (Object[])new Object[0])));
        logic.put("number", "&&");
        logics.add(logic);
        logic = new HashMap();
        logic.put("name", new LocaleString(Lang.zh_CN.toString(), ResManager.loadKDString((String)"\u6216\u8005", (String)"ConditionalRuleUtil_4", (String)"bos-wf-formplugin", (Object[])new Object[0])));
        logic.put("number", "||");
        logics.add(logic);
        return logics;
    }

    private static void setConditionItemMapField(Map<String, Object> item, String fieldName, String caption, String type, Map<String, Object> value, Map<String, Object> fieldVal) {
        item.put("fieldName", fieldName);
        item.put("fieldType", ConditionalRuleUtil.getFieldTypeByType(type));
        item.put("fieldCaption", caption);
        item.put("commVal", value);
        item.put("fieldVal", fieldVal);
        String cpGroupId = ConditionalRuleUtil.getCompareGroupIdByType(type);
        item.put("compareGroupID", cpGroupId);
        item.put("compareTypes", ConditionalRuleUtil.getCompareItems(cpGroupId));
        ConditionalRuleUtil.setCommonField(item);
    }

    private static void setCommonField(Map<String, Object> item) {
        item.put("leftBracket", ConditionalRuleUtil.getBracketList(3, true, true));
        item.put("rightBracket", ConditionalRuleUtil.getBracketList(3, false, true));
        item.put("logic", ConditionalRuleUtil.getLogicList());
    }

    public static String getShowText(JSONObject conditionRule) {
        if (conditionRule != null && !conditionRule.isEmpty()) {
            JSONObject showText = (JSONObject)conditionRule.get((Object)"showtext");
            if (showText != null && !showText.isEmpty()) {
                return (String)showText.get((Object)RequestContext.get().getLang().toString());
            }
            Object conditions = conditionRule.get((Object)"entryentity");
            if (conditions instanceof JSONArray && !((JSONArray)conditions).isEmpty()) {
                return ResManager.loadKDString((String)"\u7236\u65b9\u6848\u201c\u663e\u793a\u6587\u5b57\u201d\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"ConditionalRuleUtil_5", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            }
            return "";
        }
        return null;
    }

    private static String getDecoratedNumber(String prefix, String connector, String number) {
        if (WfUtils.isEmpty((String)prefix)) {
            return number;
        }
        return String.format("%s%s%s", prefix, connector, number);
    }

    private static int getFieldTypeByType(String type) {
        switch (type) {
            case "number": {
                return 2;
            }
            case "date": {
                return 91;
            }
            case "boolean": {
                return -7;
            }
            case "user": 
            case "org": {
                return -5;
            }
        }
        return 12;
    }

    public static String getCompareGroupIdByType(String type) {
        switch (type) {
            case "number": {
                return "1";
            }
            case "date": 
            case "datetime": {
                return "2";
            }
            case "boolean": {
                return "3";
            }
            case "user": {
                return "15";
            }
            case "org": {
                return "16";
            }
            case "basedata": {
                return "14";
            }
        }
        return "0";
    }

    private static List<CompareTypeDto> getCompareItems(String cpGroupId) {
        CompareTypesUtils cpTypesUtils = CompareTypesUtils.get();
        ArrayList<CompareTypeDto> cpList = new ArrayList<CompareTypeDto>();
        cpList.addAll(cpTypesUtils.getCompareTypesById(cpGroupId));
        return cpList;
    }

    private static Map<String, Object> getFieldVal(String number, String entityId) {
        HashMap<String, Object> fieldVal = new HashMap<String, Object>();
        fieldVal.put("type", "enum");
        fieldVal.put("number", number);
        return fieldVal;
    }
}

