/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.domainmodel.Category;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.domainmodel.ElementType;
import kd.bos.metadata.domainmodel.Property;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.converter.BpmnJsonConverter;
import kd.bos.workflow.bpmn.converter.util.ModelConfigUtil;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.model.AutoTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.design.graph.model.GraphModel;
import kd.bos.workflow.design.plugin.AbstractWorkflowConfigPlugin;
import kd.bos.workflow.design.plugin.AbstractWorkflowDesignerPlugin;
import kd.bos.workflow.design.plugin.model.ShareConfig;
import kd.bos.workflow.design.plugin.model.ShareInfo;
import kd.bos.workflow.design.plugin.model.StateItem;
import kd.bos.workflow.design.plugin.model.StencilConfig;
import kd.bos.workflow.design.plugin.model.StencilConfigs;
import kd.bos.workflow.design.plugin.model.StencilCtrlState;
import kd.bos.workflow.design.plugin.model.StencilProperty;
import kd.bos.workflow.design.plugin.model.StencilUIConfig;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.persistence.entity.management.NodeTemplateEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.validation.ValidationError;
import org.apache.commons.collections4.CollectionUtils;

public class DesignerModelUtil {
    private static Map<String, StencilConfigs> stencilConfigsMultiLang = new ConcurrentHashMap<String, StencilConfigs>();
    private static Map<String, Set<String>> modelExtendedMap = new ConcurrentHashMap<String, Set<String>>();
    private static Log log = LogFactory.getLog(DesignerModelUtil.class);

    public static BpmnModel getBpmnModel(String modelJson) throws JsonProcessingException, IOException {
        JsonNode jsonNode = new ObjectMapper().readTree(modelJson);
        BpmnModel bpmnModel = new BpmnJsonConverter().convertToBpmnModel(jsonNode);
        return bpmnModel;
    }

    public static boolean hasProperty(Map<String, Object> node, String prop) {
        return BpmnModelUtil.hasProperty(node, (String)prop);
    }

    public static Object getProperty(Map<String, Object> node, String prop) {
        return BpmnModelUtil.getProperty(node, (String)prop);
    }

    public static Object getSimplePropertyValue(Map<String, Object> node, String prop) {
        return BpmnModelUtil.getSimplePropertyValue(node, (String)prop);
    }

    public static void setProperty(Map<String, Object> node, String prop, Object value) {
        BpmnModelUtil.setProperty(node, (String)prop, (Object)value);
    }

    public static boolean isPropertyHide(Property property) {
        return property.getHide() != null && Boolean.TRUE.equals(property.getHide().get("hide"));
    }

    public static boolean isPropertyNeedHide(String modelType, String stencilType, String propName, String scene) {
        StencilProperty property = DesignerModelUtil.getConfigProperty(modelType, stencilType, propName);
        return property == null || property.isHide(scene);
    }

    public static boolean isPropertiesNeedHide(String modelType, String stencilType, String ... names) {
        StencilConfig config = DesignerModelUtil.getStencilConfig(modelType, stencilType);
        if (config == null) {
            log.debug("StencilConfig is null\uff01 StencilType\uff1a " + stencilType);
            return true;
        }
        List<Property> properties = config.getProperties();
        int size = names.length;
        block0: for (Property property : properties) {
            if (size == 0) break;
            for (String name : names) {
                if (!property.getPropertyName().equals(name)) continue;
                if (!DesignerModelUtil.isPropertyHide(property)) {
                    return false;
                }
                --size;
                continue block0;
            }
        }
        return true;
    }

    public static String openSelectEntitiesPage(IFormView view, IFormPlugin plugin, String actionId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCloseCallBack(new CloseCallBack(plugin, actionId));
        parameter.setFormId("wf_bill_list");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setShowTitle(false);
        view.showForm(parameter);
        return parameter.getPageId();
    }

    public static String openSelectEntitiesPageByCunstomerParams(IFormView view, IFormPlugin plugin, String actionId, Map<String, Object> params) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCloseCallBack(new CloseCallBack(plugin, actionId));
        parameter.setFormId("wf_bill_list");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setShowTitle(false);
        parameter.setCustomParams(params);
        view.showForm(parameter);
        return parameter.getPageId();
    }

    public static List<String> getNodeBill(GraphModel graphModel, String itemId) {
        List<String> entityNumbers = new ArrayList<String>();
        BpmnModel bpmnModel = graphModel.getBpmnModel();
        FlowNode flowElements = (FlowNode)bpmnModel.getFlowElement(itemId);
        List sequenceFlows = flowElements.getIncomingFlows();
        if (CollectionUtils.isEmpty((Collection)sequenceFlows)) {
            return null;
        }
        for (SequenceFlow sequenceFlow : sequenceFlows) {
            String entityNUmber;
            FlowNode flowElement;
            Map<String, Object> cellproperties;
            String flowNode = sequenceFlow.getSourceRef();
            if (flowNode == null || (cellproperties = graphModel.getCellProperties((flowElement = (FlowNode)bpmnModel.getFlowElement(flowNode)).getId())) == null || cellproperties.size() <= 0) continue;
            String entityId = (String)cellproperties.get("entityId");
            if (entityId == null && flowElement instanceof AutoTask) {
                entityId = ((AutoTask)flowElement).getEntityId();
            }
            if ((entityNUmber = MetadataDao.getNumberById((String)entityId)) == null) continue;
            entityNumbers.add(entityNUmber);
        }
        if (entityNumbers.size() > 0) {
            entityNumbers = entityNumbers.stream().distinct().collect(Collectors.toList());
        }
        return entityNumbers;
    }

    public static String openAuditFlowDesigner(Long modelId, IFormView view) {
        return DesignerModelUtil.openAuditFlowDesigner(modelId, view, true);
    }

    public static String openAuditFlowDesigner(Long modelId, IFormView view, boolean useTabType) {
        return DesignerModelUtil.openWorkflowDesigner("WorkflowModel", modelId, view, useTabType);
    }

    public static String openBizFlowDesigner(Long modelId, IFormView view) {
        return DesignerModelUtil.openBizFlowDesigner(modelId, view, true);
    }

    public static String openBizFlowDesigner(Long modelId, IFormView view, boolean useTabType) {
        return DesignerModelUtil.openWorkflowDesigner("BizFlowModel", modelId, view, useTabType);
    }

    public static String openWorkflowDesigner(String type, Long modelId, IFormView view, boolean useTabType) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("BizFlowModel".equals(type) ? "ide_bizflowdesigner" : "ide_workflowdesigner");
        parameter.setCustomParam("model_type", (Object)type);
        parameter.setCustomParam("id", (Object)modelId.toString());
        parameter.setClientParam("modelId", (Object)modelId.toString());
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        String formId = view.getFormShowParameter().getFormId();
        IFormView tabView = null;
        if (useTabType && (tabView = DesignerModelUtil.getTabControlView(view)) != null) {
            parameter.getOpenStyle().setTargetKey("_submaintab_");
            tabView.showForm(parameter);
            view.sendFormAction(tabView);
        } else if (null != view.getParentView() && ("wf_modelwizard".equals(formId) || "wf_modelwizardduplicate".equals(formId) || "wf_modelwizardbytemplate".equals(formId) || "wf_modelwizardbaseinfo".equals(formId))) {
            view.getParentView().showForm(parameter);
            view.sendFormAction(view.getParentView());
        } else {
            view.showForm(parameter);
        }
        return parameter.getPageId();
    }

    public static String openAuditFlowDynamicConfigScheme(IFormView view, Long procDefId) {
        return DesignerModelUtil.openDynamicConfigScheme("WorkflowModel", view, procDefId, null, null);
    }

    public static String openBizFlowDynamicConfigScheme(IFormView view, Long procDefId) {
        return DesignerModelUtil.openDynamicConfigScheme("BizFlowModel", view, procDefId, null, null);
    }

    public static String openDynamicConfigScheme(String type, IFormView view, Long procDefId, Long schemeId, String itemId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setShowTitle(false);
        showParameter.setFormId("wf_processconfig_scheme");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getOpenStyle().setTargetKey("_submaintab_");
        showParameter.setCustomParam("model_type", (Object)type);
        showParameter.setCustomParam("procDefId", (Object)procDefId);
        if (schemeId != null) {
            showParameter.setCustomParam("config_scheme_id", (Object)String.valueOf(schemeId));
            showParameter.setClientParam("config_scheme_id", (Object)String.valueOf(schemeId));
        } else {
            showParameter.setClientParam("procDefId", (Object)String.valueOf(procDefId));
        }
        if (itemId != null) {
            showParameter.setCustomParam("selected_cellId", (Object)itemId);
            showParameter.setClientParam("selected_cellId", (Object)itemId);
        }
        view.showForm(showParameter);
        return showParameter.getPageId();
    }

    public static IFormView getTabControlView(IFormView view) {
        IFormView parentView = view;
        while ((parentView = parentView.getParentView()) != null && !"pc_main_console".equals(parentView.getFormShowParameter().getFormId())) {
            Control control = parentView.getControl("_submaintab_");
            if (control == null) continue;
            return parentView;
        }
        return null;
    }

    public static AbstractWorkflowConfigPlugin getWorkflowNodeTempaltePlugin(IFormView designerView) {
        if (designerView == null) {
            return null;
        }
        FormViewPluginProxy proxy = (FormViewPluginProxy)designerView.getService(FormViewPluginProxy.class);
        for (IFormPlugin plugin : proxy.getPlugIns()) {
            if (!(plugin instanceof AbstractWorkflowConfigPlugin)) continue;
            return (AbstractWorkflowConfigPlugin)plugin;
        }
        return null;
    }

    public static AbstractWorkflowDesignerPlugin getWorkflowDesignerPlugin(IFormView designerView) {
        if (designerView == null) {
            return null;
        }
        FormViewPluginProxy proxy = (FormViewPluginProxy)designerView.getService(FormViewPluginProxy.class);
        for (IFormPlugin plugin : proxy.getPlugIns()) {
            if (!(plugin instanceof AbstractWorkflowDesignerPlugin)) continue;
            return (AbstractWorkflowDesignerPlugin)plugin;
        }
        return null;
    }

    public static StencilProperty getConfigProperty(String modelType, String stencilType, String propName) {
        if (WfUtils.isEmpty((String)stencilType)) {
            log.debug("StencilType is null\uff01");
            return null;
        }
        StencilConfig config = DesignerModelUtil.getStencilConfig(modelType, stencilType);
        if (config != null) {
            return config.getStencilProperty(propName);
        }
        return null;
    }

    private static synchronized void initStencils(String modelType) {
        StencilConfigs localeConfigs = DesignerModelUtil.getStencilLocaleConfigs();
        Map<String, List<StencilConfig>> modelStencilConfigs = localeConfigs.getModelStencilConfigs();
        Map<String, StencilConfig> stencilConfigMap = localeConfigs.getStencilConfigMap();
        List<StencilConfig> stencilConfigs = modelStencilConfigs.get(modelType);
        if (stencilConfigs == null || stencilConfigs.isEmpty() || stencilConfigMap.isEmpty()) {
            log.debug("initStencils: stencilConfigMap is empty, begin init!");
            DomainModelType model = GraphCodecUtils.getDomainType((String)modelType);
            if (model == null) {
                return;
            }
            log.debug("initStencils: begin init DomainModelStencilConfigs! " + model.getId());
            DesignerModelUtil.initDomainModelStencilConfigs(model);
            log.debug("initStencils: begin init ExtModelStencilConfigs! " + model.getId());
            DesignerModelUtil.initExtModelStencilConfigs(model);
        }
    }

    private static String getStencilKey(String modelType, String stencilType) {
        return String.format("%s_%s", modelType, stencilType);
    }

    public static StencilConfig getStencilConfig(String modelType, String stencilType) {
        log.debug(String.format("\u83b7\u53d6 %s \u6a21\u578b  %s \u8282\u70b9\u7684\u914d\u7f6e\uff01", modelType, stencilType));
        if (WfUtils.isEmpty((String)modelType) || WfUtils.isEmpty((String)stencilType)) {
            log.debug("modelType is null or stencilType is null!");
        } else {
            StencilConfigs localeConfigs = DesignerModelUtil.getStencilLocaleConfigs();
            Map<String, StencilConfig> stencilConfigMap = localeConfigs.getStencilConfigMap();
            Map<String, List<StencilConfig>> modelStencilConfigs = localeConfigs.getModelStencilConfigs();
            List<StencilConfig> modelStencilConfig = modelStencilConfigs.get(modelType);
            if (stencilConfigMap.isEmpty() || modelStencilConfig == null || !DesignerModelUtil.isInitialized(modelType)) {
                log.debug(String.format("getStencilConfig: [%s][%s]! ", stencilConfigMap.isEmpty(), modelStencilConfig == null));
                DesignerModelUtil.initStencils(modelType);
            }
            log.debug(String.format("size info:modelStencilConfig[%s]modelType[%s] stencilConfigMap[%s]modelStencilConfig[%s]! ", modelStencilConfig == null ? null : Integer.valueOf(modelStencilConfig.size()), modelType, stencilConfigMap == null ? null : Integer.valueOf(stencilConfigMap.size()), modelStencilConfig == null ? null : Integer.valueOf(modelStencilConfig.size())));
            String stencilKey = DesignerModelUtil.getStencilKey(modelType, stencilType);
            StencilConfig config = DesignerModelUtil.getStencilConfigByStencilKey(stencilKey, stencilConfigMap, modelStencilConfig);
            log.debug(String.format("config is [%s]", config == null ? null : config.getId()));
            if (config == null) {
                log.debug(String.format("stencilType is [%s]", stencilType));
                WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
                QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)stencilType)};
                List entities = service.getRepositoryService().findEntitiesByFilters("wf_nodetemplate", filters);
                if (entities != null && !entities.isEmpty()) {
                    NodeTemplateEntity entity = (NodeTemplateEntity)entities.get(0);
                    config = stencilConfigMap.get(DesignerModelUtil.getStencilKey(modelType, entity.getStencilType()));
                    StencilConfig clone = config.clone();
                    clone.setId(entity.getNumber());
                    clone.setStencilName(entity.getName());
                    clone.setTemplate(entity.getStencilType());
                    Date modifyDate = entity.getModifyTime();
                    long times = modifyDate.getTime();
                    String stencilTime = String.valueOf(times);
                    clone.setStencilTime(stencilTime);
                    String props = entity.getProperties();
                    if (WfUtils.isNotEmpty((String)props)) {
                        Map<String, StencilProperty> propMap = clone.getPropertiesMap();
                        JSONObject properties = JSON.parseObject((String)props);
                        Set<Map.Entry<String, StencilProperty>> propMapEntrySet = propMap.entrySet();
                        for (Map.Entry<String, StencilProperty> prop : propMapEntrySet) {
                            StencilProperty stencilProperty = prop.getValue();
                            Object defaultValue = DesignerModelUtil.getProperty((Map<String, Object>)properties, DesignerModelUtil.getPropertyPath(stencilProperty.getGroupId(), stencilProperty.getPropertyName()));
                            if (defaultValue == null) continue;
                            stencilProperty.setDefaultValue(defaultValue);
                        }
                    }
                    stencilConfigMap.put(stencilKey, clone);
                    if (WfUtils.isEmpty((String)WfCacheHelper.getStencilConfigTime((String)entity.getNumber()))) {
                        WfCacheHelper.putStencilConfigTime((String)entity.getNumber(), (String)stencilTime);
                    }
                    return clone;
                }
                log.debug(String.format("getStencilConfig entities is:null,stencilKey is:%s", stencilKey));
            } else {
                return config;
            }
        }
        return null;
    }

    public static StencilConfig getStencilConfigByStencilKey(String stencilKey, Map<String, StencilConfig> stencilConfigMap, List<StencilConfig> modelStencilConfig) {
        StencilConfig config = stencilConfigMap.get(stencilKey);
        log.debug(String.format("getStencilConfigByStencilKey stencilKey is : %s,%s", stencilKey, config == null ? null : config.getId()));
        HashSet xmlStencilTypes = new HashSet();
        xmlStencilTypes.addAll(ModelConfigUtil.getBuiltInStencilTypes());
        xmlStencilTypes.addAll(ModelConfigUtil.getAllExtendedStencilTypes());
        log.debug(String.format("xmlStencilTypes[%s]", WfUtils.listToString(xmlStencilTypes, (String)",")));
        if (config != null && (xmlStencilTypes.contains(config.getId()) || WfUtils.isNotEmpty((String)config.getStencilTime()) && config.getStencilTime().equals(WfCacheHelper.getStencilConfigTime((String)config.getId())))) {
            log.debug("getStencilConfigByStencilKey StencilConfig is : not null");
            return config;
        }
        log.debug("getStencilConfigByStencilKey StencilConfig is : null");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StencilConfigs getStencilLocaleConfigs() {
        String lang = Lang.get().toString();
        StencilConfigs stencilLocaleConfigs = stencilConfigsMultiLang.get(lang);
        Class<StencilConfigs> clazz = StencilConfigs.class;
        synchronized (StencilConfigs.class) {
            stencilLocaleConfigs = stencilConfigsMultiLang.get(lang);
            if (stencilLocaleConfigs == null) {
                stencilLocaleConfigs = new StencilConfigs();
                stencilConfigsMultiLang.putIfAbsent(lang, stencilLocaleConfigs);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return stencilLocaleConfigs;
        }
    }

    public static List<StencilConfig> getStencilConfigs(String modelType, boolean includeExtModel) {
        Map<String, List<StencilConfig>> modelStencilConfigs = DesignerModelUtil.getStencilLocaleConfigs().getModelStencilConfigs();
        if (!DesignerModelUtil.isInitialized(modelType)) {
            log.debug("getStencilConfigs: modelStencilConfigs is empty! begin initStencils!");
            DesignerModelUtil.initStencils(modelType);
        }
        if (!includeExtModel) {
            return modelStencilConfigs.get("AbstractWorkflowModel");
        }
        ArrayList<StencilConfig> stencils = new ArrayList<StencilConfig>();
        stencils.addAll((Collection)modelStencilConfigs.get(modelType));
        Set<String> extModels = modelExtendedMap.get(modelType);
        if (extModels != null && !extModels.isEmpty()) {
            for (String extModel : extModels) {
                if (modelStencilConfigs.get(extModel) != null) {
                    stencils.addAll((Collection<StencilConfig>)modelStencilConfigs.get(extModel));
                }
                log.debug("addStencilConfigs: key: " + extModel);
            }
        }
        return stencils;
    }

    private static boolean isInitialized(String modelType) {
        Map<String, List<StencilConfig>> modelStencilConfigs = DesignerModelUtil.getStencilLocaleConfigs().getModelStencilConfigs();
        List<StencilConfig> configs = modelStencilConfigs.get(modelType);
        return configs != null && !configs.isEmpty();
    }

    public static List<ShareConfig> getDomainModelSharedProperties(String modelType, String shareType) {
        if (!DesignerModelUtil.isInitialized(modelType)) {
            log.debug("getDomainModelSharedProperties: modelStencilConfigs is empty! begin initStencils!");
            DesignerModelUtil.initStencils(modelType);
        }
        StencilConfigs stencilConfigs = DesignerModelUtil.getStencilLocaleConfigs();
        ShareInfo sharedInfo = stencilConfigs.getSharedInfo();
        if ("general".equals(shareType)) {
            return sharedInfo.getGeneralSharedConfigs();
        }
        return sharedInfo.getAdvanceSharedConfigs();
    }

    private static void initDomainModelStencilConfigs(DomainModelType model) {
        log.debug("initDomainModelStencilConfigs: " + model.getId());
        if (DesignerModelUtil.isInitialized(model.getId())) {
            return;
        }
        ArrayList<StencilConfig> stencils = new ArrayList<StencilConfig>();
        List categories = model.getCategories();
        StencilConfigs stencilConfigs = DesignerModelUtil.getStencilLocaleConfigs();
        Map<String, StencilConfig> stencilConfigMap = stencilConfigs.getStencilConfigMap();
        ShareInfo sharedInfo = stencilConfigs.getSharedInfo();
        Map<String, List<StencilConfig>> modelStencilConfigs = stencilConfigs.getModelStencilConfigs();
        StencilConfig config = null;
        boolean visible = false;
        Property property = null;
        for (Category category : categories) {
            for (ElementType eltType : category.getElementTypes()) {
                config = new StencilConfig();
                config.setId(eltType.getId());
                config.setStencilName(eltType.getName().getLocaleValue());
                property = DesignerModelUtil.getStencilProperty(eltType.getProperties(), "configureFormId");
                if (property != null) {
                    config.setFormId(property.getName().toString());
                } else {
                    log.debug("configureFormId property is null!");
                }
                config.setImage(eltType.getPackageName());
                config.setBaseType(WfUtils.isNotEmpty((String)category.getBaseType()) ? category.getBaseType() : "bpmn");
                config.setCategory(category.getId());
                config.setContainer(eltType.isContainer());
                config.setProperties(eltType.getProperties());
                if (category.isVisible()) {
                    visible = !eltType.isInside();
                }
                config.setVisible(visible);
                DesignerModelUtil.initSharedPropertiesInfo(sharedInfo, config);
                stencilConfigMap.put(DesignerModelUtil.getStencilKey(model.getId(), config.getId()), config);
                stencils.add(config);
                log.debug("initDomainModelStencilConfigs: stencilConfigMap put " + config.getId());
            }
        }
        modelStencilConfigs.put(model.getId(), stencils);
    }

    private static void initSharedPropertiesInfo(ShareInfo sharedInfo, StencilConfig stencilConfig) {
        Map<String, ShareConfig> advSharedProps = stencilConfig.getAdvancedSharedProps();
        Map<String, ShareConfig> genSharedProps = stencilConfig.getGeneralSharedProps();
        sharedInfo.addGeneralSharedConfigs(genSharedProps.values());
        sharedInfo.addAdvanceSharedConfigs(advSharedProps.values());
    }

    private static Property getStencilProperty(List<Property> properties, String propName) {
        for (Property property : properties) {
            if (!propName.equals(property.getPropertyName())) continue;
            return property;
        }
        return null;
    }

    private static void initExtModelStencilConfigs(DomainModelType model) {
        List categories = model.getCategories();
        int size = categories.size();
        String extModelStr = null;
        for (int i = size - 1; i >= 0; --i) {
            if (!"ExtendControl".equals(((Category)categories.get(i)).getId())) continue;
            extModelStr = ((Category)categories.get(i)).getName().toString();
            break;
        }
        if (extModelStr != null) {
            Set<String> extendedModels = modelExtendedMap.get(model.getId());
            if (extendedModels == null) {
                extendedModels = new HashSet<String>();
                modelExtendedMap.put(model.getId(), extendedModels);
            }
            log.debug("initExtModelStencilConfigs: find ExtModels from " + model.getId());
            String[] extModels = extModelStr.split(";");
            StencilConfigs localeConfigs = DesignerModelUtil.getStencilLocaleConfigs();
            Map<String, List<StencilConfig>> modelStencilConfigs = localeConfigs.getModelStencilConfigs();
            Map<String, StencilConfig> stencilConfigMap = localeConfigs.getStencilConfigMap();
            DomainModelType extModel = null;
            String parentModelId = model.getId();
            for (String extName : extModels) {
                extModel = GraphCodecUtils.getDomainType((String)extName);
                if (extModel == null) continue;
                log.debug("initExtModelStencilConfigs: init ExtModel: " + extModel.getId());
                DesignerModelUtil.initDomainModelStencilConfigs(extModel);
                List<StencilConfig> stencilConfigs = modelStencilConfigs.get(extModel.getId());
                for (StencilConfig config : stencilConfigs) {
                    stencilConfigMap.put(DesignerModelUtil.getStencilKey(parentModelId, config.getId()), config);
                }
                extendedModels.add(extName);
            }
        }
    }

    private static synchronized void initStencilUiConfig() {
        Map<String, StencilUIConfig> stencilUiConfig = DesignerModelUtil.getStencilLocaleConfigs().getStencilUiConfig();
        if (stencilUiConfig.isEmpty()) {
            Map configs = ModelConfigUtil.getStencilsUiConfig();
            JSONObject config = null;
            StencilUIConfig uiConfig = null;
            for (Map.Entry entry : configs.entrySet()) {
                config = (JSONObject)entry.getValue();
                uiConfig = new StencilUIConfig();
                Object options = config.remove((Object)"options");
                if (options instanceof Map) {
                    uiConfig.getOptions().putAll((Map)options);
                }
                for (String key : config.keySet()) {
                    DesignerModelUtil.initStateProps(key, config, uiConfig);
                }
                stencilUiConfig.put((String)entry.getKey(), uiConfig);
            }
        }
    }

    private static void initStateProps(String ctrlKey, JSONObject config, StencilUIConfig uiConfig) {
        if (config.containsKey((Object)"_designer_") || config.containsKey((Object)"_scheme_")) {
            DesignerModelUtil.collectProps(ctrlKey, config, uiConfig);
            return;
        }
        for (String key : config.keySet()) {
            DesignerModelUtil.initStateProps(key, config.getJSONObject(key), uiConfig);
        }
    }

    private static void collectProps(String ctrlKey, JSONObject config, StencilUIConfig uiConfig) {
        JSONObject schemeConfig;
        Set keys;
        JSONObject designerConfig = config.getJSONObject("_designer_");
        if (designerConfig != null) {
            Object readonly;
            Object readOnlyState;
            Object hidden;
            Object hiddenState;
            if (uiConfig.getDesigner() == null) {
                uiConfig.setDesigner(new StencilCtrlState());
            }
            if ((hiddenState = designerConfig.get((Object)"hide")) instanceof JSONObject) {
                hidden = (JSONObject)hiddenState;
                Set keys2 = hidden.keySet();
                for (Iterator key : keys2) {
                    uiConfig.getDesignerState((String)((Object)key)).getHidden().add(new StateItem(ctrlKey, hidden.getBoolean(key)));
                }
            } else if (hiddenState instanceof Boolean) {
                hidden = (Boolean)hiddenState;
                uiConfig.getDesigner().getHidden().add(new StateItem(ctrlKey, (Boolean)hidden));
            }
            if ((readOnlyState = designerConfig.get((Object)"readOnly")) instanceof JSONObject) {
                readonly = (JSONObject)readOnlyState;
                keys = readonly.keySet();
                for (String key : keys) {
                    uiConfig.getDesignerState(key).getReadonly().add(new StateItem(ctrlKey, readonly.getBoolean(key)));
                }
            } else if (readOnlyState instanceof Boolean) {
                readonly = (Boolean)readOnlyState;
                uiConfig.getDesigner().getReadonly().add(new StateItem(ctrlKey, (Boolean)readonly));
            }
        }
        if ((schemeConfig = config.getJSONObject("_scheme_")) != null) {
            Object readonly;
            Object readOnlyState;
            Object hidden;
            Object hiddenState;
            if (uiConfig.getScheme() == null) {
                uiConfig.setScheme(new StencilCtrlState());
            }
            if ((hiddenState = schemeConfig.get((Object)"hide")) instanceof JSONObject) {
                hidden = (JSONObject)hiddenState;
                keys = hidden.keySet();
                for (String key : keys) {
                    uiConfig.getSchemeState(key).getHidden().add(new StateItem(ctrlKey, hidden.getBoolean(key)));
                }
            } else if (hiddenState instanceof Boolean) {
                hidden = (Boolean)hiddenState;
                uiConfig.getScheme().getHidden().add(new StateItem(ctrlKey, (Boolean)hidden));
            }
            if ((readOnlyState = schemeConfig.get((Object)"readOnly")) instanceof JSONObject) {
                readonly = (JSONObject)readOnlyState;
                Set keys3 = readonly.keySet();
                for (String key : keys3) {
                    uiConfig.getSchemeState(key).getReadonly().add(new StateItem(ctrlKey, readonly.getBoolean(key)));
                }
            } else if (readOnlyState instanceof Boolean) {
                readonly = (Boolean)readOnlyState;
                uiConfig.getScheme().getReadonly().add(new StateItem(ctrlKey, (Boolean)readonly));
            }
        }
    }

    public static StencilUIConfig getStencilUIConfig(String stencilType) {
        Map<String, StencilUIConfig> stencilUiConfig = DesignerModelUtil.getStencilLocaleConfigs().getStencilUiConfig();
        if (stencilUiConfig.isEmpty()) {
            log.debug("getStencilUiConfig: stencilUiConfigMap is empty! " + stencilType);
            DesignerModelUtil.initStencilUiConfig();
        }
        StencilUIConfig uiConfig = stencilUiConfig.get(stencilType);
        return uiConfig;
    }

    public static StencilCtrlState getStencilCtrlState(String modelType, String stencilType, String type) {
        StencilUIConfig uiConfig = DesignerModelUtil.getStencilUIConfig(stencilType);
        if (uiConfig == null) {
            log.debug("StencilUiConfig is null! " + stencilType);
            return null;
        }
        if ("designer".equals(type) || "nodeTemplate".equals(type)) {
            return uiConfig.getDesignerStencilCtrlState(modelType);
        }
        if ("scheme".equals(type)) {
            return uiConfig.getSchemeStencilCtrlState(modelType);
        }
        return null;
    }

    public static String getStencilLabelKey(String stencilType) {
        return String.format("%slabel", stencilType);
    }

    public static String getStencilImageKey(String stencilType) {
        return String.format("%simage", stencilType);
    }

    public static List<FlowElement> getPreviousNodes(String modelJson, String nodeId) throws JsonProcessingException, IOException {
        return BpmnModelUtil.getPreviousNodes((String)modelJson, (String)nodeId);
    }

    public static List<FlowElement> getPreviousNodes(BpmnModel model, String nodeId) throws JsonProcessingException, IOException {
        return BpmnModelUtil.getPreviousNodes((BpmnModel)model, (String)nodeId);
    }

    public static List<FlowElement> getRejectNodes(BpmnModel model, String nodeId) throws JsonProcessingException, IOException {
        return BpmnModelUtil.getRejectNodes((BpmnModel)model, (String)nodeId);
    }

    public static void showValidateResult(AbstractFormPlugin plugin, List<String> msgs, String caption, String title, String actionId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, actionId));
        parameter.setFormId("wf_validateresult");
        if (caption != null) {
            parameter.setCaption(caption);
        }
        StringBuffer msg = new StringBuffer("<div style='overflow:auto;word-wrap:break-word;word-break:break-all'>");
        for (String str : msgs) {
            msg.append(str).append("<br/>");
        }
        msg.append("</div>");
        HashMap<String, CharSequence> params = new HashMap<String, CharSequence>();
        params.put("plugin", plugin.getPluginName());
        params.put("pageId", plugin.getView().getPageId());
        params.put("title", title);
        params.put("messages", msg);
        parameter.setCustomParams(params);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        plugin.getView().showForm(parameter);
    }

    public static void showProcessValidateResult(AbstractFormPlugin plugin, List<String> msgs, String title) {
        String caption = ResManager.loadKDString((String)"\u6d41\u7a0b\u6821\u9a8c\u7ed3\u679c", (String)"DesignerModelUtil_1", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        if (title == null) {
            title = ResManager.loadKDString((String)"\u5931\u8d25", (String)"DesignerModelUtil_3", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        DesignerModelUtil.showValidateResult(plugin, msgs, caption, title, "validate");
    }

    public static boolean showFatalValidateError(String modelJson, AbstractFormPlugin plugin, String actionId) {
        boolean isProduct = WfConfigurationUtil.isProdEnvironment();
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel((String)modelJson);
        WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        List errorList = service.getRepositoryService().validateProcesses(bpmnModel, null);
        if (errorList != null && !errorList.isEmpty()) {
            ArrayList<ValidationError> fatalErrors = new ArrayList<ValidationError>();
            for (ValidationError error : errorList) {
                if ("systemError".equals(error.getInfoType())) {
                    fatalErrors.add(error);
                }
                if (!isProduct || !"error".equals(error.getInfoType())) continue;
                fatalErrors.add(error);
            }
            if (!fatalErrors.isEmpty()) {
                if (actionId != null) {
                    DesignerModelUtil.showProcessValidateInfo(plugin, errorList, actionId);
                } else {
                    DesignerModelUtil.showProcessValidateInfo(plugin, errorList);
                }
                return true;
            }
        }
        return false;
    }

    public static void showProcessValidateInfo(AbstractFormPlugin plugin, List<ValidationError> msgs) {
        if (null != msgs && !msgs.isEmpty()) {
            FormShowParameter parameter = new FormShowParameter();
            HashMap<String, Object> params = new HashMap<String, Object>();
            parameter.setFormId("wf_validateinfos");
            params.put("plugin", plugin.getPluginName());
            params.put("pageId", plugin.getView().getPageId());
            params.put("messages", msgs);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParams(params);
            plugin.getView().showForm(parameter);
        } else {
            plugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6d41\u7a0b\u6821\u9a8c\u6210\u529f\u3002", (String)"DesignerModelUtil_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
    }

    public static void showProcessValidateInfo(AbstractFormPlugin plugin, List<ValidationError> msgs, String actionId) {
        if (WfUtils.isNotEmpty((String)actionId)) {
            FormShowParameter parameter = new FormShowParameter();
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (null != msgs && !msgs.isEmpty()) {
                parameter.setFormId("wf_validateinfos");
                params.put("plugin", plugin.getPluginName());
                params.put("pageId", plugin.getView().getPageId());
                params.put("messages", msgs);
            } else {
                parameter.setFormId("wf_validateinfo");
            }
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParams(params);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, actionId));
            plugin.getView().showForm(parameter);
        } else {
            DesignerModelUtil.showProcessValidateInfo(plugin, msgs);
        }
    }

    public static Map<String, Object> generateHideProp(boolean hide) {
        HashMap<String, Object> hideProp = new HashMap<String, Object>();
        hideProp.put("hide", hide);
        return hideProp;
    }

    public static Boolean getBooleanValue(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.FALSE;
    }

    public static String getPropertyPath(String group, String prop) {
        if (WfUtils.isNotEmpty((String)group) && !"base".equals(group)) {
            return String.format("%s.%s", group, prop);
        }
        return prop;
    }

    public static boolean isBoundaryEvent(String stencilType) {
        return stencilType.matches("Boundary*Event");
    }

    public static Object getOperationOrDecision(String stencilType, JSONObject properties) {
        return DesignerModelUtil.getProperty((Map<String, Object>)properties, "decisionOptions");
    }

    public static List<HashMap<String, Object>> setIsModifyValue(Object pageAttrConfig) {
        List<HashMap<String, Object>> pageAttrConfigs = new ArrayList<HashMap<String, Object>>();
        if (pageAttrConfig instanceof List) {
            ArrayList<HashMap<String, Object>> removeObjs = new ArrayList<HashMap<String, Object>>();
            pageAttrConfigs = (List)pageAttrConfig;
            for (int i = 0; i < pageAttrConfigs.size(); ++i) {
                if (DesignerModelUtil.getBooleanValue(pageAttrConfigs.get(i).get("hide")).booleanValue()) {
                    pageAttrConfigs.get(i).put("modify", Boolean.FALSE);
                    pageAttrConfigs.get(i).put("hide", DesignerModelUtil.getBooleanValue(pageAttrConfigs.get(i).get("hide")));
                    continue;
                }
                removeObjs.add(pageAttrConfigs.get(i));
            }
            if (0 != removeObjs.size()) {
                pageAttrConfigs.removeAll(removeObjs);
            }
        }
        return pageAttrConfigs;
    }

    public static List<ComboItem> getProcdefPreviousVersionItemsWithResourceWords(String key) {
        String lang = RequestContext.get().getLang().toString();
        StringBuilder sql = new StringBuilder();
        sql.append("select p.fid id, p.fversion version from t_wf_procdef p ");
        sql.append("inner join t_wf_gebytearray_l g on p.fresourceid = g.fid and g.flocaleid != ? ");
        sql.append("where p.fkey = ? and g.fcontent is not null ");
        sql.append("group by p.fid, p.fversion ");
        sql.append("order by p.fversion desc");
        ArrayList<ComboItem> versions = new ArrayList<ComboItem>();
        try (DataSet ds = DB.queryDataSet((String)"wf.engine.getProcdefPreviousVersionItemsWithResourceWords", (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])new Object[]{lang, key});){
            for (Row row : ds) {
                versions.add(new ComboItem(new LocaleString(String.format(ResManager.loadKDString((String)"%s \u7248\u672c", (String)"DesignerModelUtil_4", (String)"bos-wf-formplugin", (Object[])new Object[0]), row.getString("version"))), row.getString("id")));
            }
        }
        log.debug("getProcdefPreviousVersionItemsWithResourceWords: " + versions.size());
        return versions;
    }

    public static void removeModelExtendedMapByNumber(String number, String modelType) {
        String lang = Lang.get().toString();
        StencilConfigs stencilConfigs = stencilConfigsMultiLang.get(lang);
        if (stencilConfigs == null) {
            return;
        }
        Map<String, StencilConfig> stencilConfigMap = stencilConfigs.getStencilConfigMap();
        Set<Map.Entry<String, StencilConfig>> stencilConfigMapEntrySet = stencilConfigMap.entrySet();
        Iterator<Map.Entry<String, StencilConfig>> iterators = stencilConfigMapEntrySet.iterator();
        while (iterators.hasNext()) {
            Map.Entry<String, StencilConfig> stencilConfig;
            String key = modelType + "_" + number;
            if (!key.equals((stencilConfig = iterators.next()).getKey())) continue;
            iterators.remove();
            return;
        }
    }
}

