/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.converter.util.ModelConfigUtil;
import kd.bos.workflow.bpmn.graph.model.GraphCell;
import kd.bos.workflow.bpmn.graph.model.GraphItem;
import kd.bos.workflow.design.graph.model.GraphModel;
import kd.bos.workflow.design.plugin.AbstractWorkflowDesignerPlugin;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;

public class DesignerPasteUtil {
    private static Log log = LogFactory.getLog(DesignerPasteUtil.class);

    private DesignerPasteUtil() {
    }

    public static List<Map<String, Object>> getFirstUserRejectOptions(GraphCell firstUserTask) {
        ArrayList<Map<String, Object>> options = new ArrayList<Map<String, Object>>();
        HashMap<String, String> option = new HashMap<String, String>();
        option.put("itemId", firstUserTask.getResourceId());
        option.put("name", (String)firstUserTask.getProperties().get("name"));
        options.add(option);
        return options;
    }

    public static GraphCell getFirstUserTask(List<GraphCell> children, GraphModel graphModel) {
        for (GraphCell cell : children) {
            if (!"StartSignalEvent".equals(cell.getStencil().getId())) continue;
            List outgoings = cell.getOutgoing();
            if (outgoings == null || outgoings.isEmpty()) {
                log.debug("The start cell has no outgoing!");
                return null;
            }
            for (GraphItem item : outgoings) {
                GraphCell sequenceflow = graphModel.getGraphCell(item.getResourceId());
                GraphCell node = null;
                if (sequenceflow == null || (node = graphModel.getGraphCell(sequenceflow.getTarget().getResourceId())) == null || !"UserTask".equals(node.getStencil().getId())) continue;
                return node;
            }
        }
        return null;
    }

    public static String pasteValidate(List<GraphCell> cells, String entraBillId, IFormView currentView) {
        String tip = null;
        if (cells == null || cells.isEmpty()) {
            return tip;
        }
        GraphCell originCell = null;
        GraphModel originModel = null;
        String originBillId = null;
        String pageId = currentView.getPageId();
        HashMap<String, GraphModel> modelMap = new HashMap<String, GraphModel>();
        Set stencilTypes = ModelConfigUtil.getBuiltInStencilTypes();
        for (GraphCell cell : cells) {
            if (pageId.equals(cell.getOriginId())) break;
            if (stencilTypes.isEmpty()) {
                return ResManager.loadKDString((String)"\u590d\u5236\u5931\u8d25\uff0c\u83b7\u53d6\u6d41\u7a0b\u5185\u7f6e\u8282\u70b9\u7c7b\u578b\u51fa\u9519\u3002", (String)"DesignerPasteUtil_1", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            }
            String originPageId = cell.getOriginPageId();
            originModel = (GraphModel)modelMap.get(originPageId);
            if (originModel == null) {
                AbstractWorkflowDesignerPlugin plugin = DesignerModelUtil.getWorkflowDesignerPlugin(currentView.getView(originPageId));
                if (plugin == null) {
                    return ResManager.loadKDString((String)"\u590d\u5236\u5931\u8d25\uff0c\u6e90\u9875\u9762\u53ef\u80fd\u5df2\u5173\u95ed\u3002", (String)"DesignerPasteUtil_2", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                }
                originModel = plugin.getGraphModel();
                modelMap.put(originPageId, originModel);
            }
            if ((originCell = originModel.getGraphCell(cell.getOriginId())) == null) {
                return ResManager.loadKDString((String)"\u590d\u5236\u5931\u8d25\uff0c\u6e90\u8282\u70b9\u53ef\u80fd\u5df2\u5220\u9664\u3002", (String)"DesignerPasteUtil_3", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            }
            originBillId = (String)originModel.getRootCellProperty("entraBillId");
            String type = cell.getStencil().getId();
            tip = stencilTypes.contains(type) ? DesignerPasteUtil.validateBuiltInNode(type, entraBillId, originBillId, originCell) : DesignerPasteUtil.validateExtendedNode(type, entraBillId, originBillId, originCell);
            if (tip == null) continue;
            return tip;
        }
        return tip;
    }

    private static String validateBuiltInNode(String type, String entraBillId, String originBillId, GraphCell originCell) {
        String originEntityId = null;
        switch (type) {
            case "StartSignalEvent": 
            case "EndNoneEvent": {
                return null;
            }
            case "UserTask": 
            case "AuditTask": 
            case "YunzhijiaTask": 
            case "WaitTask": 
            case "CallActivity": {
                originEntityId = (String)BpmnModelUtil.getProperty((Map)originCell.getProperties(), (String)"entityId");
                break;
            }
            case "AutoTask": {
                originEntityId = (String)BpmnModelUtil.getProperty((Map)originCell.getProperties(), (String)"service.entityId");
                break;
            }
            default: {
                originEntityId = originBillId;
            }
        }
        return DesignerPasteUtil.validateEntityId(entraBillId, originEntityId);
    }

    private static String validateEntityId(String entityId, String originEntityId) {
        boolean isEmpty = WfUtils.isEmpty((String)originEntityId);
        if (isEmpty) {
            return null;
        }
        if (!originEntityId.equals(entityId)) {
            return ResManager.loadKDString((String)"\u590d\u5236\u5931\u8d25\uff0c\u5355\u636e\u7c7b\u578b\u4e0d\u4e00\u81f4\u3002", (String)"DesignerPasteUtil_4", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    private static String validateExtendedNode(String type, String entraBillId, String originBillId, GraphCell originCell) {
        String parentType = ModelConfigUtil.getInheritStencilType((String)type);
        return DesignerPasteUtil.validateBuiltInNode(parentType, entraBillId, originBillId, originCell);
    }
}

