/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.workflow.design.plugin.AbstractWorkflowConfigurePlugin;
import kd.bos.workflow.design.plugin.ISupportDesignerModelChange;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.bos.workflow.engine.impl.flowchart.TaskHandleRecordsHelper;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.rule.util.ExpressionPropUtils;
import kd.bos.workflow.service.WorkflowService;

public class DesignerPluginUtil {
    private static final Log log = LogFactory.getLog(DesignerPluginUtil.class);

    private DesignerPluginUtil() {
    }

    public static AbstractWorkflowConfigurePlugin getConfigureViewPlugin(IFormView configureView) {
        FormViewPluginProxy proxy = (FormViewPluginProxy)configureView.getService(FormViewPluginProxy.class);
        List plugins = proxy.getPlugIns();
        for (IFormPlugin plugin : plugins) {
            if (!(plugin instanceof AbstractWorkflowConfigurePlugin)) continue;
            return (AbstractWorkflowConfigurePlugin)plugin;
        }
        return null;
    }

    public static String openConditionalRule(IFormView view, IFormPlugin plugin, JSONObject properties, String modelJson, String itemId, ConditionalRuleType type, String property, String actionId) {
        JSONObject conditionRule = (JSONObject)DesignerModelUtil.getProperty((Map<String, Object>)properties, property);
        String conditionValue = conditionRule != null ? conditionRule.toJSONString() : null;
        return DesignerPluginUtil.openConditionalRule(type, view, plugin, conditionValue, modelJson, itemId, property, actionId);
    }

    public static String openConditionalRule(ConditionalRuleType type, IFormView view, IFormPlugin plugin, String conditionValue, String modelJson, String itemId, String property, String actionId) {
        FormShowParameter parameter = DesignerPluginUtil.getConditionalRuleParameter(type, view, plugin, conditionValue, modelJson, itemId, property, actionId);
        view.showForm(parameter);
        return parameter.getPageId();
    }

    public static FormShowParameter getConditionalRuleParameter(ConditionalRuleType type, IFormView view, IFormPlugin plugin, String conditionValue, String modelJson, String itemId, String property, String actionId) {
        String typeStr = type.toString();
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("type", typeStr);
        context.put("model", modelJson);
        context.put("property", ConditionalRuleType.processStartUp == type ? "" : property);
        HashMap<String, String> nodeProperties = new HashMap<String, String>();
        nodeProperties.put("itemId", itemId);
        context.put("nodeProperties", nodeProperties);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("context", context);
        params.put("value", conditionValue);
        String typeName = ConditionalRuleType.getTypeName((String)typeStr);
        FormShowParameter parameter = DesignerPluginUtil.getFormShowParameter(plugin, "wf_conditionrule_update", actionId);
        parameter.setShowTitle(false);
        parameter.setCaption(typeName);
        parameter.setCustomParams(params);
        parameter.setCustomParam("isDefaultScheme", view.getFormShowParameter().getCustomParam("isDefaultScheme"));
        parameter.setCustomParam("schemeId", view.getFormShowParameter().getCustomParam("schemeId"));
        if ("skipcondition".equals(actionId)) {
            parameter.setCustomParam("needSourceElement", (Object)true);
        }
        parameter.setHasRight(true);
        return parameter;
    }

    public static String openExtItfInContainer(IFormView view, IFormPlugin plugin, String types, String entityId, String value, String targetKey) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("value", value);
        FormShowParameter parameter = DesignerPluginUtil.getFormShowParameter(plugin, "wf_external_interface", "externalInterface");
        parameter.setShowTitle(false);
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey(targetKey);
        parameter.setCustomParam("entityId", (Object)entityId);
        parameter.setCustomParam("data", data);
        parameter.setCustomParam("types", (Object)types);
        parameter.setCustomParam("hideParameterConfig", view.getFormShowParameter().getCustomParam("hideParameterConfig"));
        parameter.setCustomParam("optionalActions", view.getFormShowParameter().getCustomParam("optionalActions"));
        view.showForm(parameter);
        return parameter.getPageId();
    }

    public static String openExternalInterface(IFormView view, IFormPlugin plugin, String types, String entityId, String value) {
        return DesignerPluginUtil.openExternalInterface(view, plugin, types, entityId, value, false);
    }

    public static String openExternalInterface(IFormView view, IFormPlugin plugin, String types, String entityId, String value, boolean singleOperation) {
        return DesignerPluginUtil.openExternalInterface(view, plugin, types, entityId, value, singleOperation, "externalInterface");
    }

    public static String openExternalInterface(IFormView view, IFormPlugin plugin, String types, String entityId, String value, boolean singleOperation, String actionId) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("value", value);
        FormShowParameter parameter = DesignerPluginUtil.getFormShowParameter(plugin, "wf_external_interface", actionId);
        StyleCss style = new StyleCss();
        style.setWidth("460");
        style.setHeight("360");
        parameter.getOpenStyle().setInlineStyleCss(style);
        parameter.setCustomParam("showButtonPanel", (Object)Boolean.TRUE);
        parameter.setCustomParam("entityId", (Object)entityId);
        parameter.setCustomParam("data", data);
        parameter.setCustomParam("types", (Object)types);
        parameter.setCustomParam("hideParameterConfig", view.getFormShowParameter().getCustomParam("hideParameterConfig"));
        if (singleOperation) {
            parameter.setCustomParam("operationSingle", (Object)true);
        }
        view.showForm(parameter);
        return parameter.getPageId();
    }

    public static String openExpressionPage(IFormView view, IFormPlugin plugin, String value) {
        FormShowParameter formShowParameter = view.getFormShowParameter();
        String entityId = (String)formShowParameter.getCustomParam("entityId");
        String entityNumber = EntityMetadataCache.getDataEntityTypeById((String)entityId).getName();
        String modelJson = (String)formShowParameter.getCustomParam("modelJson");
        FormShowParameter parameter = DesignerPluginUtil.getFormShowParameter(plugin, "wf_valueexpression", "valueExpression");
        parameter.setCustomParam("bpmnModel", (Object)modelJson);
        parameter.setCustomParam("entityNumber", (Object)entityNumber);
        parameter.setCustomParam("ruleType", (Object)ConditionalRuleType.skip);
        if (WfUtils.isNotEmpty((String)value)) {
            if (ExpressionPropUtils.isExpressionValue((String)value)) {
                value = value.replaceAll("\\$|\\{|\\}", "");
                parameter.setCustomParam("expression", (Object)value);
            } else {
                parameter.setCustomParam("tip", (Object)WFMultiLangConstants.getValueIsNotExpressionTip());
            }
        }
        view.showForm(parameter);
        return parameter.getPageId();
    }

    private static FormShowParameter getFormShowParameter(IFormPlugin plugin, String formId, String actionId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCloseCallBack(new CloseCallBack(plugin, actionId));
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        return parameter;
    }

    public static ComboItem getDefaultPluginComboItem() {
        return new ComboItem(new LocaleString(WFMultiLangConstants.getTextWhenNodeLeaves()), "end");
    }

    public static List<ComboItem> getRunPluginComboItems() {
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>();
        combos.add(new ComboItem(new LocaleString(WFMultiLangConstants.getTextWhenNodeRun()), "approverModify"));
        combos.add(new ComboItem(new LocaleString(WFMultiLangConstants.getTextAfterCreateTask()), "afterCreate"));
        combos.add(new ComboItem(new LocaleString(WFMultiLangConstants.getTextAfterTransferTask()), "afterTransfer"));
        combos.add(new ComboItem(new LocaleString(WFMultiLangConstants.getTextAfterCoordinateReq()), "afterCoordReq"));
        combos.add(new ComboItem(new LocaleString(WFMultiLangConstants.getTextAfterCoordinateReply()), "afterCoordReply"));
        combos.add(new ComboItem(new LocaleString(WFMultiLangConstants.getTextAfterCoordinateCancel()), "afterCoordCancel"));
        return combos;
    }

    public static List<ComboItem> getRunPluginForBillTaskComboItems() {
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>();
        combos.add(new ComboItem(new LocaleString(WFMultiLangConstants.getTextWhenNodeRun()), "approverModify"));
        combos.add(new ComboItem(new LocaleString(WFMultiLangConstants.getTextAfterCreateTask()), "afterCreate"));
        combos.add(new ComboItem(new LocaleString(WFMultiLangConstants.getTextAfterTransferTask()), "afterTransfer"));
        return combos;
    }

    public static List<ComboItem> getEntryPluginExecutionTime(Object modelType, String stencilType) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5e38\u8fdb\u5165\u65f6", (String)"DesignerPluginUtil_1", (String)"bos-wf-formplugin", (Object[])new Object[0])), "normal"));
        if ("WorkflowModel".equals(modelType)) {
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u9a73\u56de\u8fdb\u5165\u65f6", (String)"DesignerPluginUtil_2", (String)"bos-wf-formplugin", (Object[])new Object[0])), "reject"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u8df3\u8f6c\u8fdb\u5165\u65f6", (String)"DesignerPluginUtil_3", (String)"bos-wf-formplugin", (Object[])new Object[0])), "jump"));
        }
        if (BpmnModelUtil.instanceofUserTaskExcludeSSCApprove((String)stencilType)) {
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u8ba1\u7b97\u4efb\u52a1\u53c2\u4e0e\u4eba\u65f6", (String)"DesignerPluginUtil_10", (String)"bos-wf-formplugin", (Object[])new Object[0])), "calculate_participant"));
        }
        return items;
    }

    public static List<ComboItem> getRunPluginExecutionTime() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u53c2\u4e0e\u4eba\u6539\u53d8\u65f6", (String)"DesignerPluginUtil_4", (String)"bos-wf-formplugin", (Object[])new Object[0])), "approverModify"));
        return items;
    }

    public static String getLocaleValue(Object value) {
        if (value == null) {
            return "";
        }
        String localeValue = null;
        localeValue = value instanceof ILocaleString ? String.valueOf(((ILocaleString)value).getLocaleValue()) : (value instanceof Map ? String.valueOf(((Map)value).get(RequestContext.get().getLang().toString())) : String.valueOf(value));
        return localeValue;
    }

    public static String getOperationShowValue(String operation) {
        try {
            List operations = SerializationUtils.fromJsonStringToList((String)operation, Map.class);
            int size = operations.size();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < size; ++i) {
                Map oper = (Map)operations.get(i);
                sb.append((String)oper.get("name"));
                if (i >= size - 1) continue;
                sb.append(",");
            }
            return sb.toString();
        }
        catch (Exception e) {
            log.error(WfUtils.getExceptionStacktrace((Throwable)e));
            return "";
        }
    }

    public static String getNodeParamsShowText(JSONArray params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        int size = params.size();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            JSONObject param = (JSONObject)params.get(i);
            sb.append(param.getString("number"));
            if (i >= size - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public static Map<String, Object> getPageMetadata(String formId) {
        MetadataService metaService = (MetadataService)ServiceFactory.getService(MetadataService.class);
        String metadata = metaService.loadClientFormMeta(formId);
        return (Map)SerializationUtils.fromJsonString((String)metadata, Map.class);
    }

    public static ISupportDesignerModelChange getSupportModelChangePlugin(IFormView view) {
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)view.getService(FormViewPluginProxy.class);
        List plugins = pluginProxy.getPlugIns();
        if (plugins != null) {
            for (IFormPlugin plugin : plugins) {
                if (!(plugin instanceof ISupportDesignerModelChange)) continue;
                return (ISupportDesignerModelChange)plugin;
            }
        }
        return null;
    }

    public static Map<String, Object> getContainerControl(Map<String, Object> obj, String id) {
        List items = (List)obj.get("items");
        if (items == null) {
            return null;
        }
        for (Map<String, Object> item : items) {
            if (id.equals(item.get("id")) && "flexpanel".equals(item.get("type"))) {
                return item;
            }
            if ((item = DesignerPluginUtil.getContainerControl(item, id)) == null) continue;
            return item;
        }
        return null;
    }

    public static void showCustomizedForm(IFormView view, Map<String, String> params) {
        String url = params.get("url");
        if (WfUtils.isNotEmpty((String)url)) {
            view.openUrl(url);
            return;
        }
        String formId = params.get("formId");
        if (WfUtils.isEmpty((String)formId)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u94fe\u63a5formId\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DesignerPluginUtil_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        String width = params.get("width");
        String height = params.get("height");
        String taskId = params.get("taskId");
        String userId = params.get("userId");
        WorkflowService service = (WorkflowService)kd.bos.workflow.service.impl.ServiceFactory.getService(WorkflowService.class);
        HistoricTaskInstanceEntity task = (HistoricTaskInstanceEntity)service.getRepositoryService().findEntityById(Long.valueOf(Long.parseLong(taskId)), "wf_hitaskinst");
        if (task == null) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u8282\u70b9\u5bf9\u5e94\u7684\u4efb\u52a1\u3002", (String)"DesignerPluginUtil_6", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.setCustomParam("taskId", (Object)taskId);
        parameter.setCustomParam("userId", (Object)userId);
        parameter.setCustomParam("businessKey", (Object)task.getBusinessKey());
        parameter.setCustomParam("entityNumber", (Object)task.getEntityNumber());
        parameter.setCustomParam("activityId", (Object)task.getTaskDefinitionKey());
        OpenStyle style = new OpenStyle();
        StyleCss cssStyle = new StyleCss();
        if (WfUtils.isNotEmpty((String)height)) {
            cssStyle.setHeight(height);
        }
        if (WfUtils.isNotEmpty((String)width)) {
            cssStyle.setWidth(width);
        }
        style.setInlineStyleCss(cssStyle);
        style.setShowType(ShowType.Modal);
        parameter.setOpenStyle(style);
        view.showForm(parameter);
    }

    public static String openFormInContainer(IFormView view, String formId, String targetKey) {
        return DesignerPluginUtil.openFormInContainer(view, formId, targetKey, null);
    }

    public static String openFormInContainer(IFormView view, String formId, String targetKey, Object[] params) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey(targetKey);
        if (params != null && params.length > 1) {
            Map customParams = parameter.getCustomParams();
            for (int i = 0; i < params.length; i += 2) {
                customParams.put((String)params[i], params[i + 1]);
            }
        }
        view.showForm(parameter);
        return parameter.getPageId();
    }

    public static String openFormListPage(IFormView view, String formId, Object ... params) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("bos_list");
        parameter.setBillFormId(formId);
        return DesignerPluginUtil.openForm(view, (FormShowParameter)parameter, params);
    }

    public static String openFormPage(IFormView view, String formId, Object ... params) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        return DesignerPluginUtil.openForm(view, parameter, params);
    }

    public static String openForm(IFormView view, FormShowParameter showParameter, Object ... params) {
        if (params != null && params.length > 1) {
            Map customParams = showParameter.getCustomParams();
            for (int i = 0; i < params.length; i += 2) {
                String key = (String)params[i];
                Object value = params[i + 1];
                if ("caption".equals(key) && value instanceof String) {
                    showParameter.setCaption((String)value);
                }
                customParams.put(key, value);
            }
        }
        showParameter.setCustomParam("fromPageId", (Object)view.getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm(showParameter);
        return showParameter.getPageId();
    }

    public static boolean checkWorkflowInService(IFormView view) {
        try {
            ((WorkflowService)kd.bos.workflow.service.impl.ServiceFactory.getService(WorkflowService.class)).getRepositoryService();
            return true;
        }
        catch (Exception e) {
            view.showMessage(e.getMessage());
            return false;
        }
    }

    public static String getUserName(Long userId, Map<Long, String> nameMap) {
        if (WfUtils.isEmpty((Long)userId)) {
            return "";
        }
        String name = nameMap.get(userId);
        if (name == null) {
            ILocaleString username = WfUtils.findUserName((Long)userId);
            if (WfUtils.isNotEmpty((ILocaleString)username)) {
                name = username.getLocaleValue();
            } else {
                log.debug(String.format("user: %s name is null!", userId));
                name = "";
            }
            nameMap.put(userId, name);
        }
        return name;
    }

    public static List<TaskHandleLogEntity> getTransferRecordsData(String taskId, String userId, boolean coordinate, TaskService getTaskService) {
        List taskHandleLogs = null;
        Long tid = Long.valueOf(taskId);
        Long uid = Long.valueOf(userId != null ? userId : "0");
        taskHandleLogs = coordinate ? new TaskHandleRecordsHelper(tid).getUserCoordinateTransferRecord(uid) : getTaskService.getUserTaskTransferLogs(tid, uid);
        if (taskHandleLogs == null || taskHandleLogs.isEmpty()) {
            log.debug(String.format("task handleLogs is empty! %s  %s", taskId, userId));
            return taskHandleLogs;
        }
        if (coordinate) {
            Collections.reverse(taskHandleLogs);
        }
        return taskHandleLogs;
    }
}

