/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.AmountField;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.BasedataPropField;
import kd.bos.metadata.entity.businessfield.BillStatusField;
import kd.bos.metadata.entity.businessfield.CreateDateField;
import kd.bos.metadata.entity.businessfield.FlexField;
import kd.bos.metadata.entity.businessfield.MaterielField;
import kd.bos.metadata.entity.businessfield.ModifyDateField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.businessfield.PriceField;
import kd.bos.metadata.entity.businessfield.QtyField;
import kd.bos.metadata.entity.businessfield.billstatusfield.StatusItem;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.DateField;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.calculator.ExpressionCalculatorUtil;

public class DynamicTplUtil {
    private static Log log = LogFactory.getLog(DynamicTplUtil.class);
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String timeFormat = "yyyy-MM-dd HH:mm:ss";

    public static Object formatFieldValue(Object fieldValue, String fieldKey, Map<String, EntityItem<?>> fieldEntityInfos, Map<String, ControlAp<?>> fieldFormInfos, EntityMetadata entityMetadata, DynamicObject billInfo, DynamicObject rowData) {
        if (fieldValue == null) {
            return fieldValue;
        }
        try {
            EntityItem<?> fieldEntityItem = fieldEntityInfos.get(fieldKey);
            if (fieldEntityItem instanceof BillStatusField) {
                fieldValue = DynamicTplUtil.getBillStatusFieldValue(fieldValue, fieldEntityItem);
            } else if (fieldEntityItem instanceof BasedataField) {
                fieldValue = DynamicTplUtil.getBasedataFieldValue(fieldValue, fieldEntityItem);
            } else if (fieldEntityItem instanceof MulBasedataField) {
                fieldValue = DynamicTplUtil.getMulBasedataFieldValue(fieldValue, fieldEntityItem);
            } else if (fieldEntityItem instanceof DateField) {
                fieldValue = DynamicTplUtil.getDateFieldValue(fieldValue, fieldKey, fieldFormInfos);
            } else if (fieldEntityItem instanceof CreateDateField || fieldEntityItem instanceof ModifyDateField || fieldEntityItem instanceof DateTimeField) {
                fieldValue = DynamicTplUtil.getCreateDateFieldValue(fieldValue, fieldKey);
            } else if (fieldEntityItem instanceof AmountField) {
                fieldValue = DynamicTplUtil.getAmountFieldValue(fieldValue, entityMetadata, billInfo, rowData, fieldEntityItem);
            } else if (fieldEntityItem instanceof QtyField) {
                fieldValue = DynamicTplUtil.getQtyFieldValue(fieldValue, entityMetadata, billInfo, rowData, fieldEntityItem);
            } else if (fieldEntityItem instanceof DecimalField) {
                fieldValue = DynamicTplUtil.getDecimalFieldValue(fieldValue, fieldEntityItem);
            } else if (fieldEntityItem instanceof ComboField) {
                fieldValue = DynamicTplUtil.getComboFieldValue(fieldValue, fieldEntityItem);
            } else if (fieldEntityItem instanceof FlexField) {
                fieldValue = ExpressionCalculatorUtil.getFlexFieldValue((Object)fieldValue);
            }
        }
        catch (Exception e) {
            log.info(String.format("formatFieldValue error:fieldKey:%s,detail:%s", fieldKey, WfUtils.getExceptionStacktrace((Throwable)e)));
        }
        return fieldValue;
    }

    private static Object getQtyFieldValue(Object fieldValue, EntityMetadata entityMetadata, DynamicObject billInfo, DynamicObject rowData, EntityItem<?> fieldEntityItem) {
        String unitFieldId = ((QtyField)fieldEntityItem).getUnitFieldId();
        if (WfUtils.isNotEmpty((String)unitFieldId)) {
            DynamicObject currencyValue;
            block6: {
                Field unitField = entityMetadata.getFieldById(unitFieldId);
                String qtyFieldKey = unitField.getKey();
                currencyValue = null;
                try {
                    currencyValue = billInfo.getDynamicObject(qtyFieldKey);
                }
                catch (Exception e) {
                    if (rowData == null) break block6;
                    currencyValue = rowData.getDynamicObject(qtyFieldKey);
                }
            }
            if (currencyValue != null) {
                try {
                    int amtprecision = currencyValue.getInt("precision");
                    BigDecimal bigDecimal = new BigDecimal(String.valueOf(fieldValue));
                    BigDecimal value = bigDecimal.setScale(amtprecision, RoundingMode.HALF_UP);
                    fieldValue = value;
                }
                catch (Exception e) {
                    return fieldValue;
                }
            }
        }
        return fieldValue;
    }

    private static Object getComboFieldValue(Object fieldValue, EntityItem<?> fieldEntityItem) {
        List items = ((ComboField)fieldEntityItem).getItems();
        if (items != null && !items.isEmpty()) {
            for (ComboItem item : items) {
                if (fieldValue == null || !fieldValue.equals(item.getValue())) continue;
                fieldValue = item.getCaption().getLocaleValue();
                break;
            }
        }
        return fieldValue;
    }

    private static Object getDecimalFieldValue(Object fieldValue, EntityItem<?> fieldEntityItem) {
        String suffix = ((DecimalField)fieldEntityItem).getSuffix();
        if (suffix == null) {
            suffix = "";
        }
        int scale = ((DecimalField)fieldEntityItem).getScale();
        BigDecimal bigDecimal = new BigDecimal(String.valueOf(fieldValue));
        BigDecimal value = bigDecimal.setScale(scale, RoundingMode.HALF_UP);
        fieldValue = suffix + value;
        return fieldValue;
    }

    private static Object getAmountFieldValue(Object fieldValue, EntityMetadata entityMetadata, DynamicObject billInfo, DynamicObject rowData, EntityItem<?> fieldEntityItem) {
        String currencyFieldId = ((AmountField)fieldEntityItem).getCurrencyFieldId();
        if (WfUtils.isNotEmpty((String)currencyFieldId)) {
            DynamicObject currencyValue;
            block8: {
                Field currencyField = entityMetadata.getFieldById(currencyFieldId);
                String currencyFieldKey = currencyField.getKey();
                currencyValue = null;
                try {
                    currencyValue = billInfo.getDynamicObject(currencyFieldKey);
                }
                catch (Exception e) {
                    if (rowData == null) break block8;
                    currencyValue = rowData.getDynamicObject(currencyFieldKey);
                }
            }
            if (currencyValue != null) {
                try {
                    int amtprecision = currencyValue.getInt("amtprecision");
                    if (fieldEntityItem instanceof PriceField) {
                        amtprecision = currencyValue.getInt("priceprecision");
                    }
                    BigDecimal bigDecimal = new BigDecimal(String.valueOf(fieldValue));
                    BigDecimal value = bigDecimal.setScale(amtprecision, RoundingMode.HALF_UP);
                    String sign = "";
                    if (currencyValue.getBoolean("isshowsign")) {
                        sign = currencyValue.getString("sign");
                    }
                    fieldValue = sign + value;
                }
                catch (Exception e) {
                    return fieldValue;
                }
            }
        }
        return fieldValue;
    }

    private static Object getCreateDateFieldValue(Object fieldValue, String fieldKey) {
        try {
            fieldValue = new SimpleDateFormat(timeFormat).format(new SimpleDateFormat(timeFormat).parse(fieldValue.toString()));
        }
        catch (ParseException e) {
            log.error("fieldKey:" + fieldKey + ",fieldValue:" + fieldValue + ": \u503c\u89e3\u6790\u51fa\u9519");
        }
        return fieldValue;
    }

    private static Object getDateFieldValue(Object fieldValue, String fieldKey, Map<String, ControlAp<?>> fieldFormInfos) {
        ControlAp<?> fieldFormItem = fieldFormInfos.get(fieldKey);
        String displayFormatString = ((FieldAp)fieldFormItem).getDisplayFormatString();
        displayFormatString = WfUtils.isEmpty((String)displayFormatString) ? "yyyy-MM-dd" : displayFormatString.replaceAll("D", "d");
        SimpleDateFormat sdf = new SimpleDateFormat(displayFormatString);
        try {
            fieldValue = sdf.format(new SimpleDateFormat(timeFormat).parse(fieldValue.toString()));
        }
        catch (ParseException e) {
            log.error("fieldKey:" + fieldKey + ",fieldValue:" + fieldValue + ": \u503c\u89e3\u6790\u51fa\u9519");
        }
        return fieldValue;
    }

    private static Object getMulBasedataFieldValue(Object fieldValue, EntityItem<?> fieldEntityItem) {
        String displayProp = ((MulBasedataField)fieldEntityItem).getDisplayProp();
        StringBuilder sb = new StringBuilder();
        for (DynamicObject dynamicObject : (DynamicObjectCollection)fieldValue) {
            DynamicObject basedata = dynamicObject.getDynamicObject("fbasedataid");
            if (!(basedata instanceof DynamicObject) || !(basedata.getDataEntityType() instanceof BasedataEntityType)) continue;
            BasedataEntityType dt = (BasedataEntityType)basedata.getDataEntityType();
            Object displayValue = "";
            displayValue = NAME.equals(displayProp) || NUMBER.equals(displayProp) ? DynamicTplUtil.getNameOrNumberFromBasedata(basedata, dt, displayProp) : DynamicTplUtil.getNameAndNumberFromBasedata(basedata, dt, displayProp);
            if (displayValue == null || displayValue == "") continue;
            sb.append(displayValue).append(';');
        }
        return sb.toString().endsWith(";") ? sb.toString().substring(0, sb.toString().length() - 1) : sb.toString();
    }

    private static Object getBasedataFieldValue(Object fieldValue, EntityItem<?> fieldEntityItem) {
        String number;
        String baseEntityId;
        String displayProp = ((BasedataField)fieldEntityItem).getDisplayProp();
        if (fieldEntityItem instanceof MaterielField && WfUtils.isNotEmpty((String)(baseEntityId = ((MaterielField)fieldEntityItem).getBaseEntityId())) && WfUtils.isNotEmpty((String)(number = MetadataDao.getEntityNumberById((String)baseEntityId)))) {
            BasedataEntityType dt = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)number);
            String masteridPropName = dt.getMasteridPropName();
            int masteridType = dt.getMasteridType();
            if (WfUtils.isNotEmpty((String)masteridPropName) && 2 == masteridType) {
                fieldValue = ((DynamicObject)fieldValue).get(masteridPropName + "." + displayProp);
                return fieldValue;
            }
        }
        if (fieldValue instanceof DynamicObject && ((DynamicObject)fieldValue).getDataEntityType() instanceof BasedataEntityType) {
            BasedataEntityType dt = (BasedataEntityType)((DynamicObject)fieldValue).getDataEntityType();
            if (NAME.equals(displayProp) || NUMBER.equals(displayProp)) {
                return DynamicTplUtil.getNameOrNumberFromBasedata(fieldValue, dt, displayProp);
            }
            return DynamicTplUtil.getNameAndNumberFromBasedata(fieldValue, dt, displayProp);
        }
        return fieldValue;
    }

    private static Object getNameAndNumberFromBasedata(Object fieldValue, BasedataEntityType dt, String displayName) {
        String[] splits;
        if (WfUtils.isEmpty((String)displayName)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String connector = displayName.replace(NAME, "").replace(NUMBER, "");
        if ("()".equals(connector)) {
            String[] splits2 = displayName.replaceAll("[( )]", ",").substring(0, displayName.length() - 1).split(",");
            for (int i = 0; i < splits2.length; ++i) {
                Object value = DynamicTplUtil.getNameOrNumberFromBasedata(fieldValue, dt, splits2[i]);
                sb.append(value == null ? "" : value.toString());
                if (i == 0) {
                    sb.append("(");
                    continue;
                }
                if (i != 1) continue;
                sb.append(")");
            }
            return sb.toString();
        }
        for (String split : splits = displayName.split(connector)) {
            Object value = DynamicTplUtil.getNameOrNumberFromBasedata(fieldValue, dt, split);
            sb.append(value == null ? "" : value.toString()).append(connector);
        }
        return sb.substring(0, sb.length() - 1);
    }

    private static Object getNameOrNumberFromBasedata(Object fieldValue, BasedataEntityType dt, String displayName) {
        IDataEntityProperty displayProp = dt.findProperty(displayName);
        if (displayProp == null) {
            if (NUMBER.equals(displayName)) {
                String numberProperty = dt.getNumberProperty();
                return ((DynamicObject)fieldValue).get(numberProperty);
            }
            if (NAME.equals(displayName)) {
                String nameProperty = dt.getNameProperty();
                return ((DynamicObject)fieldValue).get(nameProperty);
            }
            return null;
        }
        return ((DynamicObject)fieldValue).get(displayName);
    }

    private static Object getBillStatusFieldValue(Object fieldValue, EntityItem<?> fieldEntityItem) {
        List statusItems = ((BillStatusField)fieldEntityItem).getStatusItems();
        for (StatusItem statusItem : statusItems) {
            if (statusItem.getStatusKey() == null || !statusItem.getStatusKey().equals(fieldValue)) continue;
            fieldValue = statusItem.getStatusName().getLocaleValue();
            break;
        }
        return fieldValue;
    }

    public static Map<String, EntityItem<?>> getEntityFieldItems(EntityMetadata entityMetadata) {
        List items = entityMetadata.getItems();
        HashMap mapItems = new HashMap(items.size());
        for (EntityItem item : items) {
            mapItems.put(item.getKey(), item);
        }
        return mapItems;
    }

    public static Map<String, ControlAp<?>> getFieldFormInfos(FormMetadata formMetadata, List<String> attachmentKeys) {
        HashMap fieldInfos = new HashMap(16);
        List fieldItems = formMetadata.getItems();
        for (ControlAp fieldItem : fieldItems) {
            if (fieldItem instanceof AttachmentPanelAp) {
                attachmentKeys.add(fieldItem.getKey());
                continue;
            }
            fieldInfos.put(fieldItem.getKey(), fieldItem);
        }
        return fieldInfos;
    }

    public static Object getBasedataPropFieldValue(String fieldKey, Map<String, EntityItem<?>> fieldEntityInfos, EntityMetadata entityMetadata, DynamicObject billInfo, DynamicObject rowData, boolean fromEntry) {
        EntityItem<?> fieldEntityItem = fieldEntityInfos.get(fieldKey);
        BasedataPropField basedataPropField = (BasedataPropField)fieldEntityItem;
        String refBaseFieldId = basedataPropField.getRefBaseFieldId();
        Field baseField = entityMetadata.getFieldById(refBaseFieldId);
        Object baseDataValue = null;
        baseDataValue = fromEntry ? rowData.get(baseField.getKey()) : billInfo.get(baseField.getKey());
        String refDisplayProp = basedataPropField.getRefDisplayProp();
        if (refDisplayProp == null || WfUtils.isEmpty((String)refDisplayProp) || baseDataValue == null) {
            return null;
        }
        return ((DynamicObject)baseDataValue).get(refDisplayProp);
    }
}

