/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.util;

import java.util.HashMap;
import java.util.List;
import kd.bos.designer.property.alias.IPropertyConverter;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.design.plugin.WorkflowExternalInterfacePlugin;
import kd.bos.workflow.design.property.alias.AliasConverterFactory;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import org.apache.commons.beanutils.MethodUtils;

public class ExtItfPluginUtil {
    private static Log log = LogFactory.getLog(ExtItfPluginUtil.class);

    public static String invokeConfirmMethod(IFormView view, String subPageId, Object[] args) {
        Object ret = ExtItfPluginUtil.invokePluginMethod(view, subPageId, "confirm", args);
        if (ret instanceof String) {
            return ret.toString();
        }
        return null;
    }

    public static Object invokeResetMethod(IFormView view, String subPageId, Object[] args) {
        return ExtItfPluginUtil.invokePluginMethod(view, subPageId, "reset", args);
    }

    public static Object invokePluginMethod(IFormView view, String subPageId, String methodName, Object[] args) {
        IFormView subView = view.getView(subPageId);
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)subView.getService(FormViewPluginProxy.class);
        WorkflowExternalInterfacePlugin extItfPlugin = null;
        List plugins = pluginProxy.getPlugIns();
        Object result = null;
        for (IFormPlugin plugin : plugins) {
            if (!(plugin instanceof WorkflowExternalInterfacePlugin)) continue;
            extItfPlugin = (WorkflowExternalInterfacePlugin)plugin;
            try {
                result = MethodUtils.invokeMethod((Object)((Object)extItfPlugin), (String)methodName, (Object[])args);
            }
            catch (Exception e) {
                log.error(String.format("invoke WorkflowExternalInterfacePlugin's %s method error! %s", methodName, e.getMessage()));
            }
            break;
        }
        view.sendFormAction(subView);
        return result;
    }

    public static String buildExtItfOperationValue(String forward, String withdraw, String entityId, String itemId) {
        IPropertyConverter converter = AliasConverterFactory.create("wf_formoperation");
        String forwardName = null;
        String withdrawName = null;
        if (converter != null) {
            HashMap<String, String> context = new HashMap<String, String>();
            context.put("entityId", entityId);
            converter.setContext(context, itemId);
            forwardName = (String)converter.convert((Object)forward);
            withdrawName = (String)converter.convert((Object)withdraw);
        }
        return ExternalInterfaceUtil.buildExtItfOperationValue((String)forward, forwardName, (String)withdraw, withdrawName);
    }
}

