/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.util;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.design.plugin.model.ParticipantEntryInfo;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.bos.workflow.engine.impl.util.ParticipantHelper;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.taskcenter.plugin.util.PictureResourceEnum;

public class ParticipantConfigureHelper {
    private static Log log = LogFactory.getLog(ParticipantConfigureHelper.class);
    private static final String ROW_INDEX = "rowIndex";
    private static final String RD_KEY_PART = "part";
    private static final String RD_KEY_CONTEXT = "context";
    private static final String SHOWVALUE = "participant_showvalue";
    private static final String VALUE_SHOWTEXT = "valueshowtext";
    private static final String RETURNDATALIST = "returnDataAllList";
    private static final String TYPE_ITEM_RELATION = "relation";
    private static final String TYPE_ITEM_ROLE = "role";
    public static final String TYPE_ITEM_PERSON = "person";
    public static final String TYPE_ITEM_PLUGIN = "plugin";
    public static final String TYPE_ITEM_POSITION = "position";
    public static final String OPERATION_ADD = "operation_add";
    public static final String OPERATION_MODIFY = "operation_modify";
    public static final String OPERATION_DELETE = "operation_delete";
    public static final String IMAGEURL = "participant_picture";
    public static final String VALUE_SHOWTEXTPRE = "participant_showvaluepre";
    public static final String REFERENCEPERSONSCENE = "referencePersonScene";

    public static String getDatasCacheKey(String entryId) {
        return String.format("%s_%s", RETURNDATALIST, entryId);
    }

    private static String getCachedRowIndexKey(String entryId) {
        return String.format("%s_%s", ROW_INDEX, entryId);
    }

    public static void addParticipant(AbstractFormPlugin plugin, String entryId, String itemId, String modelJson, String actionId) {
        ParticipantConfigureHelper.setModificationRowIndex(plugin, entryId, -1);
        FormShowParameter parameter = ParticipantConfigureHelper.getFormShowParameter(plugin, itemId, modelJson, null, actionId);
        plugin.getView().showForm(parameter);
    }

    public static void modifyParticipant(AbstractFormPlugin plugin, String entryId, String itemId, String modelJson, String actionId) {
        int row = ParticipantConfigureHelper.isChooseRecord(plugin, StandardTips.notSelectRowTips(), entryId);
        if (row > -1) {
            String formId;
            IFormView view = plugin.getView();
            ParticipantConfigureHelper.setModificationRowIndex(plugin, entryId, row);
            Map<String, Object> partMap = ParticipantConfigureHelper.getReturnDataMapFromCache(plugin, entryId, row);
            if (partMap == null) {
                log.debug("The data from cache is null!");
                partMap = new HashMap<String, Object>();
            }
            if (WfUtils.isNotEmpty((String)(formId = (String)partMap.get("openpagebyformid"))) && "wf_part_person".equals(formId)) {
                formId = "bos_usertreelistf7_part";
            } else if ("wf_part_relation".equals(formId) && WfConfigurationUtil.isEnableNewPartRelationForm()) {
                formId = "wf_part_relation_new";
            } else if ("wf_part_relation_new".equals(formId) && !WfConfigurationUtil.isEnableNewPartRelationForm()) {
                formId = "wf_part_relation";
            }
            partMap.put(ROW_INDEX, row);
            FormShowParameter parameter = ParticipantConfigureHelper.getFormShowParameter(plugin, itemId, modelJson, formId, actionId);
            parameter.setCustomParam(RD_KEY_PART, partMap);
            Object selectedType = partMap.get("selectedType");
            parameter.setCustomParam("selectedType", WfUtils.isEmptyString((Object)selectedType) ? partMap.get("type") : selectedType);
            parameter.setCustomParam("value", partMap.get("value"));
            parameter.setCustomParam("type", partMap.get("type"));
            parameter.setCustomParam("ID", (Object)String.valueOf(partMap.get("id")));
            parameter.setCustomParam(SHOWVALUE, partMap.get(VALUE_SHOWTEXT));
            Object isRequired = partMap.get("required");
            parameter.setCustomParam("required", (Object)(WfUtils.isEmptyString((Object)isRequired) ? "" : isRequired.toString()));
            view.showForm(parameter);
        }
    }

    public static List<Map<String, Object>> deleteParticipant(AbstractFormPlugin plugin, String entryId) {
        List<Map<String, Object>> returnDataList = null;
        int rowIndex = ParticipantConfigureHelper.isChooseRecord(plugin, StandardTips.notSelectRowTips(), entryId);
        if (rowIndex > -1) {
            IDataModel model = plugin.getView().getModel();
            model.deleteEntryRow(entryId, rowIndex);
            returnDataList = ParticipantConfigureHelper.setReturnDataToCache(plugin, entryId, null, rowIndex, OPERATION_DELETE);
            if (model.getEntryRowCount(entryId) < 1) {
                plugin.getView().setVisible(Boolean.FALSE, new String[]{entryId});
            }
        } else {
            returnDataList = ParticipantConfigureHelper.getReturnDataList(plugin.getPageCache().get(ParticipantConfigureHelper.getDatasCacheKey(entryId)));
        }
        return returnDataList;
    }

    public static void deleteAllParticipants(AbstractFormPlugin plugin, String entryId) {
        String cacheKey = ParticipantConfigureHelper.getDatasCacheKey(entryId);
        IFormView view = plugin.getView();
        IDataModel model = view.getModel();
        model.deleteEntryData(entryId);
        view.setVisible(Boolean.FALSE, new String[]{entryId});
        plugin.getPageCache().put(cacheKey, "[]");
    }

    public static List<Map<String, Object>> setReturnDataToCache(AbstractFormPlugin plugin, String entryId, Map<String, Object> map, int rowIndex, String operation) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (null != map) {
            ret.putAll(map);
        }
        String cacheKey = ParticipantConfigureHelper.getDatasCacheKey(entryId);
        String pageCache = plugin.getPageCache().get(cacheKey);
        List<Map<String, Object>> returnDataList = ParticipantConfigureHelper.getReturnDataList(pageCache);
        if (!OPERATION_DELETE.equals(operation)) {
            ret.put("property", "participant");
        }
        if (OPERATION_ADD.equals(operation)) {
            returnDataList.add(rowIndex, ret);
        } else if (OPERATION_MODIFY.equals(operation)) {
            Map<String, Object> oldParticipant = returnDataList.get(rowIndex);
            Object condrule = oldParticipant.get("condrule");
            if (!ret.containsKey("condrule") && condrule != null) {
                ret.put("condrule", condrule);
            }
            Object conditionExpression = oldParticipant.get("conditionExpression");
            if (!ret.containsKey("conditionExpression") && conditionExpression != null) {
                ret.put("conditionExpression", conditionExpression);
            }
            Object condruleshowtext = oldParticipant.get("condruleshowtext");
            if (!ret.containsKey("condruleshowtext") && condruleshowtext != null) {
                ret.put("condruleshowtext", condruleshowtext);
            }
            Object defaultCondition = oldParticipant.get("defaultCondition");
            if (!ret.containsKey("defaultCondition") && defaultCondition != null) {
                ret.put("defaultCondition", defaultCondition);
            }
            returnDataList.set(rowIndex, ret);
        } else if (OPERATION_DELETE.equals(operation)) {
            returnDataList.remove(rowIndex);
        }
        String data = SerializationUtils.toJsonString(returnDataList);
        plugin.getPageCache().put(cacheKey, data);
        return returnDataList;
    }

    private static List<Map<String, Object>> getReturnDataList(String cacheData) {
        List returnDataList = null;
        returnDataList = WfUtils.isEmpty((String)cacheData) ? new ArrayList() : (List)SerializationUtils.fromJsonString((String)cacheData, List.class);
        return returnDataList;
    }

    private static void setModificationRowIndex(AbstractFormPlugin plugin, String entryId, int index) {
        plugin.getPageCache().put(ParticipantConfigureHelper.getCachedRowIndexKey(entryId), String.valueOf(index));
    }

    private static int getModificationRowIndex(AbstractFormPlugin plugin, String entryId) {
        String index = plugin.getPageCache().get(ParticipantConfigureHelper.getCachedRowIndexKey(entryId));
        if (WfUtils.isEmpty((String)index)) {
            return -1;
        }
        return Integer.parseInt(index);
    }

    private static FormShowParameter getFormShowParameter(AbstractFormPlugin plugin, String itemId, String modelJson, String openFormId, String actionId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("wf_participant_assist");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, actionId));
        if (null != openFormId) {
            parameter.setCustomParam("openpagebyformid", (Object)openFormId);
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("type", ConditionalRuleType.participant.toString());
        context.put("model", modelJson);
        context.put("property", "participant");
        HashMap<String, String> nodeProperties = new HashMap<String, String>();
        nodeProperties.put("itemId", itemId);
        context.put("nodeProperties", nodeProperties);
        parameter.setCustomParam("needSourceElement", plugin.getView().getFormShowParameter().getCustomParam("needSourceElement"));
        parameter.setCustomParam(RD_KEY_CONTEXT, context);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setShowTitle(false);
        parameter.setHasRight(true);
        parameter.setCustomParam(REFERENCEPERSONSCENE, plugin.getView().getFormShowParameter().getCustomParam(REFERENCEPERSONSCENE));
        return parameter;
    }

    private static int isChooseRecord(AbstractFormPlugin plugin, String tips, String entryId) {
        int rowIndex = -1;
        IFormView view = plugin.getView();
        IDataModel model = view.getModel();
        DynamicObjectCollection dynamicObjectCollection = model.getEntryEntity(entryId);
        if (dynamicObjectCollection == null || 0 == dynamicObjectCollection.size()) {
            view.showTipNotification(tips, Integer.valueOf(1000));
        } else {
            rowIndex = ParticipantConfigureHelper.getFocusRowIndex(view, entryId);
            if (rowIndex < 0) {
                view.showTipNotification(StandardTips.notSelectRowTips(), Integer.valueOf(1000));
            }
        }
        return rowIndex;
    }

    public static int getFocusRowIndex(IFormView view, String entryName) {
        EntryGrid grid = (EntryGrid)view.getControl(entryName);
        int[] selectRows = grid.getEntryState().getSelectedRows();
        if (selectRows != null && selectRows.length > 0) {
            return selectRows[0];
        }
        return -1;
    }

    public static List<Map<String, Object>> getReturnDataListFromCache(AbstractFormPlugin plugin, String entryId) {
        String pageCache = plugin.getPageCache().get(ParticipantConfigureHelper.getDatasCacheKey(entryId));
        if (null == pageCache) {
            return null;
        }
        List returnDataList = (List)SerializationUtils.fromJsonString((String)pageCache, List.class);
        return returnDataList;
    }

    public static Map<String, Object> getReturnDataMapFromCache(AbstractFormPlugin plugin, String entryId, int rowIndex) {
        List<Map<String, Object>> returnDataList = ParticipantConfigureHelper.getReturnDataListFromCache(plugin, entryId);
        if (returnDataList == null || returnDataList.size() <= rowIndex) {
            return null;
        }
        return returnDataList.get(rowIndex);
    }

    public static void initParticipantEntryEntity(AbstractFormPlugin plugin, ParticipantEntryInfo info, List<Map<String, Object>> participantList) {
        if (participantList == null || participantList.isEmpty()) {
            return;
        }
        plugin.getView().getModel().batchCreateNewEntryRow(info.getEntryId(), participantList.size());
        ArrayList returnDataList = new ArrayList();
        int index = 0;
        for (Map<String, Object> data : participantList) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (data != null) {
                map.putAll(data);
            }
            HashMap<String, Object> tempMap = new HashMap<String, Object>();
            tempMap.putAll(map);
            returnDataList.add(index, tempMap);
            info.setRowData(map);
            info.setRowIndex(index);
            ParticipantConfigureHelper.setEntryEntityAllMap(info.getRowData(), info.getPictureId(), info.getPrefixId());
            ParticipantConfigureHelper.setRowDataAll(plugin.getView().getModel(), info);
            ++index;
        }
        String data = SerializationUtils.toJsonString(returnDataList);
        plugin.getPageCache().put(ParticipantConfigureHelper.getDatasCacheKey(info.getEntryId()), data);
    }

    public static List<Map<String, Object>> setParticipantEntryValue(AbstractFormPlugin plugin, ParticipantEntryInfo info, String actionId) {
        int rowIndex;
        IFormView view = plugin.getView();
        IDataModel model = view.getModel();
        if (OPERATION_ADD.equals(actionId) && model.getEntryRowCount(info.getEntryId()) < 1) {
            view.setVisible(Boolean.TRUE, new String[]{info.getEntryId()});
        }
        if ((rowIndex = ParticipantConfigureHelper.getModificationRowIndex(plugin, info.getEntryId())) < 0) {
            rowIndex = model.createNewEntryRow(info.getEntryId());
        }
        info.setRowIndex(rowIndex);
        List<Map<String, Object>> returnDataList = ParticipantConfigureHelper.setReturnDataToCache(plugin, info.getEntryId(), info.getRowData(), info.getRowIndex(), actionId);
        ParticipantConfigureHelper.setEntryEntityAllMap(info.getRowData(), info.getPictureId(), info.getPrefixId());
        ParticipantConfigureHelper.setRowDataAll(plugin.getView().getModel(), info);
        return returnDataList;
    }

    private static void setEntryEntityAllMap(Map<String, Object> map, String pictureId, String prefixId) {
        String type = map.get("type").toString();
        String showTextPre = null;
        String imageUrl = null;
        if (TYPE_ITEM_RELATION.equals(type)) {
            showTextPre = ResManager.loadKDString((String)"\u5173\u7cfb\uff1a", (String)"ParticipantConfigureHelper_4", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            imageUrl = PictureResourceEnum.PC_RELATION_SMALL.getValue();
        } else if (TYPE_ITEM_ROLE.equals(type)) {
            showTextPre = ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41\u89d2\u8272\uff1a", (String)"ParticipantConfigureHelper_5", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            imageUrl = PictureResourceEnum.PC_ROLE_SMALL.getValue();
        } else if (TYPE_ITEM_PERSON.equals(type)) {
            showTextPre = ResManager.loadKDString((String)"\u4eba\u5458\uff1a", (String)"ParticipantConfigureHelper_6", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            imageUrl = PictureResourceEnum.PC_PERSON_SMALL.getValue();
        } else if (TYPE_ITEM_PLUGIN.equals(type)) {
            showTextPre = ResManager.loadKDString((String)"\u63d2\u4ef6\uff1a", (String)"ParticipantConfigureHelper_7", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            imageUrl = PictureResourceEnum.PC_PLUGIN_SMALL.getValue();
        } else if (TYPE_ITEM_POSITION.equals(type)) {
            showTextPre = ResManager.loadKDString((String)"\u5c97\u4f4d\uff1a", (String)"ParticipantConfigureHelper_11", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            imageUrl = PictureResourceEnum.PC_POSITION_SMALL.getValue();
        } else {
            WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
            showTextPre = wfService.getRepositoryService().getParticipantModelCfgEntityByCfgNumber(type).getName() + "\uff1a";
            imageUrl = PictureResourceEnum.PC_EXTEND_SMALL.getValue();
        }
        map.put(prefixId, showTextPre);
        map.put(pictureId, imageUrl);
    }

    private static void setRowDataAll(IDataModel model, ParticipantEntryInfo info) {
        Map<String, Object> map = info.getRowData();
        int rowIndex = info.getRowIndex();
        if (model == null || map == null || map.isEmpty() || rowIndex < 0) {
            return;
        }
        ParticipantConfigureHelper.setIfCheck(model, info.getPictureId(), ParticipantConfigureHelper.getString(map.get(info.getPictureId())), rowIndex);
        ParticipantConfigureHelper.setIfCheck(model, info.getPrefixId(), ParticipantConfigureHelper.getString(map.get(info.getPrefixId())), rowIndex);
        ParticipantConfigureHelper.setIfCheck(model, info.getValueId(), ParticipantConfigureHelper.getTextFromParams(map), rowIndex);
        ParticipantConfigureHelper.setIfCheck(model, info.getRequired(), (Boolean)map.get(info.getRequired()), rowIndex);
    }

    public static void setIfCheck(IDataModel model, String prop, Object value, int rowIndex) {
        if (WfUtils.isEmpty((String)prop)) {
            return;
        }
        if (WfUtils.isNotEmptyString((Object)value)) {
            if (rowIndex < 0) {
                model.setValue(prop, value);
            } else {
                model.setValue(prop, value, rowIndex);
            }
        }
    }

    public static String getTextFromParams(Map<String, Object> map) {
        return ParticipantHelper.getTextFromParams(map);
    }

    private static String getString(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    public static boolean loadCardDataForParticipant(JSONObject participant, String entryId, String modelId, AbstractFormPlugin plugin, ParticipantEntryInfo info) {
        boolean isHavingData = false;
        IFormView view = plugin.getView();
        if (participant == null) {
            view.setVisible(Boolean.FALSE, new String[]{entryId});
        } else {
            List participants = (List)participant.get((Object)modelId);
            if (participants != null && !participants.isEmpty()) {
                isHavingData = true;
                view.setVisible(Boolean.TRUE, new String[]{entryId});
                ParticipantConfigureHelper.initParticipantEntryEntity(plugin, info, participants);
            } else {
                view.setVisible(Boolean.FALSE, new String[]{entryId});
            }
        }
        return isHavingData;
    }
}

