/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.util;

import com.alibaba.fastjson.JSONArray;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.lang.Lang;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.print.PrintJob;
import kd.bos.print.api.PrintWork;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.service.BosPrintServiceHelper;
import kd.bos.servicehelper.PrintServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.bpmn.diff.util.BpmnDiffUtil;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.MessageSendModel;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntityImpl;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class PluginUtil {
    private static Log logger = LogFactory.getLog(PluginUtil.class);
    public static final String CREATEDATE = "createdate";
    public static final String MODIFYDATE = "modifydate";
    public static final String ENDTIME = "endtime";
    public static final String OLDPRINTTYPE = "A";
    public static final String NEWPRINTTYPE = "B";
    public static final String PRINTURL = "/api/print/download.do?taskId=%s&attachId=%s&accountId=%s";

    public static boolean matchPattern(String patternStr, String value) {
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(value);
        return matcher.find();
    }

    public static void setComboForControl(Map<String, Object> items, ComboEdit operation) {
        ComboItem comboItem = null;
        LocaleString localeString = null;
        Set<Map.Entry<String, Object>> entrySet = items.entrySet();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(entrySet.size());
        for (Map.Entry<String, Object> entry : entrySet) {
            comboItem = new ComboItem();
            localeString = new LocaleString();
            localeString.setLocaleValue(entry.getKey());
            comboItem.setCaption(localeString);
            comboItem.setValue(entry.getValue().toString());
            comboItems.add(comboItem);
        }
        operation.setComboItems(comboItems);
    }

    private static List<ParticipantModelEntityImpl> getDefaultParticipants(String field) {
        ArrayList<ParticipantModelEntityImpl> defaultParticipants = new ArrayList<ParticipantModelEntityImpl>();
        ParticipantModelEntityImpl participantModel = new ParticipantModelEntityImpl();
        participantModel.setType("relation");
        participantModel.setValue(ResManager.loadKDString((String)"\u6d41\u7a0b-\u6d41\u7a0b\u53d1\u8d77\u4eba\u672c\u4eba", (String)"PluginUtil_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        participantModel.setDescription(ResManager.loadKDString((String)"\u5173\u7cfb\uff1a\u6d41\u7a0b-\u6d41\u7a0b\u53d1\u8d77\u4eba\u672c\u4eba", (String)"PluginUtil_4", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        participantModel.setPersonRelation("self");
        participantModel.setProperty(String.format("%s.receiver", field));
        participantModel.setReferencePerson("PROC_initiator");
        participantModel.setReportType("admin_org");
        participantModel.setId(Long.valueOf(BpmnDiffUtil.getListElementId((String)"participant")));
        defaultParticipants.add(participantModel);
        return defaultParticipants;
    }

    public static List<MessageSendModel> getMessageNotifyInfo(String sendEvt, RepositoryService repositoryService, String field) {
        ArrayList<MessageSendModel> messageSendModels = new ArrayList<MessageSendModel>();
        MessageSendModel messageSendModel = new MessageSendModel();
        messageSendModel.setContent(ResManager.loadKDString((String)"\u5ba1\u6279\u901a\u8fc7", (String)"PluginUtil_6", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        messageSendModel.setNotify(true);
        messageSendModel.setMessagetype("notify");
        messageSendModel.setSendevt(WfUtils.isEmpty((String)sendEvt) ? "Consent" : sendEvt);
        messageSendModel.setId(BpmnDiffUtil.getListElementId((String)field));
        messageSendModel.setReceiver(PluginUtil.getDefaultParticipants(field));
        messageSendModels.add(messageSendModel);
        return messageSendModels;
    }

    public static JSONArray getMessageNotifyInfoForJson(RepositoryService repositoryService) {
        List<MessageSendModel> messageSendModels = PluginUtil.getMessageNotifyInfo(null, repositoryService, "outMsg");
        String text = SerializationUtils.toJsonString(messageSendModels);
        return JSONArray.parseArray((String)text);
    }

    public static BpmnModel getBpmnModelByModelId(Long id, RepositoryService service) {
        ResourceEntity modelResource = service.getResourceByModelIdAndType(id, "graph_json");
        String json = null;
        if (modelResource == null || WfUtils.isEmpty((String)(json = modelResource.getData()))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u6d41\u7a0b\u6a21\u578bID=\u201c%s\u201d\u5bf9\u5e94\u7684\u8d44\u6e90\u3002", (String)"PluginUtil_7", (String)"bos-wf-formplugin", (Object[])new Object[0]), id));
        }
        BpmnModel bpmnModel = null;
        try {
            bpmnModel = DesignerModelUtil.getBpmnModel(json);
        }
        catch (Exception e) {
            logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        return bpmnModel;
    }

    public static ILocaleString getAuditText(String auditNumber, Long processInstanceId, Long processDefinitionId, String nodeId) {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        BpmnModel bpmnModel = wfService.getRepositoryService().getBpmnModel(processDefinitionId, processInstanceId);
        List decisionOptionsList = bpmnModel.getFlowElement(nodeId).getDecisionOptions();
        if (decisionOptionsList != null) {
            DecisionOption decisionOption = null;
            for (int i = 0; i < decisionOptionsList.size(); ++i) {
                decisionOption = (DecisionOption)decisionOptionsList.get(i);
                if (!auditNumber.equals(decisionOption.getNumber())) continue;
                String decisionId = decisionOption.getId();
                String multiKey = BpmnModelUtil.getDecisionNameMultiKey((String)nodeId, (String)decisionId);
                ILocaleString auditText = BpmnModelUtil.getMultiLangFieldValue((Long)processInstanceId, (String)multiKey, (String)decisionOption.getName());
                return auditText;
            }
        }
        return new LocaleString("");
    }

    public static void setControlInvisible(IFormView view, String controlName) {
        if (null != view && null == view.getParentView()) {
            view.setVisible(Boolean.FALSE, new String[]{controlName});
        }
    }

    public static boolean check(IFormView view, List<QFilter> qfilters, String ... property) {
        boolean checkResult = true;
        if (qfilters == null || qfilters.isEmpty()) {
            return true;
        }
        if (StringUtils.isNotBlank((Object)property)) {
            for (QFilter filter : qfilters) {
                Object value;
                String ignoreKeys;
                ControlFilter fieldFilter;
                List values;
                List<String> propertyList = Arrays.asList(property);
                String fieldName = filter.getProperty();
                if (propertyList.isEmpty() || !propertyList.contains(fieldName)) continue;
                if (view instanceof IListView && WfUtils.isNotEmptyForCollection((Collection)(values = (fieldFilter = (ControlFilter)((IListView)view).getControlFilters().getFilters().get(fieldName)).getValue())) && (ignoreKeys = "13,10,63,24,").contains((value = values.get(0)) + ",")) {
                    return true;
                }
                String filterStr = filter.toString();
                List qfilterNests = filter.getNests(true);
                if (qfilterNests == null || qfilterNests.isEmpty()) continue;
                String startTime = null;
                String endTime = null;
                filterStr = filterStr.substring(filterStr.indexOf(39) + 1);
                startTime = filterStr.substring(0, filterStr.indexOf(39));
                filterStr = filterStr.substring(filterStr.indexOf(39) + 1);
                filterStr = filterStr.substring(filterStr.indexOf(39) + 1);
                endTime = filterStr.substring(0, filterStr.indexOf(39));
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try {
                    Date startDate = simpleDateFormat.parse(startTime);
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(startDate);
                    cal.add(7, 1);
                    cal.add(2, 3);
                    startDate = cal.getTime();
                    Date endDate = simpleDateFormat.parse(endTime);
                    int compare = endDate.compareTo(startDate);
                    if (compare > 0) {
                        checkResult = false;
                        return checkResult;
                    }
                    checkResult = true;
                }
                catch (ParseException px) {
                    logger.error((Throwable)px);
                    return checkResult;
                }
            }
        }
        return checkResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String openPrintUrl(String printType, PrintWork work, List<PrintJob> jobs, String printLang) {
        String printUrl = "";
        PrtAttach prtAttach = new PrtAttach();
        String taskId = "";
        String lang = Lang.get().toString();
        RequestContext requestContext = RequestContext.get();
        requestContext.setLang(Lang.from((String)printLang));
        try {
            if (NEWPRINTTYPE.equals(printType)) {
                HashMap<String, String> extParam = new HashMap<String, String>();
                extParam.put("lang", printLang);
                work.setExtParam(extParam);
                work.setAppNumber("wftask");
                prtAttach = BosPrintServiceHelper.execPrint((PrintWork)work);
                taskId = prtAttach.getTaskId();
            } else if (OLDPRINTTYPE.equals(printType)) {
                taskId = PrintServiceHelper.execPrint(null, (String)printType, jobs, null);
                prtAttach = BosPrintServiceHelper.getPrtAttach((String)taskId);
            }
        }
        finally {
            RequestContext rc = RequestContext.get();
            rc.setLang(Lang.from((String)lang));
        }
        List attachDetail = prtAttach.getAttachDetail();
        printUrl = UrlService.getDomainContextUrl() + PRINTURL;
        printUrl = printUrl + "&isMobile=true";
        printUrl = String.format(printUrl, taskId, ((PrtAttach.AttachDetail)attachDetail.get(0)).getAttachId(), RequestContext.get().getAccountId());
        return printUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String openPrintOldUrl(List<PrintJob> jobs, String printLang) {
        String printUrl = "";
        if (WfUtils.isEmptyForCollection(jobs)) {
            return printUrl;
        }
        String taskId = "";
        PrtAttach prtAttach = new PrtAttach();
        String lang = Lang.get().toString();
        RequestContext requestContext = RequestContext.get();
        requestContext.setLang(Lang.from((String)printLang));
        try {
            if (WfUtils.isNotEmptyForCollection(jobs)) {
                taskId = PrintServiceHelper.execPrint(null, (String)jobs.get(0).getType(), jobs, null);
                prtAttach = BosPrintServiceHelper.getPrtAttach((String)taskId);
            }
        }
        finally {
            RequestContext rc = RequestContext.get();
            rc.setLang(Lang.from((String)lang));
        }
        List attachDetail = prtAttach.getAttachDetail();
        printUrl = UrlService.getDomainContextUrl() + PRINTURL;
        printUrl = printUrl + "&isMobile=true";
        printUrl = String.format(printUrl, taskId, ((PrtAttach.AttachDetail)attachDetail.get(0)).getAttachId(), RequestContext.get().getAccountId());
        return printUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String openPrintNewUrl(PrintWork work, String printLang) {
        String printUrl = "";
        if (work == null) {
            return printUrl;
        }
        PrtAttach prtAttach = new PrtAttach();
        String taskId = "";
        String lang = Lang.get().toString();
        RequestContext requestContext = RequestContext.get();
        requestContext.setLang(Lang.from((String)printLang));
        try {
            HashMap<String, String> extParam = new HashMap<String, String>();
            extParam.put("lang", printLang);
            work.setExtParam(extParam);
            work.setAppNumber("wftask");
            prtAttach = BosPrintServiceHelper.execPrint((PrintWork)work);
            taskId = prtAttach.getTaskId();
        }
        finally {
            RequestContext rc = RequestContext.get();
            rc.setLang(Lang.from((String)lang));
        }
        List attachDetail = prtAttach.getAttachDetail();
        printUrl = UrlService.getDomainContextUrl() + PRINTURL;
        printUrl = String.format(printUrl, taskId, ((PrtAttach.AttachDetail)attachDetail.get(0)).getAttachId(), RequestContext.get().getAccountId());
        return printUrl;
    }

    public static boolean validateNumber(String number, IFormView view, BeforeDoOperationEventArgs args) {
        if (PluginUtil.matchPattern("^[A-Za-z][A-Za-z0-9_]*$", number)) {
            return true;
        }
        String result = ResManager.loadKDString((String)"\u7f16\u7801\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\uff0c\u4e14\u5fc5\u987b\u4ee5\u5b57\u6bcd\u5f00\u5934\u3002", (String)"PluginUtil_8", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        view.showTipNotification(result);
        args.setCancel(true);
        return false;
    }
}

