/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.design.plugin.WorkflowViewFlowchartPlugin;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.ManagementService;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.RuntimeService;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.SuspendType;
import kd.bos.workflow.engine.impl.util.ProcessInstanceHandleState;
import kd.bos.workflow.engine.impl.util.RuntimeUtil;
import kd.bos.workflow.engine.impl.util.ViewFlowchartUtil;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.taskcenter.plugin.data.WorkflowTCDataPlugin;
import kd.bos.workflow.taskcenter.plugin.util.WorkflowTCDataPluginUtil;

public class ProcessInstancePluginUtil
extends WorkflowTCDataPlugin {
    public static final String HIDDEN_DEAD_LETTER_JOB_FILTER = "hiddenDeadLetterJobFilter";
    private static final String BAR_ERROR_MESSAGE = "barerrormessage";
    private static final String BAR_SUSPEND = "suspend";
    private static final String BAR_REVOKE_SUSPEND = "barrevokesuspend";
    private static final String DYNAMIC_UPDATE_PROCINST = "updateprocinst";
    private static final String BAR_FORCETERMINATE = "feiqi";
    private static final String BAR_PROCESS_SALUTION = "barprocesssalution";
    private static final String CONFIRMABANDONFROMSHARED = "confirmAbandonFromShared";
    private static final String CURSELPROCESSINSTANCEID = "CURSELPROCESSINSTANCEID";
    private static final String DESTNODEID = "DESTNODEID";
    private static final String SRCID = "SRCID";
    private static final String REASON = "reason";
    private static final String BAR_SKIP = "skip";
    private static final String OPENBILL = "openbill";
    private static final String ERRORTYPE = "errortype";
    private static final String PROCESSINSTANCEID = "processinstanceid";
    private static Log log = LogFactory.getLog(ProcessInstancePluginUtil.class);

    private ProcessInstancePluginUtil() {
    }

    public static void buttonAvailable(List<Long> executionIds, Object pkidO, IFormView formView, int size) {
        String pkid;
        if (pkidO instanceof Long) {
            long pkid2 = (Long)pkidO;
            if (pkid2 == 0L) {
                formView.setEnable(Boolean.TRUE, new String[]{BAR_ERROR_MESSAGE});
                formView.setEnable(Boolean.TRUE, new String[]{BAR_SUSPEND});
                formView.setEnable(Boolean.TRUE, new String[]{BAR_REVOKE_SUSPEND});
                formView.setEnable(Boolean.TRUE, new String[]{DYNAMIC_UPDATE_PROCINST});
                formView.setEnable(Boolean.TRUE, new String[]{BAR_PROCESS_SALUTION});
                formView.setEnable(Boolean.TRUE, new String[]{BAR_SKIP});
                formView.setEnable(Boolean.TRUE, new String[]{BAR_FORCETERMINATE});
                return;
            }
        } else if (pkidO instanceof String && ((pkid = (String)pkidO) == null || "".equals(pkid))) {
            formView.setEnable(Boolean.TRUE, new String[]{BAR_ERROR_MESSAGE});
            formView.setEnable(Boolean.TRUE, new String[]{BAR_SUSPEND});
            formView.setEnable(Boolean.TRUE, new String[]{BAR_REVOKE_SUSPEND});
            formView.setEnable(Boolean.TRUE, new String[]{DYNAMIC_UPDATE_PROCINST});
            formView.setEnable(Boolean.TRUE, new String[]{BAR_PROCESS_SALUTION});
            return;
        }
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        RuntimeService runtimeService = wfService.getRuntimeService();
        RepositoryService repositoryService = wfService.getRepositoryService();
        boolean flag = true;
        List es = runtimeService.getSuspendedExecutions(executionIds);
        if (size != es.size()) {
            flag = false;
        }
        if (flag) {
            formView.setEnable(Boolean.TRUE, new String[]{BAR_REVOKE_SUSPEND});
        } else {
            formView.setEnable(Boolean.FALSE, new String[]{BAR_REVOKE_SUSPEND});
            formView.setEnable(Boolean.FALSE, new String[]{DYNAMIC_UPDATE_PROCINST});
        }
        ProcessInstancePluginUtil.setErrorMsgBtn(repositoryService, executionIds, formView);
        if (flag) {
            QFilter qFilter1 = new QFilter(PROCESSINSTANCEID, "in", executionIds);
            QFilter qFilter2 = new QFilter("type", "=", (Object)SuspendType.MANUALSUSPEND.getCode());
            QFilter qFilter3 = new QFilter("undosuspendtime", "is null", null);
            Long durations = repositoryService.getEntityCountByFilter("wf_durationdetail", new QFilter[]{qFilter1, qFilter2, qFilter3});
            int SSCOrAutoOrNotifyTaskCount = runtimeService.getSSCOrAutoOrNotifyTaskCount(executionIds);
            if (SSCOrAutoOrNotifyTaskCount > 0 || durations > 0L) {
                formView.setEnable(Boolean.FALSE, new String[]{DYNAMIC_UPDATE_PROCINST});
            } else {
                formView.setEnable(Boolean.TRUE, new String[]{DYNAMIC_UPDATE_PROCINST});
            }
        }
        if (size == 1 && !executionIds.isEmpty()) {
            Long procDefId = null;
            Long procInstId = null;
            Long executionId = executionIds.get(0);
            ExecutionEntity entity = (ExecutionEntity)repositoryService.findEntityById(executionId, "wf_execution");
            if (entity != null) {
                procDefId = entity.getProcessDefinitionId();
                procInstId = entity.getProcessInstanceId();
                formView.setEnable(Boolean.valueOf(ModelType.BizFlow.name().equals(entity.getProcessType())), new String[]{"viewbillrelation"});
            }
            if (procDefId == null) {
                HistoricProcessInstanceEntity processInstance = wfService.getHistoryService().getHistoricProcessInstance(executionId);
                if (processInstance != null) {
                    procDefId = processInstance.getProcessDefinitionId();
                    procInstId = processInstance.getProcessInstanceId();
                } else {
                    formView.setVisible(Boolean.FALSE, new String[]{"baritemap1"});
                }
            }
            if ("886006942529487872".equals(String.valueOf(procDefId)) || WfUtils.isEmpty((Long)procInstId) || ViewFlowchartUtil.isAutoTestVersion((Long)procInstId)) {
                formView.setEnable(Boolean.FALSE, new String[]{BAR_PROCESS_SALUTION});
            } else {
                formView.setEnable(Boolean.TRUE, new String[]{BAR_PROCESS_SALUTION});
            }
        } else {
            String source = (String)formView.getFormShowParameter().getCustomParam("source");
            if (!"taskmonitor".equals(source)) {
                formView.setEnable(Boolean.FALSE, new String[]{BAR_PROCESS_SALUTION});
            }
        }
        if (runtimeService.isAllProcInstAllowSuspend(executionIds)) {
            formView.setEnable(Boolean.TRUE, new String[]{BAR_SUSPEND});
        } else {
            formView.setEnable(Boolean.FALSE, new String[]{BAR_SUSPEND});
        }
        if (ProcessInstancePluginUtil.isAdministratorOperability(executionIds)) {
            formView.setEnable(Boolean.FALSE, new String[]{BAR_REVOKE_SUSPEND, BAR_SKIP, BAR_FORCETERMINATE});
        }
        if (ProcessInstancePluginUtil.isSuspendParticipantAvailable(executionIds)) {
            formView.setEnable(Boolean.FALSE, new String[]{DYNAMIC_UPDATE_PROCINST});
        }
    }

    private static void setErrorMsgBtn(RepositoryService repositoryService, List<Long> procInstIds, IFormView formView) {
        QFilter qFProcInstId = new QFilter("processInstanceId", "in", procInstIds);
        QFilter qTypes = new QFilter("jobHandlerType", "in", Arrays.asList(RuntimeUtil.getDeadLetterJobStr()));
        Long deadLetterJobs = repositoryService.getEntityCountByFilter("wf_deadletterjob", new QFilter[]{qFProcInstId, qTypes});
        if (deadLetterJobs == 0L) {
            formView.setEnable(Boolean.FALSE, new String[]{BAR_ERROR_MESSAGE});
        } else {
            formView.setEnable(Boolean.TRUE, new String[]{BAR_ERROR_MESSAGE});
        }
    }

    public static boolean isSuspendParticipantAvailable(List<Long> procInstIds) {
        QFilter filter1 = new QFilter(PROCESSINSTANCEID, "in", procInstIds);
        QFilter filter2 = new QFilter(ERRORTYPE, "=", (Object)"nullParticipant");
        QFilter[] filters = new QFilter[]{filter1, filter2};
        DynamicObjectCollection durationDetailCollection = QueryServiceHelper.query((String)"wf_deadletterjob", (String)ERRORTYPE, (QFilter[])filters);
        return durationDetailCollection != null && procInstIds != null && durationDetailCollection.size() != procInstIds.size();
    }

    public static void openErrorMSGList(List<Long> list, IFormView view) {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)ProcessInstancePluginUtil.getPermissionAppId(view), (String)ProcessInstancePluginUtil.getPermissionEntity(view), (String)"47150e89000000ac")) {
            view.showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u9519\u8bef\u4fe1\u606f\u201d\u7684\u201c\u67e5\u770b\u201d\u6743\u9650\u3002", (String)"ProcessInstancePluginUtil_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        if (WfUtils.isNotEmptyForCollection(list)) {
            ListShowParameter parameter = new ListShowParameter();
            parameter.setBillFormId("wf_deadletterjob");
            parameter.setParentPageId(view.getPageId());
            parameter.getOpenStyle().setTargetKey("_submaintab_");
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setCaption(ResManager.loadKDString((String)"\u6302\u8d77\u6d41\u7a0b", (String)"ProcessInstancePluginUtil_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            HashMap<String, Boolean> customParams = new HashMap<String, Boolean>(2);
            customParams.put(HIDDEN_DEAD_LETTER_JOB_FILTER, Boolean.TRUE);
            parameter.setCustomParams(customParams);
            ListFilterParameter listFilterParameter = new ListFilterParameter();
            QFilter qFilter = new QFilter(PROCESSINSTANCEID, "in", list);
            qFilter.and(new QFilter(ERRORTYPE, "!=", (Object)"rpa"));
            listFilterParameter.setFilter(qFilter);
            parameter.setListFilterParameter(listFilterParameter);
            view.showForm((FormShowParameter)parameter);
        } else {
            StandardTips.view((IFormView)view).notSelectRow();
        }
    }

    public static void showProcessConfiguration(IFormView view, Long procInstId) {
        String entityNumber = ProcessInstancePluginUtil.getPermissionEntity(view);
        String appId = ProcessInstancePluginUtil.getPermissionAppId(view);
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)appId, (String)"wf_processdefinition", (String)"/8M2NEU9PFQV")) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6d41\u7a0b\u7ba1\u7406\u201d\u7684\u201c\u6d41\u7a0b\u52a8\u6001\u65b9\u6848\u914d\u7f6e\u201d\u6743\u9650\u3002", (String)"ProcessInstancePluginUtil_50", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            WfUtils.addOpLogByAppId((String)appId, (String)entityNumber, (String)BAR_PROCESS_SALUTION, (MultiLangEnumBridge)new MultiLangEnumBridge("\u67e5\u770b\u6d41\u7a0b\u914d\u7f6e", "WorkflowProcessInstancePlugin_57", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u8d8a\u6743\u8bbf\u95ee:\u65e0\u201c\u6d41\u7a0b\u5b9e\u4f8b\u201d\u7684\u201c\u67e5\u770b\u6d41\u7a0b\u914d\u7f6e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", "ProcessInstancePluginUtil_41", "bos-wf-formplugin"), (Object[])new Object[0]);
            return;
        }
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        ExecutionEntity entity = (ExecutionEntity)wfService.getRepositoryService().findEntityById(procInstId, "wf_execution");
        Long procDefId = null;
        Long schemeId = null;
        String currentActivityId = null;
        if (entity != null) {
            procDefId = entity.getProcessDefinitionId();
            schemeId = entity.getSchemeId();
            currentActivityId = entity.getCurrentActivityId();
        } else {
            HistoricProcessInstanceEntity processInstance = wfService.getHistoryService().getHistoricProcessInstance(procInstId);
            procDefId = processInstance.getProcessDefinitionId();
            schemeId = processInstance.getSchemeId();
        }
        ProcessInstancePluginUtil.openModifyForm(procDefId, schemeId, currentActivityId, view);
    }

    public static void openModifyForm(Long procDefId, Long schemeId, String currentActivityId, IFormView view) {
        String itemId = null;
        if (currentActivityId != null && WfUtils.isNotEmpty((String)currentActivityId)) {
            String[] itemIds = currentActivityId.split(",");
            itemId = itemIds[0];
        }
        WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        BpmnModel bpmnModel = service.getRepositoryService().getBpmnModel(procDefId, null);
        String type = GraphCodecUtils.getModelTypeByProcessType((String)bpmnModel.getMainProcess().getProcessType());
        DesignerModelUtil.openDynamicConfigScheme(type, view, procDefId, schemeId, itemId);
    }

    public static void revokeSuspend(IFormView view, List<Long> pkValue) {
        String entityNumber = ProcessInstancePluginUtil.getPermissionEntity(view);
        String appId = ProcessInstancePluginUtil.getPermissionAppId(view);
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)appId, (String)entityNumber, (String)"/8M3MNJNJZE5")) {
            view.showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u91cd\u65b0\u6fc0\u6d3b\u201d\u6743\u9650\u3002", (String)"ProcessInstancePluginUtil_4", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            WfUtils.addOpLogByAppId((String)appId, (String)entityNumber, (String)BAR_REVOKE_SUSPEND, (MultiLangEnumBridge)new MultiLangEnumBridge("\u64a4\u9500\u6302\u8d77", "WorkflowProcessInstancePlugin_36", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u60a8\u6ca1\u6709\u201c\u64a4\u9500\u6302\u8d77\u201d\u7684\u6743\u9650\u3002", "ProcessInstancePluginUtil_36", "bos-wf-formplugin"), (Object[])new Object[0]);
            return;
        }
        ArrayList failList = Lists.newArrayListWithExpectedSize((int)pkValue.size());
        StringBuilder processInstanceIds = new StringBuilder();
        if (pkValue != null && !pkValue.isEmpty()) {
            try {
                WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
                Iterator<Long> iterator = pkValue.iterator();
                while (iterator.hasNext()) {
                    Long value;
                    Long processInstanceId = value = iterator.next();
                    processInstanceIds.append(processInstanceId).append(',');
                    if (ProcessInstancePluginUtil.canContinue(processInstanceId, view)) {
                        try {
                            wfService.getManagementService().revokeSuspendProcessInstancesByIds(null, processInstanceId);
                        }
                        catch (Exception e) {
                            failList.add(String.format(ResManager.loadKDString((String)"\u64a4\u9500\u6302\u8d77\u5931\u8d25\uff0c\u6d41\u7a0b\u5b9e\u4f8bID\u4e3a\uff1a%1$s\u3002%2$s", (String)"ProcessInstancePluginUtil_5", (String)"bos-wf-formplugin", (Object[])new Object[0]), processInstanceId, "\r\n"));
                        }
                        continue;
                    }
                    return;
                }
            }
            catch (Exception e) {
                String err = ResManager.loadKDString((String)"\u6d41\u7a0b\u5f15\u64ce\u5f02\u5e38\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"ProcessInstancePluginUtil_7", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                String format = String.format(err, e.getMessage());
                failList.add(format);
                log.error(WfUtils.getExceptionStacktrace((Throwable)e));
            }
            String handleName = ResManager.loadKDString((String)"\u64a4\u9500\u6302\u8d77", (String)"ProcessInstancePluginUtil_9", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            StandardTips.view((IFormView)view).batchOptionMsg(handleName, pkValue.size(), (List)failList);
            WfUtils.addOpLogByAppId((String)appId, (String)"wf_execution", (String)BAR_REVOKE_SUSPEND, (MultiLangEnumBridge)new MultiLangEnumBridge("\u64a4\u9500\u6302\u8d77", "ProcessInstancePluginUtil_9", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5c06\u6d41\u7a0b\u5b9e\u4f8bId[%s]\u64a4\u9500\u6302\u8d77", "ProcessInstancePluginUtil_10", "bos-wf-formplugin"), (Object[])new Object[]{processInstanceIds.substring(0, processInstanceIds.length() - 1)});
            if (view instanceof IListView) {
                ProcessInstancePluginUtil.refresh((IListView)view);
            }
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u64a4\u9500\u6302\u8d77\u7684\u6d41\u7a0b\u3002", (String)"ProcessInstancePluginUtil_11", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
    }

    public static boolean canContinue(Long pk, IFormView view) {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        ProcessInstanceHandleState state = wfService.getRepositoryService().isProcessInstanceHandled(pk);
        if (state != null) {
            if (ProcessInstanceHandleState.NOTEXIST == state) {
                view.showTipNotification(ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8b\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u3002", (String)"ProcessInstancePluginUtil_12", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (ProcessInstanceHandleState.ISRUNNING == state) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u6d41\u7a0b\u5b9e\u4f8b\u6b63\u5728\u8fd0\u884c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ProcessInstancePluginUtil_13", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (ProcessInstanceHandleState.ISRETRYING == state) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u6d41\u7a0b\u5b9e\u4f8b\u6b63\u5728\u91cd\u8bd5\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ProcessInstancePluginUtil_14", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private static void refresh(IListView view) {
        WorkflowTCDataPluginUtil.clearSelectData((IFormView)view);
        view.refresh();
    }

    public static void viewCurrentTask(IFormView view, List<Long> procInstIds) {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)ProcessInstancePluginUtil.getPermissionAppId(view), (String)ProcessInstancePluginUtil.getPermissionEntity(view), (String)"05VKOWGDW44=")) {
            view.showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u67e5\u770b\u5f53\u524d\u4efb\u52a1\u201d\u7684\u6743\u9650\u3002", (String)"ProcessInstancePluginUtil_15", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        if (WfUtils.isNotEmptyForCollection(procInstIds)) {
            ListShowParameter parameter = new ListShowParameter();
            parameter.setBillFormId("wf_taskmonitoring");
            parameter.getOpenStyle().setTargetKey("_submaintab_");
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setCaption(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1", (String)"ProcessInstancePluginUtil_16", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            ListFilterParameter listFilterParameter = new ListFilterParameter();
            QFilter qFilter = new QFilter(PROCESSINSTANCEID, "in", procInstIds);
            listFilterParameter.setFilter(qFilter);
            parameter.setListFilterParameter(listFilterParameter);
            view.showForm((FormShowParameter)parameter);
        } else {
            StandardTips.view((IFormView)view).notSelectRow();
        }
    }

    public static void updateProcInst(IFormView view, List<Long> procInstIds) {
        String entityNumber = ProcessInstancePluginUtil.getPermissionEntity(view);
        String appId = ProcessInstancePluginUtil.getPermissionAppId(view);
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)appId, (String)entityNumber, (String)"018KF2ZNSR7J")) {
            view.showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6d41\u7a0b\u5b9e\u4f8b\u201d\u7684\u201c\u8bbe\u7f6e\u6302\u8d77\u53c2\u4e0e\u4eba\u201d\u6743\u9650\u3002", (String)"ProcessInstancePluginUtil_18", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            WfUtils.addOpLogByAppId((String)appId, (String)entityNumber, (String)DYNAMIC_UPDATE_PROCINST, (MultiLangEnumBridge)new MultiLangEnumBridge("\u8bbe\u7f6e\u6302\u8d77\u53c2\u4e0e\u4eba", "ProcessInstancePluginUtil_33", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u60a8\u6ca1\u6709\u201c\u6d41\u7a0b\u5b9e\u4f8b\u201d\u7684\u201c\u8bbe\u7f6e\u6302\u8d77\u53c2\u4e0e\u4eba\u201d\u6743\u9650\u3002", "ProcessInstancePluginUtil_37", "bos-wf-formplugin"), (Object[])new Object[0]);
            return;
        }
        if (procInstIds == null || procInstIds.isEmpty()) {
            StandardTips.view((IFormView)view).notSelectRow();
        } else {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("wf_dynmodifyuser");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam("procInstId", procInstIds);
            parameter.setCaption(ResManager.loadKDString((String)"\u8bbe\u7f6e\u6302\u8d77\u53c2\u4e0e\u4eba", (String)"ProcessInstancePluginUtil_33", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            view.showForm(parameter);
        }
    }

    public static void skip(IFormView view, List<Long> procInstIds, IFormPlugin plugin) {
        String entityNumber = ProcessInstancePluginUtil.getPermissionEntity(view);
        String appId = ProcessInstancePluginUtil.getPermissionAppId(view);
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)appId, (String)entityNumber, (String)"/8M3P61RNHXZ")) {
            view.showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6d41\u7a0b\u7684\u201c\u8df3\u8f6c\u201d\u6743\u9650\u3002", (String)"ProcessInstancePluginUtil_20", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            WfUtils.addOpLogByAppId((String)appId, (String)entityNumber, (String)BAR_SKIP, (MultiLangEnumBridge)new MultiLangEnumBridge("\u8df3\u8f6c", "WorkflowProcessInstancePlugin_56", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u60a8\u6ca1\u6709\u201c\u6d41\u7a0b\u5b9e\u4f8b\u201d\u7684\u201c\u8df3\u8f6c\u201d\u6743\u9650\u3002", "ProcessInstancePluginUtil_38", "bos-wf-formplugin"), (Object[])new Object[0]);
            return;
        }
        if (procInstIds == null || procInstIds.size() != 1) {
            StandardTips.view((IFormView)view).selectMultiRow(Optional.ofNullable(procInstIds).map(List::size).orElseGet(() -> 0).intValue());
            return;
        }
        Long pk = procInstIds.get(0);
        if (ProcessInstancePluginUtil.canContinue(pk, view)) {
            String workFlowType = ViewFlowchartUtil.getWorkFlowType((Long)pk);
            if (ProcessType.BizFlow.name().equals(workFlowType)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u6d41\u4e0d\u652f\u6301\u8df3\u8f6c\u3002", (String)"ProcessInstancePluginUtil_32", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
        } else {
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCaption(ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41\u53ef\u9009\u8282\u70b9", (String)"ProcessInstancePluginUtil_23", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        parameter.setFormId("wf_skipnode");
        parameter.setCustomParam("permission", (Object)"wfexecution");
        parameter.setCustomParam("executionId", (Object)pk);
        parameter.setCloseCallBack(new CloseCallBack(plugin, parameter.getFormId()));
        view.showForm(parameter);
    }

    public static void showTransferLog(IFormView view, List<Long> list) {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)ProcessInstancePluginUtil.getPermissionAppId(view), (String)ProcessInstancePluginUtil.getPermissionEntity(view), (String)"47150e89000000ac")) {
            view.showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6d41\u7a0b\u5b9e\u4f8b\u201d\u7684\u201c\u67e5\u770b\u6d41\u8f6c\u65e5\u5fd7\u201d\u6743\u9650\u3002", (String)"ProcessInstancePluginUtil_24_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        if (list == null || list.size() == 0) {
            StandardTips.view((IFormView)view).notSelectRow();
            return;
        }
        if (list.size() == 1) {
            QFilter qFilter = new QFilter(PROCESSINSTANCEID, "=", (Object)list.get(0));
            String openBillFormId = "wf_eventlogentryes";
            if (QueryServiceHelper.exists((String)"wf_eventlogentry", (QFilter[])new QFilter[]{qFilter})) {
                openBillFormId = "wf_eventlogentry";
            }
            if (view instanceof IFormView) {
                ListShowParameter parameter = new ListShowParameter();
                parameter.setBillFormId(openBillFormId);
                parameter.setParentPageId(view.getPageId());
                parameter.getOpenStyle().setTargetKey("_submaintab_");
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.setCaption(ResManager.loadKDString((String)"\u6d41\u8f6c\u65e5\u5fd7", (String)"ProcessInstancePluginUtil_25", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                ListFilterParameter listFilterParameter = new ListFilterParameter();
                listFilterParameter.setFilter(qFilter);
                parameter.setListFilterParameter(listFilterParameter);
                view.showForm((FormShowParameter)parameter);
            }
        } else {
            StandardTips.view((IFormView)view).selectMultiRow(list.size());
        }
    }

    public static void viewParticipantparseLogList(IFormView view, List<Long> procInstIds) {
        String entityNumber;
        String billNo;
        String businessKey;
        if (procInstIds != null && procInstIds.size() == 1) {
            WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
            Long excutionId = procInstIds.get(0);
            ExecutionEntity excutionEntity = wfService.getRuntimeService().getProcessInstance(excutionId);
            businessKey = null;
            billNo = null;
            entityNumber = null;
            if (excutionEntity == null) {
                HistoricProcessInstanceEntity historicProcessInstanceEntity = wfService.getHistoryService().getHistoricProcessInstance(excutionId);
                if (historicProcessInstanceEntity != null) {
                    entityNumber = historicProcessInstanceEntity.getEntitynumber();
                    billNo = historicProcessInstanceEntity.getBillNo();
                    businessKey = historicProcessInstanceEntity.getBusinessKey();
                }
            } else {
                entityNumber = excutionEntity.getEntityNumber();
                billNo = excutionEntity.getBillNo();
                businessKey = excutionEntity.getBusinessKey();
            }
        } else {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\uff0c\u60a8\u5f53\u524d\u9009\u62e9\u4e86[%s]\u884c\u3002", (String)"ProcessInstancePluginUtil_22", (String)"bos-wf-formplugin", (Object[])new Object[0]), procInstIds == null ? 0 : procInstIds.size()), Integer.valueOf(3000));
            return;
        }
        ProcessInstancePluginUtil.viewParticipantparseLogList(view, entityNumber, businessKey, billNo);
    }

    public static void viewParticipantparseLogList(IFormView view, String entityNumber, String businessKey, String billNo) {
        IFormView settingsFormView = DesignerModelUtil.getTabControlView(view);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCustomParam("entitynumber", (Object)entityNumber);
        parameter.setCustomParam("billno", (Object)billNo);
        parameter.setCustomParam("businesskey", (Object)businessKey);
        parameter.setFormId("wf_participantlog");
        parameter.getOpenStyle().setTargetKey("_submaintab_");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setCaption(ResManager.loadKDString((String)"\u53c2\u4e0e\u4eba\u89e3\u6790\u8fc7\u7a0b", (String)"ProcessInstancePluginUtil_35", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        view.showForm(parameter);
    }

    public static void abandon(IFormView view, Long procInstId, IFormPlugin plugin) {
        log.debug("admin force abandon: " + procInstId);
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)ProcessInstancePluginUtil.getPermissionAppId(view), (String)ProcessInstancePluginUtil.getPermissionEntity(view), (String)"/8M3RG6213GO")) {
            view.showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6d41\u7a0b\u5b9e\u4f8b\u201d\u7684\u201c\u5f3a\u5236\u7ec8\u6b62\u201d\u6743\u9650\u3002", (String)"ProcessInstancePluginUtil_26", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        if (ProcessInstancePluginUtil.canContinue(procInstId, view)) {
            ArrayList<Long> pks = new ArrayList<Long>(1);
            pks.add(procInstId);
            view.getPageCache().put("processInstanceIds", SerializationUtils.toJsonString(pks));
            if (ProcessInstancePluginUtil.isInstanceofSSCApprover(pks)) {
                String message = ResManager.loadKDString((String)"\u5728\u5171\u4eab\u8282\u70b9\u5f3a\u5236\u7ec8\u6b62\u6d41\u7a0b\u540e\uff0c\u9700\u5230\u201c\u5171\u4eab\u4efb\u52a1\u4e2d\u5fc3>\u4efb\u52a1\u7ba1\u7406\u201d\u624b\u52a8\u5220\u9664\u5bf9\u5e94\u7684\u5171\u4eab\u4efb\u52a1\uff0c\u786e\u5b9a\u5f3a\u5236\u7ec8\u6b62\u5417\uff1f", (String)"WorkflowTCDataPlugin_38", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                view.showConfirm(message, MessageBoxOptions.YesNo, new ConfirmCallBackListener(CONFIRMABANDONFROMSHARED));
            } else {
                ProcessInstancePluginUtil.abandonConfirm(plugin, view);
            }
        }
    }

    public static void abandonBill(IFormView view, Long procInstId, IFormPlugin plugin) {
        log.debug("admin force abandonBill: " + procInstId);
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)ProcessInstancePluginUtil.getPermissionAppId(view), (String)ProcessInstancePluginUtil.getPermissionEntity(view), (String)"/8M3RG6213GO")) {
            view.showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6d41\u7a0b\u5b9e\u4f8b\u201d\u7684\u201c\u5f3a\u5236\u7ec8\u6b62\u201d\u6743\u9650\u3002", (String)"ProcessInstancePluginUtil_26", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_abandon");
        parameter.setCustomParam("processInstanceId", (Object)procInstId);
        parameter.setCloseCallBack(new CloseCallBack(plugin, "wf_abandon"));
        view.showForm(parameter);
    }

    public static void realAbandon(IFormView view, String id) {
        ProcessInstancePluginUtil.realAbandon(view, id, null);
    }

    public static void realAbandon(IFormView view, String id, ILocaleString msg) {
        ProcessInstancePluginUtil.realAbandon(view, id, msg, new HashMap<String, Object>());
    }

    public static void realAbandon(IFormView view, String id, ILocaleString msg, Map<String, Object> variables) {
        log.debug(String.format("admin force real abandon: %s  msg: %s ", id, msg));
        if (WfUtils.isNotEmpty((String)id)) {
            WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
            try {
                boolean abandonMainProcess = variables != null && Boolean.TRUE.equals(variables.get("abandonMainProcess"));
                String dynType = abandonMainProcess ? "forceAbortAll" : null;
                wfService.getManagementService().abandonProcessInstance(Long.parseLong(id), msg, dynType);
                WfUtils.addOpLogByAppId((String)ProcessInstancePluginUtil.getPermissionAppId(view), (String)ProcessInstancePluginUtil.getPermissionEntity(view), (String)BAR_FORCETERMINATE, (MultiLangEnumBridge)new MultiLangEnumBridge("\u5f3a\u5236\u7ec8\u6b62\u6d41\u7a0b", "AbandonProcessCmd_4", "bos-wf-engine"), null, (Object[])new Object[]{String.format("proInstanceId:[%s]", id)});
                view.showSuccessNotification(ResManager.loadKDString((String)"\u5f3a\u5236\u7ec8\u6b62\u6210\u529f\u3002", (String)"ProcessInstancePluginUtil_28", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            }
            catch (Exception e) {
                log.warn(WfUtils.getExceptionStacktrace((Throwable)e));
                view.showErrorNotification(e.getMessage());
            }
        }
    }

    public static void adminAbandonOpionCallback(IFormView view, String id, Object returnData) {
        view.getPageCache().remove("processInstanceIds");
        view.getPageCache().remove("procInstIdsWithSubProcTag");
        if (returnData == null) {
            log.debug("admin abandon opinion is null");
            return;
        }
        log.debug(String.format("admin abandon: %s opinion: %s", id, returnData));
        if (returnData instanceof Map) {
            Map dataMap = (Map)returnData;
            LocaleString msg = null;
            if (dataMap.get("abandonMessage") instanceof Map) {
                msg = new LocaleString();
                msg.putAll((Map)dataMap.get("abandonMessage"));
            }
            HashMap<String, Object> variables = new HashMap<String, Object>(1);
            variables.put("abandonMainProcess", Boolean.TRUE.equals(dataMap.get("abandonMainProcess")));
            ProcessInstancePluginUtil.realAbandon(view, id, (ILocaleString)msg, variables);
        } else {
            ProcessInstancePluginUtil.realAbandon(view, id);
        }
    }

    public static void skipSuspend(IFormView view, IPageCache pageCache) {
        try {
            Long pk = Long.valueOf(pageCache.get(CURSELPROCESSINSTANCEID));
            String destId = pageCache.get(DESTNODEID);
            String srcId = pageCache.get(SRCID);
            String reason = pageCache.get(REASON);
            Map reasonMap = (Map)SerializationUtils.fromJsonString((String)reason, Map.class);
            WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
            wfService.getManagementService().jumpToNode(pk.longValue(), destId, true, srcId, (ILocaleString)LocaleString.fromMap((Map)reasonMap));
            WfUtils.addOpLogByAppId((String)ProcessInstancePluginUtil.getPermissionAppId(view), (String)ProcessInstancePluginUtil.getPermissionEntity(view), (String)BAR_SKIP, (MultiLangEnumBridge)new MultiLangEnumBridge("\u8df3\u8f6c", "JumpToNodeCmd_4", "bos-wf-engine"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u6d41\u7a0b\u5b9e\u4f8bId[%1$s]%2$s", "JumpToNodeCmd_5", "bos-wf-engine"), (Object[])new Object[]{pk, destId});
            view.showSuccessNotification(ResManager.loadKDString((String)"\u8df3\u8f6c\u6210\u529f\u3002", (String)"ProcessInstancePluginUtil_29", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            pageCache.remove(CURSELPROCESSINSTANCEID);
            pageCache.remove(DESTNODEID);
            String openBillCache = pageCache.get(OPENBILL);
            if (openBillCache != null && Boolean.parseBoolean(openBillCache)) {
                pageCache.remove(OPENBILL);
                ProcessInstancePluginUtil.closeAndRefreshParentView(view);
            }
        }
        catch (Exception exception) {
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u8df3\u8f6c\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"ProcessInstancePluginUtil_34", (String)"bos-wf-formplugin", (Object[])new Object[0]), exception.getMessage()));
        }
    }

    public static void suspend(IFormView view, List<Long> pkValues) {
        String entityNumber = ProcessInstancePluginUtil.getPermissionEntity(view);
        String appId = ProcessInstancePluginUtil.getPermissionAppId(view);
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)appId, (String)entityNumber, (String)"0YS1GTBP53D6")) {
            view.showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6302\u8d77\u201d\u7684\u6743\u9650\u3002", (String)"WorkflowProcessInstancePlugin_46", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            WfUtils.addOpLogByAppId((String)appId, (String)entityNumber, (String)BAR_SUSPEND, (MultiLangEnumBridge)new MultiLangEnumBridge("\u6302\u8d77", "WorkflowProcessInstancePlugin_44", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u60a8\u6ca1\u6709\u201c\u6302\u8d77\u201d\u7684\u6743\u9650\u3002", "ProcessInstancePluginUtil_39", "bos-wf-formplugin"), (Object[])new Object[0]);
            return;
        }
        if (pkValues == null || pkValues.isEmpty()) {
            StandardTips.view((IFormView)view).notSelectRow();
            return;
        }
        StringBuilder tipNotification = ProcessInstancePluginUtil.getSuspendTipNotification(pkValues);
        if (!WfUtils.isEmpty((String)tipNotification.toString())) {
            view.showTipNotification(tipNotification.toString());
        } else {
            String message = "";
            message = ProcessInstancePluginUtil.isInstanceofSSCApprover(pkValues) ? ResManager.loadKDString((String)"\u4efb\u52a1\u5728\u5171\u4eab\u8282\u70b9\u6302\u8d77\u65f6\uff0c\u5bf9\u5e94\u5171\u4eab\u4efb\u52a1\u4e0d\u4f1a\u5220\u9664\uff0c\u65e0\u6cd5\u5ba1\u6838\u63d0\u4ea4\uff0c\u201c\u64a4\u9500\u6302\u8d77\u201d\u6062\u590d\u540e\u53ef\u6b63\u5e38\u63d0\u4ea4\u5ba1\u6838\u3002\r\n\u60a8\u786e\u5b9a\u8981\u6302\u8d77\u5417\uff1f", (String)"WorkflowProcessInstancePlugin_53", (String)"bos-wf-formplugin", (Object[])new Object[0]) : (pkValues.size() == 1 ? ResManager.loadKDString((String)"\u6302\u8d77\u540e\uff0c\u6d41\u7a0b\u5b9e\u4f8b\u5bf9\u5e94\u7684\u5f85\u529e\u4efb\u52a1\u5c06\u4e0d\u80fd\u5904\u7406\uff0c\u786e\u8ba4\u8981\u6302\u8d77\u5417\uff1f", (String)"WorkflowProcessInstancePlugin_48", (String)"bos-wf-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6302\u8d77\u540e\uff0c\u6d41\u7a0b\u5b9e\u4f8b\u5bf9\u5e94\u7684\u5f85\u529e\u4efb\u52a1\u5c06\u4e0d\u80fd\u5904\u7406\uff0c\u786e\u8ba4\u8981\u6302\u8d77\u5417\uff1f", (String)"WorkflowProcessInstancePlugin_49", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            view.showConfirm(message, MessageBoxOptions.YesNo, new ConfirmCallBackListener(BAR_SUSPEND));
        }
    }

    private static StringBuilder getSuspendTipNotification(List<Long> pkValues) {
        StringBuilder tipNotification = new StringBuilder();
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        RepositoryService repositoryService = wfService.getRepositoryService();
        for (Long pkValue : pkValues) {
            ProcessInstanceHandleState state;
            String billNo = "";
            ExecutionEntity execution = (ExecutionEntity)repositoryService.findEntityById(pkValue, "wf_execution", "billno");
            if (execution != null) {
                billNo = execution.getBillNo();
            }
            if ((state = repositoryService.isProcessInstanceHandled(pkValue)) == null) continue;
            if (ProcessInstanceHandleState.NOTEXIST == state) {
                tipNotification.append(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6d41\u7a0b\u5b9e\u4f8b\u4e2d\u5305\u542b\u5df2\u5904\u7406\u6216\u5220\u9664\u7684\u6d41\u7a0b\u5b9e\u4f8b\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u540e\u91cd\u8bd5\u3002", (String)"WorkflowProcessInstancePlugin_50", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                continue;
            }
            if (ProcessInstanceHandleState.ISRUNNING == state) {
                tipNotification.append(String.format(ResManager.loadKDString((String)"\u201c\u5355\u636e\u7f16\u53f7\u201d\u4e3a\u201c%s\u201d\u7684\u6d41\u7a0b\u5b9e\u4f8b\u5728\u6d41\u8f6c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"WorkflowProcessInstancePlugin_51", (String)"bos-wf-formplugin", (Object[])new Object[0]), billNo));
                continue;
            }
            if (ProcessInstanceHandleState.ISRETRYING != state) continue;
            tipNotification.append(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e3a\uff1a[%s]\u7684\u6d41\u7a0b\u5b9e\u4f8b\u6b63\u5728\u91cd\u8bd5\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002 ", (String)"WorkflowProcessInstancePlugin_52", (String)"bos-wf-formplugin", (Object[])new Object[0]), billNo));
        }
        return tipNotification;
    }

    public static void confirmSuspend(IFormView view, List<Long> pkValues, boolean isListView, IFormPlugin plugin) {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        ManagementService managementService = wfService.getManagementService();
        StringBuilder procInstIds = new StringBuilder();
        StringBuilder failedProcInstIds = new StringBuilder();
        StringBuilder errorMessage = new StringBuilder();
        int successCount = 0;
        int failedCount = 0;
        for (Long processInstanceId : pkValues) {
            procInstIds.append(processInstanceId).append(",");
            try {
                managementService.suspendProcessInstanceByProcessInstanceId(processInstanceId);
                ++successCount;
            }
            catch (Exception e) {
                errorMessage.append(e.getMessage()).append("\u3002");
                failedProcInstIds.append(processInstanceId);
                if (failedCount > 0) {
                    failedProcInstIds.append(",");
                }
                ++failedCount;
                failedProcInstIds.append(String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8bId\u4e3a[%s]\u7684\u6d41\u7a0b\u5b9e\u4f8b\u6302\u8d77\u5931\u8d25\u3002", (String)"WorkflowProcessInstancePlugin_41", (String)"bos-wf-formplugin", (Object[])new Object[0]), processInstanceId));
            }
        }
        if (isListView) {
            String title = String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8b\u6302\u8d77\u6210\u529f%1$s\u6761\uff0c\u5931\u8d25%2$s\u6761\u3002", (String)"WorkflowProcessInstancePlugin_42", (String)"bos-wf-formplugin", (Object[])new Object[0]), successCount, failedCount);
            if (WfUtils.isEmpty((String)failedProcInstIds.toString())) {
                view.showMessage(title);
            } else {
                String details = String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8bID\u4e3a\u201c%s\u201d\u7684\u6d41\u7a0b\u5b9e\u4f8b\u6302\u8d77\u5931\u8d25\u3002", (String)"WorkflowProcessInstancePlugin_43", (String)"bos-wf-formplugin", (Object[])new Object[0]), failedProcInstIds.substring(0, failedProcInstIds.length() - 1));
                view.showMessage(title, details, null);
            }
            ((IListView)view).clearSelection();
            ((IListView)view).refresh();
        } else {
            if (WfUtils.isEmpty((String)errorMessage.toString())) {
                view.showSuccessNotification(ResManager.loadKDString((String)"\u6302\u8d77\u6210\u529f\u3002", (String)"ProcessInstancePluginUtil_30", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            } else {
                view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u6302\u8d77\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"ProcessInstancePluginUtil_31", (String)"bos-wf-formplugin", (Object[])new Object[0]), errorMessage));
            }
            if (plugin instanceof WorkflowViewFlowchartPlugin) {
                ((WorkflowViewFlowchartPlugin)plugin).refreshPage();
            }
        }
        WfUtils.addOpLogByAppId((String)ProcessInstancePluginUtil.getPermissionAppId(view), (String)"wf_execution", (String)BAR_SUSPEND, (MultiLangEnumBridge)new MultiLangEnumBridge("\u6302\u8d77", "WorkflowProcessInstancePlugin_44", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5c06\u6d41\u7a0b\u5b9e\u4f8bID\u4e3a\u201c%s\u201d\u7684\u6d41\u7a0b\u5b9e\u4f8b\u6302\u8d77\u3002", "WorkflowProcessInstancePlugin_45", "bos-wf-formplugin"), (Object[])new Object[]{procInstIds.substring(0, procInstIds.length() - 1)});
    }

    public static boolean isAdministratorOperability(List<Long> procInstIds) {
        QFilter filter1 = new QFilter(PROCESSINSTANCEID, "in", procInstIds);
        QFilter[] filters = new QFilter[]{filter1};
        DynamicObjectCollection durationDetailCollection = QueryServiceHelper.query((String)"wf_durationdetail", (String)ERRORTYPE, (QFilter[])filters);
        if (durationDetailCollection != null && !durationDetailCollection.isEmpty()) {
            for (DynamicObject dynamicObject : durationDetailCollection) {
                if (!"suspendByUserId".equals(dynamicObject.get(ERRORTYPE))) continue;
                return true;
            }
        }
        return false;
    }

    public static void closeAndRefreshParentView(IFormView currentView) {
        currentView.close();
        String listViewId = (String)currentView.getFormShowParameter().getCustomParam("listView");
        if (listViewId != null) {
            ListView parentView = (ListView)currentView.getView(listViewId);
            parentView.updateView();
            currentView.sendFormAction((IFormView)parentView);
        }
    }

    public static void openAdminOpinion(IFormPlugin plugin, IFormView view) {
        log.debug("show admin abandon opinion");
        FormShowParameter form = new FormShowParameter();
        form.setFormId("wf_adminabandon_option");
        form.setCustomParam("permission", (Object)"wfexecution");
        form.getOpenStyle().setShowType(ShowType.Modal);
        String procInstIdsStr = view.getPageCache().get("processInstanceIds");
        if (StringUtils.isNotEmpty((CharSequence)procInstIdsStr)) {
            List processInstanceIds = (List)SerializationUtils.fromJsonString((String)procInstIdsStr, List.class);
            WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
            List procInstIdsWithSubProcTag = wfService.getRuntimeService().getProcessInstanceIdsWithSubProcTag(processInstanceIds);
            if (WfUtils.isNotEmptyForCollection((Collection)procInstIdsWithSubProcTag)) {
                form.setCustomParam("showAbandonSubProcFlex", (Object)Boolean.TRUE);
                view.getPageCache().put("procInstIdsWithSubProcTag", SerializationUtils.toJsonString((Object)procInstIdsWithSubProcTag));
            }
        }
        form.setCloseCallBack(new CloseCallBack(plugin, "wf_adminabandon_option"));
        view.showForm(form);
    }

    public static void abandonConfirm(IFormPlugin plugin, IFormView view) {
        Object configIsOpen = WfConfigurationUtil.getConfigCenterVal((String)"workflow.config.abandonOption");
        log.debug("admin force abandon confirm: " + configIsOpen);
        if ("false".equals(configIsOpen)) {
            view.showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5f3a\u5236\u7ec8\u6b62?", (String)"ProcessInstancePluginUtil_27", (String)"bos-wf-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(BAR_FORCETERMINATE));
        } else {
            ProcessInstancePluginUtil.openAdminOpinion(plugin, view);
        }
    }

    public static boolean isInstanceofSSCApprover(List<Long> pks) {
        boolean isIncludeSSCApprover = false;
        ArrayList<Long> args = new ArrayList<Long>(pks.size());
        for (Long pkValue : pks) {
            args.add(pkValue);
        }
        List params = WfUtils.formatInQueryParam(args, (int)500, (boolean)false);
        String sql = "select FACTID from t_wf_execution where fid in ";
        try (DataSet ds = WfUtils.batchQueryByIn((String)sql, (List)params, (String)"wf.execution.actIdQuery", (boolean)true);){
            for (Row row : ds) {
                if (!WfUtils.isNotEmpty((String)row.getString("FACTID")) || !row.getString("FACTID").contains("SSCApprove")) continue;
                isIncludeSSCApprover = true;
                break;
            }
        }
        return isIncludeSSCApprover;
    }

    public static String getPermissionAppId(IFormView view) {
        FormShowParameter parameter = view.getFormShowParameter();
        String openAppId = (String)parameter.getCustomParam("openappid");
        if ("bpm".equals(openAppId)) {
            return "194JD185SVFC";
        }
        if ("bpm".equals(parameter.getAppId())) {
            return "194JD185SVFC";
        }
        return "a479ec06000000ac";
    }

    public static String getPermissionEntity(IFormView view) {
        FormShowParameter parameter = view.getFormShowParameter();
        String openAppId = (String)parameter.getCustomParam("openappid");
        if ("bpm".equals(openAppId)) {
            return "wf_execution_tree";
        }
        if ("bpm".equals(view.getFormShowParameter().getAppId())) {
            return "wf_execution_tree";
        }
        return "wf_execution";
    }
}

