/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.util.JSONUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntityImpl;
import kd.bos.workflow.engine.repository.Model;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import org.apache.commons.io.FilenameUtils;

public class WFModelManagerUtil {
    private static Log logger = LogFactory.getLog(WFModelManagerUtil.class);

    public static String exportRecord(String[] ids) {
        String jsonName = "";
        if (ids == null || ids.length < 1) {
            return jsonName;
        }
        ArrayList jsons = new ArrayList();
        ORM orm = ORM.create();
        String fields = "id,key,name,description,orgunitid,entrabill,categoryid,version,deploymentid,bpmnxmlid,pngid,graphid,entrabillid,operation,parentprocid,type,creatorid,createdate,modifierid,modifydate";
        QFilter filter = new QFilter("id", "in", (Object)ids);
        QFilter[] qFilters = new QFilter[]{filter};
        try (DataSet modelDs = orm.queryDataSet("WfModleTest_wf_model", "wf_model", fields, qFilters, null);){
            StringBuffer fileName = new StringBuffer();
            for (Row row : modelDs) {
                String fname = row.getString("key");
                fname = StringUtils.isBlank((CharSequence)fname) ? "processWithoutName" : fname;
                fileName.append(row.getString("key")).append('_');
                HashMap<String, Object> mdlMap = new HashMap<String, Object>(21);
                mdlMap.put("id", row.getString("id"));
                mdlMap.put("key", row.getString("key"));
                mdlMap.put("name", row.getString("name"));
                mdlMap.put("description", row.getString("description"));
                mdlMap.put("orgunitid", row.getLong("orgunitid"));
                mdlMap.put("entraBill", row.getString("entraBill"));
                mdlMap.put("category", row.getString("categoryid"));
                mdlMap.put("version", row.getString("version"));
                mdlMap.put("deploymentId", row.getString("deploymentId"));
                mdlMap.put("bpmnxmlid", row.getString("bpmnxmlid"));
                mdlMap.put("pngid", row.getString("pngid"));
                mdlMap.put("graphid", row.getString("graphid"));
                mdlMap.put("entrabillid", row.getString("entrabillid"));
                mdlMap.put("operation", row.getString("operation"));
                mdlMap.put("parentprocid", row.getString("parentprocid"));
                mdlMap.put("type", row.getString("type"));
                mdlMap.put("creatorid", row.getLong("creatorid"));
                mdlMap.put("modifierid", row.getLong("modifierid"));
                mdlMap.put("createdate", row.getDate("createdate"));
                mdlMap.put("modifydate", row.getDate("modifydate"));
                ArrayList<Map<String, Object>> resources = new ArrayList<Map<String, Object>>();
                resources.add(WFModelManagerUtil.getResourceJson(mdlMap.get("bpmnxmlid").toString()));
                resources.add(WFModelManagerUtil.getResourceJson(mdlMap.get("pngid").toString()));
                resources.add(WFModelManagerUtil.getResourceJson(mdlMap.get("graphid").toString()));
                mdlMap.put("resources", resources);
                jsons.add(mdlMap);
                resources = null;
                mdlMap = null;
            }
            try {
                String json = JSONUtils.toString(jsons, (boolean)true);
                if (StringUtils.isNotBlank((CharSequence)fileName)) {
                    String directory = FilenameUtils.normalize((String)(System.getProperty("user.home") + "/exportJSON"));
                    File fileAbovePath = new File(directory);
                    if (!fileAbovePath.exists()) {
                        fileAbovePath.mkdirs();
                    }
                    jsonName = FilenameUtils.normalize((String)(directory + "/" + fileName.substring(0, fileName.length() - 1) + ".json"));
                    WFModelManagerUtil.writeToDisk(jsonName, json);
                }
            }
            catch (IOException e) {
                logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
            }
        }
        return jsonName;
    }

    private static Map<String, Object> getResourceJson(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ORM orm = ORM.create();
        String fields = "id,name,deploymentid,content,generated";
        QFilter filter = new QFilter("id", "=", (Object)new String[]{id});
        QFilter[] qFilters = new QFilter[]{filter};
        HashMap<String, Object> resourceMap = new HashMap<String, Object>();
        try (DataSet rsDs = orm.queryDataSet("WfModleTest_wf_resource", "wf_resource", fields, qFilters, null);){
            Iterator iter = rsDs.iterator();
            if (iter.hasNext()) {
                Row row = (Row)iter.next();
                resourceMap.put("id", row.getString("id"));
                resourceMap.put("content", row.getString("content"));
                resourceMap.put("name", row.getString("name"));
                resourceMap.put("deploymentid", row.getString("deploymentid"));
                resourceMap.put("generated", row.get("generated"));
            }
        }
        return resourceMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToDisk(String path, String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return;
        }
        OutputStream fos = null;
        try {
            fos = Files.newOutputStream(Paths.get(FilenameUtils.getName((String)path), new String[0]), new OpenOption[0]);
            fos.write(json.getBytes(StandardCharsets.UTF_8));
            fos.close();
        }
        catch (IOException e) {
            logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
                }
            }
        }
    }

    public static List<Map<String, Object>> importJson(String fileName) {
        List<Map<String, Object>> jsonItems = WFModelManagerUtil.readFromDisk(fileName);
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        for (Map<String, Object> mdlMap : jsonItems) {
            ModelEntityImpl modelEntity = new ModelEntityImpl();
            WFModelManagerUtil.setModelEntity(modelEntity, mdlMap);
            List resourceList = (List)mdlMap.get("resources");
            HashMap<String, String> resources = new HashMap<String, String>();
            resources.put("svg_xml", WFModelManagerUtil.getResourceEntity(mdlMap.get("pngid").toString(), resourceList));
            resources.put("graph_json", WFModelManagerUtil.getResourceEntity(mdlMap.get("bpmnxmlid").toString(), resourceList));
            resources.put("graph_xml", WFModelManagerUtil.getResourceEntity(mdlMap.get("graphid").toString(), resourceList));
            QFilter qFilter = new QFilter("key", "=", (Object)modelEntity.getKey());
            List models = wfService.getRepositoryService().findModelsByFilters(new QFilter[]{qFilter});
            if (models != null && models.size() > 0) {
                wfService.getRepositoryService().deleteModel(((ModelEntity)models.get(0)).getId());
            }
            wfService.getRepositoryService().saveModel((Model)modelEntity, resources);
            WFModelManagerUtil.updateModelMapIds(mdlMap, modelEntity);
        }
        return jsonItems;
    }

    private static void updateModelMapIds(Map<String, Object> mdlMap, ModelEntityImpl entity) {
        List resourceList = (List)mdlMap.get("resources");
        String oldJsonId = mdlMap.get("bpmnxmlid").toString();
        String oldPngId = mdlMap.get("pngid").toString();
        String id = null;
        Iterator iterator = resourceList.iterator();
        while (iterator.hasNext()) {
            Map resource;
            id = (resource = (Map)iterator.next()).get("id").toString();
            resource.put("id", oldJsonId.equals(id) ? entity.getBPMNXMLID() : (oldPngId.equals(id) ? entity.getPNGID() : entity.getGraphId()));
        }
        mdlMap.put("id", entity.getId());
        mdlMap.put("bpmnxmlid", entity.getBPMNXMLID());
        mdlMap.put("pngid", entity.getPNGID());
        mdlMap.put("graphid", entity.getGraphId());
    }

    private static String getResourceEntity(String id, List<Map<String, Object>> resourceList) {
        ResourceEntityImpl resource = new ResourceEntityImpl();
        for (Map<String, Object> item : resourceList) {
            if (!StringUtils.isNotBlank((CharSequence)id) || !id.equals(item.get("id").toString())) continue;
            resource.setData((String)item.get("data"));
            resource.setContent((ILocaleString)item.get("content"));
            resource.setName((String)item.get("name"));
            resource.setCurrentLanguage(RequestContext.get().getLang().toString());
            resource.setDeploymentId(WfUtils.normalizeId((String)item.get("deploymentid").toString()));
            resource.setDeleted(((Boolean)item.get("generated")).booleanValue());
        }
        return resource.getData();
    }

    private static void setModelEntity(ModelEntityImpl modelEntity, Map<String, Object> mdlMap) {
        modelEntity.setKey((String)mdlMap.get("key"));
        modelEntity.setName((String)mdlMap.get("name"));
        modelEntity.setDescription((String)mdlMap.get("description"));
        int orgunitid = (Integer)mdlMap.get("orgunitid");
        modelEntity.setOrgUnitId(Long.valueOf(orgunitid));
        modelEntity.setEntraBill((String)mdlMap.get("entraBill"));
        String entraBillId = (String)mdlMap.get("entrabillid");
        modelEntity.setApplicationId(WfUtils.getApplicationIdByBillId((String)entraBillId));
        modelEntity.setCategory(Long.valueOf(mdlMap.get("category").toString()));
        modelEntity.setVersion((String)mdlMap.get("version"));
        modelEntity.setDeploymentId(WfUtils.normalizeId((String)mdlMap.get("deploymentId").toString()));
        modelEntity.setEntraBillId(entraBillId);
        modelEntity.setOperation((String)mdlMap.get("operation"));
        modelEntity.setParentprocid(WfUtils.normalizeId((String)mdlMap.get("parentprocid").toString()));
        modelEntity.setType((String)mdlMap.get("type"));
        int creatorid = (Integer)mdlMap.get("creatorid");
        modelEntity.setCreatorId(Long.valueOf(creatorid));
        int modifierid = (Integer)mdlMap.get("modifierid");
        modelEntity.setModifierId(Long.valueOf(modifierid));
        modelEntity.setCreateDate(new Date((Long)mdlMap.get("createdate")));
        modelEntity.setModifyDate(new Date((Long)mdlMap.get("modifydate")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, Object>> readFromDisk(String className) {
        InputStream in = null;
        BufferedReader reader = null;
        StringBuilder json = new StringBuilder();
        try {
            in = ClassLoader.getSystemResourceAsStream(className);
            reader = new BufferedReader(new InputStreamReader(in));
            String tempString = null;
            while ((tempString = reader.readLine()) != null) {
                json.append(tempString);
            }
            reader.close();
        }
        catch (IOException e) {
            logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e1) {
                    logger.error(WfUtils.getExceptionStacktrace((Throwable)e1));
                }
            }
        }
        List jsonItems = null;
        if (!StringUtils.isBlank((CharSequence)json)) {
            try {
                jsonItems = (List)JSONUtils.cast((String)json.toString(), List.class);
            }
            catch (IOException e) {
                logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
            }
        }
        return jsonItems;
    }
}

