/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.form.operate;

import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.bizflow.graph.model.SelectedRowData;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFException;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class ViewBillRelation
extends FormOperate {
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    protected OperationResult invokeOperation() {
        IFormView view = this.getView();
        String businessKey = null;
        OperationResult result = super.invokeOperation();
        String mode = (String)this.getParameter().get("mode");
        if (view instanceof IListView) {
            boolean selectAllEntry;
            IListView listView = (IListView)view;
            ListSelectedRowCollection rows = listView.getSelectedRows();
            int size = rows.size();
            SelectedRowData rowData = new SelectedRowData(rows);
            Object primaryKeyValue = rows.get(0).getPrimaryKeyValue();
            if (size == 1) {
                businessKey = String.valueOf(primaryKeyValue);
            } else if (this.isSelectedSameBill(rows, size)) {
                businessKey = String.valueOf(primaryKeyValue);
            } else {
                StandardTips.view((IFormView)view).selectMultiRow(size);
                return result;
            }
            if (!rowData.getEntryPrimaryKeyValues().isEmpty() && !(selectAllEntry = this.isSelectAllEntry(primaryKeyValue, rowData.getEntryEntityKey(), rowData.getEntryPrimaryKeyValues().size()))) {
                if ("botpmode".equals(mode)) {
                    BizFlowUtil.showBillRelation((IFormView)this.getView(), (String)this.getEntityId(), (SelectedRowData)rowData);
                } else {
                    this.showBillRelationGraphByMixMode(rowData);
                }
                return result;
            }
        } else if (view instanceof IBillView) {
            IBillModel billModel = (IBillModel)view.getModel();
            businessKey = String.valueOf(billModel.getPKValue());
        } else {
            throw new WFException(WFErrorCode.viewFlowchartBillIdError(), new Object[]{view});
        }
        if (WfUtils.isNotEmpty((String)businessKey)) {
            if ("botpmode".equals(mode)) {
                this.showBillRelationGraphByBOTPMode(businessKey);
            } else {
                this.showBillRelationGraphByMixMode(businessKey);
            }
        } else {
            this.logger.debug("businessKey is null!");
        }
        return result;
    }

    private boolean isSelectAllEntry(Object primaryKeyValue, String entryEntityKey, int entryPrimaryKeyCount) {
        if (WfUtils.isEmpty((String)entryEntityKey)) {
            return false;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", primaryKeyValue)};
        DynamicObjectCollection ret = QueryServiceHelper.query((String)this.getEntityId(), (String)entryEntityKey, (QFilter[])filters);
        int dbEntryCount = 0;
        if (ret != null) {
            dbEntryCount = ret.size();
        }
        return entryPrimaryKeyCount == dbEntryCount;
    }

    private void showBillRelationGraphByBOTPMode(String businessKey) {
        if ("0".equals(businessKey)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"ViewBillRelation_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        String permStrategy = (String)this.getParameter().get("permStrategy");
        BizFlowUtil.showBillRelation((IFormView)this.getView(), (String)this.getEntityId(), (String)businessKey, (String)permStrategy);
    }

    private void showBillRelationGraphByMixMode(String businessKey) {
        WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        Long procInstId = service.getRuntimeService().getProcInstIdFromBillRelation(businessKey);
        if (WfUtils.isNotEmpty((Long)procInstId)) {
            String permStrategy = (String)this.getParameter().get("permStrategy");
            BizFlowUtil.showBillRelation((Long)procInstId, (IFormView)this.getView(), (String)businessKey, (String)permStrategy);
        } else {
            this.showBillRelationGraphByBOTPMode(businessKey);
        }
    }

    private void showBillRelationGraphByMixMode(SelectedRowData rowData) {
        String businessKey = String.valueOf(rowData.getPrimaryKeyValue());
        WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        Long procInstId = service.getRuntimeService().getProcInstIdFromBillRelation(businessKey);
        if (WfUtils.isNotEmpty((Long)procInstId)) {
            String permStrategy = (String)this.getParameter().get("permStrategy");
            BizFlowUtil.showBillRelation((Long)procInstId, (IFormView)this.getView(), (String)businessKey, (String)permStrategy);
        } else {
            BizFlowUtil.showBillRelation((IFormView)this.getView(), (String)this.getEntityId(), (SelectedRowData)rowData);
        }
    }

    private boolean isSelectedSameBill(ListSelectedRowCollection rows, int size) {
        if (size > 1) {
            Object first = rows.get(0).getPrimaryKeyValue();
            for (int i = 1; i < size; ++i) {
                Object next = rows.get(i).getPrimaryKeyValue();
                if (first.equals(next)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

