/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.form.operate;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.api.model.BillCard;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.WorkflowFormService;
import kd.bos.workflow.engine.impl.persistence.separatestorage.FieldNameAliasMapper;
import kd.bos.workflow.exception.WFIllegalArgumentException;
import kd.bos.workflow.feature.taskfield.util.TaskExtendFieldUtil;
import kd.bos.workflow.form.operate.flowchart.AbstractViewFlowchart;
import kd.bos.workflow.taskcenter.plugin.util.BuildQfilterUtil;

public class WorkflowFormServiceImpl
implements WorkflowFormService {
    private Log logger = LogFactory.getLog(this.getClass());

    public void viewFlowchart(Object billId, String entityNumber, String pageId, OpenStyle style, Long procDefId) {
        IFormView view = SessionManager.getCurrent().getView(pageId);
        if (view == null) {
            throw new WFIllegalArgumentException(ResManager.loadKDString((String)"pageID\u9519\u8bef\u3002", (String)"WorkflowServiceImpl_41", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
        if (ObjectUtils.isEmpty((Object)billId) && (procDefId == null || procDefId == 0L)) {
            throw new WFIllegalArgumentException(ResManager.loadKDString((String)"\u5355\u636eID\u548c\u6d41\u7a0b\u5b9a\u4e49ID\u4e0d\u53ef\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"WorkflowServiceImpl_42", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
        AbstractViewFlowchart viewFlowchart = new AbstractViewFlowchart();
        viewFlowchart.setBillId(billId);
        viewFlowchart.setEntityName(entityNumber);
        viewFlowchart.showFlowchart(view, style, procDefId);
    }

    public void viewFlowchartWithProcInstId(String pageId, OpenStyle style, Long procInstId) {
        IFormView view = SessionManager.getCurrent().getView(pageId);
        if (view == null) {
            throw new WFIllegalArgumentException(ResManager.loadKDString((String)"pageID\u9519\u8bef\u3002", (String)"WorkflowServiceImpl_41", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
        if (procInstId == null || procInstId == 0L) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8bid\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u67e5\u770b\u6d41\u7a0b\u56fe\u3002", (String)"WorkflowFormServiceImpl_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
        AbstractViewFlowchart viewFlowchart = new AbstractViewFlowchart();
        viewFlowchart.viewFlowchartWithProcInstId(view, style, procInstId);
    }

    public void showBillRelationGraph(String pageId, List<BillCard> billCards, String currentEntityNumber, String currentBusinessKey) {
        if (billCards == null) {
            this.logger.debug("billCards is null.");
            return;
        }
        IFormView view = SessionManager.getCurrent().getView(pageId);
        if (view == null) {
            this.logger.debug("view is null, Invalid pageId.");
            return;
        }
        BizFlowUtil.showBillRelation((IFormView)view, billCards, (String)currentEntityNumber, (String)currentBusinessKey);
    }

    public Map<String, List<Object>> buildToHandleFilter(String queryType, String parentFormId, List<QFilter> filters, boolean isNeedsendername, boolean isFromCount) {
        if (filters.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> formFieldMapSQLFiled = new HashMap<String, String>(20);
        formFieldMapSQLFiled.put("id", "a.fid");
        formFieldMapSQLFiled.put("createdate", "a.fcreatedate");
        if ("wf_msg_center".equals(parentFormId) && "toHandle".equals(queryType)) {
            formFieldMapSQLFiled.put("createdate", "c.fcreatedate");
        }
        formFieldMapSQLFiled.put("billno", "a.fbillno");
        formFieldMapSQLFiled.put("biztraceno", "a.FBIZTRACENO");
        formFieldMapSQLFiled.put("subject", "b.FSUBJECT");
        formFieldMapSQLFiled.put("entityname", "b.FENTITYNAME");
        formFieldMapSQLFiled.put("entitynumber", "a.FENTITYNUMBER");
        formFieldMapSQLFiled.put("handlestate", "a.Fhandlestate");
        formFieldMapSQLFiled.put("name", "b.fname");
        formFieldMapSQLFiled.put("processinstanceid", "a.fprocinstid");
        formFieldMapSQLFiled.put("participantname", "b.fparticipantname");
        formFieldMapSQLFiled.put("active", "a.FISACTIVE");
        formFieldMapSQLFiled.put("groupnumber", "a.fgroupnumber");
        formFieldMapSQLFiled.put("priority", "c.fpriority");
        formFieldMapSQLFiled.put("prioritynumber", "c.fpriority");
        formFieldMapSQLFiled.put("orgunitid", "a.forgunitid");
        formFieldMapSQLFiled.put("sourcename", "a.fsourcename");
        formFieldMapSQLFiled.put("source", "a.fsource");
        formFieldMapSQLFiled.put("category", "a.fcategory");
        formFieldMapSQLFiled.put("processtype", "a.fprocesstype");
        if (WfConfigurationUtil.isDisplaySetting()) {
            formFieldMapSQLFiled.put("startname", "b.fstartnameformat");
            if (isNeedsendername && "transferToHandle".equals(queryType)) {
                formFieldMapSQLFiled.put("sendername", "c.fassigneeformat");
            } else {
                formFieldMapSQLFiled.put("sendername", "b.fsendernameformat");
            }
        } else {
            formFieldMapSQLFiled.put("startname", "b.FSTARTNAME");
            if (isNeedsendername && "transferToHandle".equals(queryType)) {
                formFieldMapSQLFiled.put("sendername", "c.fassignee");
            } else {
                formFieldMapSQLFiled.put("sendername", "b.fsendername");
            }
        }
        formFieldMapSQLFiled.put("suspensionstate", "a.fsuspensionstate");
        formFieldMapSQLFiled.put("groupnumber.id", "a.fgroupnumber");
        formFieldMapSQLFiled.putAll(this.getTaskBusinessSelectFields("wf_task", "a", "d", "b"));
        if (!isFromCount && !"delegateToHandle".equals(queryType)) {
            formFieldMapSQLFiled.put("currentsubject", "cl.fcurrentsubject");
            return BuildQfilterUtil.getFilterSql(filters, formFieldMapSQLFiled, Boolean.FALSE);
        }
        return BuildQfilterUtil.getFilterSql(filters, formFieldMapSQLFiled, Boolean.FALSE);
    }

    public Map<String, List<Object>> buildHandledTaskFilter(String queryType, List<QFilter> filters, boolean isFromCount) {
        HashMap<String, String> formFieldMapSQLFiled = new HashMap<String, String>(32);
        formFieldMapSQLFiled.put("id", "a.fid");
        formFieldMapSQLFiled.put("createdate", "a.fcreatedate");
        formFieldMapSQLFiled.put("endtime", "a.fendtime");
        formFieldMapSQLFiled.put("billno", "a.fbillno");
        formFieldMapSQLFiled.put("entitynumber", "a.FENTITYNUMBER");
        formFieldMapSQLFiled.put("subject", "b.FSUBJECT");
        formFieldMapSQLFiled.put("name", "b.fname");
        formFieldMapSQLFiled.put("entityname", "b.FENTITYNAME");
        formFieldMapSQLFiled.put("handlestate", "a.fhandlestate");
        formFieldMapSQLFiled.put("sourcename", "a.fsourcename");
        if (WfConfigurationUtil.isDisplaySetting()) {
            formFieldMapSQLFiled.put("startname", "b.fstartnameformat");
            formFieldMapSQLFiled.put("sendername", "b.fsendernameformat");
        } else {
            formFieldMapSQLFiled.put("startname", "b.FSTARTNAME");
            formFieldMapSQLFiled.put("sendername", "b.fsendername");
        }
        if ("transferHandled".equals(queryType)) {
            formFieldMapSQLFiled.put("createdate", "c.fcreatedate");
            formFieldMapSQLFiled.put("sendername", "b.fassignee");
        }
        formFieldMapSQLFiled.put("presentassignee", "a.fpresentassignee");
        if (WfConfigurationUtil.isHiTaskSingleTableQuery().booleanValue() && WfConfigurationUtil.isUpdateHiTaskToHiCommentComplete().booleanValue()) {
            formFieldMapSQLFiled.put("subject", "b.fcurrentsubject");
            formFieldMapSQLFiled.put("name", "b.factivityname");
            formFieldMapSQLFiled.put("id", "a.ftaskid");
            formFieldMapSQLFiled.put("endtime", "a.ftime");
            formFieldMapSQLFiled.putAll(this.getTaskBusinessSelectFields("wf_hicomment", "a", "f", "b"));
        } else {
            if ("handled".equals(queryType)) {
                formFieldMapSQLFiled.put("endtime", "d.ftime");
            }
            formFieldMapSQLFiled.put("subject", "b.FSUBJECT");
            formFieldMapSQLFiled.put("name", "b.fname");
            formFieldMapSQLFiled.putAll(this.getTaskBusinessSelectFields("wf_hitaskinst", "a", "f", "b"));
        }
        if (!isFromCount) {
            if (WfConfigurationUtil.isHiTaskSingleTableQuery().booleanValue() && WfConfigurationUtil.isUpdateHiTaskToHiCommentComplete().booleanValue()) {
                formFieldMapSQLFiled.put("currentsubject", "b.fcurrentsubject");
            } else {
                formFieldMapSQLFiled.put("currentsubject", "e.fcurrentsubject");
            }
            return BuildQfilterUtil.getFilterSql(filters, formFieldMapSQLFiled, Boolean.FALSE);
        }
        return BuildQfilterUtil.getFilterSql(filters, formFieldMapSQLFiled, Boolean.FALSE);
    }

    public String buildOrderByToSql(String queryType, String orderBy) {
        if (WfUtils.isEmpty((String)orderBy)) {
            return orderBy;
        }
        if ("handled".equals(queryType) || "delegateHandled".equals(queryType) || "transferHandled".equals(queryType)) {
            return this.getHandledOrderByStr(orderBy);
        }
        if ("toHandle".equals(queryType) || "transferToHandle".equals(queryType) || "delegateToHandle".equals(queryType) || "foldToHandle".equals(queryType)) {
            return this.getToHandleOrderByStr(queryType, orderBy);
        }
        return "";
    }

    public void analyzeHandlestateFilter(QFilter f) {
        if ("handlestate".equalsIgnoreCase(f.getProperty())) {
            this.handleSuspendFilter(f);
        }
        if ("prioritynumber".equalsIgnoreCase(f.getProperty()) && f.getValue() instanceof String) {
            f.__setValue((Object)Integer.parseInt((String)f.getValue()));
        }
        if (f.getNests(true) != null && !f.getNests(true).isEmpty()) {
            List nests = f.getNests(true);
            for (int i = 0; i < nests.size(); ++i) {
                QFilter nestQfilter = ((QFilter.QFilterNest)nests.get(i)).getFilter();
                if ("handlestate".equalsIgnoreCase(nestQfilter.getProperty())) {
                    this.handleSuspendFilter(nestQfilter);
                }
                if (!"prioritynumber".equalsIgnoreCase(nestQfilter.getProperty()) || !(nestQfilter.getValue() instanceof String)) continue;
                nestQfilter.__setValue((Object)Integer.parseInt((String)nestQfilter.getValue()));
            }
        }
    }

    public Map<String, List<Object>> buildMessageFilter(Map<String, String> fieldMapping, List<QFilter> qFilter) {
        return BuildQfilterUtil.getFilterSql(qFilter, fieldMapping, Boolean.FALSE);
    }

    private void handleSuspendFilter(QFilter filter) {
        if (!filter.getProperty().equalsIgnoreCase("handlestate")) {
            return;
        }
        String cp = filter.getCP();
        if (cp.equalsIgnoreCase("=") && !(filter.getValue() instanceof QEmptyValue)) {
            String v = (String)filter.getValue();
            if ("freeze".equalsIgnoreCase(v)) {
                filter.__setProperty("active");
                filter.__setCP("=");
                filter.__setValue((Object)"0");
            } else if ("manualSuspended".equalsIgnoreCase(v)) {
                filter.__setProperty("suspensionstate");
                filter.__setCP("!=");
                filter.__setValue((Object)"1");
            } else {
                filter.and("active", "=", (Object)"1").and("suspensionstate", "=", (Object)"1");
            }
        } else if (cp.equalsIgnoreCase("in")) {
            List v = (List)filter.getValue();
            if (v.contains("freeze") && v.contains("manualSuspended")) {
                filter.or("active", "=", (Object)"0").or("suspensionstate", "!=", (Object)"1");
            } else if (v.contains("freeze") && !v.contains("manualSuspended")) {
                filter.or("active", "=", (Object)"0");
            } else if (!v.contains("freeze") && v.contains("manualSuspended")) {
                filter.or("suspensionstate", "!=", (Object)"1");
            } else {
                filter.and("active", "=", (Object)"1").and("suspensionstate", "=", (Object)"1");
            }
        }
    }

    private String getToHandleOrderByStr(String queryType, String orderBy) {
        HashMap<String, String> formFieldMapSQLFiled = new HashMap<String, String>();
        formFieldMapSQLFiled.put("id", "a.fid");
        if ("toHandle".equals(queryType)) {
            formFieldMapSQLFiled.put("createdate", "c.fcreatedate");
        } else {
            formFieldMapSQLFiled.put("createdate", "a.fcreatedate");
        }
        formFieldMapSQLFiled.put("billno", "a.fbillno");
        formFieldMapSQLFiled.put("subject", "subject");
        formFieldMapSQLFiled.put("entityname", "entityname");
        formFieldMapSQLFiled.put("entitynumber", "a.FENTITYNUMBER");
        formFieldMapSQLFiled.put("handlestate", "a.Fhandlestate");
        formFieldMapSQLFiled.put("startname", "startname");
        formFieldMapSQLFiled.put("name", "name");
        formFieldMapSQLFiled.put("processinstanceid", "a.fprocinstid");
        formFieldMapSQLFiled.put("participantname", "participantname");
        formFieldMapSQLFiled.put("sendername", "sendername");
        formFieldMapSQLFiled.put("delegatetime", "p.fcreatedate");
        formFieldMapSQLFiled.putAll(this.getTaskBusinessSelectFields("wf_task", "a", "d", "b"));
        String[] sqlFiledArray = orderBy.split(",");
        String result = "";
        StringBuilder resultSB = new StringBuilder(" ");
        for (int i = 0; i < sqlFiledArray.length; ++i) {
            String[] os = sqlFiledArray[i].split(" ");
            if (os.length != 2) continue;
            String ob = (String)formFieldMapSQLFiled.get(os[0]) + " " + os[1];
            resultSB.append(ob).append(',');
        }
        result = resultSB.substring(0, resultSB.length() - 1);
        return result;
    }

    private String getHandledOrderByStr(String orderBy) {
        if (WfUtils.isEmpty((String)orderBy)) {
            return orderBy;
        }
        Map formFieldMapSQLFiled = FieldNameAliasMapper.getFieldNameAliasMap((String)"handled");
        String[] sqlFiledArray = orderBy.split(",");
        String result = "";
        StringBuilder resultSB = new StringBuilder(" ");
        for (int i = 0; i < sqlFiledArray.length; ++i) {
            String[] os = sqlFiledArray[i].split(" ");
            if (os.length != 2) continue;
            String ob = (String)formFieldMapSQLFiled.get(os[0]) + " " + os[1];
            resultSB.append(ob).append(',');
        }
        result = resultSB.substring(0, resultSB.length() - 1);
        return result;
    }

    private Map<String, String> getTaskBusinessSelectFields(String entityNumber, String tableAlias, String tableGroupAlias, String mulAlias) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (WfUtils.isNotEmpty((String)entityNumber)) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            Map allFields = dataEntityType.getAllFields();
            Boolean allowExtendTaskFields = WfConfigurationUtil.isAllowExtendTaskFields();
            for (Map.Entry entry : allFields.entrySet()) {
                if (!TaskExtendFieldUtil.isBusinessMappingField((IDataEntityProperty)((IDataEntityProperty)entry.getValue())) && (!allowExtendTaskFields.booleanValue() || !TaskExtendFieldUtil.isBusinessMappingExtField((IDataEntityProperty)((IDataEntityProperty)entry.getValue())))) continue;
                IDataEntityProperty property = (IDataEntityProperty)entry.getValue();
                String alias = tableAlias;
                if (entry.getValue() instanceof MuliLangTextProp) {
                    alias = mulAlias;
                }
                if (((IDataEntityProperty)entry.getValue()).getTableGroup() != null) {
                    alias = tableGroupAlias;
                }
                String field = alias != null ? alias + "." + property.getAlias() : property.getAlias();
                map.put((String)entry.getKey(), field);
            }
        }
        return map;
    }

    @Deprecated
    private List<QFilter> dealQfiltersBeforeReplace(List<QFilter> filters) {
        for (int i = 0; i < filters.size(); ++i) {
            QFilter f = filters.get(i);
            if (f.getCP().equals("ftlike") && StringUtils.isNotBlank((Object)f.getValue()) && f.getValue().toString().contains("#")) {
                String value = Pattern.compile("subject").matcher((String)f.getValue()).replaceFirst("subject,currentsubject");
                f.__setValue((Object)value);
            }
            if (!"subject".equalsIgnoreCase(f.getProperty())) continue;
            QFilter currentSubjectFilter = new QFilter("currentsubject", f.getCP(), f.getValue());
            List nests = f.getNests(false);
            if (nests != null && !nests.isEmpty()) {
                for (int j = 0; j < nests.size(); ++j) {
                    QFilter nestFilter = ((QFilter.QFilterNest)nests.get(j)).getFilter();
                    if (((QFilter.QFilterNest)nests.get(j)).isAnd()) {
                        currentSubjectFilter.and(new QFilter("currentsubject", nestFilter.getCP(), nestFilter.getValue()));
                        continue;
                    }
                    currentSubjectFilter.or(new QFilter("currentsubject", nestFilter.getCP(), nestFilter.getValue()));
                }
            }
            if (f.getValue() instanceof QEmptyValue || f.getCP().equals("not like") || f.getCP().equals("<>")) {
                f.and(currentSubjectFilter);
                continue;
            }
            f.or(currentSubjectFilter);
        }
        return filters;
    }
}

