/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.form.operate.flowchart;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.engine.EntityNumberConstant;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.jobexecutor.JobDAO;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobStateEnum;
import kd.bos.workflow.engine.impl.persistence.separatestorage.SeparateStorageUtil;
import kd.bos.workflow.engine.impl.util.ViewFlowchartUtil;
import kd.bos.workflow.engine.msg.ArchiveRouteIndexCondition;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFException;
import kd.bos.workflow.form.operate.flowchart.BusinessViewFlowchart;
import kd.bos.workflow.form.operate.flowchart.IViewFlowchart;
import kd.bos.workflow.form.operate.flowchart.TaskCenterViewFlowchart;
import kd.bos.workflow.form.operate.flowchart.ViewFlowChatStatus;
import kd.bos.workflow.form.operate.util.OperateForWorkflowUtil;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.archive.ArchiveFormService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.service.separatestorage.SeparateStorageFormService;

public class AbstractViewFlowchart
implements IViewFlowchart {
    private static Log log = LogFactory.getLog(AbstractViewFlowchart.class);
    protected static final long TIME_OUT_SECOND = 30L;
    protected WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
    protected DynamicObject wfJob;
    protected JobEntity bizJobEntity;
    protected Object billId;
    protected String entityName;
    protected String billIdField;
    private String tip;

    @Override
    public void showFlowchart(IFormView view) {
        this.showFlowchart(view, null);
    }

    @Override
    public void showFlowchart(IFormView view, OpenStyle style) {
        this.showFlowchart(view, style, null);
    }

    @Override
    public void showFlowchart(IFormView view, OpenStyle style, Long procDefId) {
        Object billId = this.getBillId();
        AbstractViewFlowchart processor = new BusinessViewFlowchart();
        processor.setEntityName(this.entityName);
        if (billId != null) {
            this.infuseArchiveRouteKey(billId, view);
            super.showFlowchartForm(view, billId, style, procDefId);
            return;
        }
        if (view instanceof IListView) {
            IListView listView = (IListView)view;
            ListSelectedRowCollection rows = listView.getSelectedRows();
            int size = OperateForWorkflowUtil.getSelectedRowSize(rows);
            if (size == 1) {
                ListShowParameter showParameter = (ListShowParameter)listView.getFormShowParameter();
                String formId = showParameter.getBillFormId();
                AbstractViewFlowchart tcProcessor = TaskCenterViewFlowchart.getViewFlowchartProcessor(formId);
                if (tcProcessor != null) {
                    processor = tcProcessor;
                }
                Object businessKey = rows.get(0).getPrimaryKeyValue();
                this.infuseArchiveRouteKey(businessKey, (IFormView)listView);
                this.infuseSeparateStorageKey((IFormView)listView, this.entityName, businessKey);
                String realEntityName = EntityNumberConstant.getRealEntityNumber((String)this.entityName);
                processor.showFlowchartForm((IFormView)listView, OperateForWorkflowUtil.getRealBillId(businessKey, realEntityName, this.billIdField), style, procDefId);
            } else {
                StandardTips.view((IFormView)view).selectMultiRow(size);
            }
        } else if (view instanceof IBillView) {
            IBillView billView = (IBillView)view;
            IBillModel billModel = (IBillModel)view.getModel();
            Object billPkId = billModel.getPKValue();
            log.debug(String.format("\u5355\u636e\u7aef\u67e5\u770b\u6d41\u7a0b\u56fe\uff0cPkValue:[%s]", billPkId));
            this.infuseArchiveRouteKey(billPkId, (IFormView)billView);
            super.showFlowchartForm((IFormView)billView, OperateForWorkflowUtil.getRealBillId(billModel.getPKValue(), this.entityName, this.billIdField), style, procDefId);
        } else {
            throw new WFException(WFErrorCode.viewFlowchartBillIdError(), new Object[]{view});
        }
    }

    @Override
    public void viewFlowchartWithProcInstId(IFormView view, OpenStyle style, Long procInstId) {
        this.infuseArchiveRouteKey(procInstId, view);
        FormShowParameter parameter = new FormShowParameter();
        ArchiveFormService.create().setArchiveRouteInfo(view, parameter);
        parameter.setClientParam("procInstId", (Object)String.valueOf(procInstId));
        parameter.setCustomParam("procInstId", (Object)String.valueOf(procInstId));
        parameter.setCustomParam("isFromMobile", (Object)this.isFromMobile(view));
        if (!QueryServiceHelper.exists((String)"wf_hiprocinst", (Object)procInstId)) {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8bid[%s]\u672a\u627e\u5230\u6d41\u7a0b\uff0c\u65e0\u6cd5\u67e5\u770b\u6d41\u7a0b\u56fe\u3002", (String)"AbstractViewFlowchart_10", (String)"bos-wf-formplugin", (Object[])new Object[0]), procInstId));
        }
        ViewFlowchartUtil.showFlowchart((IFormView)view, (FormShowParameter)parameter, (OpenStyle)style);
    }

    private void infuseArchiveRouteKey(Long procInstId, IFormView view) {
    }

    private void infuseArchiveRouteKey(Object businessKey, IFormView view) {
        ArchiveRouteIndexCondition condition = new ArchiveRouteIndexCondition("businessKey", (Object)String.valueOf(businessKey));
        ArchiveFormService.create().injectArchiveRouteInfo(view, "wf_hiprocinst", condition);
    }

    private void infuseSeparateStorageKey(IFormView view, String entityNumber, Object businessKey) {
        if (SeparateStorageUtil.isSupportSeparateStorage((String)entityNumber)) {
            SeparateStorageFormService.create().injectSeparateStorageKey(view, entityNumber, businessKey);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void showFlowchartForm(IFormView view, Object id, OpenStyle style, Long procDefId) {
        DynamicObject billObj;
        FormShowParameter parameter;
        block20: {
            parameter = new FormShowParameter();
            ArchiveFormService.create().setArchiveRouteInfo(view, parameter);
            SeparateStorageFormService.create().setSeparateStorageKey(parameter);
            boolean ret = this.setClientParam(parameter, String.valueOf(id));
            if (view.getFormShowParameter().getCustomParam("procInstId") != null) {
                parameter.setClientParam("procInstId", view.getFormShowParameter().getCustomParam("procInstId"));
            }
            boolean isFromMobile = this.isFromMobile(view);
            if (ret) {
                parameter.setCustomParam("isFromMobile", (Object)isFromMobile);
                ViewFlowchartUtil.showFlowchart((IFormView)view, (FormShowParameter)parameter, (OpenStyle)style);
                return;
            }
            if (isFromMobile) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5728\u6d41\u7a0b\u4e2d\uff0c\u65e0\u6cd5\u67e5\u770b\u6d41\u7a0b\u56fe\u3002", (String)"AbstractViewFlowchart_9", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            billObj = null;
            try {
                if (!WfUtils.isEmpty((Long)procDefId) || !WfConfigurationUtil.canViewChartWithoutSubmit()) break block20;
                if (view instanceof IListView) {
                    String entityNumber;
                    IListView listView = (IListView)view;
                    ListSelectedRowCollection rows = listView.getSelectedRows();
                    String string = entityNumber = StringUtils.isNotEmpty((CharSequence)this.entityName) ? this.entityName : listView.getListModel().getEntityId();
                    if (SeparateStorageUtil.isSupportSeparateStorage((String)entityNumber)) {
                        entityNumber = EntityNumberConstant.getRealEntityNumber((String)entityNumber);
                    }
                    Object businessKey = null;
                    businessKey = id != null ? id : rows.get(0).getPrimaryKeyValue();
                    if (!WfUtils.exist((String)entityNumber, (Object)businessKey)) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5173\u4efb\u52a1\uff0c\u4efb\u52a1\u53ef\u80fd\u5df2\u7ecf\u88ab\u5904\u7406\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"AbstractViewFlowchart_4", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                        return;
                    }
                    billObj = BusinessDataServiceHelper.loadSingle((Object)businessKey, (String)entityNumber);
                } else if (view instanceof IBillView) {
                    billObj = id != null && this.entityName != null ? BusinessDataServiceHelper.loadSingle((Object)id, (String)this.entityName) : view.getModel().getDataEntity();
                } else if (id != null && this.entityName != null) {
                    billObj = BusinessDataServiceHelper.loadSingle((Object)id, (String)this.entityName);
                }
                if (billObj != null) {
                    DynamicObject procdef;
                    procDefId = this.getProcDefIdByAddressProcess(billObj);
                    if (procDefId == null) {
                        if (WfUtils.isNotEmpty((String)this.getTip())) {
                            view.showTipNotification(this.getTip());
                            return;
                        }
                        view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u6ca1\u6709\u5339\u914d\u7684\u6d41\u7a0b\uff0c\u8bf7\u68c0\u67e5\u542f\u52a8\u6761\u4ef6\u3002", (String)"AbstractViewFlowchart_6", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (WfUtils.isEmpty((String)((String)parameter.getCustomParam("procInstId"))) && (procdef = BusinessDataServiceHelper.loadSingle((Object)procDefId, (String)"wf_processdefinition")) != null && ProcessType.BizFlow.name().equals(procdef.getString("type"))) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u6d41\u4e0d\u652f\u6301\u6d41\u7a0b\u9884\u6d4b\u3002", (String)"AbstractViewFlowchart_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                        return;
                    }
                }
            }
            catch (KDException e) {
                String msg = e.getLocalizedMessage();
                if (msg != null && msg.length() > 0 && '.' == msg.charAt(msg.length() - 1)) {
                    msg = msg.substring(0, msg.length() - 1);
                }
                view.showTipNotification(String.format(ResManager.loadKDString((String)"\u67e5\u770b\u6d41\u7a0b\u56fe\u6709\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002\u539f\u56e0\uff1a%s", (String)"AbstractViewFlowchart_8", (String)"bos-wf-formplugin", (Object[])new Object[0]), msg), Integer.valueOf(3000));
                return;
            }
        }
        if (procDefId == null || procDefId == 0L) {
            if (WfUtils.isEmpty((String)this.getTip())) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5728\u6d41\u7a0b\u4e2d\uff0c\u65e0\u6cd5\u67e5\u770b\u6d41\u7a0b\u56fe\u3002", (String)"AbstractViewFlowchart_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            view.showTipNotification(this.getTip());
            return;
        }
        parameter.setClientParam("procDefId", (Object)String.valueOf(procDefId));
        parameter.setCustomParam("procDefId", (Object)String.valueOf(procDefId));
        if (billObj != null) {
            parameter.setCustomParam("entityname", (Object)billObj.getDataEntityType().getName());
            parameter.setCustomParam("billno", billObj.getPkValue());
            parameter.setCustomParam("parentViewId", (Object)view.getPageId());
        }
        ViewFlowchartUtil.showFlowchart((IFormView)view, (FormShowParameter)parameter, (OpenStyle)style);
    }

    protected boolean setClientParam(FormShowParameter parameter, String value) {
        return true;
    }

    protected String getTip() {
        return this.tip;
    }

    protected void setTip(String tip) {
        this.tip = tip;
    }

    public Object getBillId() {
        return this.billId;
    }

    public void setBillId(Object billId) {
        this.billId = billId;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public String getBillIdField() {
        return this.billIdField;
    }

    public void setBillIdField(String billIdField) {
        this.billIdField = billIdField;
    }

    protected String getMessageFromWFJob(String value) {
        if (this.wfJob == null) {
            Optional wfAddressJob;
            QFilter[] filters = new QFilter[]{new QFilter("businessKey", "=", (Object)value), new QFilter("jobHandlerType", "=", (Object)"address-process-event")};
            String selectFields = String.format("%s,%s,%s,%s", "state", "businessKey", "exceptionMessage", "createDate");
            DynamicObjectCollection wfJobs = QueryServiceHelper.query((String)"wf_job", (String)selectFields, (QFilter[])filters, (String)"createDate desc", (int)1);
            if (WfUtils.isEmptyForCollection((Collection)wfJobs)) {
                wfJobs = QueryServiceHelper.query((String)"wf_historicjobrecord", (String)selectFields, (QFilter[])filters, (String)"createDate desc", (int)1);
            }
            if (!(wfAddressJob = wfJobs.stream().findFirst()).isPresent()) {
                return null;
            }
            this.wfJob = (DynamicObject)wfAddressJob.get();
        }
        if (JobStateEnum.ERRORED.getNumber().equals(this.wfJob.getString("state"))) {
            String desc = ViewFlowChatStatus.ERROR.getDesc();
            return String.format(desc, this.wfJob.getString("businessKey"));
        }
        if (WfUtils.isNotEmpty((String)this.wfJob.getString("exceptionMessage")) && this.wfJob.getString("exceptionMessage").startsWith("no suitable process is found for")) {
            return ViewFlowChatStatus.FAIL.getDesc();
        }
        long time = this.wfJob.getDate("createDate").getTime();
        long now = System.currentTimeMillis();
        if (now - time <= 30000L) {
            return ViewFlowChatStatus.ADDRESSING.getDesc();
        }
        if (JobStateEnum.CREATED.getNumber().equals(this.wfJob.getString("state"))) {
            return ViewFlowChatStatus.CHECK_MQ.getDesc();
        }
        return null;
    }

    protected String getMessageFromBizJob(String entityName, String value) {
        if (this.bizJobEntity == null) {
            JobDAO jobDao;
            List bizJobEntities;
            Optional<JobEntity> bizAddressJob;
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
            String dbRouteKey = null;
            if (entityType != null) {
                dbRouteKey = entityType.getDBRouteKey();
            }
            if (!(bizAddressJob = (bizJobEntities = (jobDao = (JobDAO)TypesContainer.getOrRegisterSingletonInstance((String)JobDAO.class.getName())).findRunningAddressJobByBusinessKey(value, dbRouteKey)).stream().filter(item -> "address-process-event".equals(item.getJobHandlerType())).findFirst()).isPresent()) {
                return null;
            }
            this.bizJobEntity = bizAddressJob.get();
        }
        long time = this.bizJobEntity.getCreateDate().getTime();
        long now = System.currentTimeMillis();
        if (now - time <= 30000L) {
            return ViewFlowChatStatus.ADDRESSING.getDesc();
        }
        return ViewFlowChatStatus.CHECK_MQ.getDesc();
    }

    private boolean isFromMobile(IFormView view) {
        boolean result = false;
        String modelType = view.getFormShowParameter().getFormConfig().getModelType();
        if ("mobilebase".equalsIgnoreCase(modelType) || "mobilebill".equalsIgnoreCase(modelType) || "mobileform".equalsIgnoreCase(modelType) || "mobilelist".equalsIgnoreCase(modelType)) {
            result = true;
        }
        return result;
    }

    private Long getProcDefIdByAddressProcess(DynamicObject billObj) {
        Long procDefId = null;
        try {
            procDefId = this.wfService.getTaskService().addressProcess("submit", billObj);
        }
        catch (Exception e) {
            log.debug(String.format("\u5355\u636e\u672a\u8fdb\u5165\u6d41\u7a0b\u67e5\u770b\u6d41\u7a0b\u56fe\uff0c\u6d41\u7a0b\u5bfb\u5740\u5f02\u5e38\uff0cPkValue:[%s]", billObj.getPkValue()));
        }
        return procDefId;
    }
}

