/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.form.operate.flowchart;

import java.util.Map;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.bill.IBillView;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.form.operate.flowchart.DefaultViewFlowchartOperateImpl;
import kd.bos.workflow.form.operate.flowchart.IViewFlowchartOperate;
import kd.bos.workflow.form.operate.util.OperateForWorkflowUtil;

public abstract class AbstractViewFlowchartOperateImpl
implements IViewFlowchartOperate {
    private Log log = LogFactory.getLog(this.getClass());

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void showFlowchart(IFormView view, String entityNumber, Map<String, Object> params) {
        String businessKey = null;
        if (view instanceof IListView) {
            IListView listView = (IListView)view;
            ListSelectedRowCollection rows = listView.getSelectedRows();
            int size = OperateForWorkflowUtil.getSelectedRowSize(rows);
            if (size != 1) {
                StandardTips.view((IFormView)view).selectMultiRow(size);
                return;
            }
            businessKey = String.valueOf(rows.get(0).getPrimaryKeyValue());
        } else if (view instanceof IBillView) {
            IBillModel billModel = (IBillModel)view.getModel();
            businessKey = String.valueOf(billModel.getPKValue());
        }
        if (businessKey != null) {
            this.showFlowchart(view, entityNumber, businessKey, params);
            return;
        }
        this.log.info("Not Supported View.");
    }

    protected void showDefaultFlowChart(IFormView view, String entityNumber, Map<String, Object> params) {
        new DefaultViewFlowchartOperateImpl().showFlowchart(view, entityNumber, params);
    }

    protected abstract void showFlowchart(IFormView var1, String var2, String var3, Map<String, Object> var4);
}

