/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.form.operate.flowchart;

import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.design.plugin.ViewFlowChartPermComponent;
import kd.bos.workflow.design.plugin.record.ViewFlowChartPermResult;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.form.operate.flowchart.AbstractViewFlowchart;

public class BusinessViewFlowchart
extends AbstractViewFlowchart {
    @Override
    protected boolean setClientParam(FormShowParameter parameter, String value) {
        if (WfUtils.isEmpty((String)value) || "0".equals(value)) {
            return false;
        }
        String entityName = this.getEntityName();
        boolean result = this.setParamByBusinessKey(parameter, entityName, value);
        if (result) {
            return true;
        }
        this.setTipMessage(entityName, value);
        return false;
    }

    private boolean setParamByBusinessKey(FormShowParameter parameter, String entityName, String value) {
        Long procInstId = null;
        QFilter[] hisProcInstfilters = null;
        hisProcInstfilters = WfUtils.isNotEmpty((String)entityName) ? new QFilter[]{new QFilter("businessKey", "=", (Object)value), new QFilter("entitynumber", "=", (Object)entityName)} : new QFilter[]{new QFilter("businessKey", "=", (Object)value)};
        String fields = String.format("%s,%s", "id", "endtype");
        String orderBy = String.format("%s desc", "modifyDate");
        List hisProcEntities = this.wfService.getRepositoryService().findEntitiesByFilters("wf_hiprocinst", hisProcInstfilters, fields, orderBy);
        if (WfUtils.isNotEmptyForCollection((Collection)hisProcEntities)) {
            boolean isAllWithdraw = true;
            for (HistoricProcessInstanceEntity hisProcInstEntity : hisProcEntities) {
                if ("20".equals(hisProcInstEntity.getEndType())) continue;
                isAllWithdraw = false;
                procInstId = hisProcInstEntity.getId();
                break;
            }
            if (isAllWithdraw) {
                return false;
            }
        }
        if (WfUtils.isEmpty(procInstId)) {
            procInstId = this.getProcInstIdFromBizMount(entityName, value);
        }
        if (WfUtils.isEmpty(procInstId)) {
            return false;
        }
        ViewFlowChartPermComponent permComponent = new ViewFlowChartPermComponent();
        ViewFlowChartPermResult res = permComponent.initHasPermInstanceList(procInstId);
        if (StringUtils.isNotEmpty((CharSequence)res.getPlugin())) {
            parameter.setClientParam("procInstId", (Object)String.valueOf(res.getTargetId()));
            parameter.setCustomParam("procInstId", (Object)String.valueOf(res.getTargetId()));
            List<Long> hasPermInstanceList = res.getHasPermInstanceList();
            String join = Joiner.on((String)",").join(hasPermInstanceList);
            parameter.setCustomParam("hasPermProcessInstanceList", (Object)join);
            parameter.setCustomParam("permPlugin", (Object)res.getPlugin());
        } else {
            parameter.setClientParam("procInstId", (Object)String.valueOf(procInstId));
            parameter.setCustomParam("procInstId", (Object)String.valueOf(procInstId));
        }
        parameter.setCustomParam("billId", (Object)value);
        parameter.setCustomParam("entityName", (Object)entityName);
        return true;
    }

    private Long getProcInstIdFromBizMount(String entityName, String value) {
        return this.wfService.getHistoryService().getProcInstIdFromHistoricActivityByBusinessKey(entityName, value);
    }

    private void setTipMessage(String entityName, String value) {
        if (WfUtils.isEmpty((String)entityName)) {
            return;
        }
        String message = this.getMessageFromWFJob(value);
        if (this.wfJob != null) {
            this.setTip(message);
            return;
        }
        message = this.getMessageFromBizJob(entityName, value);
        if (WfUtils.isNotEmpty((String)message)) {
            this.setTip(message);
        }
    }
}

