/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.form.operate.util;

import java.util.HashSet;
import java.util.List;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.list.IListView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.msg.ArchiveRouteIndexCondition;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.archive.ArchiveFormService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class OperateForWorkflowUtil {
    public static Object getSelectedRowId(IFormView view) {
        Object rowId = null;
        if (view instanceof IListView) {
            IListView listView = (IListView)view;
            ListSelectedRowCollection rows = listView.getSelectedRows();
            int size = OperateForWorkflowUtil.getSelectedRowSize(rows);
            if (size != 1) {
                return null;
            }
            ListSelectedRow selectedRow = rows.get(0);
            if (null == selectedRow) {
                return null;
            }
            rowId = selectedRow.getPrimaryKeyValue();
        } else if (view instanceof IBillView) {
            IBillModel billModel = (IBillModel)view.getModel();
            rowId = billModel.getPKValue();
        }
        return rowId;
    }

    public static Object getRealBillId(Object selectedRowId, String entityName, String billIdField) {
        if (WfUtils.isEmpty((String)billIdField) || WfUtils.isEmpty((String)entityName)) {
            return selectedRowId;
        }
        DynamicObject dynObj = BusinessDataServiceHelper.loadSingle((Object)selectedRowId, (String)entityName, (String)billIdField);
        if (null == dynObj) {
            return selectedRowId;
        }
        return dynObj.get(billIdField);
    }

    public static int getSelectedRowSize(ListSelectedRowCollection rows) {
        if (rows == null || rows.isEmpty()) {
            return 0;
        }
        if (rows.size() == 1) {
            return 1;
        }
        HashSet<Object> ids = new HashSet<Object>(rows.size());
        for (ListSelectedRow row : rows) {
            if (null == row) continue;
            ids.add(row.getPrimaryKeyValue());
        }
        return ids.size();
    }

    public static FormShowParameter getApprovalRecordOpParameter(String businessKey, String entityNumber, IFormView view) {
        ArchiveFormService archiveFormService = ArchiveFormService.create();
        ArchiveRouteIndexCondition condition = new ArchiveRouteIndexCondition("businessKey", (Object)businessKey);
        archiveFormService.injectArchiveRouteInfo(view, "wf_hiprocinst", condition);
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        TaskService taskService = wfService.getTaskService();
        List entities = taskService.getParentProcessInstanceInfo(businessKey, entityNumber, "id", null, true);
        if (null == entities || entities.isEmpty()) {
            return null;
        }
        List approvalRecordGroups = taskService.queryApprovalRecord(businessKey, entityNumber, true, entities);
        if (null == approvalRecordGroups || approvalRecordGroups.isEmpty()) {
            return null;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("wf_viewapprovalrecord");
        parameter.setCustomParam("businessKey", (Object)businessKey);
        parameter.setCustomParam("entityNumber", (Object)entityNumber);
        parameter.setCustomParam("processInstanceCount", (Object)entities.size());
        parameter.setCustomParam("approvalRecordGroups", (Object)approvalRecordGroups);
        archiveFormService.setArchiveRouteInfo(view, parameter);
        return parameter;
    }
}

