/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.management.plugin;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.AdvContainer;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.design.util.BillSubjectUtil;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.design.util.ProcessInstancePluginUtil;
import kd.bos.workflow.engine.BillPagePluginUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.impl.persistence.entity.management.BillSubjectModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.BillSubjectModelEntityImpl;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class BillFlowAttrSettingsPlugin
extends AbstractListPlugin
implements IConfirmCallBack {
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected static final String ENTRA_BILL_NAME = "entrabillname";
    private static final String CUSTOMSUBJECT = "customsubject";
    private static final String SV_CUSTOMSUBJECT = "sv_customsubject";
    private static final String BTN_OK = "btnok";
    private static final String BTN_CANCEL = "btncancel";
    private static final String SAMPLE = "sample";
    private static final String PC_PAGE_COMBO = "pcpagecombo";
    private static final String MOB_PAGE_COMBO = "mobpagecombo";
    private static final String CUSTOMSUBJECT_MOB = "customsubject_mob";
    private static final String SV_CUSTOMSUBJECT_MOB = "sv_customsubject_mob";
    private static final String SAMPLE_MOB = "sample_mob";
    private static final String MAINFIELD_COMBO = "mainfield";
    private static final String BUSINESSFIELDMAPPINGINFO = "businessfieldmapping";
    private static final String APPROVAL_RECORD_PLUGIN = "approvalrecordplugin";
    private static final String APPROVAL_RECORD_PLUGIN_VAL = "approvalrecordpluginval";
    private static final String APPROVAL_RECORD_PLUGIN_CALLBACK = "approvalrecordplugincallback";
    private static final String VIEW_CHAT_FLOW_PERM_PLUGIN = "viewchatflowpermplugin";
    private static final String VIEW_CHAT_FLOW_PERM_PLUGIN_VAL = "viewchatflowpermpluginval";
    private static final String VIEW_CHAT_FLOW_PERM_PLUGIN_CALLBACK = "viewchatflowpermplugincallback";
    private static final String TYPE_UPDATE = "update";
    protected static final String ENTRA_BILL_ID = "entrabillid";
    protected static final String ENTRA_BILL_NUMBER = "entrabillnumber";
    private static final String ISINSERT = "isInsert";
    private static final String SPLITCHAR = "_split_";
    private static final String SAVEPERMISSION = "0=KX5+QVF5+R";
    private static final String REFERORGANIZATION = "referorganization";
    private static final String MAPPINGFIELD_UPDATETYPE_REMOVE = "remove";
    private static final String MAPPINGFIELD_UPDATETYPE_ADD = "add";
    private static final String MAPPINGFIELD_UPDATETYPE_UPDATETYPE = "updateType";
    private static final String STR_WFTASK = "wf_task";
    private static final String STR_WFHITASK = "wf_hitaskinst";
    private static final String TASK_MOVEFIIELD = "move_wf_task";
    private static final String HITASK_MOVEFIELD = "move_wf_hitaskinst";

    public void initialize() {
        this.addClickListeners(new String[]{ENTRA_BILL_NAME, SV_CUSTOMSUBJECT, PC_PAGE_COMBO, BTN_OK, BTN_CANCEL, SV_CUSTOMSUBJECT_MOB, MAINFIELD_COMBO, MOB_PAGE_COMBO, BUSINESSFIELDMAPPINGINFO, APPROVAL_RECORD_PLUGIN, VIEW_CHAT_FLOW_PERM_PLUGIN});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String type = (String)customParams.get("type");
        Boolean isInsert = Boolean.TRUE;
        if (TYPE_UPDATE.equals(type)) {
            String pkId = (String)customParams.get("pkId");
            try {
                BillSubjectModelEntity entity = this.getWFService().getRepositoryService().findBillSubjectByPkid(pkId);
                this.setPageData(entity);
                this.setReferOrganizationCombo(entity);
                this.getModel().setValue(ENTRA_BILL_NAME, (Object)entity.getBillName());
                this.getView().setEnable(Boolean.FALSE, new String[]{ENTRA_BILL_NAME});
                isInsert = Boolean.FALSE;
            }
            catch (KDException ex) {
                if (WFErrorCode.workflowEngineNotConfiguration().equals((Object)ex.getErrorCode())) {
                    this.getView().showMessage(ex.getMessage());
                }
                if (WFErrorCode.metaNotFoundError().equals((Object)ex.getErrorCode()) || WFErrorCode.entityMetaDataNotExistError().equals((Object)ex.getErrorCode())) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u6d41\u7a0b\u5c5e\u6027\u8bbe\u7f6e\u6253\u5f00\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"BillFlowAttrSettingsPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]), ex.getMessage()));
                }
                throw ex;
            }
        }
        AdvContainer subjectDesc = (AdvContainer)this.getView().getControl("subjectdesc");
        subjectDesc.setCollapse(false);
        AdvContainer otherDesc = (AdvContainer)this.getView().getControl("otherdesc");
        otherDesc.setCollapse(false);
        this.getPageCache().put(ISINSERT, isInsert.toString());
    }

    protected void setPageData(BillSubjectModelEntity entity) {
        String entityId = entity.getBillId();
        String entityNumber = entity.getEntityNumber();
        String formKey = entity.getFormKey();
        String mobileFormKey = entity.getMobileFormKey();
        HashMap<String, Object> evtData = new HashMap<String, Object>();
        evtData.put("id", entityId);
        evtData.put("number", entityNumber);
        this.setEntryInfoCache(evtData);
        this.setBillSubjectInfo(entity);
        this.showComboData(entityId, entityNumber, formKey, mobileFormKey);
        this.showComboMainFieldData(entity.getEntityNumber(), entity.getMainField());
        this.getPageCache().put("businessfieldmappingold", entity.getBusinessFieldMappingInfo());
        this.setBusinessFieldMappingInfoData(entity.getBusinessFieldMappingInfo());
        this.setViewChatFlowPermPlugin(entity.getViewChatFlowPermPlugin());
        this.setApprovalRecordPlugin(entity.getFilterApprovalRecordPlugin());
    }

    private void setBusinessFieldMappingInfoData(Object businessFieldMappingInfo) {
        if (StringUtils.isNotBlank((Object)businessFieldMappingInfo)) {
            String businessFieldMappingInfoStr = businessFieldMappingInfo instanceof List ? SerializationUtils.toJsonString((Object)((List)businessFieldMappingInfo)) : (String)businessFieldMappingInfo;
            this.getModel().setValue(BUSINESSFIELDMAPPINGINFO, (Object)businessFieldMappingInfoStr);
            this.getPageCache().put(BUSINESSFIELDMAPPINGINFO, businessFieldMappingInfoStr);
        }
    }

    private void showBusinessFieldMapping() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_businessfieldmapping");
        String entityName = (String)this.getModel().getValue(ENTRA_BILL_NAME);
        if (WfUtils.isEmpty((String)entityName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b9e\u4f53\u540d\u79f0\u3002", (String)"BillFlowAttrSettingsPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        parameter.setCustomParam(ENTRA_BILL_ID, (Object)this.getPageCache().get(ENTRA_BILL_ID));
        parameter.setCustomParam(ENTRA_BILL_NUMBER, (Object)this.getPageCache().get(ENTRA_BILL_NUMBER));
        parameter.setCustomParam(BUSINESSFIELDMAPPINGINFO, (Object)this.getPageCache().get(BUSINESSFIELDMAPPINGINFO));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BUSINESSFIELDMAPPINGINFO));
        this.getView().showForm(parameter);
    }

    private void setEntryInfoCache(Map<String, Object> evtData) {
        this.getPageCache().put(ENTRA_BILL_ID, evtData.get("id").toString());
        this.getPageCache().put(ENTRA_BILL_NUMBER, evtData.get("number").toString());
    }

    private void setBillSubjectInfo(BillSubjectModelEntity entity) {
        this.setBillSubjectInfoForPC(entity);
        this.setBillSubjectInfoForMOB(entity);
    }

    private void setBillSubjectInfoForPC(BillSubjectModelEntity entity) {
        block7: {
            String entityId = entity.getBillId();
            ILocaleString billSubjectName = entity.getBillSubjectName();
            ILocaleString billSubject = entity.getBillSubject();
            if (billSubjectName != null && WfUtils.isNotEmpty((String)billSubjectName.toString())) {
                this.getModel().setValue(SV_CUSTOMSUBJECT, (Object)billSubjectName.toString());
                if (billSubject != null) {
                    String billSubjectLocale = billSubject.toString();
                    this.getModel().setValue(CUSTOMSUBJECT, (Object)billSubjectLocale);
                    try {
                        if (!WfUtils.isNotEmpty((String)billSubjectLocale)) break block7;
                        JSONArray billSubjectArray = (JSONArray)SerializationUtils.fromJsonString((String)billSubjectLocale, JSONArray.class);
                        for (Object object : billSubjectArray) {
                            if (object == null) continue;
                            String type = (String)((HashMap)object).get("type");
                            String customSubject = (String)((HashMap)object).get("customSubject");
                            if (!"expression".equals(type) || !WfUtils.isNotEmpty((String)customSubject)) continue;
                            this.getModel().setValue(SAMPLE, (Object)BillSubjectUtil.getSample(entityId, customSubject, this.getFieldMap(entityId), this.getTreeRoot(entityId), null));
                            break;
                        }
                    }
                    catch (Exception e) {
                        try {
                            this.getModel().setValue(SAMPLE, (Object)BillSubjectUtil.getSample(entityId, billSubjectLocale, this.getFieldMap(entityId), this.getTreeRoot(entityId), null));
                        }
                        catch (Exception e1) {
                            this.logger.error(WfUtils.getExceptionStacktrace((Throwable)e1));
                        }
                    }
                }
            }
        }
    }

    private void setBillSubjectInfoForMOB(BillSubjectModelEntity entity) {
        String entityId = entity.getBillId();
        ILocaleString billSubjectMobName = entity.getBillSubjectMobName();
        ILocaleString billSubjectMob = entity.getBillSubjectMob();
        if (billSubjectMobName != null && WfUtils.isNotEmpty((String)billSubjectMobName.toString())) {
            this.getModel().setValue(SV_CUSTOMSUBJECT_MOB, (Object)billSubjectMobName.toString());
            if (billSubjectMob != null) {
                String billSubjectMobLocale = billSubjectMob.toString();
                this.getModel().setValue(CUSTOMSUBJECT_MOB, (Object)billSubjectMobLocale);
                try {
                    JSONArray billSubjectMobArray = (JSONArray)SerializationUtils.fromJsonString((String)billSubjectMobLocale, JSONArray.class);
                    for (Object object : billSubjectMobArray) {
                        if (object == null) continue;
                        String type = (String)((HashMap)object).get("type");
                        String customSubject = (String)((HashMap)object).get("customSubject");
                        if (!"expression".equals(type) || !WfUtils.isNotEmpty((String)customSubject)) continue;
                        this.getModel().setValue(SAMPLE_MOB, (Object)BillSubjectUtil.getSample(entityId, customSubject, this.getFieldMap(entityId), this.getTreeRoot(entityId), null));
                        break;
                    }
                }
                catch (Exception e) {
                    try {
                        this.getModel().setValue(SAMPLE_MOB, (Object)BillSubjectUtil.getSample(entityId, billSubjectMobLocale, this.getFieldMap(entityId), this.getTreeRoot(entityId), null));
                    }
                    catch (Exception e1) {
                        this.logger.error(WfUtils.getExceptionStacktrace((Throwable)e1));
                    }
                }
            }
        }
    }

    private void showComboData(String entityId, String entityNumber, String formKey, String mobileFormKey) {
        List<Map<String, Object>> items = this.getComboData(entityId, "BillFormModel");
        this.showFinalComboData(formKey, items, PC_PAGE_COMBO);
        List itemsForMob = BillPagePluginUtil.getBillPagesForMob(items, (String)entityId, (boolean)true, (String)entityNumber, (String)mobileFormKey);
        this.showFinalComboData(mobileFormKey, itemsForMob, MOB_PAGE_COMBO);
    }

    private List<Map<String, Object>> getComboData(String entityId, String formModel) {
        return this.getWFService().getManagementService().getBillPageByType(entityId, formModel);
    }

    private ILocaleString getBillPageMulLanNameByType(String entityId, String formModel, String number) {
        return BillPagePluginUtil.getBillPageMulLanNameByType((String)entityId, (String)formModel, (String)number);
    }

    private void showFinalComboData(String formKey, List<Map<String, Object>> items, String comboName) {
        if (items.isEmpty()) {
            return;
        }
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(items.size());
        ComboItem comboItem = null;
        LocaleString localeString = null;
        String selectValue = "";
        String selectName = "";
        selectValue = WfUtils.isEmpty((String)formKey) ? (String)items.get(0).get("id") : formKey;
        for (Map<String, Object> map : items) {
            if (WfUtils.isEmpty((String)selectName) && selectValue.equals(map.get("id"))) {
                selectName = (String)map.get("name");
            }
            comboItem = new ComboItem();
            localeString = new LocaleString();
            localeString.setLocaleValue((String)map.get("name"));
            comboItem.setCaption(localeString);
            comboItem.setValue((String)map.get("id") + SPLITCHAR + (String)map.get("name"));
            comboItems.add(comboItem);
        }
        ComboEdit operation = (ComboEdit)this.getControl(comboName);
        operation.setComboItems(comboItems);
        this.getView().getModel().setValue(comboName, (Object)(selectValue + SPLITCHAR + selectName));
    }

    private void billChanged() {
        IDataModel model = this.getModel();
        model.setValue(CUSTOMSUBJECT, null);
        model.setValue(SV_CUSTOMSUBJECT, null);
        model.setValue(CUSTOMSUBJECT_MOB, null);
        model.setValue(SV_CUSTOMSUBJECT_MOB, null);
        model.setValue(SAMPLE, null);
        model.setValue(SAMPLE_MOB, null);
        model.setValue(MAINFIELD_COMBO, null);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        String formId = null;
        boolean isinsert = Boolean.parseBoolean(this.getPageCache().get(ISINSERT));
        switch (key) {
            case "entrabillname": {
                if (!isinsert) break;
                DesignerModelUtil.openSelectEntitiesPage(this.getView(), (IFormPlugin)this, key);
                break;
            }
            case "sv_customsubject": 
            case "sv_customsubject_mob": {
                formId = "wf_tasksubject";
                this.showPageByFormId(formId, key);
                break;
            }
            case "btnok": {
                this.showSubmitFunc();
                break;
            }
            case "btncancel": {
                this.showCancelFunc();
                break;
            }
            case "businessfieldmapping": {
                this.showBusinessFieldMapping();
                break;
            }
            case "approvalrecordplugin": {
                this.showApprovalRecordPlugin();
                break;
            }
            case "viewchatflowpermplugin": {
                this.showViewChatFlowPermPlugin();
                break;
            }
        }
    }

    private void showPageByFormId(String formId, String key) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId(formId);
        parameter.setShowTitle(false);
        if ("wf_tasksubject".equals(formId)) {
            String entityName = (String)this.getModel().getValue(ENTRA_BILL_NAME);
            if (WfUtils.isEmpty((String)entityName)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b9e\u4f53\u540d\u79f0\u3002", (String)"BillFlowAttrSettingsPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            parameter.setCustomParam("openType", (Object)"billAttribute");
            parameter.setCustomParam("entityId", (Object)this.getPageCache().get(ENTRA_BILL_ID));
            parameter.setCustomParam("entityNumber", (Object)this.getPageCache().get(ENTRA_BILL_NUMBER));
            if (SV_CUSTOMSUBJECT.equals(key)) {
                parameter.setCustomParam("value", this.getModel().getValue(CUSTOMSUBJECT));
                parameter.setCustomParam("subjecttype", (Object)CUSTOMSUBJECT);
            } else {
                parameter.setCustomParam("value", this.getModel().getValue(CUSTOMSUBJECT_MOB));
                parameter.setCustomParam("subjecttype", (Object)CUSTOMSUBJECT_MOB);
            }
            parameter.setShowTitle(true);
            if (SV_CUSTOMSUBJECT_MOB.equals(key)) {
                String title = ResManager.loadKDString((String)"\u79fb\u52a8\u5ba1\u6279\u9875\u9762\u4efb\u52a1\u4e3b\u9898", (String)"BillFlowAttrSettingsPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                parameter.setCustomParam("title", (Object)title);
                parameter.setCaption(title);
            }
        }
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        this.getView().showForm(parameter);
    }

    private void showApprovalRecordPlugin() {
        String entityId = this.getPageCache().get(ENTRA_BILL_ID);
        String pluginValue = (String)this.getModel().getValue(APPROVAL_RECORD_PLUGIN_VAL);
        String types = ExternalInterfaceUtil.getTypes((String[])new String[]{"class"});
        IFormView view = this.getView();
        view.getFormShowParameter().setCustomParam("hideParameterConfig", (Object)Boolean.TRUE);
        DesignerPluginUtil.openExternalInterface(view, (IFormPlugin)this, types, entityId, pluginValue, true, APPROVAL_RECORD_PLUGIN_CALLBACK);
    }

    private void setApprovalRecordPlugin(String plugin) {
        if (ExternalInterfaceUtil.isValidValue((String)plugin)) {
            this.getModel().setValue(APPROVAL_RECORD_PLUGIN, (Object)ExternalInterfaceUtil.getFormattedShowValue((String)plugin));
            this.getModel().setValue(APPROVAL_RECORD_PLUGIN_VAL, (Object)plugin);
        }
    }

    private void showViewChatFlowPermPlugin() {
        String entityId = this.getPageCache().get(ENTRA_BILL_ID);
        String pluginValue = (String)this.getModel().getValue(VIEW_CHAT_FLOW_PERM_PLUGIN_VAL);
        String types = ExternalInterfaceUtil.getTypes((String[])new String[]{"class"});
        IFormView view = this.getView();
        view.getFormShowParameter().setCustomParam("hideParameterConfig", (Object)Boolean.TRUE);
        DesignerPluginUtil.openExternalInterface(view, (IFormPlugin)this, types, entityId, pluginValue, true, VIEW_CHAT_FLOW_PERM_PLUGIN_CALLBACK);
    }

    private void setViewChatFlowPermPlugin(String plugin) {
        if (ExternalInterfaceUtil.isValidValue((String)plugin)) {
            this.getModel().setValue(VIEW_CHAT_FLOW_PERM_PLUGIN, (Object)ExternalInterfaceUtil.getFormattedShowValue((String)plugin));
            this.getModel().setValue(VIEW_CHAT_FLOW_PERM_PLUGIN_VAL, (Object)plugin);
        }
    }

    private void showSubmitFunc() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)"wf_billsubjectmodel", (String)SAVEPERMISSION)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u4fdd\u5b58\u201d\u7684\u6743\u9650\u3002", (String)"WorkflowDesignerIDEPlugin_21", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean isinsert = Boolean.parseBoolean(this.getPageCache().get(ISINSERT));
        if (isinsert) {
            BillSubjectModelEntity entity = this.setBillSubjectModelEntityData(null);
            if (null == entity) {
                return;
            }
            this.getWFService().getRepositoryService().saveBillSubject(entity);
            WfUtils.addOpLogByAppId((String)this.getView().getFormShowParameter().getAppId(), (String)"wf_billsubjectmodel", (String)"btninsert", (MultiLangEnumBridge)new MultiLangEnumBridge("\u65b0\u589e", "BillFlowAttrSettingsPlugin_10", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5355\u636e\u4e3b\u9898,\u5355\u636e\u4e3b\u9898Id:[%s]", "BillSubjectCmd_2", "bos-wf-engine"), (Object[])new Object[]{entity.getId()});
        } else {
            String billId = this.getPageCache().get(ENTRA_BILL_ID);
            BillSubjectModelEntity entity = this.getWFService().getRepositoryService().findBillSubject(billId);
            if (null == (entity = this.setBillSubjectModelEntityData(entity))) {
                return;
            }
            this.getWFService().getRepositoryService().updateBillSubject(entity);
            WfUtils.addOpLogByAppId((String)this.getView().getFormShowParameter().getAppId(), (String)"wf_billsubjectmodel", (String)TYPE_UPDATE, (MultiLangEnumBridge)new MultiLangEnumBridge("\u66f4\u65b0", "BillFlowAttrSettingsPlugin_11", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u66f4\u65b0\u5355\u636e\u4e3b\u9898\uff0c\u5355\u636e\u4e3b\u9898ID\uff1a\u201c%s\u201d\u3002", "BillSubjectUpdateCmd_2", "bos-wf-formplugin"), (Object[])new Object[]{entity.getId()});
        }
        this.dealBusinessFieldMapping();
        this.showCancelFunc();
    }

    private void dealBusinessFieldMapping() {
        String entityNumber = this.getPageCache().get(ENTRA_BILL_NUMBER);
        Map<String, Object> resultMap = this.checkIsNeedUpdateBusinessMappingInfoOfConfCenter();
        if (resultMap.isEmpty()) {
            return;
        }
        try (TXHandle tx = TX.requiresNew();){
            this.updateBusinessConfCenter(entityNumber, resultMap);
        }
    }

    private void updateBusinessConfCenter(String entityNumber, Map<String, Object> resultMap) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"wf_confcenter", (String)"value", (QFilter[])new QFilter[]{new QFilter("key", "=", (Object)"workflow.task.needUpdateExtFieldEntitynumbers")});
        if (dynamicObject != null) {
            String value = dynamicObject.getString("value");
            Map map = (Map)Optional.ofNullable(SerializationUtils.fromJsonString((String)value, Map.class)).orElseGet(HashMap::new);
            if (MAPPINGFIELD_UPDATETYPE_REMOVE.equals(resultMap.get(MAPPINGFIELD_UPDATETYPE_UPDATETYPE))) {
                map.remove(entityNumber);
            } else {
                Object entityObj = map.get(entityNumber);
                if (entityObj instanceof Map) {
                    Map entityMap = (Map)entityObj;
                    resultMap.entrySet().forEach(entry -> {
                        String scopeKey = (String)entry.getKey();
                        if (MAPPINGFIELD_UPDATETYPE_UPDATETYPE.equals(scopeKey)) {
                            return;
                        }
                        if (TASK_MOVEFIIELD.equals(scopeKey) && entityMap.get(STR_WFTASK) != null) {
                            Map scopeMap = (Map)entityMap.get(STR_WFTASK);
                            ((Map)entry.getValue()).forEach((x, y) -> scopeMap.remove(x));
                            if (scopeMap.isEmpty()) {
                                entityMap.remove(STR_WFTASK);
                            }
                        } else if (HITASK_MOVEFIELD.equals(scopeKey) && entityMap.get(STR_WFHITASK) != null) {
                            Map scopeMap = (Map)entityMap.get(STR_WFHITASK);
                            ((Map)entry.getValue()).forEach((x, y) -> scopeMap.remove(x));
                            if (scopeMap.isEmpty()) {
                                entityMap.remove(STR_WFHITASK);
                            }
                        } else if (STR_WFTASK.equals(scopeKey) || STR_WFHITASK.equals(scopeKey)) {
                            Map scopeMap = (Map)Optional.ofNullable(entityMap.get(scopeKey)).orElseGet(HashMap::new);
                            scopeMap.putAll((Map)entry.getValue());
                            entityMap.put(scopeKey, scopeMap);
                        }
                    });
                    if (entityMap.isEmpty()) {
                        map.remove(entityNumber);
                    }
                } else {
                    HashMap entityMap = new HashMap(1);
                    resultMap.entrySet().stream().filter(entry -> STR_WFTASK.equals(entry.getKey()) || STR_WFHITASK.equals(entry.getKey())).forEach(entry -> entityMap.put(entry.getKey(), entry.getValue()));
                    map.put(entityNumber, entityMap);
                }
                dynamicObject.set("value", (Object)SerializationUtils.toJsonString((Object)map));
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
            }
        } else if (MAPPINGFIELD_UPDATETYPE_ADD.equals(resultMap.get(MAPPINGFIELD_UPDATETYPE_UPDATETYPE))) {
            HashMap map = new HashMap(1);
            HashMap entityMap = new HashMap(1);
            resultMap.entrySet().stream().filter(entry -> STR_WFTASK.equals(entry.getKey()) || STR_WFHITASK.equals(entry.getKey())).forEach(entry -> entityMap.put(entry.getKey(), entry.getValue()));
            if (!entityMap.isEmpty()) {
                map.put(entityNumber, entityMap);
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"wf_confcenter");
                dynamicObject = new DynamicObject((DynamicObjectType)dataEntityType);
                dynamicObject.set("type", (Object)"global");
                dynamicObject.set("key", (Object)"workflow.task.needUpdateExtFieldEntitynumbers");
                dynamicObject.set("value", (Object)SerializationUtils.toJsonString(map));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            }
        }
    }

    private void showCancelFunc() {
        this.deletePageCache();
        this.getView().close();
    }

    protected BillSubjectModelEntity setBillSubjectModelEntityData(BillSubjectModelEntity entity) {
        String entraBillName = (String)this.getModel().getValue(ENTRA_BILL_NAME);
        String svCustomSubject = (String)this.getModel().getValue(SV_CUSTOMSUBJECT);
        String customSubject = (String)this.getModel().getValue(CUSTOMSUBJECT);
        String svCustomSubjectMob = (String)this.getModel().getValue(SV_CUSTOMSUBJECT_MOB);
        String customSubjectMob = (String)this.getModel().getValue(CUSTOMSUBJECT_MOB);
        String mainField = (String)this.getModel().getValue(MAINFIELD_COMBO);
        String referOrganization = (String)this.getModel().getValue(REFERORGANIZATION);
        String msg = this.validate(entraBillName, svCustomSubject);
        String businessFieldMapping = (String)this.getModel().getValue(BUSINESSFIELDMAPPINGINFO);
        String viewChatFlowPermPlugin = (String)this.getModel().getValue(VIEW_CHAT_FLOW_PERM_PLUGIN_VAL);
        String approvalRecordPlugin = (String)this.getModel().getValue(APPROVAL_RECORD_PLUGIN_VAL);
        if (msg != null) {
            this.getView().showTipNotification(msg);
            return null;
        }
        String formKeyValue = (String)this.getModel().getValue(PC_PAGE_COMBO);
        String formKey = null;
        String formKeyName = null;
        if (!WfUtils.isEmpty((String)formKeyValue) && 2 == formKeyValue.split(SPLITCHAR).length) {
            formKey = formKeyValue.split(SPLITCHAR)[0];
            formKeyName = formKeyValue.split(SPLITCHAR)[1];
        }
        String mobileFormKeyValue = (String)this.getModel().getValue(MOB_PAGE_COMBO);
        String mobileFormKey = null;
        String mobileFormKeyName = null;
        if (!WfUtils.isEmpty((String)mobileFormKeyValue) && 2 == mobileFormKeyValue.split(SPLITCHAR).length) {
            mobileFormKey = mobileFormKeyValue.split(SPLITCHAR)[0];
            mobileFormKeyName = mobileFormKeyValue.split(SPLITCHAR)[1];
        }
        Object returnEntity = null;
        returnEntity = null == entity ? new BillSubjectModelEntityImpl() : entity;
        String billId = this.getPageCache().get(ENTRA_BILL_ID);
        returnEntity.setBillId(billId);
        String entityNumber = this.getPageCache().get(ENTRA_BILL_NUMBER);
        returnEntity.setBillName((ILocaleString)WfUtils.getEntityName((String)entityNumber, (String)billId));
        DynamicObject dynamicObject = returnEntity.getDynamicObject();
        WfMultiLangUtils.mergeCurLan2Entity((DynamicObject)dynamicObject, (String)"subjectShowname", (String)svCustomSubject);
        WfMultiLangUtils.mergeCurLan2Entity((DynamicObject)dynamicObject, (String)"billSubject", (String)customSubject);
        returnEntity.setEntityNumber(entityNumber);
        returnEntity.setFormKey(formKey);
        ILocaleString name = this.getBillPageMulLanNameByType(billId, "BillFormModel", formKey);
        if (WfUtils.isNotEmpty((ILocaleString)name)) {
            name.entrySet().forEach(t -> t.setValue(WfUtils.subStringForMax((String)((String)t.getValue()), (int)255)));
            returnEntity.setFormKeyName(name);
        }
        returnEntity.setMobileFormKey(mobileFormKey);
        ILocaleString mobName = BillPagePluginUtil.getBillPageMulLanNameByTypeForMob((ILocaleString)name, (String)billId, (String)entityNumber, (String)mobileFormKey);
        if (WfUtils.isNotEmpty((ILocaleString)mobName)) {
            mobName.entrySet().forEach(t -> t.setValue(WfUtils.subStringForMax((String)((String)t.getValue()), (int)255)));
            returnEntity.setMobileFormKeyName(mobName);
        }
        WfMultiLangUtils.mergeCurLan2Entity((DynamicObject)dynamicObject, (String)"billSubjectMobName", (String)svCustomSubjectMob);
        WfMultiLangUtils.mergeCurLan2Entity((DynamicObject)dynamicObject, (String)"billSubjectMob", (String)customSubjectMob);
        returnEntity.setMainField(mainField);
        returnEntity.setReferOrganization(referOrganization);
        returnEntity.setBusinessFieldMappingInfo(businessFieldMapping);
        returnEntity.setViewChatFlowPermPlugin(viewChatFlowPermPlugin);
        returnEntity.setFilterApprovalRecordPlugin(approvalRecordPlugin);
        return returnEntity;
    }

    protected String validate(String entraBillName, String svCustomSubject) {
        if (WfUtils.isEmpty((String)entraBillName)) {
            return ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5b9e\u4f53\u540d\u79f0\u201d\u3002", (String)"BillFlowAttrSettingsPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        if (WfUtils.isEmpty((String)svCustomSubject)) {
            return ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6d41\u7a0b\u4efb\u52a1\u4e3b\u9898\u201d\u3002", (String)"BillFlowAttrSettingsPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (evt.getReturnData() instanceof Map) {
            String actionId;
            Map evtData = (Map)evt.getReturnData();
            switch (actionId = evt.getActionId()) {
                case "entrabillname": {
                    String entraBillId = this.getPageCache().get(ENTRA_BILL_ID);
                    if (entraBillId != null && !entraBillId.equals(evtData.get("id"))) {
                        this.billChanged();
                    }
                    this.setPageDataByEntraBill(evtData);
                    break;
                }
                case "sv_customsubject": 
                case "sv_customsubject_mob": {
                    Map billSubject;
                    List billSubjectList;
                    String entityId = this.getPageCache().get(ENTRA_BILL_ID);
                    String sampleEvtData = (String)evtData.get(SAMPLE);
                    HashMap<String, String> sampleMap = new HashMap<String, String>();
                    sampleMap.put(SAMPLE, sampleEvtData);
                    String sample = BillSubjectUtil.getSample(entityId, sampleEvtData, this.getFieldMap(entityId), this.getTreeRoot(entityId), sampleMap);
                    String billSubjectName = (String)evtData.get("subjectShowname");
                    if (WfUtils.isEmpty((String)billSubjectName) && (billSubjectList = (List)evtData.get("billSubject")) != null && !billSubjectList.isEmpty()) {
                        billSubject = (Map)billSubjectList.get(0);
                        billSubjectName = String.valueOf(billSubject.get("customSubject"));
                    }
                    this.getModel().setValue(actionId, (Object)billSubjectName);
                    String keyWord = CUSTOMSUBJECT;
                    if (SV_CUSTOMSUBJECT.equals(actionId)) {
                        this.getModel().setValue(SAMPLE, (Object)sample);
                    } else {
                        keyWord = CUSTOMSUBJECT_MOB;
                        this.getModel().setValue(SAMPLE_MOB, (Object)sample);
                    }
                    billSubject = evtData.get("billSubject");
                    if (billSubject != null) {
                        this.getModel().setValue(keyWord, (Object)SerializationUtils.toJsonString((Object)billSubject));
                        break;
                    }
                    this.getModel().setValue(keyWord, null);
                    break;
                }
                case "businessfieldmapping": {
                    List mappingInfo = (List)evtData.get(BUSINESSFIELDMAPPINGINFO);
                    this.setBusinessFieldMappingInfoData(mappingInfo);
                    break;
                }
            }
        }
        if (evt.getReturnData() instanceof String) {
            switch (evt.getActionId()) {
                case "approvalrecordplugincallback": {
                    this.setApprovalRecordPlugin(evt.getReturnData() + "");
                    break;
                }
                case "viewchatflowpermplugincallback": {
                    this.setViewChatFlowPermPlugin(evt.getReturnData() + "");
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyKey;
        switch (propertyKey = e.getProperty().getName()) {
            case "businessfieldmapping": {
                if (!StringUtils.isBlank((Object)e.getChangeSet()[0].getNewValue())) break;
                this.getPageCache().put(BUSINESSFIELDMAPPINGINFO, "[]");
                break;
            }
            case "approvalrecordplugin": {
                if (!StringUtils.isBlank((Object)e.getChangeSet()[0].getNewValue())) break;
                this.getModel().setValue(APPROVAL_RECORD_PLUGIN_VAL, (Object)"");
                break;
            }
            case "viewchatflowpermplugin": {
                if (!StringUtils.isBlank((Object)e.getChangeSet()[0].getNewValue())) break;
                this.getModel().setValue(VIEW_CHAT_FLOW_PERM_PLUGIN_VAL, (Object)"");
            }
        }
        super.propertyChanged(e);
    }

    private void setReferOrganizationCombo(BillSubjectModelEntity entity) {
        String entityNumber = null;
        String entityNumberForOrg = this.getPageCache().get("entityNumberForOrg");
        if (entity != null) {
            entityNumber = entity.getEntityNumber();
        } else if (WfUtils.isNotEmpty((String)entityNumberForOrg)) {
            entityNumber = entityNumberForOrg;
        }
        MainEntityType mainEntity = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (mainEntity == null) {
            return;
        }
        String namePrefix = ResManager.loadKDString((String)"\u5355\u636e-", (String)"PartRelationPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        ArrayList<ComboItem> orgItems = new ArrayList<ComboItem>();
        this.getBasedataPropOrg(mainEntity, namePrefix, orgItems);
        ComboEdit referOrganizationControl = (ComboEdit)this.getControl(REFERORGANIZATION);
        referOrganizationControl.setComboItems(orgItems);
        String defultValue = null;
        if (entity != null) {
            defultValue = entity.getReferOrganization();
        }
        this.getView().getModel().setValue(REFERORGANIZATION, (Object)defultValue);
    }

    private void getBasedataPropOrg(MainEntityType mainEntity, String namePrefix, List<ComboItem> orgItems) {
        HashSet<String> usersNeedIgnore = new HashSet<String>();
        usersNeedIgnore.add("modifier");
        usersNeedIgnore.add("auditor");
        for (IDataEntityProperty prop : mainEntity.getProperties()) {
            boolean condition = prop instanceof BasedataProp && "bos_org".equals(((BasedataProp)prop).getBaseEntityId()) || prop instanceof MulBasedataProp && "bos_org".equals(((MulBasedataProp)prop).getBaseEntityId());
            if (!condition) continue;
            this.addOrgItems(prop, usersNeedIgnore, namePrefix, orgItems);
        }
    }

    private void addOrgItems(IDataEntityProperty prop, Set<String> usersNeedIgnore, String namePrefix, List<ComboItem> orgItems) {
        String valuePrefix = "ENTI_";
        String value = prop.getName();
        if (usersNeedIgnore.contains(value)) {
            return;
        }
        LocaleString name = prop.getDisplayName();
        String orignalName = name.getLocaleValue();
        String newName = namePrefix + (WfUtils.isNotEmpty((String)orignalName) ? orignalName : "");
        String newValue = valuePrefix + value;
        orgItems.add(new ComboItem(new LocaleString(newName), newValue));
    }

    private void setPageDataByEntraBill(Map<String, Object> evtData) {
        this.setEntryInfoCache(evtData);
        String billId = evtData.get("id").toString();
        BillSubjectModelEntity entity = this.getWFService().getRepositoryService().findBillSubject(billId);
        if (null == entity) {
            this.getModel().setValue(ENTRA_BILL_NAME, evtData.get("name"));
            this.showComboData(evtData.get("id").toString(), evtData.get("number").toString(), null, null);
            this.showComboMainFieldData(evtData.get("number").toString(), "");
            this.getPageCache().put("entityNumberForOrg", evtData.get("number").toString());
            this.setReferOrganizationCombo(null);
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u7c7b\u578b\u5df2\u8bbe\u7f6e\u6d41\u7a0b\u5c5e\u6027\uff0c\u662f\u5426\u53d6\u51fa\u4fee\u6539\uff1f", (String)"BillFlowAttrSettingsPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("setPageDataByEntraBill"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        if (MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            String billId = this.getPageCache().get(ENTRA_BILL_ID);
            BillSubjectModelEntity entity = this.getWFService().getRepositoryService().findBillSubject(billId);
            this.setPageData(entity);
            this.setReferOrganizationCombo(entity);
            this.getModel().setValue(ENTRA_BILL_NAME, (Object)entity.getBillName());
            this.getPageCache().put(ISINSERT, "false");
            this.getView().setEnable(Boolean.FALSE, new String[]{ENTRA_BILL_NAME});
        }
    }

    private void deletePageCache() {
        this.getPageCache().remove(ENTRA_BILL_ID);
        this.getPageCache().remove(ENTRA_BILL_NUMBER);
    }

    public TreeNode getTreeRoot(String entityId) {
        if (this.getPageCache().get(entityId + "treeRoot") != null) {
            return (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(entityId + "treeRoot"), TreeNode.class);
        }
        TreeNode root = BillSubjectUtil.getTreeRoot(entityId);
        this.getPageCache().put(entityId + "treeRoot", SerializationUtils.toJsonString((Object)root));
        return root;
    }

    public String getFieldMap(String entityId) {
        if (this.getPageCache().get(entityId + "map") == null) {
            Map<String, Object> fieldMap = BillSubjectUtil.getFieldsMap(entityId);
            String jsonMap = SerializationUtils.toJsonString(fieldMap);
            this.getPageCache().put(entityId + "map", jsonMap);
            return jsonMap;
        }
        return this.getPageCache().get(entityId + "map");
    }

    protected WorkflowService getWFService() {
        return (WorkflowService)ServiceFactory.getService(WorkflowService.class);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        this.getPageCache().remove(ISINSERT);
    }

    private void showComboMainFieldData(String entityNumber, String mainField) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Map fields = entityType.getAllFields();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        for (Map.Entry entry : fields.entrySet()) {
            ComboItem item = new ComboItem();
            IDataEntityProperty fieldProp = (IDataEntityProperty)entry.getValue();
            if (!(fieldProp instanceof IFieldHandle) || WfUtils.isNotEmpty((String)fieldProp.getParent().getName()) && !entityNumber.equals(fieldProp.getParent().getName()) || fieldProp instanceof MulBasedataProp) continue;
            if (!(fieldProp instanceof BasedataProp) && !(fieldProp instanceof AttachmentProp)) {
                item.setValue(fieldProp.getName());
                item.setCaption(((IFieldHandle)fieldProp).getDisplayName());
            }
            items.add(item);
        }
        MulComboEdit combox = (MulComboEdit)this.getControl(MAINFIELD_COMBO);
        combox.setComboItems(items);
        if (WfUtils.isNotEmpty((String)mainField)) {
            this.getModel().setValue(MAINFIELD_COMBO, (Object)mainField);
        }
    }

    private String getPermissionAppId() {
        return ProcessInstancePluginUtil.getPermissionAppId(this.getView());
    }

    private Map<String, Object> checkIsNeedUpdateBusinessMappingInfoOfConfCenter() {
        String businessFieldMappingNew;
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        String businessFieldMappingOld = "[]".equals(this.getView().getPageCache().get("businessfieldmappingold")) ? null : this.getView().getPageCache().get("businessfieldmappingold");
        String string = businessFieldMappingNew = "[]".equals(this.getView().getPageCache().get(BUSINESSFIELDMAPPINGINFO)) ? null : this.getView().getPageCache().get(BUSINESSFIELDMAPPINGINFO);
        if (StringUtils.isBlank(businessFieldMappingNew)) {
            Optional.ofNullable(businessFieldMappingOld).ifPresent(old -> result.put(MAPPINGFIELD_UPDATETYPE_UPDATETYPE, MAPPINGFIELD_UPDATETYPE_REMOVE));
        } else {
            HashMap taskFieldMapping = new HashMap();
            HashMap hitaskFieldMapping = new HashMap();
            if (StringUtils.isNotBlank((CharSequence)businessFieldMappingOld)) {
                List listOld = SerializationUtils.fromJsonStringToList((String)businessFieldMappingOld, Map.class);
                listOld.forEach(old -> {
                    Object scope = old.get("scope");
                    if (StringUtils.isBlank(scope) || ((String)scope).contains(STR_WFTASK)) {
                        taskFieldMapping.put((String)old.get("fieldlist"), (String)old.get("mapping"));
                    }
                    if (StringUtils.isNotBlank(scope) && ((String)scope).contains(STR_WFHITASK)) {
                        hitaskFieldMapping.put((String)old.get("fieldlist"), (String)old.get("mapping"));
                    }
                });
            }
            Date now = new Date(System.currentTimeMillis() + 60000L);
            List listNew = SerializationUtils.fromJsonStringToList((String)businessFieldMappingNew, Map.class);
            HashMap taskFieldMap = new HashMap();
            HashMap hiTaskFieldMap = new HashMap();
            listNew.forEach(ne -> {
                String mappingFieldOld;
                Object fieldlistNew = ne.get("fieldlist");
                Object mappingFieldNew = ne.get("mapping");
                Object scope = ne.get("scope");
                if (StringUtils.isBlank(scope) || ((String)scope).contains(STR_WFTASK)) {
                    mappingFieldOld = (String)taskFieldMapping.get(fieldlistNew);
                    if (StringUtils.isBlank((CharSequence)mappingFieldOld) || !mappingFieldOld.equals(mappingFieldNew)) {
                        taskFieldMap.put((String)fieldlistNew, now);
                    }
                    taskFieldMapping.remove(fieldlistNew);
                }
                if (StringUtils.isNotBlank(scope) && ((String)scope).contains(STR_WFHITASK)) {
                    mappingFieldOld = (String)hitaskFieldMapping.get(fieldlistNew);
                    if (StringUtils.isBlank((CharSequence)mappingFieldOld) || !mappingFieldOld.equals(mappingFieldNew)) {
                        hiTaskFieldMap.put((String)fieldlistNew, now);
                    }
                    hitaskFieldMapping.remove(fieldlistNew);
                }
            });
            if (!taskFieldMap.isEmpty()) {
                result.put(MAPPINGFIELD_UPDATETYPE_UPDATETYPE, MAPPINGFIELD_UPDATETYPE_ADD);
                result.put(STR_WFTASK, taskFieldMap);
            }
            if (!hiTaskFieldMap.isEmpty()) {
                result.put(MAPPINGFIELD_UPDATETYPE_UPDATETYPE, MAPPINGFIELD_UPDATETYPE_ADD);
                result.put(STR_WFHITASK, hiTaskFieldMap);
            }
            if (!taskFieldMapping.isEmpty()) {
                result.put(TASK_MOVEFIIELD, taskFieldMapping);
            }
            if (!hitaskFieldMapping.isEmpty()) {
                result.put(HITASK_MOVEFIELD, hitaskFieldMapping);
            }
        }
        return result;
    }
}

