/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.management.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryResult;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListColumn;
import kd.bos.list.ListGridView;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.design.util.PluginUtil;
import kd.bos.workflow.design.util.ProcessInstancePluginUtil;
import kd.bos.workflow.engine.ManagementService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class BillSubjectModelPlugin
extends AbstractListPlugin
implements IConfirmCallBack {
    private static final String ENTITYID = "wf_billsubjectmodel";
    private static final String INSERT = "insert";
    private static final String UPDATE = "update";
    private static final String DELETE = "delete";
    private static final String BILLFLOWATTRSETTINGS = "wf_billflowattrsettings";

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        String[][] arrays = this.getColumns();
        HashMap<String, String> fieldWidths = new HashMap<String, String>();
        fieldWidths.put("entitynumber", "15%");
        fieldWidths.put("billname", "15%");
        fieldWidths.put("subjectshowname", "30%");
        fieldWidths.put("formkeyname", "15%");
        fieldWidths.put("mobileformkeyname", "15%");
        List listColumns = args.getListColumns();
        listColumns.clear();
        Container parent = (Container)args.getSource();
        for (Control control : parent.getItems()) {
            if (!(control instanceof ListGridView)) continue;
            parent = (Container)control;
            break;
        }
        for (String[] arr : arrays) {
            ListColumn listColumn = this.createListColumn(arr, ENTITYID, fieldWidths);
            listColumn.setParent(parent);
            listColumn.setParentViewKey(parent.getKey());
            if ("entitynumber".equals(arr[1])) {
                listColumn.setHyperlink(true);
            }
            listColumns.add(listColumn);
        }
    }

    protected String[][] getColumns() {
        return new String[][]{{ResManager.loadKDString((String)"\u5355\u636e\u7f16\u7801", (String)"BillSubjectModelPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), "entitynumber"}, {ResManager.loadKDString((String)"\u5355\u636e\u540d\u79f0", (String)"BillSubjectModelPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), "billname"}, {ResManager.loadKDString((String)"\u5355\u636e\u4e3b\u9898", (String)"BillSubjectModelPlugin_12", (String)"bos-wf-formplugin", (Object[])new Object[0]), "subjectshowname"}, {ResManager.loadKDString((String)"\u5355\u636e\u67e5\u770b\u9875\u9762", (String)"BillSubjectModelPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]), "formkeyname"}, {ResManager.loadKDString((String)"\u5355\u636e\u79fb\u52a8\u7aef\u67e5\u770b\u9875\u9762", (String)"BillSubjectModelPlugin_13", (String)"bos-wf-formplugin", (Object[])new Object[0]), "mobileformkeyname"}, {ResManager.loadKDString((String)"\u5355\u636eid", (String)"BillSubjectModelPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]), "billid"}, {ResManager.loadKDString((String)"\u5355\u636e\u67e5\u770b\u9875\u9762(PC)\u7f16\u7801", (String)"BillSubjectModelPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]), "formkey"}};
    }

    public ListColumn createListColumn(String[] arr, String entity, Map<String, String> fieldWidths) {
        boolean flag = false;
        if ("billid".equalsIgnoreCase(arr[1]) || "formKey".equalsIgnoreCase(arr[1]) || "id".equalsIgnoreCase(arr[1])) {
            flag = true;
        }
        ListColumn listColumn = new ListColumn();
        listColumn.setCaption(new LocaleString(arr[0]));
        listColumn.setClassName("className");
        listColumn.setEntityName(entity);
        listColumn.setFieldName(arr[1]);
        listColumn.setKey("key" + arr[1]);
        listColumn.setListFieldKey(arr[1]);
        listColumn.setSeq(2);
        String width = fieldWidths.get(arr[1]);
        if (WfUtils.isNotEmpty((String)width)) {
            listColumn.setWidth(new LocaleString(width));
        }
        listColumn.setVisible(flag ? 0 : 13);
        return listColumn;
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        String type = null;
        switch (key) {
            case "btnrefresh": {
                this.refreshData();
                break;
            }
            case "btninsert": {
                if (!this.hasPermission("47156aff000000ac", ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5355\u636e\u6d41\u7a0b\u5c5e\u6027\u8bbe\u7f6e\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\u3002", (String)"BillSubjectModelPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]), INSERT)) break;
                type = INSERT;
                this.showDataPage(type);
                break;
            }
            case "btnupdate": {
                if (!this.hasPermission("4715a0df000000ac", ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5355\u636e\u6d41\u7a0b\u5c5e\u6027\u8bbe\u7f6e\u201d\u7684\u201c\u4fee\u6539\u201d\u6743\u9650\u3002", (String)"BillSubjectModelPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]), UPDATE)) break;
                type = UPDATE;
                this.showDataPage(type);
                break;
            }
            case "btndelete": {
                if (!this.hasPermission("4715e1f1000000ac", ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5355\u636e\u6d41\u7a0b\u5c5e\u6027\u8bbe\u7f6e\u201d\u7684\u201c\u5220\u9664\u201d\u6743\u9650\u3002", (String)"BillSubjectModelPlugin_15", (String)"bos-wf-formplugin", (Object[])new Object[0]), DELETE)) break;
                this.deleteBillFlowProp();
                break;
            }
        }
    }

    private boolean hasPermission(String permItemId, String message, String type) {
        boolean hasSpecificPerm = true;
        String permissionAppId = ProcessInstancePluginUtil.getPermissionAppId(this.getView());
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)permissionAppId, (String)ENTITYID, (String)permItemId)) {
            this.getView().showTipNotification(message);
            hasSpecificPerm = false;
            String opKey = null;
            MultiLangEnumBridge opNameBridge = null;
            MultiLangEnumBridge descBridge = null;
            switch (type) {
                case "insert": {
                    opKey = "btninsert";
                    opNameBridge = new MultiLangEnumBridge("\u65b0\u589e", "BillSubjectModelPlugin_16", "bos-wf-formplugin");
                    descBridge = new MultiLangEnumBridge("\u60a8\u6ca1\u6709\u201c\u5355\u636e\u6d41\u7a0b\u5c5e\u6027\u8bbe\u7f6e\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\u3002", "BillSubjectModelPlugin_8", "bos-wf-formplugin");
                    break;
                }
                case "update": {
                    opKey = UPDATE;
                    opNameBridge = new MultiLangEnumBridge("\u66f4\u65b0", "BillSubjectModelPlugin_19", "bos-wf-formplugin");
                    descBridge = new MultiLangEnumBridge("\u60a8\u6ca1\u6709\u201c\u5355\u636e\u6d41\u7a0b\u5c5e\u6027\u8bbe\u7f6e\u201d\u7684\u201c\u4fee\u6539\u201d\u6743\u9650\u3002", "BillSubjectModelPlugin_9", "bos-wf-formplugin");
                    break;
                }
                case "delete": {
                    opKey = "btndelete";
                    opNameBridge = new MultiLangEnumBridge("\u5220\u9664", "BillSubjectModelPlugin_18", "bos-wf-formplugin");
                    descBridge = new MultiLangEnumBridge("\u60a8\u6ca1\u6709\u201c\u5355\u636e\u6d41\u7a0b\u5c5e\u6027\u8bbe\u7f6e\u201d\u7684\u201c\u5220\u9664\u201d\u6743\u9650\u3002", "BillSubjectModelPlugin_15", "bos-wf-formplugin");
                }
            }
            WfUtils.addOpLogByAppId((String)this.getView().getFormShowParameter().getAppId(), (String)ENTITYID, (String)opKey, (MultiLangEnumBridge)opNameBridge, descBridge, (Object[])new Object[0]);
        }
        return hasSpecificPerm;
    }

    private void refreshData() {
        IListView listView = (IListView)this.getView();
        listView.clearSelection();
        listView.refresh();
    }

    private void showDataPage(String type) {
        String pkId = null;
        if (UPDATE.equals(type)) {
            ListSelectedRowCollection rows = this.getSelectedRows();
            if (rows != null && rows.size() == 1) {
                pkId = rows.get(0).getPrimaryKeyValue().toString();
            } else {
                StandardTips.view((IFormView)this.getView()).selectMultiRow(Optional.ofNullable(rows).map(ArrayList::size).orElseGet(() -> 0).intValue());
                return;
            }
        }
        this.showEditPage(type, pkId);
    }

    private void showEditPage(String type, String pkId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, type));
        parameter.setFormId(this.getEditPageFormId());
        parameter.setCaption(ResManager.loadKDString((String)"\u5355\u636e\u6d41\u7a0b\u5c5e\u6027\u8bbe\u7f6e", (String)"BillSubjectModelPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("pkId", (Object)pkId);
        parameter.setCustomParam("type", (Object)type);
        this.getView().showForm(parameter);
    }

    protected String getEditPageFormId() {
        return BILLFLOWATTRSETTINGS;
    }

    public ListSelectedRowCollection getSelectedRows() {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows == null || rows.isEmpty()) {
            StandardTips.view((IFormView)this.getView()).notSelectRow();
            return null;
        }
        return rows;
    }

    private void deleteBillFlowProp() {
        this.getView().invokeOperation(DELETE);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        try {
            this.getManagementService();
        }
        catch (KDException e) {
            this.getView().showMessage(e.getMessage());
            return;
        }
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ModelListDataProvider());
    }

    private ManagementService getManagementService() {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        return wfService.getManagementService();
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        this.refreshData();
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        evt.setCancel(true);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        if (this.hasPermission("4715a0df000000ac", ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5355\u636e\u6d41\u7a0b\u5c5e\u6027\u8bbe\u7f6e\u201d\u7684\u201c\u4fee\u6539\u201d\u6743\u9650\u3002", (String)"BillSubjectModelPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]), UPDATE)) {
            String pkId = String.valueOf(((IListView)this.getView()).getFocusRowPkId());
            this.showEditPage(UPDATE, pkId);
        }
        args.setCancel(true);
    }

    public void afterCreateNewData(EventObject e) {
        PluginUtil.setControlInvisible(this.getView(), "exit");
    }

    class ModelListDataProvider
    extends ListDataProvider {
        private QueryResult queryResult = null;

        ModelListDataProvider() {
        }

        public QueryResult getQueryResult() {
            return this.queryResult;
        }

        public void setQueryResult(QueryResult queryResult) {
            this.queryResult = queryResult;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            this.queryResult = new QueryResult();
            this.queryResult.setDataCount(this.getRealCount());
            ManagementService service = BillSubjectModelPlugin.this.getManagementService();
            return service.getBillSubjectModelData(BillSubjectModelPlugin.ENTITYID, start, limit, this.getQFilters(), null);
        }

        public int getRealCount() {
            ManagementService service = BillSubjectModelPlugin.this.getManagementService();
            return (int)service.getBillSubjectModelCount("id", this.getQFilters(), true);
        }
    }
}

