/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.management.plugin;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.impl.persistence.entity.management.BillSubjectModelEntity;
import kd.bos.workflow.management.plugin.BillFlowAttrSettingsPlugin;

public class BpmBillFlowAttrSettingPlugin
extends BillFlowAttrSettingsPlugin {
    private static final String BIZTRACENO = "biztraceno";
    private static final String BIZTRACENODESC = "biztracenodesc";
    private static final String PUSHSTATUSPLUGIN = "pushstatusplugin";
    private static final String PUSHSTATUSPLUGINVALUE = "pushstatuspluginvalue";
    private static final String PERMISSIONSPLUGIN = "permissionsplugin";
    private static final String PERMISSIONSPLUGINVALUE = "permissionspluginvalue";
    private static final String ACTIONID_PUSHSTATUSPLUGIN = "pushStatusPlugin";
    private static final String ACTIONID_PERMISSIONSPLUGIN = "permissionsPlugin";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit bizTraceNo = (TextEdit)this.getControl(BIZTRACENO);
        bizTraceNo.addButtonClickListener((ClickListener)this);
        TextEdit plugin = (TextEdit)this.getControl(PUSHSTATUSPLUGIN);
        plugin.addButtonClickListener((ClickListener)this);
        TextEdit permissionsPlugin = (TextEdit)this.getControl(PERMISSIONSPLUGIN);
        permissionsPlugin.addButtonClickListener((ClickListener)this);
    }

    @Override
    protected void setPageData(BillSubjectModelEntity entity) {
        super.setPageData(entity);
        this.getModel().setValue(BIZTRACENO, (Object)entity.getBizTraceNo());
        this.getModel().setValue(BIZTRACENODESC, (Object)entity.getBizTraceNoDesc());
        this.setPushStatusPluginValue(entity.getPushStatusPlugin());
        this.setPermisionsPluginValue(entity.getPermissionsPlugin());
    }

    private void setPushStatusPluginValue(String plugin) {
        if (ExternalInterfaceUtil.isValidValue((String)plugin)) {
            this.getModel().setValue(PUSHSTATUSPLUGIN, (Object)ExternalInterfaceUtil.getFormattedShowValue((String)plugin));
            this.getModel().setValue(PUSHSTATUSPLUGINVALUE, (Object)plugin);
        }
    }

    private void setPermisionsPluginValue(String plugin) {
        if (ExternalInterfaceUtil.isValidValue((String)plugin)) {
            this.getModel().setValue(PERMISSIONSPLUGIN, (Object)ExternalInterfaceUtil.getFormattedShowValue((String)plugin));
            this.getModel().setValue(PERMISSIONSPLUGINVALUE, (Object)plugin);
        }
    }

    @Override
    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "biztraceno": {
                this.showSelectBizTraceNoPage();
                break;
            }
            case "pushstatusplugin": {
                this.showPushStatusPluginPage();
                break;
            }
            case "permissionsplugin": {
                this.showPermissionsPluginPage();
                break;
            }
            default: {
                super.click(evt);
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        String propName = property.getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (PUSHSTATUSPLUGIN.equals(propName)) {
            this.pushStatusPluginChanged(newValue);
        } else if (PERMISSIONSPLUGIN.equals(propName)) {
            this.permissionsPluginChanged(newValue);
        }
    }

    private void pushStatusPluginChanged(Object newValue) {
        if (newValue == null || "".equals(newValue.toString().trim())) {
            this.getModel().setValue(PUSHSTATUSPLUGINVALUE, null);
        }
    }

    private void permissionsPluginChanged(Object newValue) {
        if (newValue == null || "".equals(newValue.toString().trim())) {
            this.getModel().setValue(PERMISSIONSPLUGINVALUE, null);
        }
    }

    private boolean validate() {
        String entityName = (String)this.getModel().getValue("entrabillname");
        if (WfUtils.isEmpty((String)entityName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5b9e\u4f53\u540d\u79f0\u201d\u3002", (String)"BpmBillFlowAttrSettingPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return false;
        }
        return true;
    }

    private void showPushStatusPluginPage() {
        if (!this.validate()) {
            return;
        }
        String entityId = this.getPageCache().get("entrabillid");
        String pluginValue = (String)this.getModel().getValue(PUSHSTATUSPLUGINVALUE);
        String types = ExternalInterfaceUtil.getTypes((String[])new String[]{"class", "script"});
        IFormView view = this.getView();
        view.getFormShowParameter().setCustomParam("hideParameterConfig", (Object)Boolean.TRUE);
        DesignerPluginUtil.openExternalInterface(view, (IFormPlugin)this, types, entityId, pluginValue, true, ACTIONID_PUSHSTATUSPLUGIN);
    }

    private void showPermissionsPluginPage() {
        if (!this.validate()) {
            return;
        }
        String entityId = this.getPageCache().get("entrabillid");
        String pluginValue = (String)this.getModel().getValue(PERMISSIONSPLUGINVALUE);
        String types = ExternalInterfaceUtil.getTypes((String[])new String[]{"class", "script"});
        IFormView view = this.getView();
        view.getFormShowParameter().setCustomParam("hideParameterConfig", (Object)Boolean.TRUE);
        DesignerPluginUtil.openExternalInterface(view, (IFormPlugin)this, types, entityId, pluginValue, true, ACTIONID_PERMISSIONSPLUGIN);
    }

    private void showSelectBizTraceNoPage() {
        if (!this.validate()) {
            return;
        }
        String entityNumber = this.getPageCache().get("entrabillnumber");
        String bizTraceNo = (String)this.getModel().getValue(BIZTRACENO);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_billsubject_light");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BIZTRACENO));
        parameter.setCaption(ResManager.loadKDString((String)"\u4e1a\u52a1\u8ddf\u8e2a\u53f7", (String)"BpmBillFlowAttrSettingPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        parameter.setCustomParam("entityNumber", (Object)entityNumber);
        parameter.setCustomParam("FROM", (Object)"MSG");
        parameter.setCustomParam("value", (Object)bizTraceNo);
        this.getView().showForm(parameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        Object returnData = evt.getReturnData();
        switch (actionId = evt.getActionId()) {
            case "biztraceno": {
                this.bizTraceNoCallBack(returnData);
                break;
            }
            case "pushStatusPlugin": {
                this.pushStatusPluginCallback(returnData);
                break;
            }
            case "permissionsPlugin": {
                this.permissionsPluginCallback(returnData);
                break;
            }
            default: {
                super.closedCallBack(evt);
            }
        }
    }

    private void pushStatusPluginCallback(Object returnData) {
        if (returnData == null) {
            return;
        }
        this.setPushStatusPluginValue(returnData.toString());
    }

    private void permissionsPluginCallback(Object returnData) {
        if (returnData == null) {
            return;
        }
        this.setPermisionsPluginValue(returnData.toString());
    }

    private void bizTraceNoCallBack(Object returnData) {
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            String value = (String)data.get("customSubject");
            this.getModel().setValue(BIZTRACENO, (Object)value);
        }
    }

    @Override
    protected String validate(String entraBillName, String svCustomSubject) {
        String bizTraceNo;
        String msg = super.validate(entraBillName, svCustomSubject);
        if (msg == null && (bizTraceNo = (String)this.getModel().getValue(BIZTRACENO)) != null && bizTraceNo.length() > 100) {
            return ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u8ddf\u8e2a\u53f7\u201d\u6700\u591a\u53ef\u8bbe\u7f6e100\u4e2a\u5b57\u7b26\u3002", (String)"BpmBillFlowAttrSettingPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        return msg;
    }

    @Override
    protected BillSubjectModelEntity setBillSubjectModelEntityData(BillSubjectModelEntity entity) {
        BillSubjectModelEntity modelEntity = super.setBillSubjectModelEntityData(entity);
        if (modelEntity == null) {
            return modelEntity;
        }
        String bizTraceNo = (String)this.getModel().getValue(BIZTRACENO);
        ILocaleString bizTraceNoDesc = (ILocaleString)this.getModel().getValue(BIZTRACENODESC);
        modelEntity.setBizTraceNo(bizTraceNo);
        modelEntity.setBizTraceNoDesc(bizTraceNoDesc);
        modelEntity.setPushStatusPlugin((String)this.getModel().getValue(PUSHSTATUSPLUGINVALUE));
        modelEntity.setPermissionsPlugin((String)this.getModel().getValue(PERMISSIONSPLUGINVALUE));
        return modelEntity;
    }
}

