/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.management.plugin;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.feature.taskfield.util.TaskExtendFieldUtil;

public class BusinessFieldMappingSettingPlugin
extends AbstractFormPlugin {
    private static final String FIELDLIST = "fieldlist";
    private static final String DISPLAYNAME = "displayname";
    private static final String MAPPING = "mapping";
    private static final String SCOPE = "scope";
    private static final String MAPPINGLIST = "mappinglist";
    private static final String BTNOK = "btnok";
    private static final String BTNADDENTRY = "add";
    private static final String ADVCONTOOLBARAP = "advcontoolbarap";
    private static final String ENTRA_BILL_ID = "entrabillid";
    private static final String ENTRA_BILL_NUMBER = "entrabillnumber";
    private static final String BUSINESSFIELDMAPPINGINFO = "businessfieldmapping";
    private static final String STR_DISPLAYNAME = "displayName";
    private static final String STR_TASKFIELDIINFO = "taskFieldiInfo";
    private static final String STR_FIELDTYPE = "fieldType";
    private static final String STR_TASK = "wf_task";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{FIELDLIST, DISPLAYNAME, MAPPING, BTNOK});
        this.addItemClickListeners(new String[]{ADVCONTOOLBARAP});
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        this.initFieldlistComboBox();
        this.getPageCache().put(ENTRA_BILL_ID, (String)this.getView().getFormShowParameter().getCustomParam(ENTRA_BILL_ID));
        this.getPageCache().put(ENTRA_BILL_NUMBER, (String)this.getView().getFormShowParameter().getCustomParam(ENTRA_BILL_NUMBER));
        Object businessFieldDatas = this.getView().getFormShowParameter().getCustomParam(BUSINESSFIELDMAPPINGINFO);
        if (StringUtils.isNotBlank((Object)businessFieldDatas)) {
            List list = (List)SerializationUtils.fromJsonString((String)((String)businessFieldDatas), List.class);
            this.setEntryValue(list);
        }
        super.afterCreateNewData(e);
    }

    private void setEntryValue(List<Map<String, Object>> businessFieldDatas) {
        if (!businessFieldDatas.isEmpty()) {
            this.getModel().batchCreateNewEntryRow(MAPPINGLIST, businessFieldDatas.size());
            int len = businessFieldDatas.size();
            for (int i = 0; i < len; ++i) {
                this.getModel().setValue(FIELDLIST, businessFieldDatas.get(i).get(FIELDLIST), i);
                this.getModel().setValue(DISPLAYNAME, businessFieldDatas.get(i).get(DISPLAYNAME), i);
                this.getModel().setValue(MAPPING, businessFieldDatas.get(i).get(MAPPING), i);
                this.getModel().setValue(SCOPE, Optional.ofNullable(businessFieldDatas.get(i).get(SCOPE)).orElse(STR_TASK), i);
            }
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (MAPPING.equals(key)) {
            this.showBusinessFieldList();
        } else if (BTNOK.equals(key)) {
            String checkInfo = this.checkInfos();
            if (StringUtils.isNotBlank((CharSequence)checkInfo)) {
                this.getView().showTipNotification(checkInfo);
                return;
            }
            this.getBusinessFieldMappingInfos();
        }
        super.click(evt);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (BTNADDENTRY.equals(itemKey)) {
            String taskFieldiInfoStr = this.getPageCache().get(STR_TASKFIELDIINFO);
            Optional.ofNullable(taskFieldiInfoStr).ifPresent(x -> {
                JSONObject taskFieldInfos = (JSONObject)SerializationUtils.fromJsonString((String)taskFieldiInfoStr, JSONObject.class);
                if (this.getModel().getEntryRowCount(MAPPINGLIST) >= 10) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u8d85\u51fa\u5b57\u6bb5\u6700\u5927\u53ef\u914d\u7f6e\u6570\u91cf\u3002", (String)"BusinessFieldMappingSettingPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
            });
        }
        super.beforeItemClick(evt);
    }

    private void showBusinessFieldList() {
        String key;
        String type;
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_basedatafieldlist");
        parameter.setCustomParam(ENTRA_BILL_ID, (Object)this.getPageCache().get(ENTRA_BILL_ID));
        parameter.setCustomParam(ENTRA_BILL_NUMBER, (Object)this.getPageCache().get(ENTRA_BILL_NUMBER));
        parameter.setCaption(ResManager.loadKDString((String)"\u4e1a\u52a1\u5b57\u6bb5\u6620\u5c04\u5173\u7cfb\u914d\u7f6e", (String)"BusinessFieldMappingSettingPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        DynamicObject selectEntryGridEntity = this.getSelectEntryGridEntity();
        if (StringUtils.isNotBlank((Object)selectEntryGridEntity.get(MAPPING))) {
            parameter.setCustomParam("value", selectEntryGridEntity.get(MAPPING));
        }
        if (StringUtils.isNotBlank((CharSequence)(type = this.getFieldType(key = selectEntryGridEntity.getString(FIELDLIST))))) {
            parameter.setCustomParam(STR_FIELDTYPE, (Object)type);
        }
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "businessFieldInfo"));
        this.getView().showForm(parameter);
    }

    private String getFieldType(String fieldName) {
        String taskFieldiInfoStr = this.getPageCache().get(STR_TASKFIELDIINFO);
        JSONObject taskFieldInfos = (JSONObject)SerializationUtils.fromJsonString((String)taskFieldiInfoStr, JSONObject.class);
        if (StringUtils.isNotBlank((CharSequence)fieldName)) {
            JSONObject info = taskFieldInfos.getJSONObject(fieldName);
            return info.getString(STR_FIELDTYPE);
        }
        return null;
    }

    private void initFieldlistComboBox() {
        ComboEdit comBox = (ComboEdit)this.getControl(FIELDLIST);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)STR_TASK);
        DataEntityPropertyCollection properties = entityType.getProperties();
        List<Object> items = new ArrayList();
        ArrayList<ComboItem> extendItems = new ArrayList<ComboItem>();
        JSONObject arr = new JSONObject();
        Boolean allowExtendTaskFields = WfConfigurationUtil.isAllowExtendTaskFields();
        for (IDataEntityProperty p : properties) {
            if (!TaskExtendFieldUtil.isBusinessMappingField((IDataEntityProperty)p) && (!allowExtendTaskFields.booleanValue() || !TaskExtendFieldUtil.isBusinessMappingExtField((IDataEntityProperty)p))) continue;
            ComboItem item = new ComboItem();
            item.setCaption(p.getDisplayName());
            item.setValue(p.getName());
            if (TaskExtendFieldUtil.isBusinessMappingExtField((IDataEntityProperty)p)) {
                extendItems.add(item);
            } else {
                items.add(item);
            }
            JSONObject obj = new JSONObject();
            obj.put("name", (Object)p.getName());
            obj.put(STR_DISPLAYNAME, (Object)p.getDisplayName());
            obj.put(STR_FIELDTYPE, (Object)p.getPropertyType());
            arr.put(p.getName(), (Object)obj);
        }
        items = items.stream().sorted(Comparator.comparing(ComboItem::getValue)).collect(Collectors.toList());
        items.addAll(extendItems);
        comBox.setComboItems(items);
        this.getPageCache().put(STR_TASKFIELDIINFO, SerializationUtils.toJsonString((Object)arr));
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() != null && "businessFieldInfo".equals(e.getActionId())) {
            List configFields = (List)e.getReturnData();
            DynamicObject dataEntity = this.getSelectEntryGridEntity();
            StringJoiner mapping = new StringJoiner(";");
            configFields.forEach(map -> {
                String name = (String)map.get("name");
                mapping.add(name);
            });
            this.getModel().setValue(MAPPING, (Object)mapping.toString(), dataEntity.getInt("seq") - 1);
        }
        super.closedCallBack(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        if (FIELDLIST.equals(key)) {
            return;
        }
        super.propertyChanged(e);
    }

    private void getBusinessFieldMappingInfos() {
        EntryGrid grid = (EntryGrid)this.getControl(MAPPINGLIST);
        DynamicObjectCollection mappingList = grid.getModel().getEntryEntity(MAPPINGLIST);
        ArrayList list = new ArrayList(mappingList.size());
        mappingList.forEach(obj -> {
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            map.put(FIELDLIST, obj.get(FIELDLIST));
            map.put(DISPLAYNAME, obj.get(DISPLAYNAME));
            map.put(MAPPING, obj.get(MAPPING));
            map.put(SCOPE, Optional.ofNullable(obj.get(SCOPE)).orElse(STR_TASK));
            String type = this.getFieldType((String)obj.get(FIELDLIST));
            if (Date.class.getName().equals(type) || BigDecimal.class.getName().equals(type)) {
                map.put("isFormat", Boolean.TRUE);
            }
            list.add(map);
        });
        HashMap returnData = new HashMap(1);
        returnData.put(BUSINESSFIELDMAPPINGINFO, list);
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    private String checkInfos() {
        EntryGrid grid = (EntryGrid)this.getControl(MAPPINGLIST);
        DynamicObjectCollection mappingList = grid.getModel().getEntryEntity(MAPPINGLIST);
        String taskFieldInfo = this.getPageCache().get(STR_TASKFIELDIINFO);
        JSONObject taskFieldInfos = (JSONObject)SerializationUtils.fromJsonString((String)taskFieldInfo, JSONObject.class);
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(ENTRA_BILL_NUMBER);
        Map allFields = new HashMap();
        if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
            MainEntityType mainEntity = EntityMetadataCache.getDataEntityType((String)entityNumber);
            allFields = mainEntity.getAllFields();
        }
        HashMap<String, String> fieldMap = new HashMap<String, String>(mappingList.size());
        for (DynamicObject entryData : mappingList) {
            String taskieldName;
            String fieldName = entryData.getString(FIELDLIST);
            String fieldMapping = entryData.getString(MAPPING);
            ILocaleString disPlayName = entryData.getLocaleString(DISPLAYNAME);
            try {
                JSONObject displayName = taskFieldInfos.getJSONObject(fieldName).getJSONObject(STR_DISPLAYNAME);
                taskieldName = LocaleString.fromMap((Map)displayName).toString();
                taskieldName = StringUtils.isNotBlank((CharSequence)taskieldName) ? taskieldName : fieldName;
            }
            catch (Exception exception) {
                taskieldName = fieldName;
            }
            String fieldScope = entryData.getString(SCOPE);
            if (taskFieldInfos.getJSONObject(fieldName) == null) {
                return ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u4fee\u6539\u201c%s\u201d\u5b57\u6bb5\uff0c\u8be5\u5b57\u6bb5\u5df2\u88ab\u5220\u9664\u6216\u4e0d\u518d\u652f\u6301\u3002", (String)"BusinessFieldMappingSettingPlugin_11", (String)"bos-wf-formplugin", (Object[])new Object[]{fieldName});
            }
            String fieldType = taskFieldInfos.getJSONObject(fieldName).getString(STR_FIELDTYPE);
            if (StringUtils.isBlank((CharSequence)fieldName)) {
                return ResManager.loadKDString((String)"\u5217\u8868\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BusinessFieldMappingSettingPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            }
            if (WfUtils.isEmpty((ILocaleString)disPlayName)) {
                return ResManager.loadKDString((String)"\u5217\u8868\u201c\u663e\u793a\u540d\u79f0\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BusinessFieldMappingSettingPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            }
            if (StringUtils.isBlank((CharSequence)fieldMapping)) {
                return ResManager.loadKDString((String)"\u4e1a\u52a1\u5b57\u6bb5\u6620\u5c04\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BusinessFieldMappingSettingPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            }
            if (StringUtils.isBlank((CharSequence)fieldScope)) {
                return ResManager.loadKDString((String)"\u201c\u4f5c\u7528\u4e8e\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BusinessFieldMappingSettingPlugin_10", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            }
            if (fieldMap.containsKey(fieldName)) {
                return ResManager.loadKDString((String)"\u201c%s\u201d\u5b58\u5728\u91cd\u590d\u5b57\u6bb5\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BusinessFieldMappingSettingPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[]{taskieldName});
            }
            fieldMap.put(fieldName, fieldName);
            String[] fieldArr = fieldMapping.split(";");
            if (!StringUtils.isNotBlank((CharSequence)fieldType) || !Date.class.getName().equals(fieldType) && !BigDecimal.class.getName().equals(fieldType)) continue;
            if (fieldArr.length > 1) {
                return ResManager.loadKDString((String)"\u5f53\u201c\u5217\u8868\u5b57\u6bb5\u201d\u4e3a\u6570\u5b57\u6216\u65e5\u671f\u7c7b\u578b\u65f6\uff0c\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u5b57\u6bb5\u3002", (String)"BusinessFieldMappingSettingPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            }
            if (allFields.get(fieldMapping) == null || (!BigDecimal.class.getName().equals(fieldType) || allFields.get(fieldMapping) instanceof DecimalProp) && (!Date.class.getName().equals(fieldType) || allFields.get(fieldMapping) instanceof DateTimeProp)) continue;
            return ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u201c\u5217\u8868\u5b57\u6bb5\u201d\u548c\u201c\u4e1a\u52a1\u5b57\u6bb5\u6620\u5c04\u5173\u7cfb\u201d\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"BusinessFieldMappingSettingPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[]{taskieldName});
        }
        return null;
    }

    private DynamicObject getSelectEntryGridEntity() {
        EntryGrid grid = (EntryGrid)this.getControl(MAPPINGLIST);
        int index = grid.getModel().getEntryCurrentRowIndex(MAPPINGLIST);
        return grid.getModel().getEntryRowEntity(MAPPINGLIST, index);
    }
}

