/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.management.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Delete;
import kd.bos.entity.operate.StatusConvert;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.IListView;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.design.util.BaseChangeLogsUtil;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.design.util.PluginUtil;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class OrgTypeEditListPlugin
extends AbstractListPlugin {
    private static final String QUERY = "query";
    private static final String ORGTYPE = "orgtype";
    private static final String BTN_DISABLE = "baritemap2";
    private static final String BTN_ENABLE = "enable";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Delete || args.getSource() instanceof StatusConvert) {
            BaseChangeLogsUtil.putBaseArrayCache(this.getView(), "wf_orgtype");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ((args.getSource() instanceof Delete || args.getSource() instanceof StatusConvert) && args.getOperationResult().isSuccess()) {
            BaseChangeLogsUtil.addChangeLog(this.getView(), args.getSource(), ORGTYPE);
        }
    }

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{QUERY});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (QUERY.equals(evt.getItemKey())) {
            if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"a479ec06000000ac", (String)"wf_orgtype", (String)"47150e89000000ac")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u67e5\u8be2\u7684\u6743\u9650\u3002", (String)"WorkflowTCDataPlugin_30", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            BaseChangeLogsUtil.queryLog(this.getView(), ORGTYPE);
        }
    }

    public void afterCreateNewData(EventObject e) {
        PluginUtil.setControlInvisible(this.getView(), "baritemap6");
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"a479ec06000000ac", (String)"wf_orgtype", (String)"47150e89000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u67e5\u8be2\u7684\u6743\u9650\u3002", (String)"WorkflowTCDataPlugin_30", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        super.billListHyperLinkClick(args);
    }

    public void listRowClick(ListRowClickEvent evt) {
        if (!DesignerPluginUtil.checkWorkflowInService(this.getView())) {
            return;
        }
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows != null && !rows.isEmpty()) {
            ArrayList<Long> ids = new ArrayList<Long>(rows.size());
            for (ListSelectedRow row : rows) {
                ids.add((Long)row.getPrimaryKeyValue());
            }
            RepositoryService service = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getRepositoryService();
            long count = service.countOrgTypesByState(ids, true);
            if (count == 0L) {
                this.getView().setEnable(Boolean.FALSE, new String[]{BTN_DISABLE});
                this.getView().setEnable(Boolean.TRUE, new String[]{BTN_ENABLE});
            } else if (count == (long)rows.size()) {
                this.getView().setEnable(Boolean.FALSE, new String[]{BTN_ENABLE});
                this.getView().setEnable(Boolean.TRUE, new String[]{BTN_DISABLE});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{BTN_DISABLE, BTN_ENABLE});
            }
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{BTN_DISABLE, BTN_ENABLE});
        }
    }
}

