/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.management.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.util.BaseChangeLogsUtil;
import kd.bos.workflow.design.util.IBaseChangeLogCallBack;
import kd.bos.workflow.design.util.PluginUtil;

public class OrgTypeEditPlugin
extends AbstractWorkflowPlugin {
    public static final String FORM_ID = "wf_orgtype";
    private static final String ORGID = "orgid";
    private static final String ORGNUMBER = "orgnumber";
    private static final String ORGTYPE = "orgtype";
    private static final String ENTRY_ENTITY = "entryentity";

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String propName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if (null != changeSet && 0 != changeSet.length) {
            ChangeData changeSet0 = changeSet[0];
            Object newValue = changeSet0.getNewValue();
            int rowIndex = changeSet0.getRowIndex();
            switch (propName) {
                case "orgid": {
                    this.setOrgInfos(model, newValue, rowIndex);
                    break;
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (!(args.getSource() instanceof Save)) {
            return;
        }
        String number = (String)this.getModel().getValue("number");
        PluginUtil.validateNumber(number, this.getView(), args);
    }

    public void registerListener(EventObject e) {
        Toolbar tbmain = (Toolbar)this.getView().getControl("toolbarap");
        tbmain.addItemClickListener((ItemClickListener)this);
    }

    private void setOrgInfos(IDataModel model, Object newValue, int rowIndex) {
        if (DynamicObject.class.isInstance(newValue)) {
            DynamicObject orgObj = (DynamicObject)newValue;
            Object orgNumber = null;
            if (null != orgObj) {
                orgNumber = orgObj.get("number");
            }
            model.setValue(ORGNUMBER, orgNumber, rowIndex);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getSource() instanceof Save && args.getOperationResult().isSuccess()) {
            String baseFormId = args.getOperationResult().getSuccessPkIds().get(0).toString();
            BaseChangeLogsUtil.addBaseLog(this.getView(), ORGTYPE, FORM_ID, baseFormId, new IBaseChangeLogCallBack(){

                @Override
                public JSONArray getModelArray() {
                    return OrgTypeEditPlugin.this.getViewModelArray();
                }
            });
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BaseChangeLogsUtil.putBaseModelCache(this.getView(), ORGTYPE, new IBaseChangeLogCallBack(){

            @Override
            public JSONArray getModelArray() {
                return OrgTypeEditPlugin.this.getViewModelArray();
            }
        });
    }

    private JSONArray getViewModelArray() {
        JSONArray arr = new JSONArray();
        for (int i = 0; i < this.getModel().getEntryRowCount(ENTRY_ENTITY); ++i) {
            JSONObject org = new JSONObject();
            EntryGrid entryentity = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
            DynamicObject orgEntry = (DynamicObject)entryentity.getModel().getValue(ORGID, i);
            if (null == orgEntry) continue;
            ILocaleString name = orgEntry.getLocaleString("name");
            if (name != null) {
                org.put("org", (Object)name);
            }
            org.put("id", (Object)String.valueOf(orgEntry.getPkValue()));
            org.put("state", this.getView().getControl(ENTRY_ENTITY).getModel().getValue("includesubordinate", i));
            arr.add((Object)org);
        }
        return arr;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (!"baritemap".equalsIgnoreCase(itemKey)) {
            return;
        }
        JSONArray array = this.getViewModelArray();
        if (null == array || array.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OrgTypeEditPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }
}

