/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.management.plugin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDException;
import kd.bos.form.ControlTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeDragEvent;
import kd.bos.form.control.events.TreeNodeDragListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.list.AbstractTreeListView;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ProcessCategoryEntity;
import kd.bos.workflow.engine.impl.util.QueryWrapper;
import kd.bos.workflow.management.plugin.dto.ExtendChain;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import org.apache.commons.collections.CollectionUtils;

public class ProcessCategoryTreeListView
extends AbstractTreeListView
implements TreeNodeQueryListener,
TreeNodeClickListener,
TreeNodeDragListener {
    private static final String CATEGORYID = "categoryid";

    public void initialize(IListView view, TreeView tv) {
        super.initialize(view, tv);
        tv.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void refreshTreeView() {
        try {
            this.refresh();
        }
        catch (KDException e) {
            this.view.showMessage(e.getMessage());
        }
    }

    public void refresh() {
        this.treeview.deleteAllNodes();
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        TreeNode node = new TreeNode();
        ProcessCategoryEntity processCategoryEntity = this.getRepositoryService().getRootProcessCategory();
        String rootId = processCategoryEntity.getId().toString();
        node.setId(rootId);
        if (WfUtils.isNotEmpty((String)processCategoryEntity.getName())) {
            node.setText(processCategoryEntity.getName());
        } else {
            node.setText(ResManager.loadKDString((String)"\u4e1a\u52a1\u4e91", (String)"ProcessCategoryTreeListView_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
        node.setParentid("");
        node.setIsOpened(true);
        node.setChildren(new ArrayList());
        nodes.add(node);
        this.treeview.addNodes(nodes);
        ITreeModel treeModel = ((IListView)this.treeview.getView()).getTreeListView().getTreeModel();
        treeModel.setRoot(node);
        this.treeview.queryTreeNodeChildren("", rootId);
    }

    public void treeNodeDragged(TreeNodeDragEvent arg0) {
    }

    public void queryTreeNodeChildren(TreeNodeEvent nodeEvent) {
        List processCategoryEntities;
        Long parentNodeId = Long.valueOf(nodeEvent.getNodeId().toString());
        RepositoryService repositoryService = this.getRepositoryService();
        String formId = null;
        FormShowParameter parameter = this.getTreeView().getView().getFormShowParameter();
        if (parameter instanceof ListShowParameter) {
            formId = ((ListShowParameter)parameter).getBillFormId();
        }
        if ((processCategoryEntities = repositoryService.getProcateByParentId(parentNodeId, formId)) == null || processCategoryEntities.isEmpty()) {
            return;
        }
        List<String> filter = this.buildChainFilter(processCategoryEntities);
        List result = filter.isEmpty() ? processCategoryEntities : processCategoryEntities.stream().filter(item -> filter.contains(item.getApplicationId())).collect(Collectors.toList());
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(processCategoryEntities.size());
        for (ProcessCategoryEntity processCategoryEntity : result) {
            TreeNode node = new TreeNode();
            node.setId(String.valueOf(processCategoryEntity.getId()));
            node.setText(processCategoryEntity.getName());
            node.setParentid(String.valueOf(parentNodeId));
            node.setIsOpened(processCategoryEntity.isLeaf().booleanValue());
            if (!processCategoryEntity.isLeaf().booleanValue()) {
                node.setChildren(new ArrayList());
            }
            nodes.add(node);
        }
        TreeView tv = (TreeView)nodeEvent.getSource();
        tv.addNodes(nodes);
    }

    private List<String> buildChainFilter(List<ProcessCategoryEntity> processCategoryEntities) {
        if (processCategoryEntities == null || processCategoryEntities.isEmpty()) {
            return new ArrayList<String>(0);
        }
        List factEntity = processCategoryEntities.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getApplicationId()) && item.isLeaf() != false).collect(Collectors.toList());
        if (factEntity.isEmpty()) {
            return new ArrayList<String>(0);
        }
        List metaDataIds = factEntity.stream().map(ProcessCategoryEntity::getApplicationId).collect(Collectors.toList());
        QFilter[] qFilters = new QFilter("id", "in", metaDataIds).toArray();
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"id,masterid,parentid", (QFilter[])qFilters);
        if (query == null || query.isEmpty()) {
            return new ArrayList<String>(0);
        }
        List<ExtendChain> extendChains = ExtendChain.toPOJO(query);
        if (extendChains.isEmpty()) {
            return new ArrayList<String>(0);
        }
        Map<String, ExtendChain> extendChainMap = extendChains.stream().collect(Collectors.toMap(ExtendChain::getId, item -> item));
        ArrayList<ExtendChain> chain = new ArrayList<ExtendChain>();
        for (ExtendChain extendChain : extendChains) {
            if (StringUtils.isEmpty((CharSequence)extendChain.getParentId())) {
                chain.add(extendChain);
                continue;
            }
            if (!extendChainMap.containsKey(extendChain.getParentId())) continue;
            ExtendChain parent = extendChainMap.get(extendChain.getParentId());
            parent.setNext(extendChain);
        }
        HashSet<String> filter = new HashSet<String>(16);
        Iterator iterator = chain.iterator();
        while (iterator.hasNext()) {
            ExtendChain item3;
            ExtendChain current = item3 = (ExtendChain)iterator.next();
            while (current.getNext() != null) {
                current = current.getNext();
            }
            filter.add(current.getId());
        }
        List list = (List)CollectionUtils.subtract(processCategoryEntities, factEntity);
        List collect = list.stream().map(ProcessCategoryEntity::getApplicationId).collect(Collectors.toList());
        filter.addAll(collect);
        return new ArrayList<String>(filter);
    }

    public void treeNodeClick(TreeNodeEvent nodeEvent) {
        Long categoryId;
        String nodeId = (String)nodeEvent.getNodeId();
        QFilter qFilter = null;
        if (this.getRootId().equals(nodeId)) {
            this.refreshBillList(qFilter);
            return;
        }
        RepositoryService repositoryService = this.getRepositoryService();
        List processCategoryEntities = repositoryService.getProcateByParentId(categoryId = Long.valueOf(nodeId));
        if (processCategoryEntities != null && !processCategoryEntities.isEmpty()) {
            Long[] ids = new Long[processCategoryEntities.size()];
            int i = 0;
            for (ProcessCategoryEntity processCategoryEntity : processCategoryEntities) {
                ids[i] = processCategoryEntity.getId();
                ++i;
            }
            qFilter = new QFilter(CATEGORYID, "in", (Object)ids).or(CATEGORYID, "=", (Object)categoryId);
        } else {
            List<Long> ids = this.buildChainIDList(categoryId);
            qFilter = new QFilter(CATEGORYID, "in", ids);
        }
        this.refreshBillList(qFilter);
    }

    private List<Long> buildChainIDList(Long categoryId) {
        ProcessCategoryEntity entity = this.getRepositoryService().getProcateById(categoryId);
        if (entity == null) {
            return new ArrayList<Long>(0);
        }
        String applicationId = entity.getApplicationId();
        if (StringUtils.isEmpty((CharSequence)applicationId)) {
            return Lists.newArrayList((Object[])new Long[]{categoryId});
        }
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bos_devportal_bizapp", (String)"id,masterid,parentid", (QFilter[])new QueryWrapper().eq("id", (Object)applicationId).getQFilters());
        ExtendChain extendChain = ExtendChain.toPOJO(dynamicObject);
        if (StringUtils.isEmpty((CharSequence)extendChain.getMasterId())) {
            return Lists.newArrayList((Object[])new Long[]{categoryId});
        }
        QFilter[] qFilters = new QFilter("masterid", "=", (Object)extendChain.getMasterId()).or("id", "=", (Object)extendChain.getMasterId()).toArray();
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"id,masterid,parentid", (QFilter[])qFilters);
        List applicationIds = ExtendChain.toPOJO(collection).stream().map(ExtendChain::getId).collect(Collectors.toList());
        return this.getRepositoryService().getProcateByApplicationIds(applicationIds).stream().map(Entity::getId).collect(Collectors.toList());
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
    }

    private String getRootId() {
        String rootId = "0";
        ProcessCategoryEntity processCategoryEntity = this.getRepositoryService().getRootProcessCategory();
        rootId = processCategoryEntity.getId().toString();
        return rootId;
    }

    public ITreeModel getTreeModel() {
        if (this.treeModel == null) {
            this.treeModel = new TreeListModel(this.view.getPageId(), this.view.getListModel().getDataEntityType());
            IPageCache pageCache = (IPageCache)this.view.getService(IPageCache.class);
            ((TreeListModel)this.treeModel).setCache(pageCache);
        }
        return this.treeModel;
    }

    private void refreshBillList(QFilter qFilter) {
        this.treeModel = this.getTreeModel();
        QFilter liFilter = this.treeModel.getListFilter();
        FilterParameter fParameter = new FilterParameter();
        if (liFilter == null && qFilter != null) {
            fParameter.setQFilter(qFilter.toSerializedString());
        }
        BillList billList = (BillList)this.view.getControl("billlistap");
        billList.setQueryFilterParameter(fParameter);
        billList.refresh();
        IListDataProvider provider = billList.getListModel().getProvider();
        if (provider != null && provider.getClass() != ListDataProvider.class) {
            this.view.getPageCache().put("treeNodeFilter", ControlTypes.toJsonString((Object)fParameter));
        }
    }

    private RepositoryService getRepositoryService() {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        return wfService.getRepositoryService();
    }
}

