/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.management.plugin;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.bpmn.model.deploy.ExportScheme;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.scheme.model.ImportSchemeParameter;
import kd.bos.workflow.engine.impl.scheme.model.ProcessDiffResult;
import kd.bos.workflow.engine.impl.util.DynamicSchemeUtil;
import kd.bos.workflow.engine.impl.util.ImportExportProcessUtil;

public class SchemeImportPlugin
extends AbstractWorkflowPlugin
implements UploadListener,
IConfirmCallBack {
    private static final String FILESCHEME = ".scheme";
    private static final String BTNOK = "btnok";
    private static final String FILELIST = "_file_list_";
    private static final String FILEMAP = "_file_map_";
    private static final String ACTIONIDIMPORTTIP = "import_tip";
    private DcxmlSerializer serializer = new DcxmlSerializer(ExportScheme.getDCBinder());

    public SchemeImportPlugin() {
        this.serializer.setColloctionIgnorePKValue(true);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK});
        AttachmentPanel attach = (AttachmentPanel)this.getControl("attachmentpanelap");
        attach.addUploadListener((UploadListener)this);
    }

    public void upload(UploadEvent evt) {
        String cacheUrls = this.getPageCache().get(FILELIST);
        List<String> filelist = StringUtils.isBlank((CharSequence)cacheUrls) ? new ArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
        String mapStr = this.getPageCache().get(FILEMAP);
        Map<String, String> fileMap = WfUtils.isEmpty((String)mapStr) ? new HashMap() : (Map)SerializationUtils.fromJsonString((String)mapStr, Map.class);
        for (Object url : evt.getUrls()) {
            Map map = (Map)url;
            String urlStr = (String)map.get("url");
            filelist.add(urlStr);
            fileMap.put(urlStr, (String)map.get("name"));
        }
        this.getPageCache().put(FILELIST, SerializationUtils.serializeToBase64(filelist));
        this.getPageCache().put(FILEMAP, SerializationUtils.toJsonString(fileMap));
    }

    public void remove(UploadEvent evt) {
        String cacheUrls = this.getPageCache().get(FILELIST);
        List filelist = StringUtils.isBlank((CharSequence)cacheUrls) ? new ArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
        String mapStr = this.getPageCache().get(FILEMAP);
        Map fileMap = WfUtils.isEmpty((String)mapStr) ? new HashMap() : (Map)SerializationUtils.fromJsonString((String)mapStr, Map.class);
        for (Object url : evt.getUrls()) {
            Map map = (Map)url;
            String urlStr = (String)map.get("url");
            filelist.remove(urlStr);
            fileMap.remove(urlStr);
        }
        this.getPageCache().put(FILELIST, SerializationUtils.serializeToBase64(filelist));
        this.getPageCache().put(FILEMAP, SerializationUtils.toJsonString(fileMap));
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (BTNOK.equals(key)) {
            this.confirm();
        }
    }

    private void confirm() {
        List<String> filelist = this.validate();
        if (filelist == null) {
            return;
        }
        try {
            this.importSchemeFiles(filelist);
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
            this.logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    private List<String> validate() {
        String cacheUrls = this.getPageCache().get(FILELIST);
        if (StringUtils.isBlank((CharSequence)cacheUrls)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6587\u4ef6\uff0c\u6216\u7b49\u5f85\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210\u3002", (String)"SchemeImportPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return null;
        }
        List filelist = (List)SerializationUtils.deSerializeFromBase64((String)cacheUrls);
        if (filelist == null || filelist.isEmpty()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6587\u4ef6\uff0c\u6216\u7b49\u5f85\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210\u3002", (String)"SchemeImportPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return null;
        }
        return filelist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importSchemeFiles(List<String> filelist) {
        String zipFile = "";
        ArrayList<ImportSchemeParameter> parameters = new ArrayList<ImportSchemeParameter>();
        Map fileMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(FILEMAP), Map.class);
        HashMap<String, String> procFileMap = new HashMap<String, String>();
        for (String url : filelist) {
            zipFile = (String)fileMap.get(url);
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            InputStream inputStream = null;
            try {
                inputStream = cache.getInputStream(url);
                ZipInputStream zipIn = new ZipInputStream((InputStream)new BufferedInputStream(inputStream), Charset.forName("GBK"));
                Throwable throwable = null;
                try {
                    ZipEntry zipEntry = null;
                    while ((zipEntry = zipIn.getNextEntry()) != null) {
                        String name = zipEntry.getName();
                        try {
                            ImportSchemeParameter parameter = this.importSchemeFile(zipFile, zipIn, name, procFileMap);
                            parameters.add(parameter);
                        }
                        finally {
                            zipIn.closeEntry();
                        }
                    }
                    if (!parameters.isEmpty()) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u538b\u7f29\u5305\u4e2d\u7684\u65b9\u6848\u6587\u4ef6\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"SchemeImportPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (zipIn == null) continue;
                    if (throwable != null) {
                        try {
                            zipIn.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    zipIn.close();
                }
            }
            catch (Exception e) {
                this.logger.error(String.format("\u5904\u7406 %s \u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef\uff1a%s", zipFile, WfUtils.getExceptionStacktrace((Throwable)e)));
                throw new KDBizException(e.getMessage());
            }
            finally {
                if (inputStream == null) continue;
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    this.logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
                }
            }
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("parameter", SerializationUtils.toJsonString(parameters));
        this.showForm(ACTIONIDIMPORTTIP, "wf_schemeimport_strategy", params);
    }

    private ImportSchemeParameter importSchemeFile(String zipFilename, ZipInputStream zipIn, String filename, Map<String, String> procFileMap) throws IOException {
        if (!filename.endsWith(FILESCHEME)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u4e2d\u7684\u6587\u4ef6\u4e0d\u5408\u6cd5\uff1a%2$s\u3002", (String)"SchemeImportPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), zipFilename, filename));
        }
        String content = this.getSchemeFileContent(zipIn);
        ImportSchemeParameter parameter = new ImportSchemeParameter();
        parameter.setFilename(filename);
        if (WfUtils.isEmpty((String)content)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\uff1a\u201c%2$s\u201d\u6587\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SchemeImportPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]), zipFilename, filename));
        }
        ExportScheme exportScheme = (ExportScheme)this.serializer.deserializeFromString(content, null);
        if (exportScheme == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u201c%s\u201d\u89e3\u6790\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u6b64\u6587\u4ef6\u662f\u5426\u662f\u6709\u6548\u7684scheme\u6587\u4ef6\u3002", (String)"SchemeImportPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]), filename));
        }
        parameter.setSchemeContent(content);
        List processDefinitions = exportScheme.getProcessDefinitions();
        DynamicObject processDefinition = (DynamicObject)processDefinitions.get(0);
        String entrabill = processDefinition.getString("entrabill");
        String entraBillId = WfUtils.isEmpty((String)processDefinition.getString("entrabillid")) ? processDefinition.getString("entrabillid_id") : processDefinition.getString("entrabillid");
        String number = processDefinition.getString("key");
        String procFile = procFileMap.get(number);
        if (procFile != null) {
            String tip = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u6d41\u7a0b \u4e0e\u201c%2$s\u201d\u4e2d\u7684\u201c%3$s\u201d\u6587\u4ef6\u4e2d\u7684\u6d41\u7a0b\u91cd\u590d\u3002", (String)"SchemeImportPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]), procFile, zipFilename, filename);
            throw new KDBizException(tip);
        }
        procFileMap.put(number, String.format(ResManager.loadKDString((String)"%1$s\u4e2d\u7684%2$s", (String)"SchemeImportPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]), zipFilename, filename));
        if (!QueryServiceHelper.exists((String)"bos_formmeta", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)entrabill), new QFilter("id", "=", (Object)entraBillId)})) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\uff1a\u5355\u636e\u201c%2$s\u201d\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"SchemeImportPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]), filename, entrabill));
        }
        QFilter[] filters = new QFilter[]{new QFilter("key", "=", (Object)number), new QFilter("entrabill", "!=", (Object)entrabill)};
        if (QueryServiceHelper.exists((String)"wf_processdefinition", (QFilter[])filters)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u201c\u6d41\u7a0b\u7f16\u7801\u201d\u4e3a\u201c%s\u201d\u7684\u53e6\u4e00\u5355\u636e\u6d41\u7a0b\uff0c\u6d41\u7a0b\u7ed1\u5b9a\u7684\u5355\u636e\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"SchemeImportPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]), number));
        }
        ImportExportProcessUtil.checkProcessTypeConsistent((String)number, (String)processDefinition.getString("type"), (boolean)true);
        parameter.setName(processDefinition.getString("name"));
        parameter.setNumber(processDefinition.getString("key"));
        RepositoryService service = this.getRepositoryService();
        ProcessDefinitionEntity latestProcDef = service.getLatestProcessDefinitionByKey((String)processDefinition.get("key"));
        if (latestProcDef != null) {
            ResourceEntity resource = service.getResourceById(latestProcDef.getResourceId());
            ProcessDiffResult result = DynamicSchemeUtil.diffProcessNodes((String)resource.getData(), (String)this.getDefaultSchemeResource(exportScheme));
            parameter.setDiffResult(result);
        }
        return parameter;
    }

    private String getSchemeFileContent(ZipInputStream zipIn) throws IOException {
        StringBuilder sb = new StringBuilder();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int len = 0;
        while ((len = zipIn.read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }
        byte[] buff = out.toByteArray();
        sb.append(new String(buff, 0, buff.length, "UTF-8"));
        return sb.toString();
    }

    private String getDefaultSchemeResource(ExportScheme exportScheme) {
        List schemes = exportScheme.getSchemes();
        List resources = exportScheme.getResources();
        for (DynamicObject scheme : schemes) {
            if (!scheme.getBoolean("isdefault")) continue;
            Long resourceId = scheme.getLong("jsonresourceid");
            for (DynamicObject resource : resources) {
                if (!resourceId.equals(resource.get("id"))) continue;
                String data = resource.getString("data");
                return WfUtils.isNotEmpty((String)data) ? data : resource.getString("content");
            }
        }
        return null;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (ACTIONIDIMPORTTIP.equals(actionId)) {
            HashMap<String, Object> datas = new HashMap<String, Object>();
            if (returnData != null) {
                Map returnMap = (Map)returnData;
                if ("finish".equals(returnMap.get("importSchemesResult"))) {
                    datas.put("isSuccess", Boolean.TRUE);
                    datas.put("validateResults", returnMap.get("validateResults"));
                    datas.put("importType", returnMap.get("importType"));
                    datas.put("importName", returnMap.get("importName"));
                    datas.put("processDefinitionIds", returnMap.get("processDefinitionIds"));
                    this.getView().returnDataToParent(datas);
                    this.getView().close();
                } else {
                    datas.put("isSuccess", Boolean.FALSE);
                    datas.put("returnData", returnData);
                    this.getView().returnDataToParent(datas);
                }
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(FILELIST);
    }
}

