/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.management.plugin;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.logging.Log;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.AmountField;
import kd.bos.metadata.entity.businessfield.BasedataPropField;
import kd.bos.metadata.entity.businessfield.ItemClassField;
import kd.bos.metadata.entity.businessfield.QtyField;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.RadioField;
import kd.bos.metadata.entity.commonfield.TimeRangeField;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.Pair;
import kd.bos.workflow.design.util.BillSummaryUtil;
import kd.bos.workflow.engine.WfUtils;

public class WFBillSummaryUtil {
    public static String checkBillSummary(Collection<DynamicObject> billSummarys) {
        StringBuilder result = new StringBuilder();
        MetadataReader reader = new MetadataReader();
        for (DynamicObject billSummary : billSummarys) {
            String scene = billSummary.getString("scene");
            if (BillSummaryUtil.isBillRelationCardSummary(scene) || BillSummaryUtil.isBillRelationStackedCardSummary(scene)) continue;
            DynamicObject billObject = billSummary.getDynamicObject("billtype");
            String billName = billObject.getLocaleString("name").getLocaleValue();
            String billType = billObject.getString("number");
            QFilter qFilter = new QFilter("number", "in", (Object)billType);
            QFilter[] qFilters = new QFilter[]{qFilter};
            boolean exists = QueryServiceHelper.exists((String)"bos_formmeta", (QFilter[])qFilters);
            if (!exists) {
                result.append(ResManager.loadKDString((String)"\u5355\u636e ", (String)"WFBillSummaryUtil_1", (String)"bos-wf-formplugin", (Object[])new Object[0])).append(billName).append(ResManager.loadKDString((String)" \u4e0d\u5b58\u5728;", (String)"WFBillSummaryUtil_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                continue;
            }
            String entityId = reader.loadIdByNumber(billType, MetaCategory.Entity);
            EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
            Map<String, EntityItem<?>> mapItems = WFBillSummaryUtil.getItems(entityMetadata);
            DynamicObjectCollection cfgEntries = billSummary.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < cfgEntries.size(); ++i) {
                DynamicObject object = (DynamicObject)cfgEntries.get(i);
                String fieldkey = object.getString("fieldkey");
                if (mapItems.get(fieldkey) != null) continue;
                result.append(ResManager.loadKDString((String)"\u5355\u636e ", (String)"WFBillSummaryUtil_1", (String)"bos-wf-formplugin", (Object[])new Object[0])).append(billName).append(ResManager.loadKDString((String)" \u91cc\u7684\u5b57\u6bb5 ", (String)"WFBillSummaryUtil_3", (String)"bos-wf-formplugin", (Object[])new Object[0])).append(fieldkey).append(ResManager.loadKDString((String)" \u4e0d\u5b58\u5728;", (String)"WFBillSummaryUtil_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            }
        }
        return result.toString();
    }

    public static Map<String, EntityItem<?>> getItems(EntityMetadata entityMetadata) {
        List items = entityMetadata.getItems();
        HashMap mapItems = new HashMap(items.size());
        for (EntityItem item : items) {
            mapItems.put(item.getKey(), item);
        }
        return mapItems;
    }

    public static Pair<String, String> getStartAndEndKey(EntityItem<?> entity) {
        String startKey = null;
        String endKey = null;
        if (entity instanceof DateRangeField) {
            startKey = ((DateRangeField)entity).getStartDateFieldKey();
            endKey = ((DateRangeField)entity).getEndDateFieldKey();
        } else if (entity instanceof TimeRangeField) {
            startKey = ((TimeRangeField)entity).getStartDateFieldKey();
            endKey = ((TimeRangeField)entity).getEndDateFieldKey();
        }
        return new Pair((Object)startKey, (Object)endKey);
    }

    public static void previewBizFlowBillSummary(DynamicObject dynamicObject, IFormView iFormView) {
        String billSummaryTplNumber = dynamicObject.getString("summarytplnum");
        DynamicObject billSummaryInfo = BusinessDataServiceHelper.loadSingle((String)"bos_formmeta", (String)"id,inheritpath", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)billSummaryTplNumber)});
        String inheritPath = billSummaryInfo.getString("inheritpath");
        if (inheritPath != null && inheritPath.contains("0DAJMH01ONG/")) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId(billSummaryTplNumber);
            OpenStyle style = new OpenStyle();
            StyleCss cssStyle = new StyleCss();
            cssStyle.setHeight("560");
            cssStyle.setWidth("960");
            style.setInlineStyleCss(cssStyle);
            style.setShowType(ShowType.Modal);
            formShowParameter.setOpenStyle(style);
            iFormView.showForm(formShowParameter);
        } else if (inheritPath != null && inheritPath.contains("0CI/=D/PV8F0")) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId(billSummaryTplNumber);
            OpenStyle style = new OpenStyle();
            StyleCss cssStyle = new StyleCss();
            cssStyle.setHeight("200");
            cssStyle.setWidth("320");
            style.setInlineStyleCss(cssStyle);
            style.setShowType(ShowType.Modal);
            formShowParameter.setOpenStyle(style);
            iFormView.showForm(formShowParameter);
        }
    }

    public static boolean editable(DynamicObject mobileConfig) {
        DynamicObjectCollection configfields = (DynamicObjectCollection)mobileConfig.get("entryentity");
        if (configfields != null && !configfields.isEmpty()) {
            for (int i = 0; i < configfields.size(); ++i) {
                DynamicObject configField = (DynamicObject)configfields.get(i);
                if (!configField.getBoolean("editable")) continue;
                return true;
            }
        }
        return false;
    }

    public static Object[] getAttachementValue(DynamicObjectCollection attachments) {
        if (attachments != null && !attachments.isEmpty()) {
            int size = attachments.size();
            Object[] attIds = new Object[size];
            for (int k = 0; k < size; ++k) {
                DynamicObject attachement = (DynamicObject)attachments.get(k);
                attIds[k] = attachement.get("fbasedataid_id");
            }
            return attIds;
        }
        return new Object[0];
    }

    public static String getRefPropFieldId(EntityItem<?> entryItemField) {
        String refPropFieldId = null;
        if (entryItemField instanceof BasedataPropField) {
            refPropFieldId = ((BasedataPropField)entryItemField).getRefBaseFieldId();
        } else if (entryItemField instanceof AmountField) {
            refPropFieldId = ((AmountField)entryItemField).getCurrencyFieldId();
        } else if (entryItemField instanceof ItemClassField) {
            refPropFieldId = ((ItemClassField)entryItemField).getTypeFieldId();
        } else if (entryItemField instanceof RadioField) {
            refPropFieldId = ((RadioField)entryItemField).getGroup();
        } else if (entryItemField instanceof QtyField) {
            refPropFieldId = ((QtyField)entryItemField).getUnitFieldId();
        }
        return refPropFieldId;
    }

    public static void setRefParentPropFieldValue(String fieldType, String fieldKey, String refParentPropFieldKey, DynamicObject dynamicObject, IDataModel model, Log log, Integer index) {
        if (null == dynamicObject) {
            return;
        }
        if (!"ItemClassField".equals(fieldType)) {
            return;
        }
        if (WfUtils.isEmpty((String)refParentPropFieldKey)) {
            try {
                refParentPropFieldKey = ((ItemClassProp)model.getDataEntityType().getProperty(fieldKey)).getTypePropName();
            }
            catch (Exception e) {
                log.info("setRefParentPropFieldValue error:" + WfUtils.getExceptionStacktrace((Throwable)e));
            }
        }
        if (WfUtils.isEmpty((String)refParentPropFieldKey) || !dynamicObject.getDataEntityType().getProperties().containsKey((Object)refParentPropFieldKey)) {
            return;
        }
        if (null != index) {
            model.setValue(refParentPropFieldKey, dynamicObject.get(refParentPropFieldKey), index.intValue());
        } else {
            model.setValue(refParentPropFieldKey, dynamicObject.get(refParentPropFieldKey));
        }
    }
}

