/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.management.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.businessfield.AmountField;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.BillNoField;
import kd.bos.metadata.entity.businessfield.BillStatusField;
import kd.bos.metadata.entity.businessfield.CityField;
import kd.bos.metadata.entity.businessfield.CreaterField;
import kd.bos.metadata.entity.businessfield.CurrencyField;
import kd.bos.metadata.entity.businessfield.MaterielField;
import kd.bos.metadata.entity.businessfield.ModifierField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.businessfield.OrgField;
import kd.bos.metadata.entity.businessfield.PriceField;
import kd.bos.metadata.entity.businessfield.QtyField;
import kd.bos.metadata.entity.businessfield.UnitField;
import kd.bos.metadata.entity.businessfield.UserField;
import kd.bos.metadata.entity.commonfield.AdminDivisionField;
import kd.bos.metadata.entity.commonfield.AttachmentField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.EmailField;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.MuliLangTextField;
import kd.bos.metadata.entity.commonfield.RadioField;
import kd.bos.metadata.entity.commonfield.TelephoneField;
import kd.bos.metadata.entity.commonfield.TextAreaField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.entity.commonfield.TimeField;
import kd.bos.metadata.entity.commonfield.TimeRangeField;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;

public class WFSensitiveFieldConfigFieldPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
TreeNodeCheckListener {
    private static final String FTARGETPROPS = "ftargetprops";
    private static final String BTNOK = "btnok";
    private static final String BTNREMOVE = "btnremove";
    private static final String TREEROOTNODE = "treerootnode";
    private static final String FIELDID = "fieldid";
    private static final String FTNAME = "ftname";
    private static final String FIELDNAME = "fieldname";
    private static final String FIELDFULLNAME = "fieldfullname";
    private static final String FIELDKEY = "fieldkey";
    private static final String FIELDTYPE = "fieldtype";
    private static final String ENTRYLOCATION = "entrylocation";
    private static final String ENTRYLOCATIONNAME = "entrylocationname";

    public void initialize() {
        this.addClickListeners(new String[]{BTNOK, BTNREMOVE});
        EntryGrid grid = (EntryGrid)this.getControl(FTARGETPROPS);
        grid.addRowClickListener((RowClickEventListener)this);
        TreeView fieldtree = (TreeView)this.getView().getControl("fieldtree");
        fieldtree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        int sensitiveFieldCount = WfConfigurationUtil.getSensitiveFieldsCount();
        String tips = ResManager.loadKDString((String)"\u6700\u591a\u53ef\u9009\u62e9\u201c%s\u201d\u4e2a\u5173\u952e\u5b57\u6bb5\u3002", (String)"WFSensitiveFieldConfigFieldPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        this.getModel().setValue("tips", (Object)String.format(tips, sensitiveFieldCount));
    }

    public void afterCreateNewData(EventObject e) {
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entityNumber");
        MetadataReader reader = new MetadataReader();
        String fid = reader.loadIdByNumber(entityNumber, MetaCategory.Entity);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)fid, (MetaCategory)MetaCategory.Entity);
        List entities = entityMetadata.getRootEntity().getItems();
        ArrayList<Object> listHead = new ArrayList<Object>(entities.size());
        ArrayList<Object> listEntry = new ArrayList<Object>(entities.size());
        for (EntityItem field : entities) {
            if (!this.filterField(field)) continue;
            if (field instanceof EntryEntity) {
                listEntry.add(field);
                continue;
            }
            listHead.add(field);
        }
        TreeView tree = (TreeView)this.getView().getControl("fieldtree");
        TreeNode root = new TreeNode();
        root.setId(entityMetadata.getId());
        root.setLongNumber(entityMetadata.getKey());
        root.setText(entityMetadata.getName().toString());
        root.setIsOpened(true);
        this.setHeadTreeNode(root, listHead);
        this.setEntryTreeNode(root, listEntry);
        tree.addNode(root);
        this.getPageCache().put(TREEROOTNODE, SerializationUtils.toJsonString((Object)root));
        Object configfields = this.getView().getFormShowParameter().getCustomParams().get("configfields");
        if (configfields == null) {
            return;
        }
        if (configfields instanceof Map) {
            String fieldsStr = (String)((Map)configfields).get("sensitiveFieldData");
            List fields = (List)SerializationUtils.fromJsonString((String)fieldsStr, List.class);
            ArrayList<TreeNode> checkNodes = new ArrayList<TreeNode>(fields.size());
            this.getModel().deleteEntryData(FTARGETPROPS);
            for (Map field : fields) {
                String fieldId = (String)field.get(FIELDID);
                TreeNode node = root.getTreeNode(fieldId, 16);
                checkNodes.add(node);
                int rowindex = this.getModel().createNewEntryRow(FTARGETPROPS);
                Map json = (Map)field.get(FIELDNAME);
                this.getModel().setValue(FTNAME, json.get(RequestContext.get().getLang().toString()), rowindex);
                this.getModel().setValue("ftid", (Object)fieldId, rowindex);
            }
            tree.checkNodes(checkNodes);
        }
    }

    private boolean filterField(EntityItem<?> field) {
        return field instanceof ModifierField || field instanceof CreaterField || field instanceof BillNoField || field instanceof BillStatusField || field instanceof UserField || field instanceof DateTimeField || field instanceof OrgField || field instanceof CityField || field instanceof MaterielField || field instanceof CurrencyField || field instanceof UnitField || field instanceof PriceField || field instanceof QtyField || field instanceof EmailField || field instanceof AmountField || field instanceof TelephoneField || field instanceof AdminDivisionField || field instanceof IntegerField || field instanceof DecimalField || field instanceof TextAreaField || field instanceof MuliLangTextField || field instanceof DateRangeField || field instanceof TimeField || field instanceof TimeRangeField || field instanceof CheckBoxField || field instanceof RadioField || field instanceof ComboField || field instanceof BasedataField || field instanceof TextField || field instanceof MulBasedataField && !(field instanceof AttachmentField) || field instanceof EntryEntity && !((EntryEntity)field).getItems().isEmpty();
    }

    private void setEntryTreeNode(TreeNode root, List<Object> listEntry) {
        for (int i = 0; i < listEntry.size(); ++i) {
            EntryEntity field = (EntryEntity)listEntry.get(i);
            TreeNode node = new TreeNode();
            node.setParentid(root.getId());
            node.setId(field.getId());
            node.setLongNumber(field.getName().getLocaleValue());
            node.setText(field.getName().getLocaleValue());
            List entryItems = field.getItems();
            for (EntityItem entryField : entryItems) {
                if (entryField instanceof EntryEntity || !this.filterField(entryField)) continue;
                TreeNode entryNode = new TreeNode();
                entryNode.setParentid(node.getId());
                entryNode.setId(entryField.getId());
                entryNode.setLongNumber(entryField.getName().getLocaleValue());
                entryNode.setText(entryField.getName().getLocaleValue());
                HashMap<String, String> data = new HashMap<String, String>();
                data.put(FIELDKEY, entryField.getKey());
                data.put(FIELDTYPE, entryField.getClass().getSimpleName());
                data.put(FIELDFULLNAME, this.changeLocaleStringToString(entryField.getName()));
                data.put(ENTRYLOCATION, field.getKey());
                data.put(ENTRYLOCATIONNAME, this.changeLocaleStringToString(field.getName()));
                entryNode.setData(data);
                node.addChild(entryNode);
            }
            root.addChild(node);
        }
    }

    private void setHeadTreeNode(TreeNode root, List<Object> listHead) {
        for (int i = 0; i < listHead.size(); ++i) {
            EntityItem field = (EntityItem)listHead.get(i);
            TreeNode node = new TreeNode();
            node.setParentid(root.getId());
            node.setId(field.getId());
            node.setText(field.getName().getLocaleValue());
            HashMap<String, String> data = new HashMap<String, String>();
            data.put(FIELDKEY, field.getKey());
            data.put(FIELDTYPE, field.getClass().getSimpleName());
            data.put(FIELDFULLNAME, this.changeLocaleStringToString(field.getName()));
            node.setData(data);
            root.addChild(node);
        }
    }

    private String changeLocaleStringToString(LocaleString localeString) {
        HashMap<String, Object> map = new HashMap<String, Object>(WfUtils.getSupportLangs().length);
        for (Lang lang : WfUtils.getSupportLangs()) {
            map.put(lang.name(), localeString.get((Object)lang.name()));
        }
        return SerializationUtils.toJsonString(map);
    }

    private LocaleString changeMapToLocaleString(String mapString) {
        LocaleString localeString = new LocaleString();
        if (WfUtils.isNotEmpty((String)mapString)) {
            Map map = (Map)SerializationUtils.fromJsonString((String)mapString, Map.class);
            for (Lang lang : WfUtils.getSupportLangs()) {
                localeString.put(lang.name(), map.get(lang.name()));
            }
        }
        return localeString;
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (BTNREMOVE.equals(key)) {
            this.delete();
        } else if (BTNOK.equals(key)) {
            this.confirm();
        }
    }

    private void confirm() {
        ArrayList listFields = new ArrayList();
        DynamicObjectCollection fields = this.getModel().getEntryEntity(FTARGETPROPS);
        int sensitiveFieldCount = WfConfigurationUtil.getSensitiveFieldsCount();
        if (sensitiveFieldCount < fields.size()) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6700\u591a\u53ef\u9009\u62e9\u201c%s\u201d\u4e2a\u5173\u952e\u5b57\u6bb5\u3002", (String)"WFSensitiveFieldConfigFieldPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]), sensitiveFieldCount));
            return;
        }
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREEROOTNODE), TreeNode.class);
        LocaleString showText = new LocaleString();
        for (DynamicObject field : fields) {
            String fieldId = field.getString("ftid");
            TreeNode node = root.getTreeNode(fieldId, 16);
            if (node == null) continue;
            HashMap<String, String> map = new HashMap<String, String>(30);
            Map nodeData = (Map)node.getData();
            LocaleString fieldName = this.changeMapToLocaleString((String)nodeData.get(FIELDFULLNAME));
            showText = WfMultiLangUtils.jointILocaleString((ILocaleString)showText, (ILocaleString)fieldName, (String)"\uff0c ");
            map.put(FIELDID, fieldId);
            map.put(FIELDNAME, (String)fieldName);
            map.put(FIELDKEY, (String)nodeData.get(FIELDKEY));
            map.put(FIELDTYPE, (String)nodeData.get(FIELDTYPE));
            map.put(ENTRYLOCATION, (String)nodeData.get(ENTRYLOCATION));
            map.put(ENTRYLOCATIONNAME, (String)this.changeMapToLocaleString((String)nodeData.get(ENTRYLOCATIONNAME)));
            listFields.add(map);
        }
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        returnData.put("showtext", showText);
        returnData.put("sensitiveFieldData", SerializationUtils.toJsonString(listFields));
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    private void delete() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(FTARGETPROPS);
        int[] rows = grid.getEntryState().getSelectedRows();
        if (rows == null || rows.length == 0) {
            StandardTips.view((IFormView)this.getView()).notSelectRow();
            return;
        }
        ArrayList<String> nodeIds = new ArrayList<String>();
        for (int row : rows) {
            if (row < 0) continue;
            nodeIds.add((String)this.getModel().getValue("ftid", row));
        }
        this.getModel().deleteEntryRows(FTARGETPROPS, rows);
        TreeView tree = (TreeView)this.getView().getControl("FieldTree");
        tree.uncheckNodes(nodeIds);
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        String fieldId = evt.getNodeId().toString();
        if (evt.getChecked().booleanValue()) {
            TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREEROOTNODE), TreeNode.class);
            TreeNode node = root.getTreeNode(fieldId, 16);
            if (node.getChildren() == null) {
                int index = this.getModel().createNewEntryRow(FTARGETPROPS);
                this.getModel().setValue("ftid", (Object)node.getId(), index);
                this.getModel().setValue(FTNAME, (Object)node.getText(), index);
            } else {
                ArrayList<String> childrenNodeIds = new ArrayList<String>();
                ArrayList<TreeNode> childrenNodes = new ArrayList<TreeNode>();
                this.getChildrenNodeIds(childrenNodeIds, childrenNodes, node);
                ArrayList<Integer> deleteFieldIndexs = new ArrayList<Integer>();
                DynamicObjectCollection fields = this.getModel().getEntryEntity(FTARGETPROPS);
                for (int i = 0; i < fields.size(); ++i) {
                    DynamicObject field = (DynamicObject)fields.get(i);
                    if (field == null || !childrenNodeIds.contains(field.get("ftid"))) continue;
                    deleteFieldIndexs.add(i);
                }
                int[] delFieldIndexs = new int[deleteFieldIndexs.size()];
                for (int i = 0; i < deleteFieldIndexs.size(); ++i) {
                    delFieldIndexs[i] = (Integer)deleteFieldIndexs.get(i);
                }
                this.getModel().deleteEntryRows(FTARGETPROPS, delFieldIndexs);
                for (TreeNode childNode : childrenNodes) {
                    int index = this.getModel().createNewEntryRow(FTARGETPROPS);
                    this.getModel().setValue("ftid", (Object)childNode.getId(), index);
                    this.getModel().setValue(FTNAME, (Object)childNode.getText(), index);
                }
            }
        } else {
            TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREEROOTNODE), TreeNode.class);
            TreeNode node = root.getTreeNode(fieldId, 16);
            ArrayList<String> childrenNodeIds = new ArrayList<String>();
            if (node.getChildren() == null) {
                childrenNodeIds.add(fieldId);
            } else {
                List childrenNodes = node.getChildren();
                for (TreeNode childNode : childrenNodes) {
                    if (childNode.getChildren() != null && !childNode.getChildren().isEmpty()) {
                        List childrenNodez = childNode.getChildren();
                        for (TreeNode childrenNode : childrenNodez) {
                            childrenNodeIds.add(childrenNode.getId());
                        }
                        continue;
                    }
                    childrenNodeIds.add(childNode.getId());
                }
            }
            ArrayList<Integer> deleteFieldIndexs = new ArrayList<Integer>();
            DynamicObjectCollection fields = this.getModel().getEntryEntity(FTARGETPROPS);
            for (int i = 0; i < fields.size(); ++i) {
                DynamicObject field = (DynamicObject)fields.get(i);
                if (field == null || !childrenNodeIds.contains(field.get("ftid"))) continue;
                deleteFieldIndexs.add(i);
            }
            int[] delFieldIndexs = new int[childrenNodeIds.size()];
            for (int i = 0; i < deleteFieldIndexs.size(); ++i) {
                delFieldIndexs[i] = (Integer)deleteFieldIndexs.get(i);
            }
            this.getModel().deleteEntryRows(FTARGETPROPS, delFieldIndexs);
        }
    }

    private void getChildrenNodeIds(List<String> childrenNodeIds, List<TreeNode> nodes, TreeNode node) {
        List childrenNodes = node.getChildren();
        if (childrenNodes != null && !childrenNodes.isEmpty()) {
            for (TreeNode childNode : childrenNodes) {
                if (childNode.getChildren() != null && !childNode.getChildren().isEmpty()) {
                    this.getChildrenNodeIds(childrenNodeIds, nodes, childNode);
                    continue;
                }
                childrenNodeIds.add(childNode.getId());
                nodes.add(childNode);
            }
        }
    }
}

