/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.management.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.formop.NewEntry;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.formula.FormulaEngine;
import kd.bos.lang.Lang;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BillTypeField;
import kd.bos.metadata.entity.businessfield.FlexField;
import kd.bos.metadata.entity.businessfield.RefBillField;
import kd.bos.metadata.entity.businessfield.UserAvatarField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.GeoPointField;
import kd.bos.metadata.entity.commonfield.LargeTextField;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.api.IWorkflowService;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.bpmn.converter.util.CollectionUtils;
import kd.bos.workflow.design.util.BillSummaryUtil;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.BillSummaryType;
import kd.bos.workflow.management.plugin.WFBillSummaryUtil;

public class WfBillSummaryMobCfg
extends AbstractBasePlugIn {
    private static final String REF_PARENT_PROP_FIELD_ID = "refparentpropfieldid";
    private static final String SUMMARYTPL = "summarytpl";
    private static final String SUMMARYTPLNUM = "summarytplnum";
    private static final String NUMBER = "number";
    private static final String BILLTYPE = "billtype";
    private static final String ENTRYENTITY = "entryentity";
    private static final String FIELDNAME = "fieldname";
    private static final String FIELDID = "fieldid";
    private static final String FIELDKEY = "fieldkey";
    private static final String FIELDTYPE = "fieldtype";
    private static final String ISHEADFIELD = "isheadfield";
    private static final String ENTRYLOCATION = "entrylocation";
    private static final String ENTRYLOCATIONID = "entrylocationid";
    private static final String ENTRYLOCATIONNAME = "entrylocationname";
    private static final String ISDEFAULTSHOW = "isdefaultshow";
    private static final String FIELDPERCENT = "fieldpercent";
    private static final String FONTCOLOR = "fontcolor";
    private static final String FONTSIZE = "fontsize";
    private static final String EDITABLE = "editable";
    private static final String AGGREGATEFUNCTION = "aggregatefunction";
    private static final String MOBILEBILLSUMMARYTPLID = "/Y1MTDFYI0H0";
    private static final String FLOATCHARTBILLSUMMARYTPLID = "0DAJMH01ONG/";
    private static final String FlOATLAYERSUMMARYTPLID = "0CI/=D/PV8F0";
    private static final String INHERITPATH = "inheritpath";
    private static final String SCENE = "scene";
    private static final String SHOWCONTENT = "showcontent";
    public static final String SHOWCONTENT_MUL = "showcontent_mul";
    private static final String FLEXDEFAULTROWS = "flex_defaultrows";
    private static final String BOSFORMMETA = "bos_formmeta";
    private static final String BTN_CONFIGFIELD = "configfield";
    private static final String BTN_ADDNEWENTRY = "addnewentry";
    private static final String PANEL_TIPS = "tipspanel";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addClickListeners(new String[]{SUMMARYTPL, SHOWCONTENT});
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void afterBindData(EventObject e) {
        if (OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus()) || OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            String summaryTplNum = (String)this.getModel().getValue(SUMMARYTPLNUM);
            if (StringUtils.isBlank((CharSequence)summaryTplNum)) {
                return;
            }
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)BOSFORMMETA, (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)summaryTplNum)});
            String summaryTpl = dynamicObject.getLocaleString("name").getLocaleValue();
            this.getModel().setValue(SUMMARYTPL, (Object)summaryTpl);
        }
        String scene = (String)this.getModel().getValue(SCENE);
        if (!BillSummaryType.mobileSummary.name().equals(scene)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEXDEFAULTROWS});
        }
        if (BillSummaryUtil.isBillRelationCardSummary(scene)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_ADDNEWENTRY, PANEL_TIPS});
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_CONFIGFIELD});
        }
        if (BillSummaryUtil.isBillRelationStackedCardSummary(scene)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{PANEL_TIPS});
        }
        if (!WfConfigurationUtil.getMBillSummaryIsEdit()) {
            EntryGrid entry = (EntryGrid)this.getControl(ENTRYENTITY);
            entry.setColumnProperty(EDITABLE, "vi", (Object)Boolean.FALSE);
        }
        this.initContentByMulLang();
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (SUMMARYTPL.equals(key)) {
            this.selectBillSummaryTpl();
        } else if (SHOWCONTENT.equals(key)) {
            this.editShowContent(key);
        }
    }

    private void initContentByMulLang() {
        EntryGrid control = (EntryGrid)this.getControl(ENTRYENTITY);
        EntryData entryData = control.getEntryData();
        for (DynamicObject dataEntity : entryData.getDataEntitys()) {
            ILocaleString localeString = dataEntity.getLocaleString(SHOWCONTENT_MUL);
            String showContent = Optional.ofNullable((String)dataEntity.get(SHOWCONTENT)).orElseGet(() -> "");
            if (this.emptyLocaleString(localeString)) {
                LocaleString contentMul = new LocaleString();
                contentMul.put(RequestContext.get().getLang().name(), (Object)showContent);
                contentMul.put("GLang", (Object)showContent);
                dataEntity.set(SHOWCONTENT_MUL, (Object)contentMul);
                continue;
            }
            dataEntity.set(SHOWCONTENT, (Object)localeString.toString());
        }
        this.getView().updateView(ENTRYENTITY);
    }

    private boolean emptyLocaleString(ILocaleString localeString) {
        if (localeString == null || localeString.isEmpty()) {
            return true;
        }
        for (String value : localeString.values()) {
            if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
            return false;
        }
        return true;
    }

    private void editShowContent(String key) {
        Object tpl = this.getModel().getValue(SUMMARYTPLNUM);
        if (BillSummaryUtil.isBillRelationStackedCardSummaryForm(tpl)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u4ec5\u652f\u6301\u8f93\u5165\uff0c\u4e0d\u652f\u6301\u9009\u62e9\u8868\u8fbe\u5f0f\u3002 ", (String)"WfBillSummaryMobCfg_16", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(BILLTYPE);
        params.put("entityNumber", dynamicObject.get(NUMBER));
        params.put("FROM", "MSG");
        ILocaleString value = (ILocaleString)this.getModel().getValue(SHOWCONTENT_MUL);
        if (WfUtils.isNotEmpty((ILocaleString)value)) {
            params.put("value", SerializationUtils.toJsonString((Object)value));
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        parameter.setFormId("wf_billsubject_light_mul");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParams(params);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        parameter.setCaption(ResManager.loadKDString((String)"\u663e\u793a\u5185\u5bb9 ", (String)"WfBillSummaryMobCfg_11", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        parameter.setHasRight(true);
        parameter.getCustomParams().put("isIgnoreLicense", Boolean.TRUE);
        this.getView().showForm(parameter);
    }

    private void selectBillSummaryTpl() {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)BOSFORMMETA, (boolean)false);
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u5355\u636e\u6458\u8981\u6a21\u677f\u5217\u8868", (String)"WfBillSummaryMobCfg_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        listShowParameter.setFormId("wf_choosebillsummary");
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "choosebillsummary"));
        ListFilterParameter filterParameter = new ListFilterParameter();
        QFilter qFilter1 = new QFilter(INHERITPATH, "match", (Object)MOBILEBILLSUMMARYTPLID);
        QFilter qFilter2 = new QFilter(INHERITPATH, "match", (Object)FLOATCHARTBILLSUMMARYTPLID);
        QFilter qFilter3 = new QFilter(INHERITPATH, "match", (Object)FlOATLAYERSUMMARYTPLID);
        QFilter cardFilter = new QFilter("id", "=", (Object)"1M=9GUOBIYOA");
        QFilter stackedCardFilter = new QFilter("id", "=", (Object)"1WU107IES6MG");
        String processType = (String)this.getView().getParentView().getFormShowParameter().getCustomParam("processType");
        if (ProcessType.AuditFlow.name().equals(processType)) {
            filterParameter.setFilter(qFilter1);
        } else {
            filterParameter.setFilter(qFilter1.or(qFilter2.or(qFilter3)).or(cardFilter).or(stackedCardFilter));
        }
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.add((String)this.getModel().getValue(SUMMARYTPLNUM));
        filterParameter.setSelectFields(selectFields);
        listShowParameter.setListFilterParameter(filterParameter);
        listShowParameter.setCustomParam("value", this.getModel().getValue(SUMMARYTPLNUM));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "configfield": {
                this.showConfigFieldPage();
                break;
            }
            case "advconbaritemap_del": {
                this.advConbarItemapDel();
                break;
            }
        }
    }

    private void showConfigFieldPage() {
        DynamicObject billType = (DynamicObject)this.getModel().getValue(BILLTYPE);
        if (billType == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5355\u636e\u201d\u3002", (String)"WfBillSummaryMobCfg_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("wf_configfield");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam(BILLTYPE, (Object)billType);
        formShowParameter.setCustomParam(SCENE, this.getModel().getValue(SCENE));
        List<Map<String, Object>> configFields = this.getConfigFields();
        formShowParameter.setCustomParam("configfields", configFields);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "configfieldcallback"));
        this.getView().showForm(formShowParameter);
    }

    private List<Map<String, Object>> getConfigFields() {
        ArrayList<Map<String, Object>> configFields = new ArrayList<Map<String, Object>>();
        DynamicObjectCollection fields = this.getModel().getEntryEntity(ENTRYENTITY);
        for (DynamicObject field : fields) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(FIELDNAME, field.get(FIELDNAME));
            map.put(FIELDID, field.get(FIELDID));
            map.put(FIELDKEY, field.get(FIELDKEY));
            map.put(FIELDTYPE, field.get(FIELDTYPE));
            map.put(ISHEADFIELD, field.get(ISHEADFIELD));
            map.put(ENTRYLOCATION, field.get(ENTRYLOCATION));
            map.put(ENTRYLOCATIONID, field.get(ENTRYLOCATIONID));
            map.put(ISDEFAULTSHOW, field.get(ISDEFAULTSHOW));
            map.put(FIELDPERCENT, field.get(FIELDPERCENT));
            map.put(FONTCOLOR, field.get(FONTCOLOR));
            map.put(FONTSIZE, field.get(FONTSIZE));
            map.put(EDITABLE, field.get(EDITABLE));
            map.put(SHOWCONTENT, field.get(SHOWCONTENT));
            map.put(SHOWCONTENT_MUL, field.get(SHOWCONTENT_MUL));
            map.put(AGGREGATEFUNCTION, field.get(AGGREGATEFUNCTION));
            configFields.add(map);
        }
        return configFields;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() != null && "configfieldcallback".equals(e.getActionId())) {
            List configFields = (List)e.getReturnData();
            if (configFields != null && !configFields.isEmpty()) {
                this.getModel().deleteEntryData(ENTRYENTITY);
                this.getModel().beginInit();
                TableValueSetter setter = new TableValueSetter(new String[0]);
                for (int i = 0; i < configFields.size(); ++i) {
                    Map field = (Map)configFields.get(i);
                    setter.set(FIELDKEY, field.get(FIELDKEY), i);
                    setter.set(FIELDID, field.get(FIELDID), i);
                    setter.set(FIELDNAME, field.get(FIELDNAME), i);
                    setter.set(ISHEADFIELD, field.get(ISHEADFIELD), i);
                    setter.set(FIELDTYPE, field.get(FIELDTYPE), i);
                    setter.set(ENTRYLOCATION, field.get(ENTRYLOCATION), i);
                    setter.set(ENTRYLOCATIONID, field.get(ENTRYLOCATIONID), i);
                    setter.set(ENTRYLOCATIONNAME, field.get(ENTRYLOCATIONNAME), i);
                    setter.set(ISDEFAULTSHOW, field.get(ISDEFAULTSHOW), i);
                    setter.set(FIELDPERCENT, field.get(FIELDPERCENT), i);
                    setter.set(FONTCOLOR, field.get(FONTCOLOR), i);
                    setter.set(FONTSIZE, field.get(FONTSIZE), i);
                    setter.set(EDITABLE, field.get(EDITABLE), i);
                    setter.set(SHOWCONTENT, field.get(SHOWCONTENT), i);
                    setter.set(SHOWCONTENT_MUL, (Object)this.toLocalSting(field.get(SHOWCONTENT_MUL)), i);
                    setter.set(AGGREGATEFUNCTION, field.get(AGGREGATEFUNCTION), i);
                    setter.set(REF_PARENT_PROP_FIELD_ID, field.get(REF_PARENT_PROP_FIELD_ID), i);
                }
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                model.batchCreateNewEntryRow(ENTRYENTITY, setter);
                model.endInit();
                this.getView().updateView(ENTRYENTITY);
            } else {
                this.getModel().deleteEntryData(ENTRYENTITY);
            }
        } else if (e.getReturnData() != null && "choosebillsummary".equals(e.getActionId())) {
            JSONObject ret = (JSONObject)e.getReturnData();
            Object formId = ret.get((Object)"formnumber");
            this.getModel().setValue(SUMMARYTPL, ret.get((Object)"formname"));
            this.getModel().setValue(SUMMARYTPLNUM, formId);
            if (BillSummaryUtil.isBillRelationCardSummaryForm(formId) || BillSummaryUtil.isBillRelationStackedCardSummaryForm(formId)) {
                this.getModel().deleteEntryData(ENTRYENTITY);
            }
        } else if (e.getReturnData() != null && SHOWCONTENT.equals(e.getActionId())) {
            Map ret = (Map)e.getReturnData();
            ILocaleString customSubject = (ILocaleString)ret.get("customSubject");
            this.getModel().setValue(SHOWCONTENT_MUL, (Object)customSubject);
            this.getModel().setValue(SHOWCONTENT, (Object)customSubject.toString());
        }
    }

    public ILocaleString toLocalSting(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof JSONObject) {
            JSONObject json = (JSONObject)o;
            Map map = (Map)json.toJavaObject(Map.class);
            return LocaleString.fromMap((Map)map);
        }
        return new LocaleString(o + "");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldId = e.getProperty().getName();
        if (BILLTYPE.equals(fieldId)) {
            this.resetConfigFields();
        } else if (SUMMARYTPLNUM.equals(fieldId)) {
            String summaryTplNum = (String)this.getModel().getValue(SUMMARYTPLNUM);
            QFilter qFilter = new QFilter(NUMBER, "=", (Object)summaryTplNum);
            DynamicObject billInfo = BusinessDataServiceHelper.loadSingle((String)BOSFORMMETA, (String)INHERITPATH, (QFilter[])new QFilter[]{qFilter});
            String inheritPath = billInfo.getString(INHERITPATH);
            if (inheritPath != null && inheritPath.contains(MOBILEBILLSUMMARYTPLID)) {
                this.getModel().setValue(SCENE, (Object)BillSummaryType.mobileSummary.name());
                this.getView().setVisible(Boolean.FALSE, new String[]{BTN_ADDNEWENTRY, PANEL_TIPS});
                this.getView().setVisible(Boolean.TRUE, new String[]{FLEXDEFAULTROWS, BTN_CONFIGFIELD});
            } else if (inheritPath != null && inheritPath.contains(FLOATCHARTBILLSUMMARYTPLID)) {
                this.getModel().setValue(SCENE, (Object)BillSummaryType.flowchartSummary.name());
                this.getView().setVisible(Boolean.FALSE, new String[]{FLEXDEFAULTROWS, BTN_ADDNEWENTRY, PANEL_TIPS});
                this.getView().setVisible(Boolean.TRUE, new String[]{BTN_CONFIGFIELD});
            } else if (inheritPath != null && inheritPath.contains(FlOATLAYERSUMMARYTPLID)) {
                this.getModel().setValue(SCENE, (Object)BillSummaryType.floatlayerSummary.name());
                this.getView().setVisible(Boolean.FALSE, new String[]{FLEXDEFAULTROWS, BTN_ADDNEWENTRY, PANEL_TIPS});
                this.getView().setVisible(Boolean.TRUE, new String[]{BTN_CONFIGFIELD});
            } else if (BillSummaryUtil.isBillRelationCardSummary(billInfo)) {
                this.getModel().setValue(SCENE, (Object)BillSummaryType.billRelationCardSummary.name());
                this.getView().setVisible(Boolean.FALSE, new String[]{FLEXDEFAULTROWS, BTN_CONFIGFIELD});
                this.getView().setVisible(Boolean.TRUE, new String[]{BTN_ADDNEWENTRY, PANEL_TIPS});
            } else if (BillSummaryUtil.isBillRelationStackedCardSummary(billInfo)) {
                this.getModel().setValue(SCENE, (Object)BillSummaryType.billRelationStackedCardSummary.name());
                this.getView().setVisible(Boolean.FALSE, new String[]{FLEXDEFAULTROWS, BTN_ADDNEWENTRY});
                this.getView().setVisible(Boolean.TRUE, new String[]{BTN_CONFIGFIELD, PANEL_TIPS});
            }
            this.resetConfigFields();
        } else if (SHOWCONTENT.equals(fieldId)) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            ILocaleString contentMul = (ILocaleString)this.getModel().getValue(SHOWCONTENT_MUL);
            contentMul.put((Object)RequestContext.get().getLang().name(), (Object)(newValue + ""));
            if (contentMul.containsKey((Object)"GLang")) {
                contentMul.put((Object)"GLang", (Object)(newValue + ""));
            }
        }
    }

    private void resetConfigFields() {
        this.getModel().deleteEntryData(ENTRYENTITY);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Save) {
            List<String> resultList = this.validateRules();
            if (CollectionUtils.isNotEmpty(resultList)) {
                args.setCancel(true);
                this.showOperationResult(resultList);
            } else {
                OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
                LocaleString content = new LocaleString();
                for (Lang lang : WfUtils.getSupportLangs()) {
                    if (WfUtils.isEmpty((String)name.get((Object)lang.name()))) {
                        content.put((Object)lang.name(), (Object)name.getLocaleValue());
                        continue;
                    }
                    content.put((Object)lang.name(), (Object)name.get((Object)lang.name()));
                }
                this.getModel().setValue("name", (Object)content);
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
            for (DynamicObject item : entryEntity) {
                if (!StringUtils.isEmpty((CharSequence)item.getString(SHOWCONTENT))) continue;
                ILocaleString localeString = item.getLocaleString(SHOWCONTENT_MUL);
                item.set(SHOWCONTENT, (Object)localeString.toString());
            }
        } else if (args.getSource() instanceof NewEntry && this.getModel().getValue(BILLTYPE) == null) {
            args.setCancel(true);
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5355\u636e\u201d\u3002", (String)"WfBillSummaryMobCfg_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String scene = (String)this.getModel().getValue(SCENE);
        if (!BillSummaryType.mobileSummary.name().equals(scene)) {
            return;
        }
        if ("save".equals(operate.getType()) && args.getOperationResult().isSuccess()) {
            DynamicObject billSummaryConfigObjects = this.getModel().getDataEntity();
            IWorkflowService wfService = (IWorkflowService)ServiceFactory.getService(IWorkflowService.class);
            wfService.rebuildBillSummaryConfigRuntimeMeta(billSummaryConfigObjects);
        }
    }

    private List<String> validateRules() {
        ArrayList errList = Lists.newArrayList();
        String number = (String)this.getModel().getValue(NUMBER);
        if (MetadataDao.checkNumber((String)number)) {
            errList.add(ResManager.loadKDString((String)"\u5f00\u53d1\u5e73\u53f0\u6216\u5355\u636e\u6458\u8981\u5217\u8868\u5b58\u5728\u7f16\u7801\u91cd\u590d\u3002", (String)"WfBillSummaryMobCfg_4", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
        if (WfUtils.isNotEmpty((String)number) && number.endsWith("_mob")) {
            errList.add(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u4e0d\u80fd\u4ee5\u201c_mob\u201d\u7ed3\u5c3e\u3002", (String)"WfBillSummaryMobCfg_17", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
        String scene = (String)this.getModel().getValue(SCENE);
        ArrayList<String> fieldKeys = new ArrayList<String>();
        DynamicObjectCollection configFields = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRYENTITY);
        if (configFields != null && !configFields.isEmpty()) {
            int headField = 0;
            HashMap<String, Integer> entryColumn = new HashMap<String, Integer>();
            for (DynamicObject dynamicObject : configFields) {
                String entryKey;
                Integer integer;
                fieldKeys.add(dynamicObject.getString(FIELDKEY));
                if (dynamicObject.getBoolean(ISHEADFIELD)) {
                    ++headField;
                    continue;
                }
                if (BillSummaryType.floatlayerSummary.name().equals(scene)) {
                    errList.add(ResManager.loadKDString((String)"\u6d6e\u52a8\u5c42\u5355\u636e\u6458\u8981\u4e0d\u80fd\u9009\u5206\u5f55\u5b57\u6bb5\u3002", (String)"WfBillSummaryMobCfg_15", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                }
                if ((integer = (Integer)entryColumn.get(entryKey = dynamicObject.getString(ENTRYLOCATION))) != null) {
                    Integer n = integer;
                    Integer n2 = integer = Integer.valueOf(integer + 1);
                    entryColumn.put(entryKey, integer);
                    continue;
                }
                entryColumn.put(entryKey, 1);
            }
            String entityNum = (String)this.getModel().getValue("billtype_Id");
            MetadataReader reader = new MetadataReader();
            String entityId = reader.loadIdByNumber(entityNum, MetaCategory.Entity);
            EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
            List items = entityMetadata.getItems();
            HashMap<String, EntityItem> mapItems = new HashMap<String, EntityItem>(items.size());
            for (EntityItem item : items) {
                mapItems.put(item.getKey(), item);
            }
            for (DynamicObject dynamicObject : configFields) {
                String fontSize;
                String fontColor;
                boolean percentIsMatch;
                String fieldName = dynamicObject.getString(FIELDNAME);
                String fieldPercent = dynamicObject.getString(FIELDPERCENT);
                if (StringUtils.isNotBlank((CharSequence)fieldPercent) && !(percentIsMatch = Pattern.matches("^[0-9]{1,3}px$", fieldPercent)) && !(percentIsMatch = Pattern.matches("^[0-9]{1,2}%$", fieldPercent))) {
                    errList.add(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u7684\u201c\u5b57\u6bb5\u5360\u6bd4\u201d\u53ea\u80fd\u662f\u6574\u6570\uff0c\u4f8b\u598230%2$s\u621630px\u3002", (String)"WfBillSummaryMobCfg_7", (String)"bos-wf-formplugin", (Object[])new Object[0]), fieldName, Character.valueOf('%')));
                }
                if (StringUtils.isNotBlank((CharSequence)(fontColor = dynamicObject.getString(FONTCOLOR))) && !fontColor.startsWith("#")) {
                    errList.add(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%s\u201d\u7684\u989c\u8272\u5fc5\u987b\u4ee5\u201c#\u201d\u5f00\u5934\uff0c\u6bd4\u5982\u201c#ffffff\u201d\u3002", (String)"WfBillSummaryMobCfg_8", (String)"bos-wf-formplugin", (Object[])new Object[0]), fieldName));
                }
                if (StringUtils.isNotBlank((CharSequence)(fontSize = dynamicObject.getString(FONTSIZE)))) {
                    int parseInt = Integer.parseInt(fontSize);
                    if (parseInt < 0) {
                        errList.add(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5 %s \u5b57\u4f53\u5927\u5c0f\u5fc5\u987b\u6b63\u6570\uff0c\u6bd4\u598212\u3002", (String)"WfBillSummaryMobCfg_9", (String)"bos-wf-formplugin", (Object[])new Object[0]), fieldName));
                    }
                    if (parseInt > 30) {
                        errList.add(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%s\u201d\u7684\u5b57\u53f7\u6700\u5927\u53ef\u8bbe\u7f6e\u4e3a30\u3002", (String)"WfBillSummaryMobCfg_10", (String)"bos-wf-formplugin", (Object[])new Object[0]), fieldName));
                    }
                }
                if (BillSummaryType.mobileSummary.name().equals(scene)) {
                    String[] vars;
                    Map mustInputConditionObj;
                    Field field;
                    Field fieldById;
                    String fieldKey = dynamicObject.getString(FIELDKEY);
                    EntityItem entityItem = (EntityItem)mapItems.get(fieldKey);
                    String refBaseFieldId = WFBillSummaryUtil.getRefPropFieldId(entityItem);
                    if (WfUtils.isNotEmpty((String)refBaseFieldId) && null != (fieldById = entityMetadata.getFieldById(refBaseFieldId)) && !fieldKeys.contains(fieldById.getKey())) {
                        errList.add(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5173\u8054\u7684\u5b57\u6bb5\u201c%2$s\u201d\u9700\u8981\u4e00\u8d77\u4f7f\u7528\u3002", (String)"WfBillSummaryMobCfg_12", (String)"bos-wf-formplugin", (Object[])new Object[0]), fieldName, fieldById.getName()));
                    }
                    if (!dynamicObject.getBoolean(EDITABLE) || !(entityItem instanceof Field) || !(field = (Field)entityItem).isMustInput() || !WfUtils.isNotEmptyForMap((Map)(mustInputConditionObj = field.getMustInputCondition())) || !Objects.nonNull(mustInputConditionObj.get("RuleCondition"))) continue;
                    for (String curField : vars = FormulaEngine.extractVariables((String)String.valueOf(mustInputConditionObj.get("RuleCondition")))) {
                        if (fieldKeys.contains(curField)) continue;
                        EntityItem entryItemField = (EntityItem)mapItems.get(curField);
                        if (entryItemField instanceof Field && (entryItemField instanceof RefBillField || entryItemField instanceof UserAvatarField || entryItemField instanceof BillTypeField || entryItemField instanceof FlexField || entryItemField instanceof GeoPointField || entryItemField instanceof LargeTextField && "largeText".equals(((LargeTextField)entryItemField).getEditingMode()))) {
                            errList.add(String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u201c%1$s\u201d\u7684\u5fc5\u5f55\u6761\u4ef6\u662f\u5426\u5f15\u7528\u4e86\u79fb\u52a8\u5355\u636e\u6458\u8981\u4e0d\u652f\u6301\u914d\u7f6e\u7684\u5b57\u6bb5\u3002", (String)"WfBillSummaryMobCfg_18", (String)"bos-wf-formplugin", (Object[])new Object[0]), field.getName(), curField));
                            continue;
                        }
                        errList.add(String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u662f\u5426\u672a\u914d\u7f6e\u201c%1$s\u201d\u5fc5\u5f55\u6761\u4ef6\u5f15\u7528\u7684\u5b57\u6bb5\u3002", (String)"WfBillSummaryMobCfg_19", (String)"bos-wf-formplugin", (Object[])new Object[0]), field.getName()));
                    }
                    continue;
                }
                if (!BillSummaryType.flowchartSummary.name().equals(scene)) continue;
                if (headField >= 40) {
                    errList.add(ResManager.loadKDString((String)"\u5355\u636e\u5934\u5b57\u6bb5\u4e0d\u80fd\u8d85\u8fc740\u4e2a\u3002", (String)"WfBillSummaryMobCfg_13", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                }
                for (Map.Entry entry : entryColumn.entrySet()) {
                    if ((Integer)entry.getValue() <= 30) continue;
                    errList.add(String.format(ResManager.loadKDString((String)"\u5206\u5f55(%s)\u5b57\u6bb5\u4e0d\u80fd\u8d85\u8fc730\u4e2a\u3002", (String)"WfBillSummaryMobCfg_14", (String)"bos-wf-formplugin", (Object[])new Object[0]), entry.getKey()));
                }
            }
        } else {
            errList.add(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5b57\u6bb5\u4fe1\u606f\u201d\u3002", (String)"WfBillSummaryMobCfg_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
        return errList;
    }

    private void showOperationResult(List<String> errList) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_operationresult");
        parameter.setPageId(UUID.randomUUID().toString());
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setShowTitle(false);
        JSONArray jsonArray = new JSONArray();
        int errorSize = 0;
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        for (String errMsg : errList) {
            jsonArray.add((Object)errMsg);
            ++errorSize;
        }
        if (errorSize == 1) {
            this.getView().showErrorNotification(jsonArray.get(0).toString());
            return;
        }
        customParams.put("title", ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"WfBillSummaryMobCfg_20", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        customParams.put("errorMsg", jsonArray);
        customParams.put("message", ResManager.loadKDString((String)"\u8bf7\u6839\u636e\u6821\u9a8c\u7ed3\u679c\u8c03\u6574\u914d\u7f6e\u540e\u91cd\u65b0\u4fdd\u5b58\u3002", (String)"WfBillSummaryMobCfg_21", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        customParams.put("hasMore", false);
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }

    private void advConbarItemapDel() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRYENTITY);
        int[] rows = grid.getEntryState().getSelectedRows();
        DynamicObjectCollection fields = this.getModel().getEntryEntity(ENTRYENTITY);
        if (rows == null || rows.length == 0 || null == fields || fields.isEmpty()) {
            StandardTips.view((IFormView)this.getView()).notSelectRow();
            return;
        }
        boolean isStackedCardTpl = BillSummaryUtil.isBillRelationStackedCardSummary(String.valueOf(this.getModel().getValue(SCENE)));
        HashSet<Integer> rowsForRefChildPropFieldSet = new HashSet<Integer>(rows.length);
        StringBuilder refParentPropFieldIdsSb = new StringBuilder();
        Object refParentPropFieldIdsObj = null;
        Object fieldType = null;
        for (int row : rows) {
            if (row < 0) break;
            if (isStackedCardTpl) continue;
            rowsForRefChildPropFieldSet.add(row);
            fieldType = this.getModel().getValue(FIELDTYPE, row);
            if (!"BasedataField".equals(fieldType) && !"CurrencyField".equals(fieldType) && !"ItemClassTypeField".equals(fieldType) && !"RadioGroupField".equals(fieldType) && !"UnitField".equals(fieldType) || WfUtils.isNotEmptyString((Object)(refParentPropFieldIdsObj = this.getModel().getValue(REF_PARENT_PROP_FIELD_ID, row)))) continue;
            refParentPropFieldIdsSb.append(this.getModel().getValue(FIELDID, row)).append(",");
        }
        if (0 == refParentPropFieldIdsSb.length()) {
            this.getModel().deleteEntryRows(ENTRYENTITY, rows);
            return;
        }
        String refParentPropFieldIdsStr = refParentPropFieldIdsSb.toString();
        int fieldsSize = fields.size();
        DynamicObject refChildPropFieldDynObj = null;
        String refParentPropFieldIdObj = null;
        for (int row = 0; row < fieldsSize; ++row) {
            if (rowsForRefChildPropFieldSet.contains(row) || null == (refChildPropFieldDynObj = (DynamicObject)fields.get(row)) || WfUtils.isEmptyString((Object)(refParentPropFieldIdObj = refChildPropFieldDynObj.getString(REF_PARENT_PROP_FIELD_ID))) || !refParentPropFieldIdsStr.contains(refParentPropFieldIdObj.toString())) continue;
            rowsForRefChildPropFieldSet.add(row);
        }
        if (rowsForRefChildPropFieldSet.isEmpty()) {
            return;
        }
        rows = new int[rowsForRefChildPropFieldSet.size()];
        int index = 0;
        for (Object e : rowsForRefChildPropFieldSet) {
            rows[index] = (Integer)e;
            ++index;
        }
        this.getModel().deleteEntryRows(ENTRYENTITY, rows);
    }
}

