/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.management.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.api.IWorkflowService;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.design.util.PluginUtil;
import kd.bos.workflow.design.util.ProcessInstancePluginUtil;
import kd.bos.workflow.engine.impl.util.BillSummaryType;
import kd.bos.workflow.management.plugin.WFBillSummaryUtil;

public class WfBillSummaryMobCfgList
extends AbstractListPlugin {
    private static final String ENABLE = "enable";
    private static final String NUMBER = "number";
    private static final String SCENE = "scene";
    private static final String FORMID = "wf_mbillsummary_cfg";
    private static final String BTNPREVIEW = "btnpreview";

    public void setFilter(SetFilterEvent e) {
        String processType = (String)this.getView().getFormShowParameter().getCustomParam("processType");
        if (ProcessType.AuditFlow.name().equals(processType)) {
            List qFilters = e.getQFilters();
            qFilters.add(new QFilter(SCENE, "=", (Object)"mobileSummary"));
            e.setCustomQFilters(qFilters);
        }
        e.setOrderBy("modifytime desc");
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        String processType = (String)this.getView().getFormShowParameter().getCustomParam("processType");
        if (ProcessType.AuditFlow.name().equals(processType)) {
            IListColumn sceneColumn = args.getListColumn(SCENE);
            sceneColumn.setColumnOrderAndFilter(false);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (BTNPREVIEW.equals(key)) {
            this.preview();
        }
    }

    private void preview() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)RequestContext.get().getCurrUserId(), (String)this.getPermissionAppId(), (String)FORMID, (String)"47150e89000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u67e5\u8be2\u7684\u6743\u9650\u3002", (String)"WorkflowTCDataPlugin_30", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows == null || rows.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"WfBillSummaryMobCfgList_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        Long primaryKeyValue = (Long)rows.get(0).getPrimaryKeyValue();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)FORMID);
        if (!dynamicObject.getBoolean(ENABLE)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u542f\u7528\u540e\u518d\u9884\u89c8\u3002", (String)"WfBillSummaryMobCfgList_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!BillSummaryType.mobileSummary.name().equals(dynamicObject.getString(SCENE))) {
            WFBillSummaryUtil.previewBizFlowBillSummary(dynamicObject, this.getView());
        } else {
            String number = dynamicObject.getString(NUMBER);
            HashMap<String, String> para = new HashMap<String, String>();
            para.put("formId", "bos_mobilepreview");
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
            showParameter.setCustomParam("modelType", (Object)"MobileBillFormModel");
            showParameter.setCustomParam(NUMBER, (Object)number);
            showParameter.setCustomParam("billsummarynumber", (Object)number);
            showParameter.setCustomParam("billtype", ((DynamicObject)dynamicObject.get("billtype")).get(NUMBER));
            showParameter.setClientParam("preview", (Object)"true");
            showParameter.setAppId(this.getView().getFormShowParameter().getAppId());
            showParameter.setCaption(ResManager.loadKDString((String)"\u79fb\u52a8\u5355\u636e\u6458\u8981\u9884\u89c8", (String)"WfBillSummaryMobCfgList_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            showParameter.setCustomParam("hasright", (Object)Boolean.TRUE);
            showParameter.setCustomParam("isIgnoreLicense", (Object)Boolean.TRUE);
            showParameter.setCustomParam(SCENE, (Object)FORMID);
            showParameter.setCustomParam("configfields", dynamicObject.get("entryentity"));
            showParameter.setCustomParam("SOURCE", (Object)"WF");
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
            showParameter.getOpenStyle().setTargetKey("_submaintab_");
            this.getView().getParentView().showForm(showParameter);
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().showForm(showParameter);
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        int size = rows.size();
        if (size == 0) {
            this.getView().setEnable(Boolean.TRUE, new String[]{BTNPREVIEW});
        } else if (size == 1) {
            Long primaryKeyValue = (Long)rows.get(0).getPrimaryKeyValue();
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)FORMID);
            if (BillSummaryType.mobileSummary.name().equals(dynamicObject.getString(SCENE))) {
                this.getView().setEnable(Boolean.TRUE, new String[]{BTNPREVIEW});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{BTNPREVIEW});
            }
        } else if (rows.size() >= 2) {
            this.getView().setEnable(Boolean.FALSE, new String[]{BTNPREVIEW});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if (ENABLE.equals(operate.getType())) {
            ListSelectedRowCollection listSelectedData = args.getListSelectedData();
            Object[] pkIds = new Long[listSelectedData.size()];
            for (int i = 0; i < listSelectedData.size(); ++i) {
                ListSelectedRow listSelectedRow = listSelectedData.get(i);
                pkIds[i] = Long.valueOf(listSelectedRow.toString());
            }
            Map billSummaryConfigObjects = BusinessDataServiceHelper.loadFromCache((Object[])pkIds, (String)FORMID);
            String result = WFBillSummaryUtil.checkBillSummary(billSummaryConfigObjects.values());
            if (StringUtils.isNotBlank((CharSequence)result)) {
                this.getView().showMessage(result);
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if (ENABLE.equals(operate.getType()) && args.getOperationResult().isSuccess()) {
            List idList = args.getOperationResult().getSuccessPkIds();
            Object[] pkIds = new Long[idList.size()];
            for (int i = 0; i < idList.size(); ++i) {
                pkIds[i] = Long.valueOf(idList.get(i).toString());
            }
            Map billSummaryConfigObjects = BusinessDataServiceHelper.loadFromCache((Object[])pkIds, (String)FORMID);
            IWorkflowService wfService = (IWorkflowService)ServiceFactory.getService(IWorkflowService.class);
            for (DynamicObject mobileConfig : billSummaryConfigObjects.values()) {
                if (!BillSummaryType.mobileSummary.name().equals(mobileConfig.getString(SCENE))) continue;
                wfService.rebuildBillSummaryConfigRuntimeMeta(mobileConfig);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        PluginUtil.setControlInvisible(this.getView(), "tblclose");
    }

    private String getPermissionAppId() {
        return ProcessInstancePluginUtil.getPermissionAppId(this.getView());
    }
}

