/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.management.plugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IconProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.AbstractElement;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.businessfield.FlexField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.businessfield.UserAvatarField;
import kd.bos.metadata.entity.commonfield.BigIntField;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.IconField;
import kd.bos.metadata.entity.commonfield.PictureField;
import kd.bos.metadata.entity.commonfield.TimeRangeField;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.management.plugin.util.TreeBuilderUtil;

public class WfBusinessMappingFieldListPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
TreeNodeCheckListener {
    private static final String TARGET_PROPS = "targetprops";
    private static final String FIELD_TREE = "fieldtree";
    private static final String CHECK_NODES = "checkNodes";
    private static final String INVALID_NODES = "invalidNodes";
    private static final String TNAME = "tname";
    private static final String ENTRA_BILL_ID = "entrabillid";
    private static final String ENTRA_BILL_NUMBER = "entrabillnumber";
    private static final Class<?>[] HIDE_FIELD_ARR = new Class[]{PictureField.class, MulBasedataField.class, IconField.class, FlexField.class, UserAvatarField.class, TimeRangeField.class, DateRangeField.class, PictureProp.class, MulBasedataProp.class, IconProp.class, FlexProp.class};

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btnremove"});
        EntryGrid grid = (EntryGrid)this.getControl(TARGET_PROPS);
        grid.addRowClickListener((RowClickEventListener)this);
        TreeView fieldtree = (TreeView)this.getView().getControl(FIELD_TREE);
        fieldtree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ENTRA_BILL_ID);
        if (StringUtils.isBlank((CharSequence)entityId)) {
            return;
        }
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        Map<String, Object> params = this.buildParam();
        TreeView tree = (TreeView)this.getView().getControl(FIELD_TREE);
        TreeNode root = TreeBuilderUtil.buildEntityTree(entityMetadata, params);
        tree.addNode(root);
        if (root.getChildren() == null) {
            root.setDisabled(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u914d\u7f6e\u7684\u5b57\u6bb5\u3002", (String)"WfBusinessMappingFieldListPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        root.getChildren().forEach(node -> node.setParentid(root.getId()));
        Object value = this.getView().getFormShowParameter().getCustomParams().get("value");
        String[] selectFields = new String[]{};
        if (StringUtils.isNotBlank(value)) {
            selectFields = ((String)value).split(";");
        }
        ArrayList<String> checkNodeIds = new ArrayList<String>(selectFields.length);
        ArrayList<TreeNode> checkNodes = new ArrayList<TreeNode>(selectFields.length);
        ArrayList<String> invalidNodeIds = new ArrayList<String>(selectFields.length);
        for (int i = 0; i < selectFields.length; ++i) {
            String nodeId = selectFields[i];
            TreeNode treeNode = root.getTreeNode(nodeId, 16);
            if (treeNode != null && !checkNodeIds.contains(nodeId)) {
                checkNodeIds.add(nodeId);
                checkNodes.add(treeNode);
                continue;
            }
            invalidNodeIds.add(nodeId);
        }
        tree.checkNodes(checkNodes);
        this.getPageCache().put(FIELD_TREE, SerializationUtils.toJsonString((Object)root));
        this.getPageCache().put(CHECK_NODES, SerializationUtils.toJsonString(checkNodeIds));
        this.getPageCache().put(INVALID_NODES, SerializationUtils.toJsonString(invalidNodeIds));
        this.getModel().deleteEntryData(TARGET_PROPS);
        HashSet<String> nodeIdsSet = new HashSet<String>(checkNodeIds.size());
        for (int i = 0; i < selectFields.length; ++i) {
            String nodeId = selectFields[i];
            TreeNode node2 = root.getTreeNode(nodeId, 16);
            if (node2 == null || !nodeIdsSet.add(nodeId)) continue;
            int rowindex = this.getModel().createNewEntryRow(TARGET_PROPS);
            this.getModel().setValue(TNAME, (Object)node2.getId(), rowindex);
            this.getModel().setValue("ftdisplayname", (Object)node2.getText(), rowindex);
        }
    }

    private Map<String, Object> buildParam() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        String fieldType = (String)this.getView().getFormShowParameter().getCustomParam("fieldType");
        Optional.ofNullable(fieldType).ifPresent(x -> {
            if (Date.class.getName().equals(fieldType)) {
                param.put("onlyDateFieldType", Boolean.TRUE);
                param.put("isHideEntry", Boolean.TRUE);
            } else if (BigDecimal.class.getName().equals(fieldType)) {
                param.put("onlyBigDecimalFieldType", Boolean.TRUE);
                param.put("isHideEntry", Boolean.TRUE);
            } else {
                param.put("filterDateAndBigDecimalType", Boolean.TRUE);
            }
        });
        param.put("isHideSubEntry", Boolean.TRUE);
        if (!WfConfigurationUtil.isTaskBusinessFieldSupportBigIntField()) {
            param.put("ingnoreFieldArr", ArrayUtils.add((Object[])HIDE_FIELD_ARR, BigIntField.class));
        } else {
            param.put("ingnoreFieldArr", HIDE_FIELD_ARR);
        }
        return param;
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        Control source = (Control)evt.getSource();
        if (TARGET_PROPS.equals(source.getKey())) {
            this.delete();
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("btnremove".equals(key)) {
            this.delete();
        } else if ("btnok".equals(key)) {
            this.returnData();
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(FIELD_TREE), TreeNode.class);
        TreeView tree = (TreeView)this.getView().getControl(FIELD_TREE);
        List currChecks = tree.getTreeState().getCheckedNodeIds();
        List checkNodes = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(CHECK_NODES), List.class);
        if (evt.getChecked().booleanValue()) {
            if (checkNodes.isEmpty() || currChecks.removeAll(checkNodes)) {
                currChecks.forEach(id -> {
                    TreeNode node = root.getTreeNode(id, 16);
                    if (node != null && node.getChildren() == null) {
                        int row = this.getModel().createNewEntryRow(TARGET_PROPS);
                        this.getModel().setValue(TNAME, (Object)node.getId(), row);
                        this.getModel().setValue("ftdisplayname", (Object)node.getText(), row);
                    }
                });
            }
        } else if (currChecks.isEmpty() || checkNodes.removeAll(currChecks)) {
            for (int i = 0; i < checkNodes.size(); ++i) {
                TreeNode node = root.getTreeNode((String)checkNodes.get(i), 16);
                if (node == null || node.getChildren() == null) continue;
                checkNodes.remove(i);
            }
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int i = this.getModel().getEntryRowCount(TARGET_PROPS) - 1; i >= 0; --i) {
                if (!checkNodes.contains(this.getModel().getValue(TNAME, i))) continue;
                list.add(i);
            }
            int[] rows = list.stream().mapToInt(Integer::valueOf).toArray();
            this.getModel().deleteEntryRows(TARGET_PROPS, rows);
        }
        this.getPageCache().put(CHECK_NODES, SerializationUtils.toJsonString((Object)tree.getTreeState().getCheckedNodeIds()));
    }

    protected void returnData() {
        Object entranceFlag;
        ArrayList<Map<String, Object>> fieldList = new ArrayList<Map<String, Object>>();
        int invalidValueCount = this.setInvaildValue(fieldList);
        String entryName = null;
        boolean hasMoreEntry = false;
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ENTRA_BILL_ID);
        if (entityId == null) {
            return;
        }
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        Map<String, String> entitys = entityMetadata.getEntitys().stream().filter(entity -> entity instanceof EntryEntity).collect(Collectors.toMap(AbstractElement::getKey, AbstractElement::getKey));
        for (DynamicObject field : this.getModel().getEntryEntity(TARGET_PROPS)) {
            HashMap<String, String> fMap = new HashMap<String, String>();
            fMap.put("name", field.getString(TNAME));
            String f = field.getString(TNAME);
            String[] arr = f.split("\\.");
            if (f.contains(".") && arr.length > 1 && entitys.get(arr[0]) != null) {
                String entity2 = arr[0];
                if (StringUtils.isNotBlank(entryName) && !entity2.equals(entryName)) {
                    hasMoreEntry = true;
                    break;
                }
                entryName = entity2;
                fMap.put("entryName", entryName);
            }
            fieldList.add(fMap);
        }
        if ((entranceFlag = this.getView().getFormShowParameter().getCustomParam("entranceFlag")) == null) {
            if (hasMoreEntry) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u652f\u6301\u914d\u7f6e\u6765\u540c\u4e00\u5206\u5f55\u7684\u4e0d\u540c\u5b57\u6bb5\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"WfBusinessMappingFieldListPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            String fieldType = (String)this.getView().getFormShowParameter().getCustomParam("fieldType");
            if (StringUtils.isNotBlank((CharSequence)fieldType) && (Date.class.getName().equals(fieldType) || BigDecimal.class.getName().equals(fieldType)) && fieldList.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u5b57\u7c7b\u578b\u548c\u65e5\u671f\u7c7b\u578b\u53ea\u80fd\u9009\u62e91\u4e2a\u5b57\u6bb5\u3002", (String)"WfBusinessMappingFieldListPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            if (fieldList.size() > 3) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ef\u8bbe\u7f6e3\u4e2a\u5355\u4e2a\u5217\u8868\u5b57\u6bb5\u5bf9\u5e94\u7684\u4e1a\u52a1\u5b57\u6bb5\u7ec4\u5408\u3002", (String)"WfBusinessMappingFieldListPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
        } else if ("pluginParams".equals((String)entranceFlag) && fieldList.size() - invalidValueCount > 10) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53c2\u6570\u503c\u7684\u4e2a\u6570\u6700\u591a\u53ef\u8bbe\u7f6e10\u4e2a\u3002", (String)"WfBusinessMappingFieldListPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().returnDataToParent(fieldList);
        this.getView().close();
    }

    private int setInvaildValue(List<Map<String, Object>> fieldList) {
        List invalidNodeIds;
        if (this.getPageCache().get(INVALID_NODES) != null && WfUtils.isNotEmptyForCollection((Collection)(invalidNodeIds = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(INVALID_NODES), List.class)))) {
            for (String nodeId : invalidNodeIds) {
                HashMap<String, String> fMap = new HashMap<String, String>(1);
                fMap.put("name", nodeId);
                fieldList.add(fMap);
            }
            return invalidNodeIds.size();
        }
        return 0;
    }

    private void delete() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(TARGET_PROPS);
        int[] rows = grid.getEntryState().getSelectedRows();
        if (rows == null || rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u79fb\u9664\u7684\u884c\u3002", (String)"WfBusinessMappingFieldListPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        IDataModel model = this.getModel();
        ArrayList<String> nodeIds = new ArrayList<String>();
        for (int row : rows) {
            if (row < 0) continue;
            nodeIds.add((String)model.getValue(TNAME, row));
        }
        model.deleteEntryRows(TARGET_PROPS, rows);
        TreeView tree = (TreeView)this.getView().getControl(FIELD_TREE);
        tree.uncheckNodes(nodeIds);
        this.getPageCache().put(CHECK_NODES, SerializationUtils.toJsonString((Object)tree.getTreeState().getCheckedNodeIds()));
    }
}

