/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.management.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.lang.Lang;
import kd.bos.list.IListView;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.design.util.BillSummaryUtil;

public class WfChooseBillSummary
extends AbstractListPlugin
implements ClickListener {
    private static final String NUMBER = "number";

    public void afterCreateNewData(EventObject e) {
        if (!Lang.zh_CN.equals((Object)Lang.get())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"operate"});
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            this.returnData();
        }
    }

    private void returnData() {
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        if (selectedRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c!", (String)"WfChooseBillSummary_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRow listSelectedRow = selectedRows.get(0);
        String formId = listSelectedRow.getPrimaryKeyValue().toString();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)formId, (String)"bos_formmeta", (String)NUMBER);
        String formNumber = dynamicObject.getString(NUMBER);
        String formName = dynamicObject.getLocaleString("name").getLocaleValue();
        JSONObject ret = new JSONObject();
        ret.put("formnumber", (Object)formNumber);
        ret.put("formname", (Object)formName);
        this.getView().returnDataToParent((Object)ret);
        this.getView().close();
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if (NUMBER.equals(fieldName)) {
            args.setCancel(true);
            this.returnData();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing) {
            this.previewBillSummary(args.getListSelectedData());
            args.setCancel(true);
        }
    }

    private void previewBillSummary(ListSelectedRowCollection listSelectedRowCollection) {
        String formId = listSelectedRowCollection.get(0).getPrimaryKeyValue().toString();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)formId, (String)"bos_formmeta");
        String billSummaryTplNumber = dynamicObject.getString(NUMBER);
        String inheritPath = dynamicObject.getString("inheritpath");
        if (inheritPath != null && (inheritPath.contains("/Y1MTDFYI0H0") || inheritPath.contains("0DAJMH01ONG/") || inheritPath.contains("0CI/=D/PV8F0"))) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("wf_previewbillsummary");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam("billsummarytpl", (Object)billSummaryTplNumber);
            this.getView().showForm(formShowParameter);
        } else if (BillSummaryUtil.isBillRelationCardSummary(dynamicObject) || BillSummaryUtil.isBillRelationStackedCardSummary(dynamicObject)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId(billSummaryTplNumber);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(parameter);
        } else {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6a21\u677f%s\u6ca1\u6709\u6dfb\u52a0\u9884\u89c8\u56fe\u7247\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6dfb\u52a0\u3002", (String)"WfChooseBillSummary_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), billSummaryTplNumber));
        }
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        evt.setCancel(true);
    }
}

