/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.management.plugin;

import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class WfCooperationDefPlugin
extends AbstractBasePlugIn {
    private static final String FACTORY_PACKAGE = "factorypackage";

    public void afterCreateNewData(EventObject e) {
        String number = (String)this.getModel().getValue("number");
        boolean isAdminOrg = "admin_org".equals(number);
        if (isAdminOrg) {
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
        }
    }

    public void afterBindData(EventObject e) {
        String factoryPackage = (String)this.getModel().getValue(FACTORY_PACKAGE);
        DynamicObjectCollection refPersonType = (DynamicObjectCollection)this.getModel().getValue("refpersontype");
        if (refPersonType == null || refPersonType.size() == 0) {
            DynamicObject bosUser = BusinessDataServiceHelper.loadSingle((String)"bos_entityobject", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"bos_user")});
            refPersonType = new DynamicObjectCollection(bosUser.getDynamicObjectType(), null);
            refPersonType.add((Object)bosUser);
            this.getModel().setValue("refpersontype", (Object)refPersonType);
        }
        if (StringUtils.isBlank((CharSequence)factoryPackage)) {
            String cloudkey = (String)this.getModel().getValue("cloudkey");
            String appkey = (String)this.getModel().getValue("appkey");
            if (StringUtils.isNotBlank((CharSequence)cloudkey) && StringUtils.isNotBlank((CharSequence)appkey)) {
                factoryPackage = "kd." + cloudkey + "." + appkey + ".servicehelper";
                this.getModel().setValue(FACTORY_PACKAGE, (Object)factoryPackage);
            }
        }
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "factorypackage": {
                String factoryPackage = (String)e.getChangeSet()[0].getNewValue();
                this.updateAppkeyAndCloudkey(factoryPackage);
            }
        }
    }

    private void updateAppkeyAndCloudkey(String factorypackage) {
        String[] packageArr;
        if (StringUtils.isNotBlank((CharSequence)factorypackage) && (packageArr = factorypackage.split("\\.")) != null && packageArr.length == 4 && "kd".equals(packageArr[0]) && "servicehelper".equals(packageArr[3])) {
            String cloudkey = packageArr[1];
            String appkey = packageArr[2];
            this.getModel().setValue("cloudkey", (Object)cloudkey);
            this.getModel().setValue("appkey", (Object)appkey);
        }
    }
}

