/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.management.plugin;

import java.util.HashMap;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.design.plugin.WorkflowModelManagePlugin;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.BasedataFormListType;
import kd.bos.workflow.management.plugin.basedatafiltertools.FilterDimemsionParam;

public class WfCustomReportRelationUtil {
    protected static Log logger = LogFactory.getLog(WorkflowModelManagePlugin.class);
    private static final String CAPTION = "caption";
    protected static final String REFERFILTER = "referfilter";

    private WfCustomReportRelationUtil() {
    }

    public static void openCustomReport(Map<String, Object> params, IFormView view, IPageCache pageCache) {
        Long id = (Long)params.get("id");
        String ids = (String)params.get("ids");
        Map<String, String> idsMap = ids != null ? (Map)SerializationUtils.fromJsonString((String)ids, Map.class) : new HashMap();
        String idStr = String.valueOf(id);
        String pageId = null;
        IFormView openedView = null;
        pageId = (String)idsMap.get(idStr);
        if (pageId != null && (openedView = view.getView(pageId)) != null) {
            openedView.activate();
            view.sendFormAction(openedView);
            return;
        }
        try {
            pageId = WfCustomReportRelationUtil.openWindow(params, view);
            if (StringUtils.isNotBlank((CharSequence)pageId)) {
                idsMap.put(idStr, pageId);
            }
            pageCache.put("customreport_ids", SerializationUtils.toJsonString(idsMap));
        }
        catch (Exception e) {
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u6253\u5f00\u5931\u8d25\u3002\u539f\u56e0\uff1a%s\u3002", (String)"WfCustomReportRelationUtil_0", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
            logger.warn(WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    private static String openWindow(Map<String, Object> params, IFormView view) {
        String pageType = (String)params.get("pageType");
        String pageId = null;
        switch (pageType) {
            case "pageType_List": {
                pageId = WfCustomReportRelationUtil.openRelationListInfoWindow(params, view);
                break;
            }
            case "pageTypeInfo": {
                pageId = WfCustomReportRelationUtil.openRelationInfoWindow(params, view);
                break;
            }
        }
        return pageId;
    }

    private static String openRelationListInfoWindow(Map<String, Object> params, IFormView view) {
        String cooperationName = (String)params.get("name");
        String cooperaNumber = (String)params.get("cooperanumber");
        Object coopId = params.get("cooperaid");
        IFormView tabView = DesignerModelUtil.getTabControlView(view);
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("wf_customreportrelation");
        parameter.setFormId("bos_templatetreelist");
        parameter.getOpenStyle().setTargetKey("_submaintab_");
        parameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        parameter.setCaption(cooperationName);
        parameter.setCustomParam("cooperanumber", (Object)cooperaNumber);
        parameter.setCustomParam("cooperaid", coopId);
        tabView.showForm((FormShowParameter)parameter);
        view.sendFormAction(tabView);
        view.showForm((FormShowParameter)parameter);
        return parameter.getPageId();
    }

    private static String openRelationInfoWindow(Map<String, Object> params, IFormView view) {
        IFormView tabView = DesignerModelUtil.getTabControlView(view);
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setFormId("wf_customreportrelation");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setCaption(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6c47\u62a5\u5173\u7cfb", (String)"WfCustomReportRelationUtil_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        parameter.setCustomParam("id", params.get("id"));
        tabView.showForm((FormShowParameter)parameter);
        view.sendFormAction(tabView);
        return parameter.getPageId();
    }

    public static void addNumberPrefix(DynamicObject customreport) {
        String coopRandomNumber = customreport.getString("randomnumber");
        String number = customreport.getString("number");
        customreport.set("number", (Object)WfCustomReportRelationUtil.addNumberPrefix(coopRandomNumber, number));
    }

    public static String addNumberPrefix(String prefix, String suffix) {
        return String.format("%s_%s", prefix, suffix);
    }

    public static ListShowParameter createShowListForm(String formId, boolean isMultiSelect, int f7Style) {
        return WfCustomReportRelationUtil.createShowListForm(formId, isMultiSelect, f7Style, true);
    }

    public static ListShowParameter createShowListForm(String formId, boolean isMultiSelect, int f7Style, boolean isLookUP) {
        ListShowParameter para = new ListShowParameter();
        para.setLookUp(isLookUP);
        para.setBillFormId(formId);
        if (isLookUP) {
            para.getOpenStyle().setShowType(ShowType.Modal);
            StyleCss formConfig = new StyleCss();
            formConfig.setWidth("960px");
            formConfig.setHeight("580px");
            para.getOpenStyle().setInlineStyleCss(formConfig);
            para.setFormId(WfCustomReportRelationUtil.getListFormId(formId, f7Style));
            para.setF7Style(f7Style);
        } else {
            para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            FormConfig formConfig1 = FormMetadataCache.getListFormConfig((String)formId);
            para.setFormId(formConfig1.getListFormId());
        }
        para.setMultiSelect(isMultiSelect);
        para.setShowTitle(false);
        para.setHasRight(true);
        return para;
    }

    private static String getListFormId(String formId, int f7Style) {
        FormConfig formConfig = FormMetadataCache.getListFormConfig((String)formId);
        if (BasedataFormListType.BOS_USERTREELISTF7.getNumber().equals(f7Style)) {
            return "bos_usertreelistf7";
        }
        if (BasedataFormListType.BOS_ADMINORGLISTF7.getNumber().equals(f7Style)) {
            return "bos_adminorg_treelistf7";
        }
        return formConfig.getF7ListFormId();
    }

    public static void openWindow(IFormPlugin plugin, FilterDimemsionParam params) {
        WfCustomReportRelationUtil.openWindow(plugin, params, REFERFILTER);
    }

    public static void openWindow(IFormPlugin plugin, FilterDimemsionParam params, String closeCallBackTag) {
        IFormView view = ((AbstractFormPlugin)plugin).getView();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCloseCallBack(new CloseCallBack(plugin, closeCallBackTag));
        parameter.setFormId("wf_filter_dimensions");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCaption(params.getCaption());
        parameter.setCustomParams(WfCustomReportRelationUtil.covertCustomParams(params));
        parameter.setHasRight(true);
        parameter.getCustomParams().put("isIgnoreLicense", Boolean.TRUE);
        view.showForm(parameter);
    }

    private static Map<String, Object> covertCustomParams(FilterDimemsionParam params) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("filterdimension", params.getFilterDimension());
        FilterDimemsionParam.SelectInfo selectInfo = params.getSelectInfo();
        dataMap.put("radio_option", selectInfo.getSelectType());
        dataMap.put("name_option", selectInfo.getShowName());
        dataMap.put("info_option", selectInfo.getParseInfo());
        FilterDimemsionParam.ControlName controlName = params.getControlName();
        if (controlName != null) {
            dataMap.put(CAPTION, controlName.getCaption());
            String businessControlName = controlName.getBusinessControlName();
            String constantControlName = controlName.getConstantControlName();
            String expressControlName = controlName.getExpressControlName();
            if (WfUtils.isNotEmpty((String)businessControlName)) {
                dataMap.put("businessControlName", businessControlName);
            }
            if (WfUtils.isNotEmpty((String)constantControlName)) {
                dataMap.put("constantControlName", constantControlName);
            }
            if (WfUtils.isNotEmpty((String)expressControlName)) {
                dataMap.put("expressControlName", expressControlName);
            }
        }
        dataMap.put("bpmnModel", params.getModelJson());
        dataMap.put("entityNumber", params.getEntityNumber());
        dataMap.put("isMultiSelect", params.getIsMultiSelect());
        return dataMap;
    }
}

