/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.management.plugin;

import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Delete;
import kd.bos.entity.operate.StatusConvert;
import kd.bos.exception.KDException;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.design.plugin.ExportModelSQLUtil;
import kd.bos.workflow.design.util.BaseChangeLogsUtil;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.management.plugin.WfDynamicFormMappingPlugin;

public class WfDynamicFormMappingListPlugin
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(WfDynamicFormMappingPlugin.class);

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object source = args.getSource();
        if (source instanceof Delete || source instanceof StatusConvert) {
            BaseChangeLogsUtil.putBaseArrayCache(this.getView(), "wf_dynamicformmapping");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        Object source = args.getSource();
        if ((source instanceof Delete || source instanceof StatusConvert) && args.getOperationResult().isSuccess()) {
            BaseChangeLogsUtil.addChangeLog(this.getView(), source, "dynamicformmapping");
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        switch (itemKey = evt.getItemKey()) {
            case "barexportsql": {
                if (null == rows || rows.isEmpty()) {
                    this.getView().showTipNotification(WFMultiLangConstants.getNoDataSelectedTip());
                    return;
                }
                this.exportSql(rows.getPrimaryKeyValues());
                break;
            }
            case "querymodifylog": {
                BaseChangeLogsUtil.queryLog(this.getView(), "dynamicformmapping");
                break;
            }
        }
    }

    private void exportSql(Object[] pkIds) {
        try {
            String fileName;
            StringBuilder sqls = new StringBuilder();
            String fromfield = fileName = "t_wf_dynamicformmapping";
            String selectField = "fid ,fmodeltype ,fdynamicformnumber ,fentitynumber ,fdescription ,fbusinessenable ,fenable ,fcreatorid ,fcreatetime ,fmodifierid ,fmodifytime ,fsourceid ,fname ,fpreinsdata ,fnumber ,fmasterid";
            StringBuilder wherefieldS = new StringBuilder();
            wherefieldS.append("fid in (");
            int size = pkIds.length;
            for (Object obj : pkIds) {
                wherefieldS.append(obj);
                if (0 != --size) {
                    wherefieldS.append(",");
                    continue;
                }
                wherefieldS.append(")");
            }
            String orderfield = "fcreatetime desc";
            String sql = ExportModelSQLUtil.genInsertSQLScript(fromfield, selectField, wherefieldS.toString(), orderfield);
            if (WfUtils.isNotEmpty((String)sql)) {
                sqls.append(sql);
            }
            if (WfUtils.isNotEmpty((String)(sql = ExportModelSQLUtil.genInsertSQLScript(fromfield = "t_wf_dynamicformmapping_l", selectField = "fpkid ,fid ,flocaleid ,fdescription ,fname", wherefieldS.toString(), null)))) {
                sqls.append(sql);
            }
            if (0 == sqls.length()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5bfc\u51fa\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u3002", (String)"WfDynamicFormMappingPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            String sqlFileName = String.format("%s_%s.sql", fileName, new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
            ExportModelSQLUtil.exportFile(sqls.toString(), sqlFileName, this.getView());
        }
        catch (Exception e) {
            logger.info(WfUtils.getExceptionStacktrace((Throwable)e));
            if (!(e instanceof KDException)) {
                return;
            }
            this.getView().showErrorNotification(((KDException)((Object)e)).getMessage());
        }
    }
}

