/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.management.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.Save;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.design.util.BaseChangeLogsUtil;
import kd.bos.workflow.design.util.IBaseChangeLogCallBack;
import kd.bos.workflow.engine.WfUtils;

public class WfDynamicFormMappingPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener,
ItemClickListener {
    private static final String DESCRIPTION = "description";
    private static final String ENTITY_NUMBER = "entityNumber";
    private static final String DYNAMIC_FORM_NUMBER = "dynamicFormNumber";
    private static final String MODELTYPE = "modeltype";
    private static final String[] compareField = new String[]{"modeltype", "dynamicFormNumber", "entityNumber", "description"};
    private static final String TBMAIN = "tbmain";
    private static final String CONTROLMODELTYPE = "modeltype";
    private static final String CONTROLDYNAMICFORM = "dynamicformnumber";
    private static final String CONTROLENTITY = "entitynumber";

    public void registerListener(EventObject e) {
        Toolbar tbmain = (Toolbar)this.getView().getControl(TBMAIN);
        tbmain.addItemClickListener((ItemClickListener)this);
        BasedataEdit dynamicform = (BasedataEdit)this.getView().getControl(CONTROLDYNAMICFORM);
        dynamicform.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        BaseShowParameter baseShowParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        Object id = baseShowParameter.getPkId();
        boolean isAddNew = WfUtils.isNullObject((Object)id);
        if (isAddNew) {
            return;
        }
        BaseChangeLogsUtil.putBaseModelCache(this.getView(), "dynamicformmapping", new IBaseChangeLogCallBack(){

            @Override
            public JSONArray getModelArray() {
                return WfDynamicFormMappingPlugin.this.getViewModelArray();
            }
        });
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (!(args.getSource() instanceof Save) || !args.getOperationResult().isSuccess()) {
            return;
        }
        String baseFormId = args.getOperationResult().getSuccessPkIds().get(0).toString();
        BaseChangeLogsUtil.addBaseLog(this.getView(), "dynamicformmapping", "", baseFormId, new IBaseChangeLogCallBack(){

            @Override
            public JSONArray getModelArray() {
                return WfDynamicFormMappingPlugin.this.getViewModelArray();
            }
        });
    }

    private JSONArray getViewModelArray() {
        JSONArray arr = new JSONArray();
        JSONObject jsonObj = new JSONObject();
        String modelType = (String)this.getModel().getValue("modeltype");
        String modelTypeDes = null;
        if ("DynamicFormModel".equals(modelType)) {
            modelTypeDes = ResManager.loadKDString((String)"PC\u7aef\u7684\u52a8\u6001\u8868\u5355", (String)"WfDynamicFormMappingPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        } else if ("MobileFormModel".equals(modelType)) {
            modelTypeDes = ResManager.loadKDString((String)"\u79fb\u52a8\u7248\u7684\u52a8\u6001\u8868\u5355", (String)"WfDynamicFormMappingPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        jsonObj.put("modeltype", (Object)modelTypeDes);
        DynamicObject dynamicFormNumberObj = (DynamicObject)this.getModel().getValue(CONTROLDYNAMICFORM);
        jsonObj.put(DYNAMIC_FORM_NUMBER, (Object)dynamicFormNumberObj.getString("number"));
        jsonObj.put("dynamicFormName", (Object)dynamicFormNumberObj.getLocaleString("name"));
        DynamicObject entityNumberObj = (DynamicObject)this.getModel().getValue(CONTROLENTITY);
        jsonObj.put(ENTITY_NUMBER, (Object)entityNumberObj.getString("number"));
        jsonObj.put("entityName", (Object)entityNumberObj.getLocaleString("name"));
        ILocaleString description = (ILocaleString)this.getModel().getValue(DESCRIPTION);
        if (WfUtils.isNotEmpty((ILocaleString)description)) {
            jsonObj.put(DESCRIPTION, (Object)description);
        }
        arr.add((Object)jsonObj);
        return arr;
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String controlName = arg0.getProperty().getName();
        QFilter filter = null;
        switch (controlName) {
            case "dynamicformnumber": {
                Object modelTypeObj = this.getModel().getValue("modeltype");
                filter = new QFilter("modeltype", "=", modelTypeObj);
                break;
            }
        }
        if (null == filter) {
            return;
        }
        ListShowParameter param = (ListShowParameter)arg0.getFormShowParameter();
        param.getListFilterParameter().getQFilters().add(filter);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (!"bar_save".equalsIgnoreCase(itemKey) && !"bar_saveandnew".equalsIgnoreCase(itemKey)) {
            return;
        }
        DynamicObject dynamicFormObj = (DynamicObject)this.getModel().getValue(CONTROLDYNAMICFORM);
        DynamicObject entityObj = (DynamicObject)this.getModel().getValue(CONTROLENTITY);
        QFilter qFilterDyn = new QFilter(CONTROLDYNAMICFORM, "=", dynamicFormObj.get("number"));
        QFilter qFilterEntity = new QFilter(CONTROLENTITY, "=", entityObj.get("number"));
        QFilter[] qFilters = null;
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        if (null == pkValue || WfUtils.isEmpty((Long)Long.parseLong(pkValue.toString()))) {
            qFilters = new QFilter[]{qFilterDyn, qFilterEntity};
        } else {
            QFilter qFilterId = new QFilter("id", "!=", pkValue);
            qFilters = new QFilter[]{qFilterId, qFilterDyn, qFilterEntity};
        }
        boolean exists = QueryServiceHelper.exists((String)"wf_dynamicformmapping", (QFilter[])qFilters);
        if (exists) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6620\u5c04\u5173\u7cfb\u5df2\u5b58\u5728\uff0c\u65e0\u9700\u91cd\u590d\u5efa\u7acb\u3002", (String)"WfDynamicFormMappingPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        boolean modifyData = this.isModifyData();
        if (modifyData) {
            this.getModel().setValue("name", dynamicFormObj.get("name"));
            this.getModel().setValue("number", dynamicFormObj.get("number"));
            return;
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"WfDynamicFormMappingPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        evt.setCancel(true);
    }

    private boolean isModifyData() {
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        if (null == pkValue || WfUtils.isEmpty((Long)Long.parseLong(pkValue.toString()))) {
            return true;
        }
        String entry = this.getPageCache().get("entry");
        if (WfUtils.isEmpty((String)entry)) {
            return true;
        }
        JSONArray arrBegin = JSONArray.parseArray((String)entry);
        if (null == arrBegin || arrBegin.isEmpty()) {
            return true;
        }
        JSONObject arrBeginJ = (JSONObject)arrBegin.get(0);
        JSONArray arrayEnd = this.getViewModelArray();
        JSONObject arrEndJ = (JSONObject)arrayEnd.get(0);
        Object valueBegin = null;
        Object valueEnd = null;
        for (String field : compareField) {
            valueBegin = arrBeginJ.get((Object)field);
            valueEnd = arrEndJ.get((Object)field);
            if (null == valueBegin && null == valueEnd) continue;
            if (null != valueBegin && null == valueEnd) {
                return true;
            }
            if (null == valueBegin && null != valueEnd) {
                return true;
            }
            if (valueBegin.equals(valueEnd)) continue;
            return true;
        }
        return false;
    }
}

