/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.management.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.businessfield.AmountField;
import kd.bos.metadata.entity.commonfield.AttachmentField;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TimeRangeField;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.cardentry.CardEntryAp;
import kd.bos.metadata.form.cardentry.CardEntryFieldAp;
import kd.bos.metadata.form.cardentry.CardEntryRowAp;
import kd.bos.metadata.form.cardentry.CardEntryViewAp;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.Pair;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.DynamicObjectJsonSerializer;
import kd.bos.workflow.management.plugin.WFBillSummaryUtil;

public class WfShowEntryDetailEdit
extends AbstractMobBillPlugIn {
    private static final String CONFIRM = "confirm";
    private static final String BILLTYPE = "billtype";
    private static final String HEADAP = "headAp";
    private static final String CONTAINERAP = "containerap";
    private static final String MOBILECONTAINER = "mobilecontainer";
    private static final String MOBILEENTITY = "mobileentity";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{CONFIRM});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (CONFIRM.equals(key)) {
            FormShowParameter parameter = this.getView().getFormShowParameter();
            String billType = (String)parameter.getCustomParam(BILLTYPE);
            MetadataReader reader = new MetadataReader();
            String fid = reader.loadIdByNumber(billType, MetaCategory.Entity);
            EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)fid, (MetaCategory)MetaCategory.Entity);
            Map<String, EntityItem<?>> mapItems = WFBillSummaryUtil.getItems(entityMetadata);
            String dynamicObjectInfo = (String)parameter.getCustomParam("dynamicObjectInfo");
            DynamicObject billInfo = DynamicObjectJsonSerializer.parseDynamicObjectJson((String)dynamicObjectInfo, (String)billType);
            String currentEntryKey = (String)parameter.getCustomParam("entrykey");
            DynamicObjectCollection datas = this.getModel().getDataEntity(true).getDynamicObjectCollection(currentEntryKey);
            Long billSummaryId = (Long)parameter.getCustomParam("billsummaryid");
            DynamicObject mobileConfig = BusinessDataServiceHelper.loadSingle((Object)billSummaryId, (String)"wf_mbillsummary_cfg");
            DynamicObjectCollection entries = mobileConfig.getDynamicObjectCollection("entryentity");
            for (DynamicObject object : entries) {
                String fieldkey = object.getString("fieldkey");
                String entryKey = object.getString("entrylocation");
                boolean editable = object.getBoolean("editable");
                EntityItem<?> entity = mapItems.get(fieldkey);
                if (billInfo == null || !editable || entryKey == null || !entryKey.equals(currentEntryKey)) continue;
                for (int i = 0; i < datas.size(); ++i) {
                    if (entity instanceof DateRangeField || entity instanceof TimeRangeField) {
                        Pair<String, String> startAndEndKey = WFBillSummaryUtil.getStartAndEndKey(entity);
                        if (!StringUtils.isNotBlank((CharSequence)((CharSequence)startAndEndKey.getKey())) || !StringUtils.isNotBlank((CharSequence)((CharSequence)startAndEndKey.getValue()))) continue;
                        ((DynamicObject)billInfo.getDynamicObjectCollection(currentEntryKey).get(i)).set((String)startAndEndKey.getKey(), ((DynamicObject)datas.get(i)).get((String)startAndEndKey.getKey()));
                        ((DynamicObject)billInfo.getDynamicObjectCollection(currentEntryKey).get(i)).set((String)startAndEndKey.getValue(), ((DynamicObject)datas.get(i)).get((String)startAndEndKey.getValue()));
                        continue;
                    }
                    ((DynamicObject)billInfo.getDynamicObjectCollection(currentEntryKey).get(i)).set(fieldkey, ((DynamicObject)datas.get(i)).get(fieldkey));
                }
            }
            if (billInfo != null) {
                this.getView().returnDataToParent((Object)DynamicObjectJsonSerializer.convertDynamicObjectToJson((DynamicObject)billInfo));
            }
            this.getView().close();
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        MobileFormShowParameter parameter = (MobileFormShowParameter)e.getSource();
        FlexPanelAp uiHeadMeta = new FlexPanelAp();
        uiHeadMeta.setKey(HEADAP);
        FlexPanelAp uiContainerMeta = new FlexPanelAp();
        uiContainerMeta.setKey(CONTAINERAP);
        this.createMeta(uiHeadMeta, uiContainerMeta, parameter);
        HashMap<String, String> mapHead = new HashMap<String, String>();
        mapHead.put("id", MOBILECONTAINER);
        mapHead.put("items", (String)uiHeadMeta.createControl().get("items"));
        e.getItems().add(mapHead);
        HashMap<String, String> mapEntry = new HashMap<String, String>();
        mapEntry.put("id", MOBILEENTITY);
        mapEntry.put("items", (String)uiContainerMeta.createControl().get("items"));
        e.getItems().add(mapEntry);
    }

    public void createNewData(BizDataEventArgs e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String billType = (String)parameter.getCustomParam(BILLTYPE);
        String dynamicObjectInfo = (String)parameter.getCustomParam("dynamicObjectInfo");
        DynamicObject billInfo = DynamicObjectJsonSerializer.parseDynamicObjectJson((String)dynamicObjectInfo, (String)billType);
        e.setDataEntity((Object)billInfo);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        MetadataReader reader = new MetadataReader();
        String fid = reader.loadIdByNumber("bos_mobileform", MetaCategory.Entity);
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)fid, (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)fid, (MetaCategory)MetaCategory.Entity);
        formMetadata.bindEntityMetadata(entityMetadata);
        MobileFormShowParameter parameter = (MobileFormShowParameter)this.getView().getFormShowParameter();
        FlexPanelAp uiHeadMeta = new FlexPanelAp();
        uiHeadMeta.setKey(HEADAP);
        FlexPanelAp uiContainerMeta = new FlexPanelAp();
        uiContainerMeta.setKey(CONTAINERAP);
        this.createMeta(uiHeadMeta, uiContainerMeta, parameter);
        Container c = (Container)this.getControl(MOBILECONTAINER);
        c.getItems().addAll(((Container)uiHeadMeta.buildRuntimeControl()).getItems());
        this.getView().createControlIndex(c.getItems());
        Container entryCard = (Container)this.getControl(MOBILEENTITY);
        List entryFieldEditors = ((Container)uiContainerMeta.buildRuntimeControl()).getItems();
        for (Control entryFieldEditor : entryFieldEditors) {
            if (entryFieldEditor instanceof CardEntry) {
                ((CardEntry)entryFieldEditor).setEntryKey(entryFieldEditor.getKey());
                ArrayList<Control> list = new ArrayList<Control>();
                list.add(entryFieldEditor);
                this.getView().createControlIndex(list);
            }
            entryFieldEditor.setView(this.getView());
            if (entryCard == null || entryCard.getItems() == null) continue;
            entryCard.getItems().add(entryFieldEditor);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        if (MOBILECONTAINER.equals(e.getKey()) || MOBILEENTITY.equals(e.getKey())) {
            return;
        }
        MobileFormShowParameter parameter = (MobileFormShowParameter)this.getView().getFormShowParameter();
        FlexPanelAp uiHeadMeta = new FlexPanelAp();
        uiHeadMeta.setKey(HEADAP);
        FlexPanelAp uiContainerMeta = new FlexPanelAp();
        uiContainerMeta.setKey(CONTAINERAP);
        this.createMeta(uiHeadMeta, uiContainerMeta, parameter);
        Control entryFieldEditor = (Control)((Container)uiContainerMeta.buildRuntimeControl()).getItems().get(0);
        String controlKey = entryFieldEditor.getKey();
        if (e.getKey().equals(controlKey)) {
            entryFieldEditor.setView(this.getView());
            ((CardEntry)entryFieldEditor).setEntryKey(controlKey);
            e.setControl(entryFieldEditor);
        } else {
            List cardEntries = ((CardEntry)entryFieldEditor).getItems();
            CardEntry cardEntry = (CardEntry)cardEntries.get(0);
            List containers = cardEntry.getItems();
            Container container = (Container)containers.get(0);
            List controls = container.getItems();
            if (CollectionUtil.isNotEmpty((Collection)controls)) {
                for (Control control : controls) {
                    if (e.getKey() == null || !e.getKey().equals(control.getKey())) continue;
                    control.setView(this.getView());
                    if (control instanceof FieldEdit) {
                        ((FieldEdit)control).setEntryKey(controlKey);
                    }
                    e.setControl(control);
                }
            }
        }
    }

    private void createEntry(FlexPanelAp uiContainerMeta, String entryKey, Map<String, CardEntryRowAp> entryMap) {
        CardEntryAp uiMetaEntry = new CardEntryAp();
        uiMetaEntry.setKey(entryKey);
        uiMetaEntry.setId(entryKey);
        uiMetaEntry.setEntryId(entryKey);
        uiMetaEntry.setShrink(0);
        uiMetaEntry.setGrow(0);
        CardEntryViewAp entryview = new CardEntryViewAp();
        entryview.setId(entryKey + "viewap");
        entryview.setKey(entryKey + "viewap");
        CardEntryRowAp entryrow = new CardEntryRowAp();
        entryrow.setId(entryKey + "rowap");
        entryrow.setKey(entryKey + "rowap");
        Style entryStyle = new Style();
        Border border = new Border();
        String borderStyle = "0.5px_solid_#f8f9fb";
        border.setBottom(borderStyle);
        border.setLeft(borderStyle);
        border.setRight(borderStyle);
        border.setTop("12px_solid_#f8f9fb");
        entryStyle.setBorder(border);
        entryrow.setStyle(entryStyle);
        entryMap.put(entryKey, entryrow);
        entryview.getItems().add(entryrow);
        uiMetaEntry.getItems().add(entryview);
        uiContainerMeta.getItems().add(uiMetaEntry);
    }

    private void createMeta(FlexPanelAp uiHeadMeta, FlexPanelAp uiContainerMeta, MobileFormShowParameter parameter) {
        Long billSummaryId = (Long)parameter.getCustomParam("billsummaryid");
        DynamicObject mobileConfig = BusinessDataServiceHelper.loadSingle((Object)billSummaryId, (String)"wf_mbillsummary_cfg");
        String number = mobileConfig.getString("billtype_Id");
        MetadataReader reader = new MetadataReader();
        String fid = reader.loadIdByNumber(number, MetaCategory.Entity);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)fid, (MetaCategory)MetaCategory.Entity);
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)fid, (MetaCategory)MetaCategory.Form);
        String currentEntryKey = (String)parameter.getCustomParam("entrykey");
        EntityItem<?> entityItem = this.getItemById(entityMetadata, currentEntryKey);
        if (entityItem == null) {
            return;
        }
        List hideKeys = (List)parameter.getCustomParam("disvisblenumber");
        HashMap<String, CardEntryRowAp> entryMap = new HashMap<String, CardEntryRowAp>();
        this.createEntry(uiContainerMeta, entityItem.getKey(), entryMap);
        DynamicObjectCollection entries = mobileConfig.getDynamicObjectCollection("entryentity");
        for (DynamicObject object : entries) {
            String fieldkey = object.getString("fieldkey");
            String entryKey = object.getString("entrylocation");
            if (entryKey == null || !entryKey.equals(currentEntryKey) || hideKeys.contains(fieldkey)) continue;
            this.createCardEntryFieldAp(uiHeadMeta, entityMetadata, entryMap, object, fieldkey, entryKey, false, formMetadata);
        }
    }

    private void createCardEntryFieldAp(FlexPanelAp uiHeadMeta, EntityMetadata entityMetadata, Map<String, CardEntryRowAp> entryMap, DynamicObject object, String fieldkey, String entryKey, boolean hide, FormMetadata formMetadata) {
        CardEntryFieldAp entryFldAp = new CardEntryFieldAp();
        entryFldAp.setId(fieldkey);
        entryFldAp.setKey(fieldkey);
        if (object != null && !hide) {
            String fieldPercent;
            ILocaleString localeString = object.getLocaleString("fieldname");
            entryFldAp.setName(LocaleString.fromMap((Map)localeString));
            boolean editable = object.getBoolean("editable");
            if (editable) {
                entryFldAp.setLock("");
            } else {
                entryFldAp.setLock("new,edit");
            }
            String fontColor = object.getString("fontcolor");
            if (WfUtils.isNotEmpty((String)fontColor)) {
                entryFldAp.setForeColor(fontColor);
                entryFldAp.setFieldForeColor(fontColor);
            } else {
                entryFldAp.setForeColor("#212121");
                entryFldAp.setFieldForeColor("#212121");
            }
            if (WfUtils.isEmpty((String)fontColor) && !editable) {
                entryFldAp.setForeColor("#999999");
                entryFldAp.setFieldForeColor("#999999");
            }
            if (WfUtils.isNotEmpty((String)(fieldPercent = object.getString("fieldpercent")))) {
                entryFldAp.setLabelWidth(new LocaleString(fieldPercent));
            } else {
                entryFldAp.setLabelWidth(new LocaleString("40%"));
            }
            int fontSize = object.getInt("fontsize");
            if (fontSize > 0) {
                entryFldAp.setFontSize(fontSize);
                entryFldAp.setFieldFontSize(fontSize);
            } else {
                entryFldAp.setFontSize(16);
                entryFldAp.setFieldFontSize(16);
            }
        }
        entryFldAp.setFireUpdEvt(true);
        EntityItem<?> item = this.getEntryItemById(entityMetadata, entryKey, fieldkey);
        if (item != null) {
            ControlAp formItem;
            Field field;
            String currencyFieldId;
            if (item instanceof AmountField && WfUtils.isNotEmpty((String)(currencyFieldId = ((AmountField)item).getCurrencyFieldId())) && (field = entityMetadata.getFieldById(currencyFieldId)) != null) {
                if (WfUtils.isEmpty((String)field.getParentId())) {
                    this.createHeadFieldAp(uiHeadMeta, entityMetadata, field, entryKey);
                } else {
                    this.createCardEntryFieldAp(uiHeadMeta, entityMetadata, entryMap, null, field.getKey(), entryKey, true, formMetadata);
                }
            }
            if (formMetadata != null && object != null && (formItem = formMetadata.getItem(object.getString("fieldid"))) instanceof FieldAp) {
                entryFldAp.setNoDisplayScaleZero(((FieldAp)formItem).isNoDisplayScaleZero());
                entryFldAp.setDisplayFormatString(((FieldAp)formItem).getDisplayFormatString());
            }
            entryFldAp.setFieldTextAlign("right");
            entryFldAp.setField((Field)item);
            entryFldAp.setShowTitle(true);
            LocaleString width = new LocaleString();
            LocaleString height = new LocaleString();
            width.setLocaleValue("100%");
            if (!(item instanceof AttachmentField)) {
                height.setLocaleValue("48px");
                Style entryFldApStyle = new Style();
                Padding padding = new Padding();
                padding.setTop("18px");
                padding.setLeft("12px");
                padding.setRight("12px");
                entryFldApStyle.setPadding(padding);
                entryFldAp.setStyle(entryFldApStyle);
            }
            entryFldAp.setHeight(height);
            entryFldAp.setWidth(width);
            if (hide) {
                entryFldAp.setVisible("");
            }
        }
        entryMap.get(entryKey).getItems().add(entryFldAp);
    }

    private void createHeadFieldAp(FlexPanelAp uiHeadMeta, EntityMetadata entityMetadata, Field<?> field, String entryKey) {
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId(field.getKey());
        fieldAp.setKey(field.getKey());
        fieldAp.setName(field.getName());
        EntityItem<?> item = this.getEntryItemById(entityMetadata, entryKey, field.getKey());
        fieldAp.setField((Field)item);
        uiHeadMeta.getItems().add(fieldAp);
    }

    private EntityItem<?> getEntryItemById(EntityMetadata entityMetadata, String entryKey, String fieldkey) {
        List entities = entityMetadata.getRootEntity().getItems();
        for (EntityItem entityItem : entities) {
            if (entryKey != null && entryKey.equals(entityItem.getKey())) {
                EntryEntity entry = (EntryEntity)entityItem;
                for (EntityItem entryItem : entry.getItems()) {
                    if (fieldkey == null || !fieldkey.equals(entryItem.getKey())) continue;
                    return entryItem;
                }
            }
            if (fieldkey == null || !fieldkey.equals(entityItem.getKey())) continue;
            return entityItem;
        }
        return null;
    }

    private EntityItem<?> getItemById(EntityMetadata entityMetadata, String currentEntryKey) {
        List entities = entityMetadata.getRootEntity().getItems();
        for (EntityItem entityItem : entities) {
            if (currentEntryKey == null || !currentEntryKey.equals(entityItem.getKey())) continue;
            return entityItem;
        }
        return null;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        MainEntityType newMainType = EntityMetadataCache.getDataEntityTypeNoCache((String)((String)customParams.get(BILLTYPE)));
        e.setNewEntityType(newMainType);
    }
}

