/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.management.plugin;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.field.FieldEdit;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.IModelModifyLog;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.ModelModifyLogEntity;

public class WfVersionDifferencePlugin
extends AbstractWorkflowPlugin {
    private static final String ENTRY_ENTITY = "diffentryentity";
    private static final String PROC_NUM = "procnum";
    private static final String PROC_NAME = "procname";
    private static final String ELEMENT_NAME = "elementname";
    private static final String GROUP = "group";
    private static final String PROP_NAME = "propname";
    private static final String MANAGE_PROP = "manageprop";
    private static final String DESIGN_PROP = "designprop";
    private static final String TOOLBARAP = "toolbarap";
    private static final String REFRESH = "refresh";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.showData();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbar = (Toolbar)this.getControl(TOOLBARAP);
        toolbar.addItemClickListener((ItemClickListener)this);
    }

    private void showData() {
        String parentPage;
        switch (parentPage = (String)this.getView().getFormShowParameter().getCustomParam("parentPage")) {
            case "manageCenter": {
                this.showForManageCenter();
                break;
            }
            case "dynamicConfigScheme": {
                this.showForDynaConfScheme();
                break;
            }
        }
    }

    private void showForManageCenter() {
        Long procDefId = (Long)this.getView().getFormShowParameter().getCustomParam("procDefId");
        ProcessDefinitionEntity procDefEntity = (ProcessDefinitionEntity)this.getRepositoryService().findEntityById(procDefId, "wf_processdefinition", "key,name,resourceid,modelid");
        Long resourceId = procDefEntity.getResourceId();
        Long modelId = procDefEntity.getModelId();
        ResourceEntity dynaConfigResource = this.getRepositoryService().getResourceById(resourceId);
        String dynaCfgSchemeJson = dynaConfigResource.getData();
        ModelEntity modelEntity = (ModelEntity)this.getRepositoryService().findEntityById(modelId, "wf_model", "bpmnxmlid");
        Long modelResourceId = modelEntity.getBPMNXMLID();
        ResourceEntity modelResource = this.getRepositoryService().getResourceById(modelResourceId);
        String designJson = modelResource.getData();
        List modelModifyLogEntities = this.getManagementService().compareVersionDifference(designJson, dynaCfgSchemeJson, (IModelModifyLog)procDefEntity, Collections.emptySet());
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRY_ENTITY);
        model.setValue(PROC_NUM, (Object)procDefEntity.getKey());
        model.setValue(PROC_NAME, (Object)procDefEntity.getName());
        int size = modelModifyLogEntities.size();
        if (size == 0) {
            return;
        }
        model.beginInit();
        model.batchCreateNewEntryRow(ENTRY_ENTITY, size);
        for (int i = 0; i < size; ++i) {
            ModelModifyLogEntity entity = (ModelModifyLogEntity)modelModifyLogEntities.get(i);
            model.setValue(ELEMENT_NAME, (Object)entity.getElementName(), i);
            model.setValue(GROUP, (Object)(WfUtils.isEmpty((ILocaleString)entity.getGroupName()) ? null : entity.getGroupName()), i);
            model.setValue(PROP_NAME, (Object)(WfUtils.isEmpty((ILocaleString)entity.getPropertyName()) ? null : entity.getPropertyName()), i);
            model.setValue(DESIGN_PROP, (Object)entity.getContent(), i);
            model.setValue(MANAGE_PROP, (Object)entity.getOldval(), i);
        }
        model.endInit();
        this.getView().updateView(ENTRY_ENTITY);
    }

    private void showForDynaConfScheme() {
        IDataModel model = this.getModel();
        Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("schemeId");
        DynamicConfigSchemeEntity dEntity = (DynamicConfigSchemeEntity)this.getRepositoryService().findEntityById(schemeId, "wf_processdynamicconfig");
        if (dEntity == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5b50\u65b9\u6848\u5df2\u4e0d\u5b58\u5728\u3002", (String)"WfVersionDifferencePlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            model.deleteEntryData(ENTRY_ENTITY);
            return;
        }
        Long parentSchemeId = dEntity.getParentSchemeId();
        String sonJson = this.getManagementService().getDynamicConfigSchemeModelString(schemeId);
        String parentJson = this.getManagementService().getDynamicConfigSchemeModelString(parentSchemeId);
        List modelModifyLogEntities = this.getManagementService().compareVersionDifference(parentJson, sonJson, (IModelModifyLog)dEntity, Collections.emptySet());
        Long procDefId = dEntity.getProcDefId();
        ProcessDefinitionEntity procEntity = this.getRepositoryService().getProcessdefineById(procDefId);
        FieldEdit mFieldEdit = (FieldEdit)this.getControl(MANAGE_PROP);
        mFieldEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u9ed8\u8ba4\u65b9\u6848\u5c5e\u6027", (String)"WfVersionDifferencePlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0])));
        FieldEdit dFieldEdit = (FieldEdit)this.getControl(DESIGN_PROP);
        dFieldEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5b50\u65b9\u6848\u5c5e\u6027", (String)"WfVersionDifferencePlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0])));
        model.setValue(PROC_NUM, (Object)procEntity.getKey());
        model.setValue(PROC_NAME, (Object)procEntity.getName());
        model.deleteEntryData(ENTRY_ENTITY);
        int size = modelModifyLogEntities.size();
        if (size == 0) {
            return;
        }
        model.beginInit();
        model.batchCreateNewEntryRow(ENTRY_ENTITY, size);
        for (int i = 0; i < size; ++i) {
            ModelModifyLogEntity entity = (ModelModifyLogEntity)modelModifyLogEntities.get(i);
            model.setValue(ELEMENT_NAME, (Object)entity.getElementName(), i);
            model.setValue(GROUP, (Object)entity.getGroupName(), i);
            model.setValue(PROP_NAME, (Object)entity.getPropertyName(), i);
            model.setValue(MANAGE_PROP, (Object)entity.getContent(), i);
            model.setValue(DESIGN_PROP, (Object)entity.getOldval(), i);
        }
        model.endInit();
        this.getView().updateView(ENTRY_ENTITY);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "refresh": {
                this.refresh();
                break;
            }
        }
    }

    private void refresh() {
        this.showData();
    }
}

