/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.management.plugin;

import java.util.HashSet;
import java.util.List;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.design.plugin.AbstractWorkflowListPlugin;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.impl.persistence.entity.basedata.BaseDataRefRecordEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;

public class WorkflowBasedataRefRecordListPlugin
extends AbstractWorkflowListPlugin {
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        this.addProcessTypeFilter(e);
    }

    private void addProcessTypeFilter(SetFilterEvent e) {
        RepositoryService service = this.getRepositoryService();
        List records = service.findEntitiesByFilters("wf_basedatarefrecord", e.getQFilters().toArray(new QFilter[0]), "procdefid", null);
        if (records.isEmpty()) {
            return;
        }
        HashSet<Long> procDefIds = new HashSet<Long>(records.size());
        for (BaseDataRefRecordEntity record : records) {
            procDefIds.add(record.getProcdefId());
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", procDefIds), new QFilter("type", "=", (Object)ModelType.AuditFlow.name())};
        List entities = service.findEntitiesByFilters("wf_processdefinition", filters, "id", null);
        if (!entities.isEmpty()) {
            procDefIds = new HashSet(entities.size());
            for (ProcessDefinitionEntity entity : entities) {
                procDefIds.add(entity.getId());
            }
            e.getQFilters().add(new QFilter("procdefid", "in", procDefIds));
        }
    }
}

