/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.management.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.field.ComboItem;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.WfUtils;

public class WorkflowResWordsVersionPlugin
extends AbstractWorkflowPlugin
implements RowClickEventListener {
    private static final String ENTRYENTITY = "entryentity";
    private static final String PROCDEFID = "procdefid";
    private static final String VERSION = "version";
    private static final String BTNOK = "btnok";
    private static final String SELECTEDROW = "selectedRow";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK});
    }

    public void afterBindData(EventObject e) {
        int index;
        super.afterBindData(e);
        String rowIndex = this.getPageCache().get(SELECTEDROW);
        if (!WfUtils.isEmpty((String)rowIndex) && (index = Integer.parseInt(rowIndex)) > -1) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
            entryGrid.selectRows(index);
        }
        this.getPageCache().remove(SELECTEDROW);
    }

    public void afterCreateNewData(EventObject e) {
        this.initEntryEntity();
    }

    private void initEntryEntity() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String procNumber = (String)customParams.get("procNumber");
        String procDefId = (String)customParams.get("procDefId");
        List<ComboItem> items = DesignerModelUtil.getProcdefPreviousVersionItemsWithResourceWords(procNumber);
        int selectRow = -1;
        if (items != null && !items.isEmpty()) {
            IDataModel model = this.getModel();
            model.batchCreateNewEntryRow(ENTRYENTITY, items.size());
            int i = 0;
            for (ComboItem item : items) {
                String value = item.getValue();
                if (!WfUtils.isEmpty((String)value) && value.equals(procDefId)) {
                    selectRow = i;
                }
                model.setValue(PROCDEFID, (Object)value, i);
                LocaleString caption = item.getCaption();
                if (!WfUtils.isEmpty((ILocaleString)caption)) {
                    model.setValue(VERSION, (Object)caption.getLocaleValue(), i);
                }
                ++i;
            }
        }
        if (selectRow > -1) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
            entryGrid.selectRows(selectRow);
            this.getPageCache().put(SELECTEDROW, String.valueOf(selectRow));
        }
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        if (BTNOK.equals(key)) {
            this.returnDataToParent();
        }
    }

    private void returnDataToParent() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int rowIndex = entryGrid.getEntryState().getFocusRow();
        if (rowIndex <= -1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7248\u672c\u53f7", (String)"WorkflowResWordsVersionPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, String> returnData = new HashMap<String, String>();
        IDataModel model = this.getModel();
        returnData.put("procDefId", (String)model.getValue(PROCDEFID, rowIndex));
        returnData.put(VERSION, (String)model.getValue(VERSION, rowIndex));
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }
}

