/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.management.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.AfterShowTipsEvent;
import kd.bos.form.control.events.BeforeShowTipsEvent;
import kd.bos.form.control.events.TipsListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.bpmn.model.deploy.ExportScheme;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.WfAdminUtil;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.scheme.enumeration.ImportType;
import kd.bos.workflow.engine.impl.scheme.model.ImportSchemeParameter;
import kd.bos.workflow.engine.impl.scheme.model.ProcessDiffResult;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.management.batchsetting.MutexResult;

public class WorkflowSchemeImportStrategyPlugin
extends AbstractWorkflowPlugin
implements TipsListener {
    private static final String BTN_CONFIRM = "btnok";
    private static final String ENTRYFORNEW = "entryfornew";
    private static final String ENTRYENTITY = "entryentity";
    private static final String ENTRYFORNODIFF = "entryfornodiff";
    private static final String LABEL_COUNT = "count";
    private static final String LABEL_COUNTFORNEW = "countfornew";
    private static final String LABEL_DIFFCOUNT = "diffcount";
    private static final String LABEL_NODIFFCOUNT = "nodiffcount";
    private static final String NAMEFORNEW = "namefornew";
    private static final String NUMBERFORNEW = "numberfornew";
    private static final String STRATEGYFORNEW = "strategyfornew";
    private static final String PROCNAME = "procname";
    private static final String PROCNUMBER = "procnumber";
    private static final String PROCNUMBER_NODIFF = "numberfornodiff";
    private static final String PROCNAME_NODIFF = "namefornodiff";
    private static final String CHANGES = "changes";
    private static final String TIP_CHANGES = "changestip";
    private static final String STRATEGY = "strategy";
    private static final String STRATEGY_NODIFF = "strategyfornodiff";
    private static final String SV_SYNCHRONIZE_RESOURCEWORDS = "sv_syncreswords";
    private static final String SYNCHRONIZE_RESOURCEWORDS = "syncreswords";
    private static final String SV_SYNCHRONIZE_RESOURCEWORDS_NODIFF = "sv_syncreswordsfornodiff";
    private static final String SYNCHRONIZE_RESOURCEWORDS_NODIFF = "syncreswordsfornodiff";
    private static final String TITLE_PANELFORNEW = "titlepanelfornew";
    private static final String TITLE_PANELFOREXIST = "titlepanelforexist";
    private static final String TITLE_PANELFORDIFF = "titlepanelfordiff";
    private static final String TITLE_PANELFORNODIFF = "titlepanelfornodiff";
    private static final String SCHEME_PANELFORNEW = "schemepanelfornew";
    private static final String SCHEME_PANELFORDIFF = "schemepanelfordiff";
    private static final String SCHEME_PANELFORNODIFF = "schemepanelfornodiff";
    private final String COUNT_TPL = ResManager.loadKDString((String)"%s\u4e2a", (String)"WorkflowSchemeImportStrategyPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]);
    private final String TIP_TPL = ResManager.loadKDString((String)"\u8282\u70b9\u6216\u7ebf\u5b58\u5728%s\u4e2a\u53d8\u52a8", (String)"WorkflowSchemeImportStrategyPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]);
    private static final String PREFIX_CHANGES = "diff_";
    private static final String CACHE_KEY_DIFFCOUNT = "diffcount";
    private static final String COVER_IMPORT_MBSUMMARYCFG = "coverImportMBSummaryCfg";
    private DcxmlSerializer serializer = new DcxmlSerializer(ExportScheme.getDCBinder());
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public WorkflowSchemeImportStrategyPlugin() {
        this.serializer.setColloctionIgnorePKValue(true);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CONFIRM, SV_SYNCHRONIZE_RESOURCEWORDS, SV_SYNCHRONIZE_RESOURCEWORDS_NODIFF});
        Label tip = (Label)this.getControl(TIP_CHANGES);
        tip.addTipsListener((TipsListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        List schemeParameters = SerializationUtils.fromJsonStringToList((String)parameter.getCustomParam("parameter").toString(), ImportSchemeParameter.class);
        this.initPanel(schemeParameters);
    }

    private void initPanel(List<ImportSchemeParameter> schemeParameters) {
        if (schemeParameters == null || schemeParameters.isEmpty()) {
            this.log.debug("\u521d\u59cb\u5316\u65b9\u6848\u5bfc\u5165\u7b56\u7565\u9875\u9762\u9700\u8981\u7684\u53c2\u6570\u4e3a\u7a7a\uff01");
            return;
        }
        ProcessDiffResult result = null;
        IDataModel model = this.getModel();
        int newCount = 0;
        int diffCount = 0;
        int noDiffCount = 0;
        String procName = null;
        String procNumber = null;
        String TPL_NUMBER = "%s ( %s )";
        HashMap<String, String> retMap = new HashMap<String, String>();
        for (ImportSchemeParameter parameter : schemeParameters) {
            procNumber = parameter.getNumber();
            procName = String.format("%s ( %s )", parameter.getName(), procNumber);
            result = parameter.getDiffResult();
            if (result != null) {
                if (result.isExistDiff()) {
                    model.createNewEntryRow(ENTRYENTITY);
                    model.setValue(PROCNAME, (Object)procName, diffCount);
                    model.setValue(PROCNUMBER, (Object)procNumber, diffCount);
                    model.setValue(CHANGES, (Object)String.format(this.TIP_TPL, result.getAddedNodes().size() + result.getRemovedNodes().size()), diffCount);
                    retMap.put(String.format("%s%s", PREFIX_CHANGES, diffCount), SerializationUtils.toJsonString((Object)result));
                    this.initSyncResWords(ENTRYENTITY, model, procNumber, diffCount, SV_SYNCHRONIZE_RESOURCEWORDS);
                    ++diffCount;
                    continue;
                }
                model.createNewEntryRow(ENTRYFORNODIFF);
                model.setValue(PROCNAME_NODIFF, (Object)procName, noDiffCount);
                model.setValue(PROCNUMBER_NODIFF, (Object)procNumber, noDiffCount);
                this.initSyncResWords(ENTRYFORNODIFF, model, procNumber, noDiffCount, SV_SYNCHRONIZE_RESOURCEWORDS_NODIFF);
                ++noDiffCount;
                continue;
            }
            model.createNewEntryRow(ENTRYFORNEW);
            model.setValue(NAMEFORNEW, (Object)procName, newCount);
            model.setValue(NUMBERFORNEW, (Object)procNumber, newCount);
            ++newCount;
        }
        if (!retMap.isEmpty()) {
            this.getPageCache().put(retMap);
        }
        this.getPageCache().put("diffcount", String.valueOf(diffCount));
        if (newCount > 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{TITLE_PANELFORNEW, SCHEME_PANELFORNEW});
            Label countForNew = (Label)this.getControl(LABEL_COUNTFORNEW);
            countForNew.setText(String.format(this.COUNT_TPL, newCount));
        }
        if (diffCount > 0 && noDiffCount > 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{TITLE_PANELFOREXIST, TITLE_PANELFORDIFF, TITLE_PANELFORNODIFF, SCHEME_PANELFORDIFF, SCHEME_PANELFORNODIFF});
        } else if (diffCount > 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{TITLE_PANELFOREXIST, SCHEME_PANELFORDIFF});
        } else if (noDiffCount > 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{TITLE_PANELFOREXIST, SCHEME_PANELFORNODIFF});
        }
        Label countForDiff = (Label)this.getControl("diffcount");
        countForDiff.setText(String.format(this.COUNT_TPL, diffCount));
        Label countForNoDiff = (Label)this.getControl(LABEL_NODIFFCOUNT);
        countForNoDiff.setText(String.format(this.COUNT_TPL, noDiffCount));
        Label count = (Label)this.getControl(LABEL_COUNT);
        count.setText(String.format(this.COUNT_TPL, diffCount + noDiffCount));
        this.initStrategyItems(newCount, diffCount, noDiffCount);
    }

    private void initSyncResWords(String entryEntity, IDataModel model, String procNumber, int index, String controlKey) {
        List<ComboItem> versions = DesignerModelUtil.getProcdefPreviousVersionItemsWithResourceWords(procNumber);
        if (versions == null || versions.isEmpty()) {
            CardEntry cardEntry = (CardEntry)this.getView().getControl(entryEntity);
            cardEntry.setChildVisible(false, index, new String[]{controlKey});
        }
    }

    private void initStrategyItems(int newCount, int diffCount, int noDiffCount) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        String controlKey = null;
        ComboItem newItem = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u65b0\u5efa", (String)"WorkflowSchemeImportStrategyPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0])), ImportType.CREATE.toString());
        if (newCount == 1 && diffCount == 0 && noDiffCount == 0) {
            controlKey = STRATEGYFORNEW;
            items.add(newItem);
        } else if (diffCount == 1 && newCount == 0 && noDiffCount == 0) {
            controlKey = STRATEGY;
            items.add(newItem);
        } else if (noDiffCount == 1 && newCount == 0 && diffCount == 0) {
            controlKey = STRATEGY_NODIFF;
            items.add(newItem);
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u8986\u76d6", (String)"WorkflowSchemeImportStrategyPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0])), ImportType.COVER.toString()));
        }
        if (items.size() > 0 && controlKey != null) {
            ComboEdit strategy = (ComboEdit)this.getControl(controlKey);
            strategy.setComboItems(items);
            this.getModel().setValue(controlKey, (Object)ImportType.CREATE.toString());
        }
    }

    public void click(EventObject evt) {
        String key;
        Control ctrl = (Control)evt.getSource();
        switch (key = ctrl.getKey()) {
            case "btnok": {
                this.confirm(false, null);
                break;
            }
            case "sv_syncreswords": {
                this.showResWordsVersion(SV_SYNCHRONIZE_RESOURCEWORDS, ENTRYENTITY, PROCNUMBER, SYNCHRONIZE_RESOURCEWORDS, SV_SYNCHRONIZE_RESOURCEWORDS);
                break;
            }
            case "sv_syncreswordsfornodiff": {
                this.showResWordsVersion(SV_SYNCHRONIZE_RESOURCEWORDS_NODIFF, ENTRYFORNODIFF, PROCNUMBER_NODIFF, SYNCHRONIZE_RESOURCEWORDS_NODIFF, SV_SYNCHRONIZE_RESOURCEWORDS_NODIFF);
                break;
            }
            default: {
                super.click(evt);
            }
        }
    }

    private void confirm(boolean isConfirmCallBack, Boolean isCoverSummaryCfg) {
        List<ImportSchemeParameter> importParameters = this.getImportParameters();
        if (importParameters == null || importParameters.isEmpty()) {
            this.log.warn("\u7f13\u5b58\u4e2d\u53d6\u5230\u7684 ImportSchemeParameters\u4e3a\u7a7a\uff01");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff01", (String)"WorkflowSchemeImportStrategyPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        } else {
            try {
                List<ImportSchemeParameter> schemeParameters = this.getSchemeParameters(importParameters);
                if (schemeParameters.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u65b0\u5efa\u6216\u8986\u76d6\u7684\u6d41\u7a0b\u3002", (String)"WorkflowSchemeImportStrategyPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
                HashMap<String, String> procNumberContent = new HashMap<String, String>(schemeParameters.size());
                for (ImportSchemeParameter schemeParameter : schemeParameters) {
                    String procNumberImportType = String.format("%s,%s", schemeParameter.getNumber(), schemeParameter.getImportType().toString());
                    procNumberContent.put(procNumberImportType, schemeParameter.getSchemeContent());
                }
                if (this.checkMobileBillSummaryCfg(schemeParameters, procNumberContent, isConfirmCallBack, isCoverSummaryCfg)) {
                    this.importSchemes(importParameters, schemeParameters);
                }
            }
            catch (Exception e) {
                this.getView().showErrorNotification(e.getMessage());
                this.log.warn(WfUtils.getExceptionStacktrace((Throwable)e));
            }
        }
    }

    private List<ImportSchemeParameter> getImportParameters() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object parameter = showParameter.getCustomParam("parameter");
        if (parameter != null) {
            return SerializationUtils.fromJsonStringToList((String)parameter.toString(), ImportSchemeParameter.class);
        }
        return new ArrayList<ImportSchemeParameter>();
    }

    private List<ImportSchemeParameter> getSchemeParameters(List<ImportSchemeParameter> importParameters) {
        HashMap<String, ImportSchemeParameter> parameterMap = new HashMap<String, ImportSchemeParameter>(importParameters.size());
        for (ImportSchemeParameter importParameter : importParameters) {
            parameterMap.put(importParameter.getNumber(), importParameter);
        }
        ArrayList<ImportSchemeParameter> schemeParameters = new ArrayList<ImportSchemeParameter>();
        schemeParameters.addAll(this.getEntrySchemeParameters(parameterMap, ENTRYFORNEW, NUMBERFORNEW, STRATEGYFORNEW));
        schemeParameters.addAll(this.getEntrySchemeParameters(parameterMap, ENTRYENTITY, PROCNUMBER, STRATEGY));
        schemeParameters.addAll(this.getEntrySchemeParameters(parameterMap, ENTRYFORNODIFF, PROCNUMBER_NODIFF, STRATEGY_NODIFF));
        return schemeParameters;
    }

    private boolean checkMobileBillSummaryCfg(List<ImportSchemeParameter> schemeParameters, Map<String, String> procNumberContent, boolean isConfirmCallBack, Boolean isCoverSummaryCfg) {
        if (procNumberContent == null || procNumberContent.isEmpty()) {
            return true;
        }
        StringBuilder sameEntityMBSummaryNumbers = new StringBuilder();
        StringBuilder notSameEntityMBSummaryNumbers = new StringBuilder();
        boolean filterByOrg = WfConfigurationUtil.isFilterDataByOrg();
        for (Map.Entry<String, String> entry : procNumberContent.entrySet()) {
            List mobileBillSummarys;
            DynamicObject def;
            List procDefs;
            String procNumber = entry.getKey().split(",")[0];
            String importType = entry.getKey().split(",")[1];
            String schemeContent = entry.getValue();
            ExportScheme exportScheme = (ExportScheme)this.serializer.deserializeFromString(schemeContent, null);
            if ("cover".equalsIgnoreCase(importType) && filterByOrg && WfUtils.isNotEmptyForCollection((Collection)(procDefs = exportScheme.getProcessDefinitions())) && null != (def = (DynamicObject)procDefs.get(0))) {
                Object orgUnitId = def.get("orgunitid_id");
                long userId = Long.parseLong(RequestContext.get().getUserId());
                boolean isAdminForOrg = WfAdminUtil.isAdminForOrg((Long)userId, (Long)((Long)orgUnitId));
                if (!isAdminForOrg) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u6240\u5c5e\u7ec4\u7ec7\u201d\u4e0d\u5728\u60a8\u7684\u7ba1\u8f96\u7ec4\u7ec7\u8303\u56f4\u5185\uff0c\u4e0d\u80fd\u8fdb\u884c\u8986\u76d6\u5bfc\u5165\u3002", (String)"WorkflowSchemeImportStrategyPlugin_10", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return false;
                }
            }
            if ((mobileBillSummarys = exportScheme.getMobileBillSummaryCfg()) == null || mobileBillSummarys.isEmpty()) continue;
            StringBuilder sameMBSummaryNumbers = new StringBuilder();
            StringBuilder notSameMBSummaryNumbers = new StringBuilder();
            this.getTargetMobileBillSummarys(mobileBillSummarys, importType, sameMBSummaryNumbers, notSameMBSummaryNumbers);
            if (sameMBSummaryNumbers.length() > 1) {
                String mBSummaryNumbers = sameMBSummaryNumbers.substring(0, sameMBSummaryNumbers.length() - 1);
                sameEntityMBSummaryNumbers.append(String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u3010%1$s\u3011\u4e2d\u7684\u79fb\u52a8\u5355\u636e\u6458\u8981\u8bbe\u7f6e\u3010%2$s\u3011\uff1b", (String)"WorkflowSchemeImportStrategyPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]), procNumber, mBSummaryNumbers));
                this.setCoverSummaryCfg(isConfirmCallBack, schemeParameters, isCoverSummaryCfg, procNumber);
            }
            if (notSameMBSummaryNumbers.length() <= 1) continue;
            String summaryNumbers = notSameMBSummaryNumbers.substring(0, notSameMBSummaryNumbers.length() - 1);
            notSameEntityMBSummaryNumbers.append(String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u3010%1$s\u3011\u4e2d\u7684\u79fb\u52a8\u5355\u636e\u6458\u8981\u8bbe\u7f6e\u3010%2$s\u3011\uff1b", (String)"WorkflowSchemeImportStrategyPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]), procNumber, summaryNumbers));
        }
        if (notSameEntityMBSummaryNumbers.length() > 1) {
            String errorNotification = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u7ecf\u5b58\u5728\uff0c\u4f46\u5bf9\u5e94\u7684\u5355\u636e\u5b9e\u4f53\u4e0d\u76f8\u540c\uff0c\u4e0d\u80fd\u5bfc\u5165\uff0c\u8bf7\u4fee\u6539\u7f16\u7801\u540e\u518d\u5c1d\u8bd5\u3002", (String)"WorkflowSchemeImportStrategyPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]), notSameEntityMBSummaryNumbers.substring(0, notSameEntityMBSummaryNumbers.length() - 1));
            this.getView().showErrorNotification(errorNotification);
            return false;
        }
        if (!isConfirmCallBack && sameEntityMBSummaryNumbers.length() > 1) {
            String message = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u7ecf\u5b58\u5728\uff0c\u8986\u76d6\u540e\u5176\u4ed6\u5f15\u7528\u4e86\u8be5\u79fb\u52a8\u5355\u636e\u6458\u8981\u7684\u6d41\u7a0b\u5c06\u4f7f\u7528\u5bfc\u5165\u540e\u7684\u6570\u636e\uff0c\u662f\u5426\u786e\u8ba4\u8986\u76d6\uff1f", (String)"WorkflowSchemeImportStrategyPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]), sameEntityMBSummaryNumbers.substring(0, sameEntityMBSummaryNumbers.length() - 1));
            this.getView().showConfirm(message, MessageBoxOptions.YesNoCancel, new ConfirmCallBackListener(COVER_IMPORT_MBSUMMARYCFG));
            return false;
        }
        return true;
    }

    private void getTargetMobileBillSummarys(List<DynamicObject> mobileBillSummarys, String importType, StringBuilder sameMBSummaryNumbers, StringBuilder notSameMBSummaryNumbers) {
        for (DynamicObject mobileBillSummary : mobileBillSummarys) {
            String summaryNumber = mobileBillSummary.getString("number");
            String billType = mobileBillSummary.getString("billtype_id");
            QFilter filter1 = new QFilter("number", "=", (Object)summaryNumber);
            QFilter filter2 = new QFilter("billtype", "=", (Object)billType);
            boolean existsSameEntityMBSummary = QueryServiceHelper.exists((String)"wf_mbillsummary_cfg", (QFilter[])new QFilter[]{filter1, filter2});
            if (!ImportType.DONOTHING.toString().equals(importType) && existsSameEntityMBSummary) {
                sameMBSummaryNumbers.append(summaryNumber).append("\uff0c");
            }
            QFilter filter3 = new QFilter("billtype", "!=", (Object)billType);
            boolean existsNotSameEntityMBSummary = QueryServiceHelper.exists((String)"wf_mbillsummary_cfg", (QFilter[])new QFilter[]{filter1, filter3});
            if (ImportType.DONOTHING.toString().equals(importType) || !existsNotSameEntityMBSummary) continue;
            notSameMBSummaryNumbers.append(summaryNumber).append("\uff0c");
        }
    }

    private void setCoverSummaryCfg(boolean isConfirmCallBack, List<ImportSchemeParameter> schemeParameters, Boolean isCoverSummaryCfg, String procNumber) {
        if (!isConfirmCallBack) {
            return;
        }
        for (ImportSchemeParameter schemeParameter : schemeParameters) {
            if (!procNumber.equals(schemeParameter.getNumber())) continue;
            schemeParameter.setCoverSummaryCfg(isCoverSummaryCfg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importSchemes(List<ImportSchemeParameter> importParameters, List<ImportSchemeParameter> schemeParameters) {
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        List results = null;
        HashSet<String> procNumbers = new HashSet<String>(schemeParameters.size());
        try {
            for (ImportSchemeParameter importSchemeParameter : schemeParameters) {
                if (ImportType.DONOTHING == importSchemeParameter.getImportType()) continue;
                String tip = this.requireMutexLock(importSchemeParameter.getName(), importSchemeParameter.getNumber());
                if (tip != null) {
                    this.getView().showTipNotification(tip, Integer.valueOf(5000));
                    return;
                }
                procNumbers.add(importSchemeParameter.getNumber());
            }
            results = this.getRepositoryService().importSchemes(schemeParameters, this.getView().getFormShowParameter().getAppId());
        }
        finally {
            this.releaseMutexLock(procNumbers);
        }
        if (results != null && !results.isEmpty()) {
            returnData.put("validateResults", SerializationUtils.toJsonString((Object)results));
        }
        returnData.put("importSchemesResult", "finish");
        ArrayList<Long> processDefinitionIds = new ArrayList<Long>(schemeParameters.size());
        for (ImportSchemeParameter parameter : schemeParameters) {
            processDefinitionIds.add(parameter.getProcessDefinitionId());
        }
        returnData.put("processDefinitionIds", processDefinitionIds);
        HashMap<String, ImportType> hashMap = new HashMap<String, ImportType>(importParameters.size());
        HashMap<String, ImportType> importName = new HashMap<String, ImportType>(importParameters.size());
        for (ImportSchemeParameter importParameter : importParameters) {
            hashMap.put(importParameter.getNumber(), importParameter.getImportType());
            importName.put(importParameter.getName(), importParameter.getImportType());
        }
        if (!hashMap.isEmpty()) {
            returnData.put("importType", hashMap);
            returnData.put("importName", importName);
        }
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    private String requireMutexLock(String name, String number) {
        MutexResult result = BpmnModelUtil.requirePublishOrImportProcessMutexLock((String)"import", (String)number);
        if (!result.isSuccess()) {
            String nameNumber = String.format("%s(%s)", name, number);
            return String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u6b63\u5728\u53d1\u5e03\u6216\u5bfc\u5165\u6d41\u7a0b\u201c%2$s\u201d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"WorkflowSchemeImportStrategyPlugin_11", (String)"bos-wf-formplugin", (Object[])new Object[0]), result.getUserName(), nameNumber);
        }
        return null;
    }

    private void releaseMutexLock(Set<String> procNumbers) {
        for (String procNumber : procNumbers) {
            BpmnModelUtil.releasePublishOrImportProcessMutexLock((String)"import", (String)procNumber);
        }
    }

    private List<ImportSchemeParameter> getEntrySchemeParameters(Map<String, ImportSchemeParameter> parameterMap, String entry, String number, String strategy) {
        ArrayList<ImportSchemeParameter> schemeParameters = new ArrayList<ImportSchemeParameter>();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entry);
        if (entryEntity != null) {
            ImportSchemeParameter schemeParameter = null;
            String importType = null;
            String syncResWordsId = null;
            for (DynamicObject row : entryEntity) {
                importType = row.getString(strategy);
                if (ImportType.DONOTHING.toString().equalsIgnoreCase(importType)) continue;
                schemeParameter = parameterMap.get(row.getString(number));
                schemeParameter.setImportType(ImportType.getImportType((String)importType));
                if (ENTRYENTITY.equals(entry)) {
                    syncResWordsId = row.getString(SYNCHRONIZE_RESOURCEWORDS);
                } else if (ENTRYFORNODIFF.equals(entry)) {
                    syncResWordsId = row.getString(SYNCHRONIZE_RESOURCEWORDS_NODIFF);
                }
                schemeParameter.setSyncResWordsId(syncResWordsId);
                schemeParameters.add(schemeParameter);
            }
        }
        return schemeParameters;
    }

    private void showResWordsVersion(String key, String entryEntity, String procNumCtrl, String syncReswordsCtrl, String svSyncReswordsCtrl) {
        CardEntry cardEntry = (CardEntry)this.getView().getControl(entryEntity);
        int index = cardEntry.getEntryState().getFocusRow();
        IDataModel model = this.getModel();
        HashMap<String, Object> params = new HashMap<String, Object>();
        String procNumber = (String)model.getValue(procNumCtrl, index);
        params.put("procNumber", procNumber);
        String procdefId = (String)model.getValue(syncReswordsCtrl, index);
        params.put("procDefId", procdefId);
        this.showForm(key, "wf_reswordsversion", params);
    }

    public void beforeShowTips(BeforeShowTipsEvent evt) {
        EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] rows = grid.getSelectRows();
        if (rows.length > 0) {
            int row = rows[0];
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            paramsMap.put("result", this.getPageCache().get(String.format("%s%s", PREFIX_CHANGES, row)));
            evt.setParamsMap(paramsMap);
        } else {
            this.log.debug("\u9009\u4e2d\u884c\u4e3a\u7a7a\uff01");
        }
    }

    public void afterShowTips(AfterShowTipsEvent evt) {
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (COVER_IMPORT_MBSUMMARYCFG.equals(callBackId)) {
            MessageBoxResult result = messageBoxClosedEvent.getResult();
            if (MessageBoxResult.Cancel.equals((Object)result)) {
                return;
            }
            Boolean isCoverSummaryCfg = Boolean.FALSE;
            if (MessageBoxResult.Yes.equals((Object)result)) {
                isCoverSummaryCfg = Boolean.TRUE;
            }
            this.confirm(true, isCoverSummaryCfg);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        String propName = property.getName();
        if (STRATEGY_NODIFF.equals(propName)) {
            this.propertyChangeForStrategy(ENTRYFORNODIFF, PROCNUMBER_NODIFF, STRATEGY_NODIFF, SV_SYNCHRONIZE_RESOURCEWORDS_NODIFF);
        } else if (STRATEGY.equals(propName)) {
            this.propertyChangeForStrategy(ENTRYENTITY, PROCNUMBER, STRATEGY, SV_SYNCHRONIZE_RESOURCEWORDS);
        }
    }

    private void propertyChangeForStrategy(String entryEntity, String procNumCtrl, String strategyCtrl, String resWordsCtrl) {
        CardEntry cardEntry = (CardEntry)this.getView().getControl(entryEntity);
        int index = cardEntry.getEntryState().getFocusRow();
        IDataModel model = this.getModel();
        String procNumber = (String)model.getValue(procNumCtrl, index);
        String strategyForNodiff = (String)model.getValue(strategyCtrl, index);
        List<ComboItem> versions = DesignerModelUtil.getProcdefPreviousVersionItemsWithResourceWords(procNumber);
        if (ImportType.DONOTHING.toString().equals(strategyForNodiff) || versions == null || versions.isEmpty()) {
            cardEntry.setChildVisible(false, index, new String[]{resWordsCtrl});
        } else {
            cardEntry.setChildVisible(true, index, new String[]{resWordsCtrl});
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId) {
            case "sv_syncreswords": {
                this.setSyncResourceWords(ENTRYENTITY, SV_SYNCHRONIZE_RESOURCEWORDS, SYNCHRONIZE_RESOURCEWORDS, returnData);
                break;
            }
            case "sv_syncreswordsfornodiff": {
                this.setSyncResourceWords(ENTRYFORNODIFF, SV_SYNCHRONIZE_RESOURCEWORDS_NODIFF, SYNCHRONIZE_RESOURCEWORDS_NODIFF, returnData);
                break;
            }
        }
    }

    private void setSyncResourceWords(String entryEntity, String svSyncResWords, String syncResWords, Object returnData) {
        Map data = (Map)returnData;
        CardEntry cardEntry = (CardEntry)this.getView().getControl(entryEntity);
        int index = cardEntry.getEntryState().getFocusRow();
        if (index > -1) {
            IDataModel model = this.getModel();
            model.setValue(svSyncResWords, data.get("version"), index);
            model.setValue(syncResWords, data.get("procDefId"), index);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String countStr = this.getPageCache().get("diffcount");
        this.getPageCache().remove("diffcount");
        if (WfUtils.isNotEmpty((String)countStr)) {
            int count = Integer.parseInt(countStr);
            for (int i = 0; i < count; ++i) {
                this.getPageCache().remove(String.format("%s%s", PREFIX_CHANGES, i));
            }
        }
    }
}

