/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.management.plugin;

import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.scheme.model.NodeInfo;
import kd.bos.workflow.engine.impl.scheme.model.ProcessDiffResult;

public class WorkflowSchemeNodesDiffPlugin
extends AbstractWorkflowPlugin {
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String ENTRY_ADDED = "addedentry";
    private static final String ENTRY_REMOVED = "removedentry";
    private static final String LABEL_ADDEDNODE = "addednode";
    private static final String LABEL_REMOVEDNODE = "removednode";
    private final String TPL_ADD_NODE = ResManager.loadKDString((String)"\u65b0\u589e\u8282\u70b9 %1$s[%2$s]", (String)"WorkflowSchemeNodesDiffPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]);
    private final String TPL_ADD_SEQUENCEFLOW = ResManager.loadKDString((String)"\u65b0\u589e\u8fde\u7ebf %s", (String)"WorkflowSchemeNodesDiffPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]);
    private final String TPL_REMOVE_NODE = ResManager.loadKDString((String)"\u5220\u9664\u8282\u70b9 %1$s[%2$s]", (String)"WorkflowSchemeNodesDiffPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]);
    private final String TPL_REMOVE_SEQUENCEFLOW = ResManager.loadKDString((String)"\u5220\u9664\u8fde\u7ebf %s", (String)"WorkflowSchemeNodesDiffPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]);

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String ret = (String)parameter.getCustomParam("result");
        if (WfUtils.isNotEmpty((String)ret)) {
            IDataModel model = this.getModel();
            ProcessDiffResult result = (ProcessDiffResult)SerializationUtils.fromJsonString((String)ret, ProcessDiffResult.class);
            int index = 0;
            if (result.getAddedNodes().size() > 0) {
                this.getView().setVisible(Boolean.TRUE, new String[]{ENTRY_ADDED});
                this.log.debug("\u521b\u5efa\u65b0\u589e\u8282\u70b9tips...");
                model.batchCreateNewEntryRow(ENTRY_ADDED, result.getAddedNodes().size());
                for (NodeInfo info : result.getAddedNodes()) {
                    if (info.isEdge()) {
                        model.setValue(LABEL_ADDEDNODE, (Object)String.format(this.TPL_ADD_SEQUENCEFLOW, info.getNumber()), index);
                    } else {
                        model.setValue(LABEL_ADDEDNODE, (Object)String.format(this.TPL_ADD_NODE, info.getName(), info.getNumber()), index);
                    }
                    ++index;
                }
            }
            if (result.getRemovedNodes().size() > 0) {
                this.getView().setVisible(Boolean.TRUE, new String[]{ENTRY_REMOVED});
                index = 0;
                this.log.debug("\u521b\u5efa\u5220\u9664\u8282\u70b9tips...");
                model.batchCreateNewEntryRow(ENTRY_REMOVED, result.getRemovedNodes().size());
                for (NodeInfo info : result.getRemovedNodes()) {
                    if (info.isEdge()) {
                        model.setValue(LABEL_REMOVEDNODE, (Object)String.format(this.TPL_REMOVE_SEQUENCEFLOW, info.getNumber()), index);
                    } else {
                        model.setValue(LABEL_REMOVEDNODE, (Object)String.format(this.TPL_REMOVE_NODE, info.getName(), info.getNumber()), index);
                    }
                    ++index;
                }
            }
        } else {
            this.log.debug("\u663e\u793a\u5dee\u5f02tips\u9700\u8981\u7684\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
    }
}

