/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.management.plugin.basedatafiltertools;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.UserProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.converter.util.CollectionUtils;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.bos.workflow.engine.impl.cmd.task.BasedataFormListType;
import kd.bos.workflow.engine.impl.cmd.task.CRRDimenTypeConstant;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.rule.util.ExpressionPropUtils;
import kd.bos.workflow.management.plugin.WfCustomReportRelationUtil;
import kd.bos.workflow.management.plugin.basedatafiltertools.FilterDimemsionParam;

public class FilterDimemsionsPlugin
extends AbstractWorkflowPlugin {
    public static final String CANCEL = "cancel";
    public static final String CONFIRM = "confirm";
    private static final String DIMENSIONNUMBER = "dimensionNumber";
    private static final String CLOSECALLBACK_EXPR = "closecallbackexpr";
    private static final String PROP = "prop";
    private static final String CUSTOMPARAMS = "customParams";
    private static final Set<String> F7_FILTERS = new HashSet<String>();
    private static final Set<String> USERS_NEED_IGNORE = new HashSet<String>();

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{CANCEL, CONFIRM, "constant_field", "express_field"});
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        Map customParams = view.getFormShowParameter().getCustomParams();
        this.getPageCache().put(CUSTOMPARAMS, SerializationUtils.toJsonString((Object)customParams));
        String dimensionNumber = (String)customParams.get("filterdimension");
        String entraBill = (String)customParams.get("entityNumber");
        List qfilters = (List)customParams.get("qfilters");
        this.getPageCache().put(DIMENSIONNUMBER, dimensionNumber);
        this.getPageCache().put("qfilters", SerializationUtils.toJsonString((Object)qfilters));
        String isMultiSelect = customParams.get("isMultiSelect") == null ? String.valueOf(Boolean.FALSE) : String.valueOf(customParams.get("isMultiSelect"));
        this.getPageCache().put("isMultiSelect", isMultiSelect);
        List<Object> dimensionItems = new ArrayList(3);
        dimensionItems = "bos_org".equals(dimensionNumber) ? this.extractOrgItemsFromEntity(entraBill) : this.extractItemsFromEntity(entraBill, dimensionNumber);
        if (CollectionUtil.isNotEmpty(dimensionItems)) {
            ((ComboEdit)this.getControl("business_field")).setComboItems(dimensionItems);
        }
        this.updateControlName(customParams);
        this.updateComboxItemName(customParams);
        String showOption = CRRDimenTypeConstant.BUSINESSFIELD.getValue();
        this.showControl(showOption);
        this.updateControl(customParams);
    }

    private void updateComboxItemName(Map<String, Object> customParams) {
        String businessControlName = (String)customParams.get("businessControlName");
        String constantControlName = (String)customParams.get("constantControlName");
        String expressControlName = (String)customParams.get("expressControlName");
        if (WfUtils.isEmpty((String)businessControlName) && WfUtils.isEmpty((String)constantControlName) && WfUtils.isEmpty((String)expressControlName)) {
            return;
        }
        ComboEdit settingTypeComBox = (ComboEdit)this.getControl("settingtype");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(3);
        items.add(new ComboItem(WfUtils.isEmpty((String)businessControlName) ? ResManager.getLocaleString((String)"\u5355\u636e\u5b57\u6bb5", (String)"WfFilterDimemsionsPlugin_2", (String)"bos-wf-formplugin") : new LocaleString(businessControlName), "2"));
        items.add(new ComboItem(WfUtils.isEmpty((String)constantControlName) ? ResManager.getLocaleString((String)"\u56fa\u5b9a\u503c", (String)"WfFilterDimemsionsPlugin_3", (String)"bos-wf-formplugin") : new LocaleString(constantControlName), "1"));
        items.add(new ComboItem(WfUtils.isEmpty((String)expressControlName) ? ResManager.getLocaleString((String)"\u8868\u8fbe\u5f0f", (String)"WfFilterDimemsionsPlugin_4", (String)"bos-wf-formplugin") : new LocaleString(expressControlName), "3"));
        settingTypeComBox.setComboItems(items);
    }

    private void updateControlName(Map<String, Object> customParams) {
        String businessControlName = (String)customParams.get("businessControlName");
        String constantControlName = (String)customParams.get("constantControlName");
        String expressControlName = (String)customParams.get("expressControlName");
        if (WfUtils.isNotEmpty((String)businessControlName)) {
            ComboEdit businessField = (ComboEdit)this.getControl("business_field");
            businessField.setCaption(new LocaleString(businessControlName));
        }
        if (WfUtils.isNotEmpty((String)constantControlName)) {
            TextEdit constantField = (TextEdit)this.getControl("constant_field");
            constantField.setCaption(new LocaleString(constantControlName));
        }
        if (WfUtils.isNotEmpty((String)expressControlName)) {
            TextEdit expressField = (TextEdit)this.getControl("express_field");
            expressField.setCaption(new LocaleString(expressControlName));
        }
    }

    private void updateControl(Map<String, Object> customParams) {
        String radioOption = (String)customParams.get("radio_option");
        String nameOption = (String)customParams.get("name_option");
        String infoOption = (String)customParams.get("info_option");
        if (radioOption != null && nameOption != null && infoOption != null) {
            this.getModel().setValue("settingtype", (Object)radioOption);
            if (CRRDimenTypeConstant.CONSTANT.getValue().equals(radioOption)) {
                this.getModel().setValue("constant_field", (Object)nameOption);
                this.getModel().setValue("constant_info", (Object)infoOption);
            } else if (CRRDimenTypeConstant.BUSINESSFIELD.getValue().equals(radioOption)) {
                this.getModel().setValue("business_info", (Object)nameOption);
                this.getModel().setValue("business_field", (Object)infoOption);
            } else if (CRRDimenTypeConstant.EXPRESSION.getValue().equals(radioOption)) {
                this.getModel().setValue("express_field", (Object)nameOption);
                this.getModel().setValue("express_info", (Object)infoOption);
            }
            this.showControl(radioOption);
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase()) {
            case "cancel": {
                this.getView().close();
                break;
            }
            case "confirm": {
                this.checkBeforeConfirm();
                break;
            }
            case "constant_field": {
                this.showDimenSelects();
                break;
            }
            case "express_field": {
                this.showExpressionForm();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String propName = property.getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        this.propertyChanged(propName, newValue);
    }

    private void propertyChanged(String propName, Object newValue) {
        switch (propName) {
            case "settingtype": {
                this.showControl(newValue);
                break;
            }
            case "business_field": {
                this.changedBusinessField(newValue);
                break;
            }
        }
    }

    private void changedBusinessField(Object newValue) {
        List dimensionItems;
        String dimensStr = this.getPageCache().get("filterdimension");
        if (WfUtils.isNotEmpty((String)dimensStr) && CollectionUtils.isNotEmpty((Collection)(dimensionItems = SerializationUtils.fromJsonStringToList((String)dimensStr, ComboItem.class)))) {
            for (ComboItem comboItem : dimensionItems) {
                String value = comboItem.getValue();
                if (!StringUtils.equals((CharSequence)newValue.toString(), (CharSequence)value)) continue;
                this.getModel().setValue("business_info", (Object)comboItem.getCaption());
            }
        }
    }

    private void showControl(Object showOption) {
        if (CRRDimenTypeConstant.CONSTANT.getValue().equals(showOption)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"constant_field"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"business_field"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"express_field"});
        } else if (CRRDimenTypeConstant.BUSINESSFIELD.getValue().equals(showOption)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"constant_field"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"business_field"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"express_field"});
        } else if (CRRDimenTypeConstant.EXPRESSION.getValue().equals(showOption)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"constant_field"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"business_field"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"express_field"});
        }
    }

    private void showDimenSelects() {
        String number = this.getPageCache().get(DIMENSIONNUMBER);
        String qfiltersStr = this.getPageCache().get("qfilters");
        ArrayList<QFilter> qfilters = (ArrayList<QFilter>)SerializationUtils.fromJsonString((String)qfiltersStr, List.class);
        String isMultiSelectStr = this.getPageCache().get("isMultiSelect");
        Boolean isMultiSelect = WfUtils.isEmpty((String)isMultiSelectStr) ? Boolean.FALSE : Boolean.valueOf(isMultiSelectStr);
        ListShowParameter showParameter = null;
        showParameter = "bos_user".equals(number) ? WfCustomReportRelationUtil.createShowListForm(number, isMultiSelect, BasedataFormListType.BOS_USERTREELISTF7.getNumber()) : ("bos_org".equals(number) ? WfCustomReportRelationUtil.createShowListForm(number, isMultiSelect, BasedataFormListType.BOS_ADMINORGLISTF7.getNumber()) : WfCustomReportRelationUtil.createShowListForm(number, isMultiSelect, BasedataFormListType.BOS_LISTF7.getNumber()));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "dimenselected");
        showParameter.setCloseCallBack(closeCallBack);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        if (CollectionUtil.isEmpty((Collection)qfilters)) {
            qfilters = new ArrayList<QFilter>();
            this.addFilters(qfilters, number);
        }
        listFilterParameter.setQFilters((List)qfilters);
        showParameter.setListFilterParameter(listFilterParameter);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if ("dimenselected".equals(actionId) && returnData != null) {
            this.setCloseDataForDimen(returnData);
        } else if (CLOSECALLBACK_EXPR.equals(actionId) && returnData != null) {
            this.setCloseDataForExpression(returnData);
        }
    }

    private void setCloseDataForExpression(Object returnData) {
        HashMap dataMap = (HashMap)returnData;
        if (dataMap != null && !dataMap.isEmpty()) {
            String prop = (String)dataMap.get(PROP);
            JSONObject propObj = (JSONObject)SerializationUtils.fromJsonString((String)prop, JSONObject.class);
            String express = propObj.getString("expression");
            String parseType = propObj.getString("parseType");
            String name = "";
            if ("model".equals(parseType)) {
                name = propObj.getString("fullName");
            } else if ("proc".equals(parseType)) {
                name = propObj.getString("name");
            }
            this.getModel().setValue("express_field", (Object)name);
            this.getModel().setValue("express_info", (Object)express);
            this.getPageCache().put("express_field", SerializationUtils.toJsonString((Object)express));
            HashMap<String, String> tempCustomParams = new HashMap<String, String>();
            tempCustomParams.put("name_option", name);
            tempCustomParams.put("info_option", express);
            tempCustomParams.put("radio_option", CRRDimenTypeConstant.EXPRESSION.getValue());
            this.getPageCache().put(CUSTOMPARAMS, SerializationUtils.toJsonString(tempCustomParams));
        } else {
            this.getModel().deleteEntryData("dimenselected");
        }
    }

    private void setCloseDataForDimen(Object returnData) {
        ListSelectedRowCollection datas = (ListSelectedRowCollection)returnData;
        if (CollectionUtils.isNotEmpty((Collection)datas)) {
            ListSelectedRow data = (ListSelectedRow)datas.get(0);
            this.getModel().setValue("constant_field", (Object)data.getName());
            this.getModel().setValue("constant_info", data.getPrimaryKeyValue());
            this.getPageCache().put("constant_field", SerializationUtils.toJsonString((Object)data));
        } else {
            this.getModel().deleteEntryData("dimenselected");
        }
    }

    private void checkBeforeConfirm() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String entityNumber = (String)parameter.getCustomParam("filterdimension");
        String option = (String)this.getModel().getValue("settingtype");
        FilterDimemsionParam filter = new FilterDimemsionParam();
        if (CRRDimenTypeConstant.CONSTANT.getValue().equals(option)) {
            filter.setSelectInfo(option, String.valueOf(this.getModel().getValue("constant_field")), String.valueOf(this.getModel().getValue("constant_info")));
        } else if (CRRDimenTypeConstant.BUSINESSFIELD.getValue().equals(option)) {
            filter.setSelectInfo(option, (String)this.getModel().getValue("business_info"), (String)this.getModel().getValue("business_field"));
        } else if (CRRDimenTypeConstant.EXPRESSION.getValue().equals(option)) {
            filter.setSelectInfo(option, (String)this.getModel().getValue("express_field"), (String)this.getModel().getValue("express_info"));
        }
        FilterDimemsionParam.SelectInfo selectInfo = filter.getSelectInfo();
        String parseInfo = selectInfo.getParseInfo();
        String showName = selectInfo.getShowName();
        if (WfUtils.isEmpty((String)parseInfo) || WfUtils.isEmpty((String)showName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u9879\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WfFilterDimemsionsPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        if (WfUtils.isEmpty((String)selectInfo.getEntityNumber())) {
            selectInfo.setEntityNumber(entityNumber);
        }
        this.getView().returnDataToParent((Object)filter.getSelectInfo().toString());
        this.getView().close();
    }

    private void showExpressionForm() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String modelJson = (String)showParameter.getCustomParam("bpmnModel");
        String entityNumber = (String)showParameter.getCustomParam("entityNumber");
        HashMap<String, Object> content = new HashMap<String, Object>();
        if (WfUtils.isNotEmpty((String)modelJson)) {
            content.put("bpmnModel", modelJson);
        }
        content.put("entityNumber", entityNumber);
        content.put("ruleType", ConditionalRuleType.participant);
        content.put("fromSubjectModelAndApp", "fromSubjectModelAndApp");
        this.setDefaultValue(content);
        FormShowParameter parameter = this.getShowParameter(CLOSECALLBACK_EXPR, "wf_valueexpression", content);
        parameter.setCustomParam("filter", (Object)"filterF7");
        this.showForm(parameter);
    }

    private void setDefaultValue(Map<String, Object> content) {
        String customParamsStr = this.getPageCache().get(CUSTOMPARAMS);
        JSONObject customParams = JSONObject.parseObject((String)customParamsStr);
        String radioOption = customParams.getString("radio_option");
        if (CRRDimenTypeConstant.EXPRESSION.getValue().equals(radioOption)) {
            String infoOption = customParams.getString("info_option");
            content.put("expression", infoOption);
        }
    }

    private List<ComboItem> extractItemsFromEntity(String entraBill, String dimensionNumber) {
        ArrayList<ComboItem> dimensionItems = new ArrayList<ComboItem>();
        if (WfUtils.isEmpty((String)entraBill) || WfUtils.isEmpty((String)dimensionNumber)) {
            return dimensionItems;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entraBill);
        this.extractItems((DynamicObjectType)entityType, dimensionItems, dimensionNumber);
        this.getPageCache().put("filterdimension", SerializationUtils.toJsonString(dimensionItems));
        return dimensionItems;
    }

    private List<ComboItem> extractOrgItemsFromEntity(String entraBill) {
        List<ComboItem> dimensionItems = new ArrayList<ComboItem>(3);
        if (WfUtils.isEmpty((String)entraBill)) {
            return dimensionItems;
        }
        dimensionItems = FilterDimemsionsPlugin.getOrgItems(entraBill);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && "true".equals(parentView.getPageCache().get("isAddMacro"))) {
            dimensionItems = this.addCustomOrgItems(dimensionItems);
        }
        this.getPageCache().put("filterdimension", SerializationUtils.toJsonString(dimensionItems));
        return dimensionItems;
    }

    private List<ComboItem> addCustomOrgItems(List<ComboItem> orgItems) {
        List customProps = ExpressionPropUtils.getCustomPropsByType((String)"bos_org", (String)"bos_org");
        ArrayList<ComboItem> newOrgItems = new ArrayList<ComboItem>(orgItems);
        for (Map prop : customProps) {
            for (ComboItem item : orgItems) {
                String name = item.getCaption().getLocaleValue();
                String value = item.getValue();
                String newName = name + "-" + (String)prop.get("name");
                String newValue = value + "." + (String)prop.get("number");
                newOrgItems.add(new ComboItem(new LocaleString(newName), newValue));
            }
        }
        return newOrgItems;
    }

    private void extractItems(DynamicObjectType entityType, List<ComboItem> dimensionItems, String dimensionNumber) {
        String namePrefix = ResManager.loadKDString((String)"\u5355\u636e-", (String)"PartRelationPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        String valuePrefix = "ENTI_";
        if (entityType instanceof EntryType) {
            namePrefix = entityType.getDisplayName().getLocaleValue() + "-";
            valuePrefix = "ENTRY_" + entityType.getName() + ".";
        }
        for (IDataEntityProperty item : entityType.getProperties()) {
            if (!(item instanceof BasedataProp) && !(item instanceof MulBasedataProp)) continue;
            String value = item.getName();
            String baseEntityId = null;
            if (item instanceof BasedataProp) {
                baseEntityId = ((BasedataProp)item).getBaseEntityId();
            }
            if (item instanceof MulBasedataProp) {
                baseEntityId = ((MulBasedataProp)item).getBaseEntityId();
            }
            if (baseEntityId == null || !baseEntityId.equals(dimensionNumber)) continue;
            LocaleString name = item.getDisplayName();
            String orignalName = name.getLocaleValue();
            String newName = namePrefix + (WfUtils.isNotEmpty((String)orignalName) ? orignalName : "");
            String newValue = valuePrefix + value;
            dimensionItems.add(new ComboItem(new LocaleString(newName), newValue));
        }
    }

    private void addFilters(List<QFilter> qFilters, String number) {
        if (F7_FILTERS.contains(number)) {
            qFilters.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        }
    }

    public static List<ComboItem> getOrgItems(String entraBill) {
        MainEntityType mainEntity = EntityMetadataCache.getDataEntityType((String)entraBill);
        List<ComboItem> fieldItems = FilterDimemsionsPlugin.extractOrgItemsFromEntityCacheForPartRole((DynamicObjectType)mainEntity, ResManager.loadKDString((String)"\u5355\u636e-", (String)"PartRolePlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        Map<String, LocaleString> fieldMap = FilterDimemsionsPlugin.extractOrgMapFromEntityCacheForPartRole((DynamicObjectType)mainEntity, ResManager.loadKDString((String)"\u5355\u636e-", (String)"PartRolePlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        for (IDataEntityProperty prop : mainEntity.getProperties()) {
            if (!(prop instanceof EntryProp)) continue;
            fieldItems.addAll(FilterDimemsionsPlugin.extractOrgItemsFromEntityCacheForPartRole(((EntryProp)prop).getDynamicCollectionItemPropertyType(), null));
            fieldMap.putAll(FilterDimemsionsPlugin.extractOrgMapFromEntityCacheForPartRole(((EntryProp)prop).getDynamicCollectionItemPropertyType(), null));
        }
        return fieldItems;
    }

    protected static List<ComboItem> extractOrgItemsFromEntityCacheForPartRole(DynamicObjectType entityType, String prefix) {
        DataEntityPropertyCollection properties;
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        if (null != entityType && null != (properties = entityType.getProperties()) && properties.size() > 0) {
            String namePrefix = prefix;
            String valuePrefix = "ENTI_";
            if (entityType instanceof EntryType) {
                namePrefix = entityType.getDisplayName().getLocaleValue() + "-";
                valuePrefix = "ENTRY_" + entityType.getName() + ".";
            }
            String newName = null;
            String newValue = null;
            boolean isOrgPropExist = false;
            boolean isBasedataPropForOrg = false;
            boolean isBasedataPropForUser = false;
            BasedataProp itemProp = null;
            String itemPropValue = null;
            LocaleString itemPropNameLocal = null;
            String itemPropName = null;
            String orgPropName = null;
            String orgPropValue = null;
            MainEntityType mainEntityForUser = null;
            DataEntityPropertyCollection propertiesForUser = null;
            EntryType typeForUser = null;
            DataEntityPropertyCollection propertiesForUserEntry = null;
            OrgProp orgPropForUser = null;
            for (IDataEntityProperty item : properties) {
                isOrgPropExist = false;
                itemPropValue = item.getName();
                boolean bl = isBasedataPropForOrg = item instanceof BasedataProp && "bos_org".equals(((BasedataProp)item).getBaseEntityId());
                if (item instanceof OrgProp || isBasedataPropForOrg) {
                    isOrgPropExist = true;
                    orgPropName = item.getDisplayName().getLocaleValue();
                    orgPropValue = item.getName();
                    newName = namePrefix + (WfUtils.isNotEmpty((String)orgPropName) ? orgPropName : "");
                    newValue = valuePrefix + orgPropValue;
                } else {
                    boolean bl2 = isBasedataPropForUser = item instanceof BasedataProp && "bos_user".equals(((BasedataProp)item).getBaseEntityId());
                    if (item instanceof UserProp || isBasedataPropForUser) {
                        if (USERS_NEED_IGNORE.contains(itemPropValue)) continue;
                        itemProp = (BasedataProp)item;
                        mainEntityForUser = EntityMetadataCache.getDataEntityType((String)itemProp.getBaseEntityId());
                        if (null != mainEntityForUser && null != (propertiesForUser = mainEntityForUser.getProperties()) && propertiesForUser.size() > 0) {
                            block1: for (IDataEntityProperty prop : propertiesForUser) {
                                if (!(prop instanceof EntryProp) || !"entryentity".equals(((EntryProp)prop).getName()) || null == (typeForUser = (EntryType)((EntryProp)prop).getDynamicCollectionItemPropertyType()) || (propertiesForUserEntry = typeForUser.getProperties()) == null || propertiesForUserEntry.size() <= 0) continue;
                                for (IDataEntityProperty propForEntry : propertiesForUserEntry) {
                                    if (!(propForEntry instanceof OrgProp) || null == (orgPropForUser = (OrgProp)propForEntry) || !"dpt".equals(orgPropForUser.getName())) continue;
                                    isOrgPropExist = true;
                                    orgPropName = orgPropForUser.getDisplayName().getLocaleValue();
                                    orgPropValue = typeForUser.getName() + "." + orgPropForUser.getName();
                                    continue block1;
                                }
                            }
                        }
                        if (isOrgPropExist) {
                            itemPropNameLocal = item.getDisplayName();
                            itemPropName = itemPropNameLocal.getLocaleValue();
                            newName = namePrefix + (WfUtils.isNotEmpty((String)itemPropName) ? itemPropName : "") + '.' + (WfUtils.isNotEmpty((String)orgPropName) ? orgPropName : "");
                            newValue = valuePrefix + itemPropValue + '.' + orgPropValue;
                        }
                    }
                }
                if (!isOrgPropExist) continue;
                items.add(new ComboItem(new LocaleString(newName), newValue));
            }
        }
        return items;
    }

    protected static Map<String, LocaleString> extractOrgMapFromEntityCacheForPartRole(DynamicObjectType entityType, String prefix) {
        DataEntityPropertyCollection properties;
        HashMap<String, LocaleString> items = new HashMap<String, LocaleString>();
        if (null != entityType && null != (properties = entityType.getProperties()) && properties.size() > 0) {
            String namePrefix = prefix;
            String valuePrefix = "ENTI_";
            if (entityType instanceof EntryType) {
                namePrefix = entityType.getDisplayName().getLocaleValue() + "-";
                valuePrefix = "ENTRY_" + entityType.getName() + ".";
            }
            String newName = null;
            String newValue = null;
            boolean isOrgPropExist = false;
            boolean isBasedataPropForOrg = false;
            boolean isBasedataPropForUser = false;
            BasedataProp itemProp = null;
            String itemPropValue = null;
            LocaleString itemPropNameLocal = null;
            String itemPropName = null;
            String orgPropName = null;
            String orgPropValue = null;
            MainEntityType mainEntityForUser = null;
            DataEntityPropertyCollection propertiesForUser = null;
            EntryType typeForUser = null;
            DataEntityPropertyCollection propertiesForUserEntry = null;
            OrgProp orgPropForUser = null;
            for (IDataEntityProperty item : properties) {
                isOrgPropExist = false;
                itemPropValue = item.getName();
                boolean bl = isBasedataPropForOrg = item instanceof BasedataProp && "bos_org".equals(((BasedataProp)item).getBaseEntityId());
                if (item instanceof OrgProp || isBasedataPropForOrg) {
                    isOrgPropExist = true;
                    orgPropName = item.getDisplayName().getLocaleValue();
                    orgPropValue = item.getName();
                    newName = namePrefix + (WfUtils.isNotEmpty((String)orgPropName) ? orgPropName : "");
                    newValue = valuePrefix + orgPropValue;
                } else {
                    boolean bl2 = isBasedataPropForUser = item instanceof BasedataProp && "bos_user".equals(((BasedataProp)item).getBaseEntityId());
                    if (item instanceof UserProp || isBasedataPropForUser) {
                        if (USERS_NEED_IGNORE.contains(itemPropValue)) continue;
                        itemProp = (BasedataProp)item;
                        mainEntityForUser = EntityMetadataCache.getDataEntityType((String)itemProp.getBaseEntityId());
                        if (null != mainEntityForUser && null != (propertiesForUser = mainEntityForUser.getProperties()) && propertiesForUser.size() > 0) {
                            for (IDataEntityProperty prop : propertiesForUser) {
                                if (!(prop instanceof EntryProp) || null == (typeForUser = (EntryType)((EntryProp)prop).getDynamicCollectionItemPropertyType()) || null == (propertiesForUserEntry = typeForUser.getProperties()) || propertiesForUserEntry.size() <= 0) continue;
                                for (IDataEntityProperty propForEntry : propertiesForUserEntry) {
                                    if (!(propForEntry instanceof OrgProp) || null == (orgPropForUser = (OrgProp)propForEntry)) continue;
                                    isOrgPropExist = true;
                                    orgPropName = orgPropForUser.getDisplayName().getLocaleValue();
                                    orgPropValue = typeForUser.getName() + "." + orgPropForUser.getName();
                                }
                            }
                        }
                        if (isOrgPropExist) {
                            itemPropNameLocal = item.getDisplayName();
                            itemPropName = itemPropNameLocal.getLocaleValue();
                            newName = namePrefix + (WfUtils.isNotEmpty((String)itemPropName) ? itemPropName : "") + '.' + (WfUtils.isNotEmpty((String)orgPropName) ? orgPropName : "");
                            newValue = valuePrefix + itemPropValue + '.' + orgPropValue;
                        }
                    }
                }
                if (!isOrgPropExist) continue;
                items.put(newValue, new LocaleString(newName));
            }
        }
        return items;
    }

    static {
        USERS_NEED_IGNORE.add("modifier");
        USERS_NEED_IGNORE.add("auditor");
        F7_FILTERS.add("bos_org");
        F7_FILTERS.add("bos_user");
    }
}

