/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.management.plugin.delegatesetting;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.impl.persistence.entity.management.delegatesetting.DelegateSettingEntity;
import kd.bos.workflow.management.plugin.delegatesetting.DelegateSettingBatchResult;

public class DelegateDefeatedInfoPlugin
extends AbstractWorkflowPlugin {
    private static final String ENTRYENTITY = "entryentity";
    private static Log log = LogFactory.getLog(DelegateDefeatedInfoPlugin.class);

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String failListStr = (String)parameter.getCustomParam("failList");
        List<DelegateSettingBatchResult> failList = this.getFailList(failListStr);
        HashMap<Long, DelegateSettingBatchResult> map = new HashMap<Long, DelegateSettingBatchResult>();
        for (DelegateSettingBatchResult result : failList) {
            map.put(result.getId(), result);
        }
        List ids = failList.stream().map(DelegateSettingBatchResult::getId).collect(Collectors.toList());
        List delegateSettingEntitys = this.getRepositoryService().findEntitiesByFilters("wf_delegatesetting", new QFilter[]{new QFilter("id", "in", ids)});
        this.getModel().deleteEntryData(ENTRYENTITY);
        EntryGrid entry = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        IDataModel entryModel = entry.getModel();
        ArrayList<Object> entraBillIdList = new ArrayList<Object>(delegateSettingEntitys.size());
        for (int i = 0; i < delegateSettingEntitys.size(); ++i) {
            DelegateSettingEntity delegateSettingEntity = (DelegateSettingEntity)delegateSettingEntitys.get(i);
            this.getModel().createNewEntryRow(ENTRYENTITY);
            entryModel.setValue("assignor", (Object)delegateSettingEntity.getAssignorId(), i);
            entryModel.setValue("trustee", (Object)delegateSettingEntity.getTrusteeId(), i);
            entryModel.setValue("reason", (Object)((DelegateSettingBatchResult)map.get(delegateSettingEntity.getId())).getMessage(), i);
            entryModel.setValue("processnumber", (Object)delegateSettingEntity.getProcessDefinitionId(), i);
            entryModel.setValue("processname", (Object)delegateSettingEntity.getProcessDefinitionId(), i);
            entryModel.setValue("delegatenodename", (Object)delegateSettingEntity.getDelegateNodeName(), i);
            String entraBillId = delegateSettingEntity.getEntraBillId();
            entraBillIdList.add(entraBillId);
            entryModel.setValue("delegaterule", (Object)delegateSettingEntity.getDelegateRule(), i);
            entryModel.setValue("starttime", (Object)delegateSettingEntity.getStartTime().toString(), i);
            entryModel.setValue("endtime", (Object)delegateSettingEntity.getEndTime(), i);
        }
        DynamicObjectCollection entitys = QueryServiceHelper.query((String)"bos_entityobject", (String)"id,dentityid", (QFilter[])new QFilter[]{new QFilter("dentityid", "in", entraBillIdList)});
        HashMap<String, String> entityMap = new HashMap<String, String>();
        for (DynamicObject entity : entitys) {
            entityMap.put(entity.getString("dentityid"), entity.getString("id"));
        }
        for (int i = 0; i < delegateSettingEntitys.size(); ++i) {
            DelegateSettingEntity delegateSettingEntity = (DelegateSettingEntity)delegateSettingEntitys.get(i);
            String entraBillId = delegateSettingEntity.getEntraBillId();
            entryModel.setValue("entrabillnumber", entityMap.get(entraBillId), i);
            entryModel.setValue("entrabillname", entityMap.get(entraBillId), i);
        }
    }

    private List<DelegateSettingBatchResult> getFailList(String json) {
        try {
            return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<DelegateSettingBatchResult>>(){});
        }
        catch (JsonProcessingException e) {
            log.warn((Throwable)e);
            return new ArrayList<DelegateSettingBatchResult>(0);
        }
    }
}

