/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.management.plugin.delegatesetting;

import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;

public class DelegationProcDefPlugin
extends AbstractWorkflowPlugin {
    private static final String BTNCANCEL = "btncancel";
    private static final String BTNOK = "btnok";
    private static final String LATESTVERSION = "latestversion";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNCANCEL, BTNOK});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object parameterLatestVersion = parameter.getCustomParam("isLatestVersion");
        if (parameterLatestVersion != null) {
            this.getModel().setValue(LATESTVERSION, parameterLatestVersion);
        }
        Boolean isLatestVersion = (Boolean)this.getModel().getValue(LATESTVERSION);
        this.showProcDefForm(isLatestVersion);
    }

    private void showProcDefForm(Boolean isLatestVersion) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("wf_processtreelist");
        parameter.setBillFormId("wf_delegateprocdeflist");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addprocess"));
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey("contentpanel");
        parameter.setShowClose(false);
        parameter.setShowTitle(false);
        parameter.setMultiSelect(((Boolean)this.getView().getFormShowParameter().getCustomParam("isMultiSelect")).booleanValue());
        parameter.setLookUp(((Boolean)this.getView().getFormShowParameter().getCustomParam("isLookUp")).booleanValue());
        parameter.setCustomParam("hideHyperlink", this.getView().getFormShowParameter().getCustomParam("hideHyperlink"));
        String selectedRows = (String)this.getView().getFormShowParameter().getCustomParam("selectedRows");
        if (WfUtils.isNotEmpty((String)selectedRows)) {
            Object[] ids = (Long[])SerializationUtils.fromJsonString((String)selectedRows, Long[].class);
            parameter.setSelectedRows(ids);
        }
        parameter.setCustomParam("isLatestVersion", (Object)isLatestVersion);
        parameter.setCustomParam("isOnlyShowAuditFlow", this.getView().getFormShowParameter().getCustomParam("isOnlyShowAuditFlow"));
        parameter.setCustomParam("isHidenAppointedColumn", (Object)true);
        parameter.setCustomParam("isFromDele", (Object)true);
        this.getPageCache().put("sonPageId", parameter.getPageId());
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (BTNOK.equals(key)) {
            ListSelectedRowCollection rows = ((IListView)this.getView().getView(this.getPageCache().get("sonPageId"))).getSelectedRows();
            if (rows == null || rows.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6d41\u7a0b\u3002", (String)"DelegationProcDefPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().returnDataToParent((Object)rows);
            this.getPageCache().remove("sonPageId");
            Boolean isLatestVersion = (Boolean)this.getModel().getValue(LATESTVERSION);
            isLatestVersion = isLatestVersion == null ? Boolean.TRUE : isLatestVersion;
            this.getView().getParentView().getPageCache().put("isLatestVersion", String.valueOf(isLatestVersion));
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (LATESTVERSION.equals(propName)) {
            Boolean isLatestVersion = (Boolean)newValue;
            this.showProcDefForm(isLatestVersion);
        }
    }
}

