/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.management.plugin.delegatesetting;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.task.TaskDelegateUtil;
import kd.bos.workflow.management.plugin.delegatesetting.DelegateSettingBatchResult;
import kd.bos.workflow.management.plugin.delegatesetting.DelegateSettingDTO;
import kd.bos.workflow.management.plugin.util.DelegateSettingUtil;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class EnableDelegateSettingTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(EnableDelegateSettingTask.class);

    public void execute(RequestContext arg0, Map<String, Object> params) throws KDException {
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u542f\u52a8\u59d4\u6258\u8bbe\u7f6e\u4efb\u52a1", (String)"EnableDelegateSettingTask_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), null);
        Integer time = (Integer)params.get("time");
        List<DelegateSettingDTO> delegateSettingDTOs = this.getDTOs((String)params.get("delegateSettingDTOs"));
        ArrayList<DelegateSettingBatchResult> results = new ArrayList<DelegateSettingBatchResult>();
        time = delegateSettingDTOs.size();
        if (time == null || time == 0) {
            time = 100;
        }
        HashMap<String, String> resultMap = new HashMap<String, String>(time);
        ArrayList<Long> delegateIdList = new ArrayList<Long>(time);
        try {
            int progress = 0;
            WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
            RepositoryService repositoryService = wfService.getRepositoryService();
            for (int i = 0; i < time; ++i) {
                DelegateSettingBatchResult result = new DelegateSettingBatchResult();
                String desc = String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u8fdb\u884c\u7b2c  %1$s / %2$s \u6b21\u5faa\u73af", (String)"EnableDelegateSettingTask_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), i + 1, time);
                progress = 100 * i / time;
                this.feedbackProgress(progress, desc, null);
                if (this.isStop()) {
                    resultMap.put("results", SerializationUtils.toJsonString(results));
                    this.stop();
                    return;
                }
                DelegateSettingDTO dto = delegateSettingDTOs.get(i);
                Long delegateId = dto.getId();
                result.from(dto);
                results.add(result);
                if (TaskDelegateUtil.existSameDelegateSetting((Long)delegateId)) {
                    String message = ResManager.loadKDString((String)"\u8be5\u59d4\u6258\u8bbe\u7f6e\u5df2\u5b58\u5728\uff0c\u65e0\u9700\u91cd\u590d\u542f\u7528\u3002", (String)"WorkflowDelegateSettingListPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                    result.setSuccess(false);
                    result.setMessage(message);
                    continue;
                }
                Map<String, Object> existDelegateRingMap = DelegateSettingUtil.existDelegateRing(delegateId, null, null, true);
                if (((Boolean)existDelegateRingMap.get("reslut")).booleanValue()) {
                    String message = (String)existDelegateRingMap.get("message");
                    result.setSuccess(false);
                    result.setMessage(message);
                    continue;
                }
                repositoryService.activateDelegationSettings(delegateId);
                delegateIdList.add(delegateId);
                result.setSuccess(true);
            }
        }
        catch (Exception e) {
            log.error(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        resultMap.put("results", SerializationUtils.toJsonString(results));
        WfUtils.addOpLog((String)"wf_delegatesetting", (String)"enable", (String)ResManager.getLocaleString((String)"\u59d4\u6258\u542f\u7528", (String)"WorkflowDelegateSettingListPlugin_18", (String)"bos-wf-formplugin").getLocaleValue_zh_CN(), (MultiLangEnumBridge)new MultiLangEnumBridge("\u6210\u529f\u542f\u7528id\u4e3a%s\u7684\u59d4\u6258", "WorkflowDelegateSettingListPlugin_19", "bos-wf-formplugin"), (Object[])new Object[]{delegateIdList});
        this.feedbackCustomdata(resultMap);
    }

    private List<DelegateSettingDTO> getDTOs(String json) {
        if (json == null) {
            return new ArrayList<DelegateSettingDTO>(0);
        }
        try {
            return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<DelegateSettingDTO>>(){});
        }
        catch (JsonProcessingException e) {
            log.warn((Throwable)e);
            return new ArrayList<DelegateSettingDTO>(0);
        }
    }
}

