/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.management.plugin.delegatesetting;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bec.engine.utils.BatchStandardTipsTitleBuilder;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.AbstractTaskClick;
import kd.bos.schedule.form.event.ClickEventArgs;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.management.plugin.delegatesetting.DelegateSettingBatchResult;

public class EnableDelegateSettingTaskClick
extends AbstractTaskClick {
    private Log logger = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());
    private static final String ROWSSIZE = "rowsSize";

    public void click(ClickEventArgs e) {
        TaskInfo taskInfo = this.queryTask();
        IFormView parentView = this.getParentView();
        if (taskInfo.isTaskEnd()) {
            e.setClearTask(true);
            IFormView mainView = this.getMainView();
            if (taskInfo.isTaskEnd()) {
                Map data = (Map)SerializationUtils.fromJsonString((String)taskInfo.getData(), Map.class);
                String resultStr = (String)data.get("results");
                List<DelegateSettingBatchResult> results = this.getResults(resultStr);
                List successList = results.stream().filter(DelegateSettingBatchResult::getSuccess).collect(Collectors.toList());
                List failList = results.stream().filter(item -> !item.getSuccess()).collect(Collectors.toList());
                List failTipsList = failList.stream().map(item -> ResManager.loadKDString((String)"\u59d4\u6258\u4eba:{0} \u53d7\u6258\u4eba:{1}", (String)"WorkflowDelegateSettingListPlugin_26", (String)"bos-wf-formplugin", (Object[])new Object[]{item.getAssignorName(), item.getTrusteeName()})).collect(Collectors.toList());
                this.logger.info(String.format("EnableDelegateSettingTaskClick,parentView is %s;rowsSize is %s", parentView, results.size()));
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("wf_delegatedefeatedinfo");
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCustomParam("failList", (Object)SerializationUtils.toJsonString(failList));
                StandardTips.view((IFormView)mainView).batchOptionMsg(new BatchStandardTipsTitleBuilder().setHandleName(ResManager.loadKDString((String)"\u542f\u7528", (String)"WorkflowDelegateSettingListPlugin_25", (String)"bos-wf-formplugin", (Object[])new Object[0])).setFailCount(failList.size()).setSuccessCount(successList.size()).setTotal(results.size()).build(), StandardTips.batchOptionMsgContent(failTipsList), parameter);
                if (parentView instanceof IListView) {
                    ((IListView)parentView).refresh();
                }
            }
        } else if (parentView == null) {
            this.getMainView().showMessage(ResManager.loadKDString((String)"\u542f\u52a8\u4efb\u52a1\u7684\u9875\u9762\u5df2\u7ecf\u5173\u95ed\uff0c\u4e0d\u80fd\u518d\u6253\u5f00\u8fdb\u5ea6\u754c\u9762\u3002", (String)"EnableDelegateSettingTaskClick_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        } else {
            this.showProgressForm(parentView);
        }
    }

    private void showProgressForm(IFormView view) {
        if (this.isExistProgressForm()) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("sch_taskprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (WfUtils.isEmpty((String)this.getJobFormInfo().getCaption())) {
            showParameter.setCaption(this.getJobFormInfo().getCaption());
        }
        showParameter.getCustomParams().put("ServiceAppId", this.getJobFormInfo().getJobInfo().getAppId());
        String jobInfoStr = SerializationUtils.toJsonString((Object)this.getJobFormInfo());
        showParameter.getCustomParams().put("sch_clientjobinfo", jobInfoStr);
        showParameter.getCustomParams().put("sch_taskid", this.getTaskId());
        showParameter.setCloseCallBack(this.getJobFormInfo().getCloseCallBack());
        view.showForm(showParameter);
        this.getMainView().sendFormAction(view);
        this.setProgressPageId(showParameter.getPageId());
    }

    private List<DelegateSettingBatchResult> getResults(String json) {
        try {
            return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<DelegateSettingBatchResult>>(){});
        }
        catch (JsonProcessingException e) {
            this.logger.warn((Throwable)e);
            return new ArrayList<DelegateSettingBatchResult>(0);
        }
    }
}

