/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.management.plugin.delegatesetting;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;

public class WorkflowDelegateNodePlugin
extends AbstractWorkflowPlugin
implements RowClickEventListener {
    private static final String ENTRYENTITY = "entryentity";
    private static final String BTNOK = "btnok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setEntryGridFocusRow();
    }

    private void setEntryGridFocusRow() {
        Object delegateNodeIdObj = this.getView().getFormShowParameter().getCustomParam("delegateNodeId");
        String delegateNodeId = "";
        if (delegateNodeIdObj != null) {
            delegateNodeId = (String)delegateNodeIdObj;
        }
        List<FlowElement> delegateNodes = this.getDelegateNodes();
        int i = 0;
        for (FlowElement delegateNode : delegateNodes) {
            if (delegateNode.getId().equals(delegateNodeId)) {
                EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
                entryGrid.selectRows(i);
            }
            ++i;
        }
    }

    private List<FlowElement> getDelegateNodes() {
        ArrayList<FlowElement> delegateNodes = new ArrayList<FlowElement>();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long procDefId = (Long)customParams.get("procDefId");
        if (WfUtils.isEmpty((Long)procDefId)) {
            return delegateNodes;
        }
        BpmnModel bpmnModel = this.getRepositoryService().getBpmnModel(procDefId, null);
        if (bpmnModel == null) {
            return delegateNodes;
        }
        Map locationMap = bpmnModel.getLocationMap();
        for (Map.Entry location : locationMap.entrySet()) {
            String flowElementId = (String)location.getKey();
            FlowElement flowElement = bpmnModel.getFlowElement(flowElementId);
            String type = flowElement.getType();
            if ((!"UserTask".equals(type) || BpmnModelUtil.isFirstNodeByModel((FlowNode)((FlowNode)flowElement))) && !"AuditTask".equals(type) && !"YunzhijiaTask".equals(type)) continue;
            delegateNodes.add(flowElement);
        }
        return delegateNodes;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initEntryEntity();
    }

    private void initEntryEntity() {
        List<FlowElement> delegateNodes = this.getDelegateNodes();
        if (!delegateNodes.isEmpty()) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Long procDefId = (Long)customParams.get("procDefId");
            ResourceEntity resource = this.getRepositoryService().getResourceByProcDefId(procDefId);
            IDataModel model = this.getModel();
            model.deleteEntryData(ENTRYENTITY);
            model.batchCreateNewEntryRow(ENTRYENTITY, delegateNodes.size());
            int i = 0;
            for (FlowElement delegateNode : delegateNodes) {
                String activityId = delegateNode.getId();
                model.setValue("delegatenodeid", (Object)activityId, i);
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"delegatenodeid"});
                String activityNameMultiKey = BpmnModelUtil.getActivityNameMultiKey((String)activityId);
                ILocaleString delegateNodeName = BpmnModelUtil.getMultiLangFieldValueFromResource((ResourceEntity)resource, (String)activityNameMultiKey, (String)delegateNode.getName());
                model.setValue("delegatenodename", (Object)delegateNodeName, i);
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"delegatenodename"});
                ++i;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals(BTNOK)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
            int focusRow = entryGrid.getEntryState().getFocusRow();
            if (focusRow > -1) {
                HashMap<String, String> returnData = new HashMap<String, String>(2);
                String delegateNodeId = (String)this.getModel().getValue("delegatenodeid", focusRow);
                ILocaleString delegateNodeName = (ILocaleString)this.getModel().getValue("delegatenodename", focusRow);
                returnData.put("delegatenodeid", delegateNodeId);
                returnData.put("delegatenodename", (String)delegateNodeName);
                this.getView().returnDataToParent(returnData);
                this.getView().close();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u59d4\u6258\u8282\u70b9\u201d\u3002", (String)"WorkflowDelegateNodePlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            }
        }
    }
}

