/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.management.plugin.delegatesetting;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.bec.engine.utils.BatchStandardTipsTitleBuilder;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.Copy;
import kd.bos.form.operate.Modify;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ChatEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowSelectAllEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowListPlugin;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.management.delegatesetting.DelegateSettingEntity;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.task.TaskDelegateUtil;
import kd.bos.workflow.management.plugin.delegatesetting.DelegateSettingBatchResult;
import kd.bos.workflow.management.plugin.delegatesetting.DelegateSettingDTO;
import kd.bos.workflow.management.plugin.util.DelegateSettingUtil;
import kd.bos.workflow.taskcenter.plugin.data.TCCheckPermUtil;

public class WorkflowDelegateSettingListPlugin
extends AbstractWorkflowListPlugin
implements IConfirmCallBack {
    private static final String DELETE = "delete";
    private static final String VIEWDELEGATETASK = "viewdelegatetask";
    private static final String VIEWDELEGATEHISTORY = "viewdelegatehistory";
    private static final String CLOSE = "close";
    private static final String DISABLE = "disable";
    private static final String ENABLE = "enable";
    private static final String DELEGATESETTING = "delegate";
    private static final String HYPERLINK = "hyperLink";
    private static final String MULTIADDNEW = "multiaddnew";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{MULTIADDNEW, ENABLE});
        final BillList billList = (BillList)this.getControl("billlistap");
        Consumer<ListRowSelectAllEvent> listRowSelectAllListener = new Consumer<ListRowSelectAllEvent>(){

            @Override
            public void accept(ListRowSelectAllEvent arg0) {
                ListSelectedRowCollection rows = billList.getSelectedRows();
                ArrayList<Long> delegateIds = new ArrayList<Long>(rows.size());
                for (ListSelectedRow row : rows) {
                    delegateIds.add((Long)row.getPrimaryKeyValue());
                }
                RepositoryService service = WorkflowDelegateSettingListPlugin.this.getRepositoryService();
                if (service.isAllDelegateEnable(delegateIds)) {
                    WorkflowDelegateSettingListPlugin.this.getView().setEnable(Boolean.TRUE, new String[]{WorkflowDelegateSettingListPlugin.DISABLE});
                    WorkflowDelegateSettingListPlugin.this.getView().setEnable(Boolean.FALSE, new String[]{WorkflowDelegateSettingListPlugin.ENABLE});
                } else if (service.isAllDelegateDisable(delegateIds)) {
                    WorkflowDelegateSettingListPlugin.this.getView().setEnable(Boolean.FALSE, new String[]{WorkflowDelegateSettingListPlugin.DISABLE});
                    WorkflowDelegateSettingListPlugin.this.getView().setEnable(Boolean.TRUE, new String[]{WorkflowDelegateSettingListPlugin.ENABLE});
                } else {
                    WorkflowDelegateSettingListPlugin.this.getView().setEnable(Boolean.FALSE, new String[]{WorkflowDelegateSettingListPlugin.DISABLE});
                    WorkflowDelegateSettingListPlugin.this.getView().setEnable(Boolean.FALSE, new String[]{WorkflowDelegateSettingListPlugin.ENABLE});
                }
            }
        };
        billList.addListRowSelectAllListeners((Consumer)listRowSelectAllListener);
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        super.beforePackageData(e);
        DynamicObjectCollection pageDatas = e.getPageData();
        for (DynamicObject pageData : pageDatas) {
            Boolean isLatestVersion = pageData.getBoolean("islatestversion");
            if (!isLatestVersion.booleanValue() || pageData.getDynamicObject("processdefinitionid") == null) continue;
            pageData.set("processdefinitionid.version", null);
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        this.enableDisableDeleteBtn();
        this.controlStatusbtn();
    }

    public void controlStatusbtn() {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (CollectionUtil.isNotEmpty((Collection)rows)) {
            ArrayList<Long> delegateIds = new ArrayList<Long>(rows.size());
            for (ListSelectedRow row : rows) {
                delegateIds.add((Long)row.getPrimaryKeyValue());
            }
            RepositoryService service = this.getRepositoryService();
            if (service.isAllDelegateEnable(delegateIds)) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{DISABLE});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{ENABLE});
            } else if (service.isAllDelegateDisable(delegateIds)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{DISABLE});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{ENABLE});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{DISABLE});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{ENABLE});
            }
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{DISABLE});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{ENABLE});
        }
    }

    private void enableDisableDeleteBtn() {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        Boolean isDeleteEnable = Boolean.TRUE;
        this.getView().setEnable(isDeleteEnable, new String[]{DELETE});
        if (rows != null && !rows.isEmpty()) {
            ArrayList<Long> delegateId = new ArrayList<Long>(rows.size());
            for (ListSelectedRow row : rows) {
                delegateId.add((Long)row.getPrimaryKeyValue());
            }
            QFilter filter1 = new QFilter("id", "in", delegateId);
            QFilter filter2 = new QFilter("status", "=", (Object)Character.valueOf('1'));
            QFilter[] filters = new QFilter[]{filter1, filter2};
            Long count = this.getRepositoryService().getEntityCountByFilter("wf_delegatesetting", filters);
            if (WfUtils.isNotEmpty((Long)count) && count > 0L) {
                isDeleteEnable = Boolean.FALSE;
            }
        }
        this.getView().setEnable(isDeleteEnable, new String[]{DELETE});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (DelegateSettingUtil.isOpenFromMessageCenter(this.getView())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{VIEWDELEGATETASK, VIEWDELEGATEHISTORY, CLOSE});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "viewdelegatetask": {
                this.viewDelegateTask();
                break;
            }
            case "viewdelegatehistory": {
                this.viewDelegateHistory();
                break;
            }
            case "multiaddnew": {
                if (!DelegateSettingUtil.isOpenFromMessageCenter(this.getView()) && !PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"a479ec06000000ac", (String)"wf_delegatesetting", (String)"47156aff000000ac")) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u59d4\u6258\u8bbe\u7f6e\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\u3002", (String)"WorkflowDelegateSettingListPlugin_14", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.batchAddition();
                break;
            }
            case "enable": {
                if (!DelegateSettingUtil.isOpenFromMessageCenter(this.getView()) && !PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"a479ec06000000ac", (String)"wf_delegatesetting", (String)"4730fc5d000000ac")) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u59d4\u6258\u8bbe\u7f6e\u201d\u7684\u201c\u542f\u7528\u201d\u6743\u9650\u3002", (String)"WorkflowDelegateSettingListPlugin_15", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.enableValidate();
                ((IListView)this.getView()).refresh();
                break;
            }
        }
    }

    private void batchAddition() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "batchAddition"));
        parameter.setFormId("wf_multidelegatesetting");
        this.getView().showForm(parameter);
    }

    private void viewDelegateTask() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"a479ec06000000ac", (String)"wf_delegatesetting", (String)"47150e89000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u67e5\u770b\u201c\u59d4\u6258\u4fee\u6539\u8bb0\u5f55\u201d\u7684\u6743\u9650\u3002", (String)"WorkflowDelegateSettingListPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<QFilter> qFilters = null;
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows != null && !rows.isEmpty()) {
            ArrayList<Long> delegateIds = new ArrayList<Long>(rows.size());
            for (ListSelectedRow row : rows) {
                delegateIds.add((Long)row.getPrimaryKeyValue());
            }
            qFilters = new ArrayList<QFilter>(1);
            qFilters.add(new QFilter("delegateid", "in", delegateIds));
        }
        this.showListForm("wf_delegatetask", ResManager.loadKDString((String)"\u59d4\u6258\u4efb\u52a1\u8bb0\u5f55", (String)"WorkflowDelegateSettingListPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]), qFilters);
    }

    private void viewDelegateHistory() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"a479ec06000000ac", (String)"wf_delegatesetting", (String)"47150e89000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u67e5\u770b\u201c\u59d4\u6258\u4fee\u6539\u8bb0\u5f55\u201d\u7684\u6743\u9650\u3002", (String)"WorkflowDelegateSettingListPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<QFilter> qFilters = null;
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows != null && !rows.isEmpty()) {
            ArrayList<Long> delegateIds = new ArrayList<Long>(rows.size());
            for (ListSelectedRow row : rows) {
                delegateIds.add((Long)row.getPrimaryKeyValue());
            }
            qFilters = new ArrayList<QFilter>(1);
            qFilters.add(new QFilter("delegateid", "in", delegateIds));
        }
        this.showListForm("wf_hidelegatesetting", ResManager.loadKDString((String)"\u59d4\u6258\u4fee\u6539\u8bb0\u5f55", (String)"WorkflowDelegateSettingListPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]), qFilters);
    }

    private void showListForm(String billFormId, String caption, List<QFilter> qFilters) {
        IFormView settingsFormView = DesignerModelUtil.getTabControlView(this.getView());
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId(billFormId);
        parameter.getOpenStyle().setTargetKey("_submaintab_");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setCaption(caption);
        parameter.setCustomParam("isOpenNewTab", (Object)Boolean.TRUE);
        if (qFilters != null && !qFilters.isEmpty()) {
            ListFilterParameter filterParameter = new ListFilterParameter();
            filterParameter.setQFilters(qFilters);
            parameter.setListFilterParameter(filterParameter);
        }
        if (settingsFormView != null) {
            settingsFormView.showForm((FormShowParameter)parameter);
            this.getView().sendFormAction(settingsFormView);
        } else {
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object option = args.getSource();
        boolean isOpenFromMessageCenter = DelegateSettingUtil.isOpenFromMessageCenter(this.getView());
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (option instanceof Copy) {
            if (rows.size() != 1) {
                StandardTips.view((IFormView)this.getView()).selectMultiRow(rows.size());
                args.setCancel(true);
                return;
            }
            if (isOpenFromMessageCenter && !TCCheckPermUtil.checkIsDelegateOwnerAndFromMsgCenter(rows, this.getView())) {
                args.setCancel(true);
                return;
            }
        }
        if (option instanceof Modify) {
            this.checkModify(args, isOpenFromMessageCenter, option);
        }
    }

    private void checkModify(BeforeDoOperationEventArgs args, boolean isOpenFromMessageCenter, Object option) {
        String hyperLink = this.getPageCache().get(HYPERLINK);
        if (hyperLink != null) {
            this.getPageCache().remove(HYPERLINK);
        } else {
            this.checkIsOnlyOne(args);
        }
    }

    private void checkIsOnlyOne(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (CollectionUtil.isEmpty((Collection)rows) || rows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"WorkflowDelegateSettingListPlugin_20", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public boolean enableValidate() {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows == null || rows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"WorkflowDelegateSettingListPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return false;
        }
        if (rows.size() > 100) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u6b21\u6700\u591a\u542f\u7528100\u6761\u59d4\u6258\u3002", (String)"WorkflowDelegateSettingListPlugin_16", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return false;
        }
        if (rows.size() == 1) {
            ListSelectedRow row = rows.get(0);
            Long delegateId = (Long)row.getPrimaryKeyValue();
            if (TaskDelegateUtil.existSameDelegateSetting((Long)delegateId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u59d4\u6258\u8bbe\u7f6e\u5df2\u5b58\u5728\uff0c\u65e0\u9700\u91cd\u590d\u542f\u7528\u3002", (String)"WorkflowDelegateSettingListPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return false;
            }
            Map<String, Object> existDelegateRingMap = DelegateSettingUtil.existDelegateRing(delegateId, null, null, true);
            if (((Boolean)existDelegateRingMap.get("reslut")).booleanValue()) {
                this.getView().showErrorNotification((String)existDelegateRingMap.get("message"));
                return false;
            }
            this.getRepositoryService().activateDelegationSettings(delegateId);
            WfUtils.addOpLog((String)"wf_delegatesetting", (String)ENABLE, (String)ResManager.getLocaleString((String)"\u59d4\u6258\u542f\u7528", (String)"WorkflowDelegateSettingListPlugin_18", (String)"bos-wf-formplugin").getLocaleValue_zh_CN(), (MultiLangEnumBridge)new MultiLangEnumBridge("\u6210\u529f\u542f\u7528id\u4e3a%s\u7684\u59d4\u6258", "WorkflowDelegateSettingListPlugin_19", "bos-wf-formplugin"), (Object[])new Object[]{delegateId});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"WorkflowDelegateSettingListPlugin_11", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        } else {
            this.getPageCache().put("rowsSize", String.valueOf(rows.size()));
            this.dispatch(rows);
        }
        return true;
    }

    private void dispatch(ListSelectedRowCollection rows) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("wf");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        jobInfo.setName(ResManager.loadKDString((String)"\u542f\u7528\u59d4\u6258\u8bbe\u7f6e", (String)"WorkflowDelegateSettingListPlugin_12", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname("kd.bos.workflow.management.plugin.delegatesetting.EnableDelegateSettingTask");
        jobInfo.setRunByLang(RequestContext.get().getLang());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("time", 100);
        ListSelectedRowCollection listSelectedRows = Optional.ofNullable(rows).orElseGet(ListSelectedRowCollection::new);
        List ids = listSelectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).map(item -> {
            if (item instanceof Long) {
                return (Long)item;
            }
            if (item instanceof String) {
                return Long.valueOf((String)item);
            }
            return 0L;
        }).collect(Collectors.toList());
        List entities = this.getManagementService().findDelegateSettingEntitiesByIds(ids);
        List<DelegateSettingDTO> delegateSettingDTOs = this.findDelegateSettingDTOs(entities);
        params.put("delegateSettingDTOs", SerializationUtils.toJsonString(delegateSettingDTOs));
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "enableDelegate");
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(ResManager.loadKDString((String)"\u59d4\u6258\u8bbe\u7f6e\u542f\u7528", (String)"WorkflowDelegateSettingListPlugin_10", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(true);
        jobFormInfo.setClickClassName("kd.bos.workflow.management.plugin.delegatesetting.EnableDelegateSettingTaskClick");
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
    }

    private List<DelegateSettingDTO> findDelegateSettingDTOs(List<DelegateSettingEntity> entities) {
        if (entities == null || entities.isEmpty()) {
            return new ArrayList<DelegateSettingDTO>(0);
        }
        HashSet<Long> userIds = new HashSet<Long>();
        for (DelegateSettingEntity entity : entities) {
            userIds.add(entity.getAssignorId());
            userIds.add(entity.getTrusteeId());
        }
        List userInfoByID = UserServiceHelper.getUserInfoByID(new ArrayList(userIds));
        HashMap<Long, String> map = new HashMap<Long, String>();
        for (Map item2 : userInfoByID) {
            map.put((Long)item2.get("id"), (String)item2.get("name"));
        }
        return entities.stream().map(item -> {
            DelegateSettingDTO dto = new DelegateSettingDTO();
            dto.setId(item.getId());
            dto.setAssignorId(item.getAssignorId());
            dto.setAssignorName((String)map.get(item.getAssignorId()));
            dto.setTrusteeId(item.getTrusteeId());
            dto.setTrusteeName((String)map.get(item.getTrusteeId()));
            return dto;
        }).collect(Collectors.toList());
    }

    private boolean hasSpecificPerm(String permItemId) {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"a479ec06000000ac", (String)"wf_delegatesetting", (String)permItemId)) {
            if ("47156aff000000ac".equals(permItemId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u65b0\u589e\u201d\u7684\u6743\u9650\u3002", (String)"WorkflowDelegateSettingListPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            } else if ("4715a0df000000ac".equals(permItemId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u4fee\u6539\u201d\u6743\u9650\u3002", (String)"WorkflowDelegateSettingListPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            } else if ("47160c2b000000ac".equals(permItemId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u7981\u7528\u7684\u6743\u9650\u3002", (String)"WorkflowDelegateSettingListPlugin_21", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            } else if ("4730fc5d000000ac".equals(permItemId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u542f\u7528\u7684\u6743\u9650\u3002", (String)"WorkflowDelegateSettingListPlugin_22", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            } else if ("4715e1f1000000ac".equals(permItemId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5220\u9664\u7684\u6743\u9650\u3002", (String)"WorkflowDelegateSettingListPlugin_23", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        return true;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId) {
            case "delegate": {
                ((IListView)this.getView()).refresh();
                break;
            }
            case "batchAddition": {
                if (!(returnData instanceof Map)) break;
                Map result = (Map)returnData;
                Boolean succeed = Boolean.valueOf((String)result.get("succeed"));
                String message = (String)result.get("message");
                if (succeed.booleanValue()) {
                    this.getView().showSuccessNotification(message);
                    ((IListView)this.getView()).refresh();
                    break;
                }
                this.getView().showErrorNotification(message);
                break;
            }
            case "enableDelegate": {
                this.taskCallBack(returnData);
                break;
            }
        }
    }

    private void taskCallBack(Object returnData) {
        if (!(returnData instanceof Map)) {
            return;
        }
        Map result = (Map)returnData;
        String taskInfoStr = (String)result.get("taskinfo");
        if (WfUtils.isEmpty((String)taskInfoStr)) {
            return;
        }
        TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class);
        if (taskInfo.isTaskEnd()) {
            Map data = (Map)SerializationUtils.fromJsonString((String)taskInfo.getData(), Map.class);
            if ("stop".equals(data.get("stop"))) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7ec8\u6b62\u6210\u529f\u3002", (String)"WorkflowDelegateSettingListPlugin_13", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            String resultStr = (String)data.get("results");
            List<DelegateSettingBatchResult> results = this.getResults(resultStr);
            List successList = results.stream().filter(DelegateSettingBatchResult::getSuccess).collect(Collectors.toList());
            List failList = results.stream().filter(item -> !item.getSuccess()).collect(Collectors.toList());
            if (failList.size() == 0) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"WorkflowDelegateSettingListPlugin_11", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            } else {
                List failTipsList = failList.stream().map(item -> ResManager.loadKDString((String)"\u59d4\u6258\u4eba:{0} \u53d7\u6258\u4eba:{1}", (String)"WorkflowDelegateSettingListPlugin_26", (String)"bos-wf-formplugin", (Object[])new Object[]{item.getAssignorName(), item.getTrusteeName()})).collect(Collectors.toList());
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("wf_delegatedefeatedinfo");
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCustomParam("failList", (Object)SerializationUtils.toJsonString(failList));
                StandardTips.view((IFormView)this.getView()).batchOptionMsg(new BatchStandardTipsTitleBuilder().setHandleName(ResManager.loadKDString((String)"\u542f\u7528", (String)"WorkflowDelegateSettingListPlugin_25", (String)"bos-wf-formplugin", (Object[])new Object[0])).setFailCount(failList.size()).setSuccessCount(successList.size()).setTotal(results.size()).build(), StandardTips.batchOptionMsgContent(failTipsList), parameter);
            }
            ((IListView)this.getView()).clearSelection();
            ((IListView)this.getView()).refresh();
        }
    }

    private List<DelegateSettingBatchResult> getResults(String json) {
        try {
            return (List)new ObjectMapper().readValue(json, (TypeReference)new TypeReference<List<DelegateSettingBatchResult>>(){});
        }
        catch (JsonProcessingException e) {
            this.log.warn((Throwable)e);
            return new ArrayList<DelegateSettingBatchResult>(0);
        }
    }

    public void chat(ChatEvent e) {
        e.setCancel(true);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        this.getPageCache().put(HYPERLINK, HYPERLINK);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        this.getPageCache().remove("rowsSize");
    }
}

