/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.management.plugin.delegatesetting;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.management.delegatesetting.HistoricDelegateSettingEntityImpl;
import kd.bos.workflow.engine.task.TaskDelegateUtil;
import kd.bos.workflow.engine.task.delegatesetting.DelegateScopeEnum;
import kd.bos.workflow.engine.task.delegatesetting.DelegateStatusEnum;
import kd.bos.workflow.management.plugin.util.DelegateSettingUtil;
import kd.bos.workflow.monitor.plugin.WorkflowUserUtil;
import kd.bos.workflow.taskcenter.plugin.data.TCCheckPermUtil;
import kd.bos.workflow.taskcenter.plugin.util.ApprovalPluginUtil;

public class WorkflowDelegateSettingPlugin
extends AbstractWorkflowPlugin {
    private static final String ENTRABILLNAME = "entrabillname";
    private static final String SV_DELEGATERULE = "sv_delegaterule";
    private static final String SV_DELEGATENODENAME = "sv_delegatenodename";
    private static final String OPENFROMMSGCENTER = "openFromMsgCenter";
    private static final String SV_PROCESSDEFINITIONID = "sv_processdefinitionid";
    private static final String ISLATESTVERSION = "islatestversion";
    private static final String TYPE = "type";
    private static final String NAME = "name";
    private static final String ADDPROCESS = "addprocess";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{SV_DELEGATENODENAME, ENTRABILLNAME, SV_DELEGATERULE, SV_PROCESSDEFINITIONID});
        this.addProcDefParam();
        this.showUsersAddCustomParam();
    }

    private void addProcDefParam() {
        BasedataEdit procDefF7 = (BasedataEdit)this.getControl("processdefinitionid");
        procDefF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listShowParameter.setCustomParam("openFromNonProcDef", (Object)Boolean.TRUE);
            if ("wf_msg_center".equalsIgnoreCase(this.getPageCache().get(OPENFROMMSGCENTER))) {
                listShowParameter.setCustomParam(OPENFROMMSGCENTER, (Object)Boolean.TRUE);
            }
        });
    }

    private void showUsersAddCustomParam() {
        String[] fieldkeys = new String[]{"assignorid", "trusteeid"};
        WorkflowUserUtil.showUsersAddCustomParam(this.getView(), fieldkeys);
        if (DelegateSettingUtil.isOpenFromMessageCenter(this.getView().getParentView())) {
            BasedataEdit bosUserF7 = (BasedataEdit)this.getControl("trusteeid");
            List<QFilter> qFilters = ApprovalPluginUtil.addPersonFiltersCustomEvent(this.getView(), null);
            if (null == qFilters || qFilters.isEmpty()) {
                return;
            }
            bosUserF7.setQFilters(qFilters);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initDelegateSetting();
        this.getModel().setDataChanged(false);
        if (this.getView().getParentView() != null && this.getView().getParentView().getParentView() != null) {
            String ppFormId = this.getView().getParentView().getParentView().getFormShowParameter().getFormId();
            this.getPageCache().put(OPENFROMMSGCENTER, ppFormId);
        }
    }

    private void initDelegateSetting() {
        if (DelegateSettingUtil.isOpenFromMessageCenter(this.getView().getParentView())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"assignorid"});
            this.getModel().setValue("assignorid", (Object)WfUtils.getCurrentUser());
            FieldEdit sendMsg = (FieldEdit)this.getControl("sendmsgtoassignor");
            sendMsg.setCaption(new LocaleString(ResManager.loadKDString((String)"\u59d4\u6258\u7684\u4efb\u52a1\u88ab\u5904\u7406\u540e\u901a\u77e5\u6211", (String)"WorkflowDelegateSettingPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0])));
        }
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        Object isCopy = this.getView().getFormShowParameter().getCustomParams().get("iscopy");
        boolean copy = WfUtils.isEmptyString(isCopy) ? Boolean.FALSE : Boolean.valueOf(isCopy.toString());
        if (OperationStatus.ADDNEW.equals((Object)operationStatus) && !copy) {
            this.getView().setVisible(Boolean.FALSE, new String[]{SV_PROCESSDEFINITIONID, SV_DELEGATENODENAME, ENTRABILLNAME, SV_DELEGATERULE});
        } else if (OperationStatus.EDIT.equals((Object)operationStatus) || copy) {
            ILocaleString deleRuleShowText;
            DynamicObject entraBill = (DynamicObject)this.getModel().getValue("entrabillid");
            DynamicObject procDef = (DynamicObject)this.getModel().getValue("processdefinitionid");
            if (entraBill == null && procDef == null) {
                this.getModel().setValue("scope", (Object)"3");
            }
            this.changeProcBillVisible();
            ILocaleString delegateNodeName = (ILocaleString)this.getModel().getValue("delegatenodename");
            if (delegateNodeName != null) {
                this.getModel().setValue(SV_DELEGATENODENAME, (Object)delegateNodeName.getLocaleValue());
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{SV_DELEGATENODENAME});
            }
            if (entraBill != null) {
                this.getModel().setValue(ENTRABILLNAME, entraBill.get(NAME));
            }
            if ((deleRuleShowText = (ILocaleString)this.getModel().getValue("deleruleshowtext")) != null) {
                this.getModel().setValue(SV_DELEGATERULE, (Object)deleRuleShowText.getLocaleValue());
            }
            if (procDef != null) {
                this.getModel().setValue(SV_PROCESSDEFINITIONID, (Object)procDef.getString(NAME));
            }
            this.changeDelegateRuleVisible();
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "sv_delegatenodename": {
                this.showDelegateNode(key);
                break;
            }
            case "entrabillname": {
                RepositoryService service = this.getRepositoryService();
                Set entityNumbers = service.getProcessEntityNumbers();
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("NodeEntityNumbers", entityNumbers);
                params.put("isMultiSelect", false);
                DesignerModelUtil.openSelectEntitiesPageByCunstomerParams(this.getView(), (IFormPlugin)this, key, params);
                break;
            }
            case "sv_delegaterule": {
                this.showDelegateRule(SV_DELEGATERULE);
                break;
            }
            case "sv_processdefinitionid": {
                this.showDeleaProcDef();
                break;
            }
        }
    }

    private void showDeleaProcDef() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("wf_delegaprocdef");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ADDPROCESS));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss styleCss = new StyleCss();
        styleCss.setHeight("680px");
        styleCss.setWidth("1060px");
        parameter.getOpenStyle().setInlineStyleCss(styleCss);
        parameter.setShowTitle(false);
        parameter.setShowClose(true);
        HashMap<String, Object> customParamMap = new HashMap<String, Object>();
        customParamMap.put("isMultiSelect", false);
        customParamMap.put("isLookUp", true);
        customParamMap.put("hideHyperlink", "true");
        DynamicObject procDef = (DynamicObject)this.getModel().getValue("processdefinitionid");
        Long id = procDef == null ? 0L : procDef.getLong("id");
        Long[] ids = new Long[]{id};
        customParamMap.put("selectedRows", SerializationUtils.toJsonString((Object)ids));
        customParamMap.put("isLatestVersion", this.getModel().getValue(ISLATESTVERSION));
        customParamMap.put("isOnlyShowAuditFlow", true);
        parameter.setCustomParams(customParamMap);
        this.getView().showForm(parameter);
    }

    private void showDelegateNode(String key) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        DynamicObject procDef = (DynamicObject)this.getModel().getValue("processdefinitionid");
        Boolean islatestversion = (Boolean)this.getModel().getValue(ISLATESTVERSION);
        if (islatestversion.booleanValue()) {
            QFilter qFilter1 = new QFilter("modelid", "=", (Object)procDef.getLong("modelid"));
            QFilter qFilter2 = new QFilter("versionstate", "=", (Object)"newest");
            DynamicObject procDefDyn = QueryServiceHelper.queryOne((String)"wf_processdefinition", (String)"id", (QFilter[])new QFilter[]{qFilter1, qFilter2});
            params.put("procDefId", procDefDyn.getLong("id"));
        } else if (procDef != null) {
            params.put("procDefId", (Long)procDef.getPkValue());
        }
        String delegateNodeId = (String)this.getModel().getValue("delegatenodeid");
        if (!WfUtils.isEmpty((String)delegateNodeId)) {
            params.put("delegateNodeId", delegateNodeId);
        }
        this.showForm(key, "wf_delegatenode", params);
    }

    private void showDelegateRule(String actionId) {
        String delegateRule = (String)this.getModel().getValue("delegaterule");
        JSONObject conditionRule = null;
        if (!WfUtils.isEmpty((String)delegateRule)) {
            conditionRule = (JSONObject)SerializationUtils.fromJsonString((String)delegateRule, JSONObject.class);
        }
        String typeStr = ConditionalRuleType.DELEGATESETTINGRULE.toString();
        HashMap<String, String> context = new HashMap<String, String>();
        context.put(TYPE, typeStr);
        context.put("property", "rule");
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("context", context);
        customParams.put("value", conditionRule != null ? conditionRule.toJSONString() : null);
        customParams.put("openType", "billRule");
        String scope = (String)this.getModel().getValue("scope");
        if (DelegateScopeEnum.PROCESS.getNumber().equals(scope)) {
            DynamicObject procDef = (DynamicObject)this.getModel().getValue("processdefinitionid");
            if (procDef != null) {
                DynamicObject procEntraBill = (DynamicObject)procDef.get("entrabillid");
                this.putEntraBillParams(customParams, procEntraBill);
            }
        } else if (DelegateScopeEnum.ENTRABILL.getNumber().equals(scope)) {
            DynamicObject entraBill = (DynamicObject)this.getModel().getValue("entrabillid");
            this.putEntraBillParams(customParams, entraBill);
        }
        String typeName = ConditionalRuleType.getTypeName((String)typeStr);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        parameter.setFormId("wf_conditionrule_update");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setShowTitle(false);
        parameter.setCaption(typeName);
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }

    private void putEntraBillParams(Map<String, Object> customParams, DynamicObject entraBill) {
        if (entraBill != null) {
            customParams.put("entityId", entraBill.getPkValue());
            customParams.put("entityNumber", entraBill.get("number"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            if (DelegateSettingUtil.isOpenFromMessageCenter(this.getView().getParentView()) && !TCCheckPermUtil.checkDelegateOwner(this.getView())) {
                args.setCancel(true);
            }
            if (!this.validateForConform()) {
                args.setCancel(true);
            } else {
                this.emptyEntraBillProcDef();
            }
        }
    }

    private boolean validateForConform() {
        DynamicObject assignor = (DynamicObject)this.getModel().getValue("assignorid");
        if (assignor == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u59d4\u6258\u4eba\u3002", (String)"WorkflowDelegateSettingPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return false;
        }
        Long assignorId = (Long)assignor.getPkValue();
        DynamicObject trustee = (DynamicObject)this.getModel().getValue("trusteeid");
        if (trustee == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u53d7\u6258\u4eba\u201d\u3002", (String)"WorkflowDelegateSettingPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return false;
        }
        Long trusteeId = (Long)trustee.getPkValue();
        if (assignorId.equals(trusteeId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u59d4\u6258\u4eba\u548c\u53d7\u6258\u4eba\u4e0d\u80fd\u662f\u540c\u4e00\u4e2a\u4eba\u3002", (String)"WorkflowDelegateSettingPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return false;
        }
        Object startTime = this.getModel().getValue("starttime");
        Object endTime = this.getModel().getValue("endtime");
        if (startTime == null || endTime == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u59d4\u6258\u671f\u95f4\u201d\u3002", (String)"WorkflowDelegateSettingPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (((Date)startTime).getTime() < WfUtils.now().getTime()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u59d4\u6258\u671f\u95f4\u201d\u7684\u201c\u5f00\u59cb\u65f6\u95f4\u201d\u4e0d\u5f97\u65e9\u4e8e\u5f53\u524d\u65f6\u95f4\u3002", (String)"WorkflowDelegateSettingPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return false;
        }
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        String status = (String)this.getModel().getValue("status");
        if (OperationStatus.EDIT.equals((Object)operationStatus) && DelegateStatusEnum.ENABLE.getNumber().equals(status)) {
            Long curDelegateId = (Long)this.getModel().getValue("id");
            if (TaskDelegateUtil.existSameDelegateSetting((Long)curDelegateId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u59d4\u6258\u8bbe\u7f6e\u5df2\u5b58\u5728\uff0c\u65e0\u9700\u91cd\u590d\u4fdd\u5b58\u3002", (String)"WorkflowDelegateSettingPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (DelegateSettingUtil.existDelegateRing(curDelegateId, assignorId, trusteeId, this.getView(), false)) {
                return false;
            }
        }
        return true;
    }

    private void emptyEntraBillProcDef() {
        String scope = (String)this.getModel().getValue("scope");
        if (DelegateScopeEnum.PROCESS.getNumber().equals(scope)) {
            this.getModel().setValue(ENTRABILLNAME, null);
            this.getModel().setValue("entrabillid", null);
        } else if (DelegateScopeEnum.ENTRABILL.getNumber().equals(scope)) {
            this.getModel().setValue("processdefinitionid", null);
            this.getModel().setValue(SV_DELEGATENODENAME, null);
            this.getModel().setValue("delegatenodeid", null);
            this.getModel().setValue("delegatenodename", null);
            this.getModel().setValue(ISLATESTVERSION, (Object)false);
        } else {
            this.getModel().setValue(ISLATESTVERSION, (Object)false);
            this.getModel().setValue(ENTRABILLNAME, null);
            this.getModel().setValue("entrabillid", null);
            this.getModel().setValue("processdefinitionid", null);
            this.getModel().setValue(SV_DELEGATENODENAME, null);
            this.getModel().setValue("delegatenodeid", null);
            this.getModel().setValue("delegatenodename", null);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getSource() instanceof Save) {
            this.saveHiDelegateSetting();
        }
    }

    private void saveHiDelegateSetting() {
        DynamicObject entraBill;
        HistoricDelegateSettingEntityImpl hiDelegate = new HistoricDelegateSettingEntityImpl();
        hiDelegate.setDelegateId((Long)this.getModel().getValue("id"));
        DynamicObject assignor = (DynamicObject)this.getModel().getValue("assignorid");
        Long assignorId = (Long)assignor.getPkValue();
        hiDelegate.setAssignorId(assignorId);
        DynamicObject trustee = (DynamicObject)this.getModel().getValue("trusteeid");
        Long trusteeId = (Long)trustee.getPkValue();
        hiDelegate.setTrusteeId(trusteeId);
        String scope = (String)this.getModel().getValue("scope");
        hiDelegate.setScope(scope);
        if (DelegateScopeEnum.PROCESS.getNumber().equals(scope)) {
            DynamicObject procDef = (DynamicObject)this.getModel().getValue("processdefinitionid");
            if (procDef != null) {
                hiDelegate.setProcessDefinitionId((Long)procDef.getPkValue());
                hiDelegate.setDelegateNodeId((String)this.getModel().getValue("delegatenodeid"));
                hiDelegate.setDelegateNodeName((ILocaleString)this.getModel().getValue("delegatenodename"));
            }
        } else if (DelegateScopeEnum.ENTRABILL.getNumber().equals(scope) && (entraBill = (DynamicObject)this.getModel().getValue("entrabillid")) != null) {
            hiDelegate.setEntraBillId((String)entraBill.getPkValue());
        }
        hiDelegate.setDelegateRule((String)this.getModel().getValue("delegaterule"));
        hiDelegate.setDelegateExpression((String)this.getModel().getValue("delegateexpression"));
        hiDelegate.setDeleRuleShowText((ILocaleString)this.getModel().getValue("deleruleshowtext"));
        hiDelegate.setStartTime((Date)this.getModel().getValue("starttime"));
        hiDelegate.setEndTime((Date)this.getModel().getValue("endtime"));
        hiDelegate.setSendMsgToAssignor((Boolean)this.getModel().getValue("sendmsgtoassignor"));
        hiDelegate.setReceiveTodoTask((Boolean)this.getModel().getValue("receivetodotask"));
        hiDelegate.setStatus((String)this.getModel().getValue("status"));
        hiDelegate.setDelegateTodo((Boolean)this.getModel().getValue("delegatetodo"));
        this.getRepositoryService().saveOrUpdateEntity((Entity)hiDelegate);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        switch (propName) {
            case "scope": {
                this.changeProcBillVisible();
                this.clearPropertyValue();
                if (!WfUtils.isEmptyString((Object)newValue)) break;
                this.getModel().setValue("processdefinitionid", null);
                this.getModel().setValue("delegatenodeid", null);
                this.getModel().setValue("delegatenodename", null);
                this.getModel().setValue(ENTRABILLNAME, null);
                this.getModel().setValue("entrabillid", null);
                this.emptyDelegateRule();
                break;
            }
            case "processdefinitionid": {
                if (newValue == null) {
                    this.getModel().setValue("processdefinitionid", null);
                }
                this.changeDelegateRuleVisible();
                this.clearPropertyValue();
                DynamicObject procDef = (DynamicObject)this.getModel().getValue("processdefinitionid");
                if (procDef == null) break;
                this.getView().setVisible(Boolean.TRUE, new String[]{SV_DELEGATENODENAME});
                break;
            }
            case "entrabillname": {
                this.changeDelegateRuleVisible();
                this.clearPropertyValue();
                if (!WfUtils.isEmptyString((Object)newValue)) break;
                this.getModel().setValue(ENTRABILLNAME, null);
                this.getModel().setValue("entrabillid", null);
                this.emptyDelegateRule();
                this.getView().setVisible(Boolean.FALSE, new String[]{SV_DELEGATERULE});
                break;
            }
            case "entrabillid": {
                if (WfUtils.isEmptyString((Object)newValue)) break;
                this.getView().setVisible(Boolean.TRUE, new String[]{SV_DELEGATERULE});
                break;
            }
            case "sv_delegaterule": {
                if (!WfUtils.isEmptyString((Object)newValue)) break;
                this.emptyDelegateRule();
                break;
            }
            case "sv_delegatenodename": {
                if (!WfUtils.isEmptyString((Object)newValue)) break;
                this.getModel().setValue(SV_DELEGATENODENAME, null);
                this.getModel().setValue("delegatenodeid", null);
                this.getModel().setValue("delegatenodename", null);
                break;
            }
        }
    }

    private void clearPropertyValue() {
        this.getModel().setValue(SV_DELEGATENODENAME, null);
        this.getModel().setValue(SV_DELEGATERULE, null);
    }

    private void changeProcBillVisible() {
        String scope = (String)this.getModel().getValue("scope");
        if (WfUtils.isEmpty((String)scope)) {
            scope = "3";
        }
        DelegateScopeEnum delegateScope = DelegateScopeEnum.getDelegateScope((String)scope);
        switch (delegateScope) {
            case PROCESS: {
                this.getView().setVisible(Boolean.FALSE, new String[]{ENTRABILLNAME});
                DynamicObject procDef = (DynamicObject)this.getModel().getValue("processdefinitionid");
                this.getView().setVisible(Boolean.TRUE, new String[]{SV_PROCESSDEFINITIONID});
                if (procDef != null) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{SV_DELEGATERULE});
                    this.getView().setVisible(Boolean.TRUE, new String[]{SV_DELEGATENODENAME});
                    break;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{SV_DELEGATERULE});
                this.getView().setVisible(Boolean.FALSE, new String[]{SV_DELEGATENODENAME});
                break;
            }
            case ENTRABILL: {
                this.getView().setVisible(Boolean.FALSE, new String[]{SV_PROCESSDEFINITIONID});
                this.getView().setVisible(Boolean.FALSE, new String[]{SV_DELEGATENODENAME});
                DynamicObject entraBill = (DynamicObject)this.getModel().getValue("entrabillid");
                this.getView().setVisible(Boolean.TRUE, new String[]{ENTRABILLNAME});
                if (entraBill != null) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{SV_DELEGATERULE});
                    break;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{SV_DELEGATERULE});
                break;
            }
            case ALLTASK: {
                this.getView().setVisible(Boolean.FALSE, new String[]{SV_PROCESSDEFINITIONID, SV_DELEGATENODENAME, ENTRABILLNAME, SV_DELEGATERULE});
                break;
            }
            default: {
                this.getView().setVisible(Boolean.FALSE, new String[]{SV_PROCESSDEFINITIONID, SV_DELEGATENODENAME, ENTRABILLNAME, SV_DELEGATERULE});
            }
        }
    }

    private void changeDelegateRuleVisible() {
        DynamicObject procDef = (DynamicObject)this.getModel().getValue("processdefinitionid");
        DynamicObject entraBill = (DynamicObject)this.getModel().getValue("entrabillid");
        if (procDef != null && "1".equals(this.getModel().getValue("scope"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{SV_DELEGATERULE, SV_DELEGATENODENAME});
        } else if (entraBill != null && "2".equals(this.getModel().getValue("scope"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{SV_DELEGATERULE});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{SV_DELEGATERULE, SV_DELEGATENODENAME});
        }
    }

    private void emptyDelegateRule() {
        this.getModel().setValue(SV_DELEGATERULE, null);
        this.getModel().setValue("delegaterule", null);
        this.getModel().setValue("delegateexpression", null);
        this.getModel().setValue("deleruleshowtext", null);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId) {
            case "sv_delegatenodename": {
                this.updateDelegateNode(returnData);
                break;
            }
            case "entrabillname": {
                this.updateEntraBill(returnData);
                break;
            }
            case "sv_delegaterule": {
                this.updateDelegateRule(returnData);
                break;
            }
            case "addprocess": {
                this.updateDelegateProc(returnData);
                break;
            }
        }
    }

    private void updateDelegateProc(Object returnData) {
        if (!(returnData instanceof ListSelectedRowCollection)) {
            return;
        }
        ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
        Long id = selectedRows.get(0) == null ? Long.valueOf(0L) : (Long)selectedRows.get(0).getPrimaryKeyValue();
        this.getModel().setValue("processdefinitionid", (Object)id);
        String name = selectedRows.get(0) == null ? "" : selectedRows.get(0).getName();
        this.getModel().setValue(SV_PROCESSDEFINITIONID, (Object)name);
        Boolean isLatestVersion = this.getPageCache().get("isLatestVersion") == null ? Boolean.TRUE : Boolean.valueOf(this.getPageCache().get("isLatestVersion"));
        this.getModel().setValue(ISLATESTVERSION, (Object)isLatestVersion);
    }

    private void updateDelegateNode(Object returnData) {
        if (returnData instanceof Map) {
            HashMap delegateNode = (HashMap)returnData;
            String delegateNodeId = (String)delegateNode.get("delegatenodeid");
            this.getModel().setValue("delegatenodeid", (Object)delegateNodeId);
            Map delegateNodeNameMap = (Map)delegateNode.get("delegatenodename");
            LocaleString delegateNodeName = LocaleString.fromMap((Map)delegateNodeNameMap);
            this.getModel().setValue("delegatenodename", (Object)delegateNodeName);
            this.getModel().setValue(SV_DELEGATENODENAME, (Object)delegateNodeName.getLocaleValue());
        }
    }

    private void updateEntraBill(Object returnData) {
        if (returnData instanceof Map) {
            Map entraBills = (Map)returnData;
            this.getModel().setValue(ENTRABILLNAME, entraBills.get(NAME));
            DynamicObject entityObject = QueryServiceHelper.queryOne((String)"bos_entityobject", (String)"number,dentityid", (QFilter[])new QFilter[]{new QFilter("number", "=", entraBills.get("number"))});
            entityObject = entityObject == null ? new DynamicObject() : entityObject;
            this.getModel().setValue("entrabillid", entityObject.get("dentityid"));
        }
    }

    private void updateDelegateRule(Object returnData) {
        if (returnData instanceof Map) {
            Map delegateRuleMap = (Map)returnData;
            if (delegateRuleMap.isEmpty()) {
                this.emptyDelegateRule();
            } else {
                this.setDelegateRuleValue(delegateRuleMap);
            }
        }
    }

    private void setDelegateRuleValue(Map<String, Object> delegateRuleMap) {
        String delegateExpression;
        this.getModel().setValue("delegaterule", (Object)SerializationUtils.toJsonString(delegateRuleMap));
        Object delegateRuleShowText = delegateRuleMap.get("showtext");
        if (delegateRuleShowText != null) {
            String lang = RequestContext.get().getLang().toString();
            Map ruleShowTextMap = (Map)delegateRuleShowText;
            String svDelegateRule = (String)ruleShowTextMap.get(lang);
            this.getModel().setValue(SV_DELEGATERULE, (Object)svDelegateRule);
            LocaleString deleRuleShowText = new LocaleString();
            for (Map.Entry entry : ruleShowTextMap.entrySet()) {
                Object value = entry.getValue();
                if (value == null) continue;
                deleRuleShowText.setItem((String)entry.getKey(), (Object)value.toString());
            }
            this.getModel().setValue("deleruleshowtext", (Object)deleRuleShowText);
        }
        if (WfUtils.isEmpty((String)(delegateExpression = (String)delegateRuleMap.get("expression")))) {
            delegateExpression = (String)delegateRuleMap.get("plugin");
        }
        this.getModel().setValue("delegateexpression", (Object)delegateExpression);
    }
}

