/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.management.plugin.delegatesetting;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.enumeration.ConditionalRuleType;
import kd.bos.workflow.engine.task.delegatesetting.DelegateScopeEnum;
import kd.bos.workflow.management.plugin.util.DelegateSettingUtil;

public class WorkflowMultiDelegateSettingPlugin
extends AbstractWorkflowPlugin {
    private static final String PROCESS_DELEGATENODE = "process_delegatenode";
    private static final String PROCESS_CONDITION = "process_condition";
    private static final String BILL_CONDITION = "bill_condition";
    private static final String PROCESSENTRYENTITY = "processentryentity";
    private static final String BILLENTRYENTITY = "billentryentity";
    private static final String ADDPROCESS = "addprocess";
    private static final String ADDBILL = "addbill";
    private static final String PROCESS_NUMBER = "process_number";
    private static final String PROCESS_NAME = "process_name";
    private static final String BILL_NUMBER = "bill_number";
    private static final String BILL_NAME = "bill_name";
    private static final String ENTRABILLID = "entrabillid";
    private static final String BILL_DELEGATERULE = "bill_delegaterule";
    private static final String PROCESS_DELEGATERULE = "process_delegaterule";
    private static final String BILL_DELEGATEEXPRESSION = "bill_delegateexpression";
    private static final String PROCES_DELEGATEEXPRESSION = "proces_delegateexpression";
    private static final String BILL_DELERULESHOWTEXT = "bill_deleruleshowtext";
    private static final String PROCESS_DELERULESHOWTEXT = "process_deleruleshowtext";
    private static final String PROCESSDEFINITIONID = "processdefinitionid";
    private static final String DELEGATENODEID = "delegatenodeid";
    private static final String DELEGATENODENAME = "delegatenodename";
    private static final String BTNOK = "btnok";
    private static final String BTNCANCEL = "btncancel";
    private static final String ASSIGNORID = "assignorid";
    private static final String TRUSTEEID = "trusteeid";
    private static final String SCOPE = "scope";
    private static final String NUMBER = "number";
    private static final String ISCONFIRM = "isConfirm";
    private static final String PROCESSENTRYENTITYIDS = "processEntryEntityIds";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{ADDPROCESS, ADDBILL, PROCESS_DELEGATENODE, PROCESS_CONDITION, BILL_CONDITION, BTNOK, BTNCANCEL});
    }

    public void afterCreateNewData(EventObject e) {
        if (DelegateSettingUtil.isOpenFromMessageCenter(this.getView().getParentView())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{ASSIGNORID});
            this.getModel().setValue(ASSIGNORID, (Object)WfUtils.getCurrentUser());
            FieldEdit sendMsg = (FieldEdit)this.getControl("sendmsgtoassignor");
            sendMsg.setCaption(new LocaleString(ResManager.loadKDString((String)"\u59d4\u6258\u7684\u4efb\u52a1\u88ab\u5904\u7406\u540e\u901a\u77e5\u6211", (String)"WorkflowDelegateSettingPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0])));
            FieldEdit receTask = (FieldEdit)this.getControl("receivetodotask");
            receTask.setCaption(new LocaleString(ResManager.loadKDString((String)"\u59d4\u6258\u671f\u95f4\u6211\u63a5\u6536\u4efb\u52a1", (String)"WorkflowDelegateSettingPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0])));
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "process_delegatenode": {
                this.showDelegateNode(key);
                break;
            }
            case "process_condition": {
                this.showBillList(PROCESS_CONDITION, PROCESSENTRYENTITY, PROCESS_DELEGATERULE);
                break;
            }
            case "bill_condition": {
                this.showBillList(BILL_CONDITION, BILLENTRYENTITY, BILL_DELEGATERULE);
                break;
            }
            case "addprocess": {
                this.showProcessList();
                break;
            }
            case "addbill": {
                this.showBillList();
                break;
            }
            case "btnok": {
                this.confirm();
                break;
            }
            case "btncancel": {
                this.getView().close();
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        boolean isChanged;
        super.beforeClosed(e);
        if (!Boolean.parseBoolean(this.getPageCache().get(ISCONFIRM)) && (isChanged = this.getModel().getDataChanged())) {
            ConfirmCallBackListener error = new ConfirmCallBackListener("continue_close", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"WorkflowMultiDelegateSettingPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"WorkflowMultiDelegateSettingPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002\u662f\u5426\u76f4\u63a5\u9000\u51fa\uff1f", (String)"WorkflowMultiDelegateSettingPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            msg = WfUtils.isNotEmpty((String)msg) ? msg.replaceAll("\\\\r\\\\n", "\r\n") : msg;
            this.getView().showConfirm(msg, this.getModel().getChangeDesc(), options, ConfirmTypes.Save, error, btnNameMaps);
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (MessageBoxResult.Yes == messageBoxClosedEvent.getResult() && "continue_close".equals(callBackId)) {
            this.getPageCache().put(ISCONFIRM, "true");
            this.getView().close();
        }
    }

    private void confirm() {
        Long trusteeId;
        DynamicObject assignor = (DynamicObject)this.getModel().getValue(ASSIGNORID);
        DynamicObject trustee = (DynamicObject)this.getModel().getValue(TRUSTEEID);
        String scope = (String)this.getModel().getValue(SCOPE);
        Date startTime = (Date)this.getModel().getValue("starttime");
        Date endTime = (Date)this.getModel().getValue("endtime");
        if (assignor == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u59d4\u6258\u4eba\u3002", (String)"WorkflowDelegateSettingPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        if (trustee == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u53d7\u6258\u4eba\u201d\u3002", (String)"WorkflowDelegateSettingPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        Long assignorId = (Long)assignor.getPkValue();
        if (assignorId.equals(trusteeId = (Long)trustee.getPkValue())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u59d4\u6258\u4eba\u548c\u53d7\u6258\u4eba\u4e0d\u80fd\u662f\u540c\u4e00\u4e2a\u4eba\u3002", (String)"WorkflowDelegateSettingPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        if (startTime == null || endTime == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u59d4\u6258\u671f\u95f4\u201d\u3002", (String)"WorkflowDelegateSettingPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        if (startTime.getTime() < WfUtils.now().getTime()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u59d4\u6258\u671f\u95f4\u201d\u7684\u201c\u5f00\u59cb\u65f6\u95f4\u201d\u4e0d\u5f97\u65e9\u4e8e\u5f53\u524d\u65f6\u95f4\u3002", (String)"WorkflowDelegateSettingPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection entryEntityData = new DynamicObjectCollection();
        if ("2".equals(scope)) {
            entryEntityData = this.getModel().getEntryEntity(BILLENTRYENTITY);
        } else if ("1".equals(scope)) {
            entryEntityData = this.getModel().getEntryEntity(PROCESSENTRYENTITY);
        }
        if (entryEntityData == null || entryEntityData.isEmpty()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u59d4\u6258\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WorkflowDelegateSettingPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        Boolean sendMsgToassignor = (Boolean)this.getModel().getValue("sendmsgtoassignor");
        Boolean receiveTodotTask = (Boolean)this.getModel().getValue("receivetodotask");
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            this.getRepositoryService().batchDelegationSettings(assignor, trustee, scope, startTime, endTime, sendMsgToassignor, receiveTodotTask, entryEntityData);
            resultMap.put("succeed", "true");
            resultMap.put("message", ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"WorkflowMultiDelegateSettingPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
        catch (Exception e) {
            this.logger.error(WfUtils.getExceptionStacktrace((Throwable)e));
            resultMap.put("succeed", "false");
            resultMap.put("message", String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u539f\u56e0:%s", (String)"WorkflowMultiDelegateSettingPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
        this.getView().returnDataToParent(resultMap);
        WfUtils.addOpLog((String)"wf_delegatesetting", (String)"adddonothing", (String)ResManager.getLocaleString((String)"\u6279\u91cf\u65b0\u589e\u59d4\u6258", (String)"WorkflowMultiDelegateSettingPlugin_6", (String)"bos-wf-formplugin").getLocaleValue_zh_CN(), (MultiLangEnumBridge)new MultiLangEnumBridge("\u6279\u91cf\u65b0\u589e\u59d4\u6258\u6210\u529f", "WorkflowMultiDelegateSettingPlugin_7", "bos-wf-formplugin"), (Object[])new Object[0]);
        this.getView().getPageCache().put(ISCONFIRM, "true");
        this.getView().close();
    }

    private void showDelegateNode(String key) {
        String delegateNodeId;
        HashMap<String, Object> params = new HashMap<String, Object>();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(PROCESSENTRYENTITY);
        int[] rows = entryGrid.getSelectRows();
        Long processDefinitionId = (Long)entryGrid.getModel().getValue(PROCESSDEFINITIONID, rows[0]);
        if (WfUtils.isNotEmpty((Long)processDefinitionId)) {
            params.put("procDefId", processDefinitionId);
        }
        if (!WfUtils.isEmpty((String)(delegateNodeId = (String)entryGrid.getModel().getValue(DELEGATENODEID, rows[0])))) {
            params.put("delegateNodeId", delegateNodeId);
        }
        this.showForm(key, "wf_delegatenode", params);
    }

    private void showProcessList() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("wf_delegaprocdef");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ADDPROCESS));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss styleCss = new StyleCss();
        styleCss.setHeight("680px");
        styleCss.setWidth("1060px");
        parameter.getOpenStyle().setInlineStyleCss(styleCss);
        parameter.setShowTitle(false);
        parameter.setShowClose(true);
        HashMap<String, Object> customParamMap = new HashMap<String, Object>();
        customParamMap.put("isMultiSelect", true);
        customParamMap.put("isLookUp", true);
        customParamMap.put("hideHyperlink", "true");
        customParamMap.put("selectedRows", this.getPageCache().get(PROCESSENTRYENTITYIDS));
        customParamMap.put("isLatestVersion", this.getPageCache().get("isLatestVersion"));
        customParamMap.put("isOnlyShowAuditFlow", true);
        parameter.setCustomParams(customParamMap);
        this.getView().showForm(parameter);
    }

    private void showBillList() {
        RepositoryService service = this.getRepositoryService();
        Set entityNumbers = service.getProcessEntityNumbers();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("NodeEntityNumbers", entityNumbers);
        params.put("isMultiSelect", true);
        DesignerModelUtil.openSelectEntitiesPageByCunstomerParams(this.getView(), (IFormPlugin)this, ADDBILL, params);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId) {
            case "addbill": {
                this.updateEntraBill(returnData);
                break;
            }
            case "addprocess": {
                this.updateEntraProcess(returnData);
                break;
            }
            case "bill_condition": 
            case "process_condition": {
                this.updateDelegateRule(returnData, actionId);
                break;
            }
            case "process_delegatenode": {
                this.updateDelegateNode(returnData);
                break;
            }
        }
    }

    private void updateDelegateNode(Object returnData) {
        if (returnData instanceof Map) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(PROCESSENTRYENTITY);
            IDataModel model = entryGrid.getModel();
            int[] rows = entryGrid.getSelectRows();
            HashMap delegateNode = (HashMap)returnData;
            String delegateNodeId = (String)delegateNode.get(DELEGATENODEID);
            model.setValue(DELEGATENODEID, (Object)delegateNodeId, rows[0]);
            Map delegateNodeNameMap = (Map)delegateNode.get(DELEGATENODENAME);
            LocaleString delegateNodeName = LocaleString.fromMap((Map)delegateNodeNameMap);
            model.setValue(DELEGATENODENAME, (Object)delegateNodeName, rows[0]);
            model.setValue(PROCESS_DELEGATENODE, (Object)delegateNodeName.getLocaleValue(), rows[0]);
        }
    }

    private void updateDelegateRule(Object returnData, String actionId) {
        if (returnData instanceof Map) {
            Map delegateRuleMap = (Map)returnData;
            if (delegateRuleMap.isEmpty()) {
                this.emptyDelegateRule(actionId);
            } else if (BILL_CONDITION.equals(actionId)) {
                this.setDelegateRuleValue(delegateRuleMap, BILLENTRYENTITY, BILL_DELEGATERULE, BILL_CONDITION, BILL_DELERULESHOWTEXT, BILL_DELEGATEEXPRESSION);
            } else if (PROCESS_CONDITION.equals(actionId)) {
                this.setDelegateRuleValue(delegateRuleMap, PROCESSENTRYENTITY, PROCESS_DELEGATERULE, PROCESS_CONDITION, PROCESS_DELERULESHOWTEXT, PROCES_DELEGATEEXPRESSION);
            }
        }
    }

    private void setDelegateRuleValue(Map<String, Object> delegateRuleMap, String entyrEntityKey, String delegateRuleKey, String conditionKey, String deleRuleShowTextKey, String delegateExpressionKey) {
        String delegateExpression;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entyrEntityKey);
        int[] rows = entryGrid.getSelectRows();
        entryGrid.getModel().setValue(delegateRuleKey, (Object)SerializationUtils.toJsonString(delegateRuleMap), rows[0]);
        Object delegateRuleShowText = delegateRuleMap.get("showtext");
        if (delegateRuleShowText != null) {
            String lang = RequestContext.get().getLang().toString();
            Map ruleShowTextMap = (Map)delegateRuleShowText;
            String svDelegateRule = (String)ruleShowTextMap.get(lang);
            this.getModel().setValue(conditionKey, (Object)svDelegateRule);
            LocaleString deleRuleShowText = new LocaleString();
            for (Map.Entry entry : ruleShowTextMap.entrySet()) {
                Object value = entry.getValue();
                if (value == null) continue;
                deleRuleShowText.setItem((String)entry.getKey(), (Object)value.toString());
            }
            entryGrid.getModel().setValue(deleRuleShowTextKey, (Object)deleRuleShowText, rows[0]);
        }
        if (WfUtils.isEmpty((String)(delegateExpression = (String)delegateRuleMap.get("expression")))) {
            delegateExpression = (String)delegateRuleMap.get("plugin");
        }
        entryGrid.getModel().setValue(delegateExpressionKey, (Object)delegateExpression, rows[0]);
    }

    private void emptyDelegateRule(String actionId) {
        if (BILL_CONDITION.equals(actionId)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(BILLENTRYENTITY);
            int[] rows = entryGrid.getSelectRows();
            int row = rows[0];
            this.getModel().setValue(BILL_CONDITION, null, row);
            this.getModel().setValue(BILL_DELEGATERULE, null, row);
            this.getModel().setValue(BILL_DELEGATEEXPRESSION, null, row);
            this.getModel().setValue(BILL_DELERULESHOWTEXT, null, row);
        } else if (PROCESS_CONDITION.equals(actionId)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(PROCESSENTRYENTITY);
            int[] rows = entryGrid.getSelectRows();
            int row = rows[0];
            this.getModel().setValue(PROCESS_DELEGATERULE, null, row);
            this.getModel().setValue(PROCESS_CONDITION, null, row);
            this.getModel().setValue(PROCESS_DELERULESHOWTEXT, null, row);
            this.getModel().setValue(PROCES_DELEGATEEXPRESSION, null, row);
        }
    }

    private void updateEntraProcess(Object returnData) {
        if (!(returnData instanceof ListSelectedRowCollection)) {
            return;
        }
        ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
        Long[] ids = new Long[selectedRows.size()];
        IDataModel model = this.getModel();
        model.deleteEntryData(PROCESSENTRYENTITY);
        model.beginInit();
        model.batchCreateNewEntryRow(PROCESSENTRYENTITY, selectedRows.size());
        HashMap<Long, String> versionMap = new HashMap<Long, String>(selectedRows.size());
        HashMap<Long, Integer> idMap = new HashMap<Long, Integer>(selectedRows.size());
        for (int i = 0; i < selectedRows.size(); ++i) {
            ListSelectedRow selectedRow = selectedRows.get(i);
            String number = selectedRow.getNumber();
            String name = selectedRow.getName();
            ids[i] = (Long)selectedRow.getPrimaryKeyValue();
            Long proDefId = (Long)selectedRow.getPrimaryKeyValue();
            idMap.put(proDefId, i);
            model.setValue(PROCESS_NUMBER, (Object)number, i);
            model.setValue(PROCESS_NAME, (Object)name, i);
            model.setValue(PROCESSDEFINITIONID, (Object)proDefId, i);
            model.setValue("islatestversion", (Object)Boolean.valueOf(this.getPageCache().get("isLatestVersion")), i);
        }
        this.getPageCache().put(PROCESSENTRYENTITYIDS, SerializationUtils.toJsonString((Object)ids));
        DynamicObjectCollection processDefinitionDyna = QueryServiceHelper.query((String)"wf_processdefinition", (String)"id,version", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
        for (DynamicObject processDefinition : processDefinitionDyna) {
            versionMap.put(processDefinition.getLong("id"), processDefinition.getString("version"));
        }
        Boolean isLatestVersion = Boolean.valueOf(this.getPageCache().get("isLatestVersion"));
        for (ListSelectedRow selectedRow : selectedRows) {
            String version = "";
            Long proDefId = (Long)selectedRow.getPrimaryKeyValue();
            Integer i = (Integer)idMap.get(proDefId);
            if (!isLatestVersion.booleanValue()) {
                version = (String)versionMap.get(proDefId);
            }
            model.setValue("version", (Object)version, i.intValue());
        }
        model.endInit();
        this.getView().updateView(PROCESSENTRYENTITY);
    }

    private void updateEntraBill(Object returnData) {
        if (returnData instanceof List) {
            String number;
            List selectedRows = (List)returnData;
            ArrayList<String> numbers = new ArrayList<String>(selectedRows.size());
            for (Map selectedRow : selectedRows) {
                String number2 = (String)selectedRow.get(NUMBER);
                numbers.add(number2);
            }
            DynamicObjectCollection entityObjects = QueryServiceHelper.query((String)"bos_entityobject", (String)"number,dentityid", (QFilter[])new QFilter[]{new QFilter(NUMBER, "in", numbers)});
            HashMap<String, String> numberDentityMap = new HashMap<String, String>(entityObjects.size());
            for (DynamicObject entityObject : entityObjects) {
                String dentityid = entityObject.getString("dentityid");
                number = entityObject.getString(NUMBER);
                numberDentityMap.put(number, dentityid);
            }
            IDataModel model = this.getModel();
            model.deleteEntryData(BILLENTRYENTITY);
            model.beginInit();
            model.batchCreateNewEntryRow(BILLENTRYENTITY, selectedRows.size());
            for (int i = 0; i < selectedRows.size(); ++i) {
                Map selectedRow = (Map)selectedRows.get(i);
                number = (String)selectedRow.get(NUMBER);
                String name = (String)selectedRow.get("name");
                String id = (String)numberDentityMap.get(number);
                model.setValue(BILL_NUMBER, (Object)number, i);
                model.setValue(BILL_NAME, (Object)name, i);
                model.setValue(ENTRABILLID, (Object)id, i);
            }
            model.endInit();
            this.getView().updateView(BILLENTRYENTITY);
        }
    }

    private void showBillList(String actionId, String entryEntityKey, String delegateRuleKey) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entryEntityKey);
        int[] rows = entryGrid.getSelectRows();
        String delegateRule = (String)entryGrid.getModel().getValue(delegateRuleKey, rows[0]);
        JSONObject conditionRule = null;
        if (!WfUtils.isEmpty((String)delegateRule)) {
            conditionRule = (JSONObject)SerializationUtils.fromJsonString((String)delegateRule, JSONObject.class);
        }
        String typeStr = ConditionalRuleType.DELEGATESETTINGRULE.toString();
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("type", typeStr);
        context.put("property", "rule");
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("context", context);
        customParams.put("value", conditionRule != null ? conditionRule.toJSONString() : null);
        customParams.put("openType", "billRule");
        String scope = (String)this.getModel().getValue(SCOPE);
        if (DelegateScopeEnum.PROCESS.getNumber().equals(scope)) {
            Long proDefId = (Long)entryGrid.getModel().getValue(PROCESSDEFINITIONID, rows[0]);
            QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)proDefId)};
            DynamicObject procDef = BusinessDataServiceHelper.loadSingle((String)"wf_processdefinition", (String)ENTRABILLID, (QFilter[])filters);
            if (procDef != null) {
                DynamicObject procEntraBill = procDef.getDynamicObject(ENTRABILLID);
                customParams.put("entityId", procEntraBill.getPkValue());
                customParams.put("entityNumber", procEntraBill.get(NUMBER));
            }
        } else if (DelegateScopeEnum.ENTRABILL.getNumber().equals(scope)) {
            customParams.put("entityId", String.valueOf(entryGrid.getModel().getValue(ENTRABILLID, rows[0])));
            customParams.put("entityNumber", entryGrid.getModel().getValue(BILL_NUMBER, rows[0]));
        }
        String typeName = ConditionalRuleType.getTypeName((String)typeStr);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        parameter.setFormId("wf_conditionrule_update");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setShowTitle(false);
        parameter.setCaption(typeName);
        parameter.setCustomParams(customParams);
        this.getView().showForm(parameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (BILL_CONDITION.equals(propName) && WfUtils.isEmpty((String)((String)newValue))) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(BILLENTRYENTITY);
            int[] rows = entryGrid.getSelectRows();
            IDataModel model = this.getModel();
            model.setValue(BILL_DELEGATERULE, null, rows[0]);
            model.setValue(BILL_DELEGATEEXPRESSION, null, rows[0]);
            model.setValue(BILL_DELERULESHOWTEXT, null, rows[0]);
        } else if (PROCESS_DELEGATENODE.equals(propName) && WfUtils.isEmpty((String)((String)newValue))) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(PROCESSENTRYENTITY);
            int[] rows = entryGrid.getSelectRows();
            IDataModel model = this.getModel();
            model.setValue(DELEGATENODENAME, null, rows[0]);
            model.setValue(DELEGATENODEID, null, rows[0]);
        } else if (PROCESS_CONDITION.equals(propName) && WfUtils.isEmpty((String)((String)newValue))) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(PROCESSENTRYENTITY);
            int[] rows = entryGrid.getSelectRows();
            IDataModel model = this.getModel();
            model.setValue(PROCESS_DELEGATERULE, null, rows[0]);
            model.setValue(PROCESS_DELERULESHOWTEXT, null, rows[0]);
            model.setValue(PROCES_DELEGATEEXPRESSION, null, rows[0]);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        Object option = afterDoOperationEventArgs.getSource();
        if (option instanceof DeleteEntry && "deleteentry".equals(((DeleteEntry)option).getOperateKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(PROCESSENTRYENTITY);
            DynamicObject[] dataEntitys = entryGrid.getEntryData().getDataEntitys();
            String newIds = "";
            if (dataEntitys != null && dataEntitys.length > 0) {
                Long[] ids = new Long[dataEntitys.length];
                for (int i = 0; i < dataEntitys.length; ++i) {
                    DynamicObject dynamicObject = dataEntitys[i];
                    ids[i] = dynamicObject.getLong(PROCESSDEFINITIONID);
                }
                newIds = SerializationUtils.toJsonString((Object)ids);
            }
            this.getPageCache().put(PROCESSENTRYENTITYIDS, newIds);
        }
    }
}

